require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&LINUX_PCI_REGS_H)) {
    eval 'sub LINUX_PCI_REGS_H () {1;}' unless defined(&LINUX_PCI_REGS_H);
    eval 'sub PCI_CFG_SPACE_SIZE () {256;}' unless defined(&PCI_CFG_SPACE_SIZE);
    eval 'sub PCI_CFG_SPACE_EXP_SIZE () {4096;}' unless defined(&PCI_CFG_SPACE_EXP_SIZE);
    eval 'sub PCI_STD_HEADER_SIZEOF () {64;}' unless defined(&PCI_STD_HEADER_SIZEOF);
    eval 'sub PCI_STD_NUM_BARS () {6;}' unless defined(&PCI_STD_NUM_BARS);
    eval 'sub PCI_VENDOR_ID () {0x;}' unless defined(&PCI_VENDOR_ID);
    eval 'sub PCI_DEVICE_ID () {0x2;}' unless defined(&PCI_DEVICE_ID);
    eval 'sub PCI_COMMAND () {0x4;}' unless defined(&PCI_COMMAND);
    eval 'sub PCI_COMMAND_IO () {0x1;}' unless defined(&PCI_COMMAND_IO);
    eval 'sub PCI_COMMAND_MEMORY () {0x2;}' unless defined(&PCI_COMMAND_MEMORY);
    eval 'sub PCI_COMMAND_MASTER () {0x4;}' unless defined(&PCI_COMMAND_MASTER);
    eval 'sub PCI_COMMAND_SPECIAL () {0x8;}' unless defined(&PCI_COMMAND_SPECIAL);
    eval 'sub PCI_COMMAND_INVALIDATE () {0x10;}' unless defined(&PCI_COMMAND_INVALIDATE);
    eval 'sub PCI_COMMAND_VGA_PALETTE () {0x20;}' unless defined(&PCI_COMMAND_VGA_PALETTE);
    eval 'sub PCI_COMMAND_PARITY () {0x40;}' unless defined(&PCI_COMMAND_PARITY);
    eval 'sub PCI_COMMAND_WAIT () {0x80;}' unless defined(&PCI_COMMAND_WAIT);
    eval 'sub PCI_COMMAND_SERR () {0x100;}' unless defined(&PCI_COMMAND_SERR);
    eval 'sub PCI_COMMAND_FAST_BACK () {0x200;}' unless defined(&PCI_COMMAND_FAST_BACK);
    eval 'sub PCI_COMMAND_INTX_DISABLE () {0x400;}' unless defined(&PCI_COMMAND_INTX_DISABLE);
    eval 'sub PCI_STATUS () {0x6;}' unless defined(&PCI_STATUS);
    eval 'sub PCI_STATUS_IMM_READY () {0x1;}' unless defined(&PCI_STATUS_IMM_READY);
    eval 'sub PCI_STATUS_INTERRUPT () {0x8;}' unless defined(&PCI_STATUS_INTERRUPT);
    eval 'sub PCI_STATUS_CAP_LIST () {0x10;}' unless defined(&PCI_STATUS_CAP_LIST);
    eval 'sub PCI_STATUS_66MHZ () {0x20;}' unless defined(&PCI_STATUS_66MHZ);
    eval 'sub PCI_STATUS_UDF () {0x40;}' unless defined(&PCI_STATUS_UDF);
    eval 'sub PCI_STATUS_FAST_BACK () {0x80;}' unless defined(&PCI_STATUS_FAST_BACK);
    eval 'sub PCI_STATUS_PARITY () {0x100;}' unless defined(&PCI_STATUS_PARITY);
    eval 'sub PCI_STATUS_DEVSEL_MASK () {0x600;}' unless defined(&PCI_STATUS_DEVSEL_MASK);
    eval 'sub PCI_STATUS_DEVSEL_FAST () {0x;}' unless defined(&PCI_STATUS_DEVSEL_FAST);
    eval 'sub PCI_STATUS_DEVSEL_MEDIUM () {0x200;}' unless defined(&PCI_STATUS_DEVSEL_MEDIUM);
    eval 'sub PCI_STATUS_DEVSEL_SLOW () {0x400;}' unless defined(&PCI_STATUS_DEVSEL_SLOW);
    eval 'sub PCI_STATUS_SIG_TARGET_ABORT () {0x800;}' unless defined(&PCI_STATUS_SIG_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_TARGET_ABORT () {0x1000;}' unless defined(&PCI_STATUS_REC_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_MASTER_ABORT () {0x2000;}' unless defined(&PCI_STATUS_REC_MASTER_ABORT);
    eval 'sub PCI_STATUS_SIG_SYSTEM_ERROR () {0x4000;}' unless defined(&PCI_STATUS_SIG_SYSTEM_ERROR);
    eval 'sub PCI_STATUS_DETECTED_PARITY () {0x8000;}' unless defined(&PCI_STATUS_DETECTED_PARITY);
    eval 'sub PCI_CLASS_REVISION () {0x8;}' unless defined(&PCI_CLASS_REVISION);
    eval 'sub PCI_REVISION_ID () {0x8;}' unless defined(&PCI_REVISION_ID);
    eval 'sub PCI_CLASS_PROG () {0x9;}' unless defined(&PCI_CLASS_PROG);
    eval 'sub PCI_CLASS_DEVICE () {0xa;}' unless defined(&PCI_CLASS_DEVICE);
    eval 'sub PCI_CACHE_LINE_SIZE () {0xc;}' unless defined(&PCI_CACHE_LINE_SIZE);
    eval 'sub PCI_LATENCY_TIMER () {0xd;}' unless defined(&PCI_LATENCY_TIMER);
    eval 'sub PCI_HEADER_TYPE () {0xe;}' unless defined(&PCI_HEADER_TYPE);
    eval 'sub PCI_HEADER_TYPE_MASK () {0x7f;}' unless defined(&PCI_HEADER_TYPE_MASK);
    eval 'sub PCI_HEADER_TYPE_NORMAL () {0;}' unless defined(&PCI_HEADER_TYPE_NORMAL);
    eval 'sub PCI_HEADER_TYPE_BRIDGE () {1;}' unless defined(&PCI_HEADER_TYPE_BRIDGE);
    eval 'sub PCI_HEADER_TYPE_CARDBUS () {2;}' unless defined(&PCI_HEADER_TYPE_CARDBUS);
    eval 'sub PCI_HEADER_TYPE_MFD () {0x80;}' unless defined(&PCI_HEADER_TYPE_MFD);
    eval 'sub PCI_BIST () {0xf;}' unless defined(&PCI_BIST);
    eval 'sub PCI_BIST_CODE_MASK () {0xf;}' unless defined(&PCI_BIST_CODE_MASK);
    eval 'sub PCI_BIST_START () {0x40;}' unless defined(&PCI_BIST_START);
    eval 'sub PCI_BIST_CAPABLE () {0x80;}' unless defined(&PCI_BIST_CAPABLE);
    eval 'sub PCI_BASE_ADDRESS_0 () {0x10;}' unless defined(&PCI_BASE_ADDRESS_0);
    eval 'sub PCI_BASE_ADDRESS_1 () {0x14;}' unless defined(&PCI_BASE_ADDRESS_1);
    eval 'sub PCI_BASE_ADDRESS_2 () {0x18;}' unless defined(&PCI_BASE_ADDRESS_2);
    eval 'sub PCI_BASE_ADDRESS_3 () {0x1c;}' unless defined(&PCI_BASE_ADDRESS_3);
    eval 'sub PCI_BASE_ADDRESS_4 () {0x20;}' unless defined(&PCI_BASE_ADDRESS_4);
    eval 'sub PCI_BASE_ADDRESS_5 () {0x24;}' unless defined(&PCI_BASE_ADDRESS_5);
    eval 'sub PCI_BASE_ADDRESS_SPACE () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE);
    eval 'sub PCI_BASE_ADDRESS_SPACE_IO () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE_IO);
    eval 'sub PCI_BASE_ADDRESS_SPACE_MEMORY () {0x;}' unless defined(&PCI_BASE_ADDRESS_SPACE_MEMORY);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_MASK () {0x6;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_MASK);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_32 () {0x;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_32);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_1M () {0x2;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_1M);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_64 () {0x4;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_64);
    eval 'sub PCI_BASE_ADDRESS_MEM_PREFETCH () {0x8;}' unless defined(&PCI_BASE_ADDRESS_MEM_PREFETCH);
    eval 'sub PCI_BASE_ADDRESS_MEM_MASK () {(~0xf);}' unless defined(&PCI_BASE_ADDRESS_MEM_MASK);
    eval 'sub PCI_BASE_ADDRESS_IO_MASK () {(~0x3);}' unless defined(&PCI_BASE_ADDRESS_IO_MASK);
    eval 'sub PCI_CARDBUS_CIS () {0x28;}' unless defined(&PCI_CARDBUS_CIS);
    eval 'sub PCI_SUBSYSTEM_VENDOR_ID () {0x2c;}' unless defined(&PCI_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_SUBSYSTEM_ID () {0x2e;}' unless defined(&PCI_SUBSYSTEM_ID);
    eval 'sub PCI_ROM_ADDRESS () {0x30;}' unless defined(&PCI_ROM_ADDRESS);
    eval 'sub PCI_ROM_ADDRESS_ENABLE () {0x1;}' unless defined(&PCI_ROM_ADDRESS_ENABLE);
    eval 'sub PCI_ROM_ADDRESS_MASK () {(~0x7ff);}' unless defined(&PCI_ROM_ADDRESS_MASK);
    eval 'sub PCI_CAPABILITY_LIST () {0x34;}' unless defined(&PCI_CAPABILITY_LIST);
    eval 'sub PCI_INTERRUPT_LINE () {0x3c;}' unless defined(&PCI_INTERRUPT_LINE);
    eval 'sub PCI_INTERRUPT_PIN () {0x3d;}' unless defined(&PCI_INTERRUPT_PIN);
    eval 'sub PCI_MIN_GNT () {0x3e;}' unless defined(&PCI_MIN_GNT);
    eval 'sub PCI_MAX_LAT () {0x3f;}' unless defined(&PCI_MAX_LAT);
    eval 'sub PCI_PRIMARY_BUS () {0x18;}' unless defined(&PCI_PRIMARY_BUS);
    eval 'sub PCI_SECONDARY_BUS () {0x19;}' unless defined(&PCI_SECONDARY_BUS);
    eval 'sub PCI_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_SUBORDINATE_BUS);
    eval 'sub PCI_SEC_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_SEC_LATENCY_TIMER);
    eval 'sub PCI_IO_BASE () {0x1c;}' unless defined(&PCI_IO_BASE);
    eval 'sub PCI_IO_LIMIT () {0x1d;}' unless defined(&PCI_IO_LIMIT);
    eval 'sub PCI_IO_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_IO_RANGE_TYPE_MASK);
    eval 'sub PCI_IO_RANGE_TYPE_16 () {0x;}' unless defined(&PCI_IO_RANGE_TYPE_16);
    eval 'sub PCI_IO_RANGE_TYPE_32 () {0x1;}' unless defined(&PCI_IO_RANGE_TYPE_32);
    eval 'sub PCI_IO_RANGE_MASK () {(~0xf);}' unless defined(&PCI_IO_RANGE_MASK);
    eval 'sub PCI_IO_1K_RANGE_MASK () {(~0x3);}' unless defined(&PCI_IO_1K_RANGE_MASK);
    eval 'sub PCI_SEC_STATUS () {0x1e;}' unless defined(&PCI_SEC_STATUS);
    eval 'sub PCI_MEMORY_BASE () {0x20;}' unless defined(&PCI_MEMORY_BASE);
    eval 'sub PCI_MEMORY_LIMIT () {0x22;}' unless defined(&PCI_MEMORY_LIMIT);
    eval 'sub PCI_MEMORY_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_MEMORY_RANGE_TYPE_MASK);
    eval 'sub PCI_MEMORY_RANGE_MASK () {(~0xf);}' unless defined(&PCI_MEMORY_RANGE_MASK);
    eval 'sub PCI_PREF_MEMORY_BASE () {0x24;}' unless defined(&PCI_PREF_MEMORY_BASE);
    eval 'sub PCI_PREF_MEMORY_LIMIT () {0x26;}' unless defined(&PCI_PREF_MEMORY_LIMIT);
    eval 'sub PCI_PREF_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_PREF_RANGE_TYPE_MASK);
    eval 'sub PCI_PREF_RANGE_TYPE_32 () {0x;}' unless defined(&PCI_PREF_RANGE_TYPE_32);
    eval 'sub PCI_PREF_RANGE_TYPE_64 () {0x1;}' unless defined(&PCI_PREF_RANGE_TYPE_64);
    eval 'sub PCI_PREF_RANGE_MASK () {(~0xf);}' unless defined(&PCI_PREF_RANGE_MASK);
    eval 'sub PCI_PREF_BASE_UPPER32 () {0x28;}' unless defined(&PCI_PREF_BASE_UPPER32);
    eval 'sub PCI_PREF_LIMIT_UPPER32 () {0x2c;}' unless defined(&PCI_PREF_LIMIT_UPPER32);
    eval 'sub PCI_IO_BASE_UPPER16 () {0x30;}' unless defined(&PCI_IO_BASE_UPPER16);
    eval 'sub PCI_IO_LIMIT_UPPER16 () {0x32;}' unless defined(&PCI_IO_LIMIT_UPPER16);
    eval 'sub PCI_ROM_ADDRESS1 () {0x38;}' unless defined(&PCI_ROM_ADDRESS1);
    eval 'sub PCI_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_BRIDGE_CONTROL);
    eval 'sub PCI_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_BRIDGE_CTL_PARITY);
    eval 'sub PCI_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_BRIDGE_CTL_SERR);
    eval 'sub PCI_BRIDGE_CTL_ISA () {0x4;}' unless defined(&PCI_BRIDGE_CTL_ISA);
    eval 'sub PCI_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_BRIDGE_CTL_VGA);
    eval 'sub PCI_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_BRIDGE_CTL_BUS_RESET () {0x40;}' unless defined(&PCI_BRIDGE_CTL_BUS_RESET);
    eval 'sub PCI_BRIDGE_CTL_FAST_BACK () {0x80;}' unless defined(&PCI_BRIDGE_CTL_FAST_BACK);
    eval 'sub PCI_CB_CAPABILITY_LIST () {0x14;}' unless defined(&PCI_CB_CAPABILITY_LIST);
    eval 'sub PCI_CB_SEC_STATUS () {0x16;}' unless defined(&PCI_CB_SEC_STATUS);
    eval 'sub PCI_CB_PRIMARY_BUS () {0x18;}' unless defined(&PCI_CB_PRIMARY_BUS);
    eval 'sub PCI_CB_CARD_BUS () {0x19;}' unless defined(&PCI_CB_CARD_BUS);
    eval 'sub PCI_CB_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_CB_SUBORDINATE_BUS);
    eval 'sub PCI_CB_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_CB_LATENCY_TIMER);
    eval 'sub PCI_CB_MEMORY_BASE_0 () {0x1c;}' unless defined(&PCI_CB_MEMORY_BASE_0);
    eval 'sub PCI_CB_MEMORY_LIMIT_0 () {0x20;}' unless defined(&PCI_CB_MEMORY_LIMIT_0);
    eval 'sub PCI_CB_MEMORY_BASE_1 () {0x24;}' unless defined(&PCI_CB_MEMORY_BASE_1);
    eval 'sub PCI_CB_MEMORY_LIMIT_1 () {0x28;}' unless defined(&PCI_CB_MEMORY_LIMIT_1);
    eval 'sub PCI_CB_IO_BASE_0 () {0x2c;}' unless defined(&PCI_CB_IO_BASE_0);
    eval 'sub PCI_CB_IO_BASE_0_HI () {0x2e;}' unless defined(&PCI_CB_IO_BASE_0_HI);
    eval 'sub PCI_CB_IO_LIMIT_0 () {0x30;}' unless defined(&PCI_CB_IO_LIMIT_0);
    eval 'sub PCI_CB_IO_LIMIT_0_HI () {0x32;}' unless defined(&PCI_CB_IO_LIMIT_0_HI);
    eval 'sub PCI_CB_IO_BASE_1 () {0x34;}' unless defined(&PCI_CB_IO_BASE_1);
    eval 'sub PCI_CB_IO_BASE_1_HI () {0x36;}' unless defined(&PCI_CB_IO_BASE_1_HI);
    eval 'sub PCI_CB_IO_LIMIT_1 () {0x38;}' unless defined(&PCI_CB_IO_LIMIT_1);
    eval 'sub PCI_CB_IO_LIMIT_1_HI () {0x3a;}' unless defined(&PCI_CB_IO_LIMIT_1_HI);
    eval 'sub PCI_CB_IO_RANGE_MASK () {(~0x3);}' unless defined(&PCI_CB_IO_RANGE_MASK);
    eval 'sub PCI_CB_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_CB_BRIDGE_CONTROL);
    eval 'sub PCI_CB_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_CB_BRIDGE_CTL_PARITY);
    eval 'sub PCI_CB_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_CB_BRIDGE_CTL_SERR);
    eval 'sub PCI_CB_BRIDGE_CTL_ISA () {0x4;}' unless defined(&PCI_CB_BRIDGE_CTL_ISA);
    eval 'sub PCI_CB_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_CB_BRIDGE_CTL_VGA);
    eval 'sub PCI_CB_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_CB_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_CB_BRIDGE_CTL_CB_RESET () {0x40;}' unless defined(&PCI_CB_BRIDGE_CTL_CB_RESET);
    eval 'sub PCI_CB_BRIDGE_CTL_16BIT_INT () {0x80;}' unless defined(&PCI_CB_BRIDGE_CTL_16BIT_INT);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM0 () {0x100;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM0);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM1 () {0x200;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM1);
    eval 'sub PCI_CB_BRIDGE_CTL_POST_WRITES () {0x400;}' unless defined(&PCI_CB_BRIDGE_CTL_POST_WRITES);
    eval 'sub PCI_CB_SUBSYSTEM_VENDOR_ID () {0x40;}' unless defined(&PCI_CB_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_CB_SUBSYSTEM_ID () {0x42;}' unless defined(&PCI_CB_SUBSYSTEM_ID);
    eval 'sub PCI_CB_LEGACY_MODE_BASE () {0x44;}' unless defined(&PCI_CB_LEGACY_MODE_BASE);
    eval 'sub PCI_CAP_LIST_ID () {0;}' unless defined(&PCI_CAP_LIST_ID);
    eval 'sub PCI_CAP_ID_PM () {0x1;}' unless defined(&PCI_CAP_ID_PM);
    eval 'sub PCI_CAP_ID_AGP () {0x2;}' unless defined(&PCI_CAP_ID_AGP);
    eval 'sub PCI_CAP_ID_VPD () {0x3;}' unless defined(&PCI_CAP_ID_VPD);
    eval 'sub PCI_CAP_ID_SLOTID () {0x4;}' unless defined(&PCI_CAP_ID_SLOTID);
    eval 'sub PCI_CAP_ID_MSI () {0x5;}' unless defined(&PCI_CAP_ID_MSI);
    eval 'sub PCI_CAP_ID_CHSWP () {0x6;}' unless defined(&PCI_CAP_ID_CHSWP);
    eval 'sub PCI_CAP_ID_PCIX () {0x7;}' unless defined(&PCI_CAP_ID_PCIX);
    eval 'sub PCI_CAP_ID_HT () {0x8;}' unless defined(&PCI_CAP_ID_HT);
    eval 'sub PCI_CAP_ID_VNDR () {0x9;}' unless defined(&PCI_CAP_ID_VNDR);
    eval 'sub PCI_CAP_ID_DBG () {0xa;}' unless defined(&PCI_CAP_ID_DBG);
    eval 'sub PCI_CAP_ID_CCRC () {0xb;}' unless defined(&PCI_CAP_ID_CCRC);
    eval 'sub PCI_CAP_ID_SHPC () {0xc;}' unless defined(&PCI_CAP_ID_SHPC);
    eval 'sub PCI_CAP_ID_SSVID () {0xd;}' unless defined(&PCI_CAP_ID_SSVID);
    eval 'sub PCI_CAP_ID_AGP3 () {0xe;}' unless defined(&PCI_CAP_ID_AGP3);
    eval 'sub PCI_CAP_ID_SECDEV () {0xf;}' unless defined(&PCI_CAP_ID_SECDEV);
    eval 'sub PCI_CAP_ID_EXP () {0x10;}' unless defined(&PCI_CAP_ID_EXP);
    eval 'sub PCI_CAP_ID_MSIX () {0x11;}' unless defined(&PCI_CAP_ID_MSIX);
    eval 'sub PCI_CAP_ID_SATA () {0x12;}' unless defined(&PCI_CAP_ID_SATA);
    eval 'sub PCI_CAP_ID_AF () {0x13;}' unless defined(&PCI_CAP_ID_AF);
    eval 'sub PCI_CAP_ID_EA () {0x14;}' unless defined(&PCI_CAP_ID_EA);
    eval 'sub PCI_CAP_ID_MAX () { &PCI_CAP_ID_EA;}' unless defined(&PCI_CAP_ID_MAX);
    eval 'sub PCI_CAP_LIST_NEXT () {1;}' unless defined(&PCI_CAP_LIST_NEXT);
    eval 'sub PCI_CAP_FLAGS () {2;}' unless defined(&PCI_CAP_FLAGS);
    eval 'sub PCI_CAP_SIZEOF () {4;}' unless defined(&PCI_CAP_SIZEOF);
    eval 'sub PCI_PM_PMC () {2;}' unless defined(&PCI_PM_PMC);
    eval 'sub PCI_PM_CAP_VER_MASK () {0x7;}' unless defined(&PCI_PM_CAP_VER_MASK);
    eval 'sub PCI_PM_CAP_PME_CLOCK () {0x8;}' unless defined(&PCI_PM_CAP_PME_CLOCK);
    eval 'sub PCI_PM_CAP_RESERVED () {0x10;}' unless defined(&PCI_PM_CAP_RESERVED);
    eval 'sub PCI_PM_CAP_DSI () {0x20;}' unless defined(&PCI_PM_CAP_DSI);
    eval 'sub PCI_PM_CAP_AUX_POWER () {0x1c0;}' unless defined(&PCI_PM_CAP_AUX_POWER);
    eval 'sub PCI_PM_CAP_D1 () {0x200;}' unless defined(&PCI_PM_CAP_D1);
    eval 'sub PCI_PM_CAP_D2 () {0x400;}' unless defined(&PCI_PM_CAP_D2);
    eval 'sub PCI_PM_CAP_PME () {0x800;}' unless defined(&PCI_PM_CAP_PME);
    eval 'sub PCI_PM_CAP_PME_MASK () {0xf800;}' unless defined(&PCI_PM_CAP_PME_MASK);
    eval 'sub PCI_PM_CAP_PME_D0 () {0x800;}' unless defined(&PCI_PM_CAP_PME_D0);
    eval 'sub PCI_PM_CAP_PME_D1 () {0x1000;}' unless defined(&PCI_PM_CAP_PME_D1);
    eval 'sub PCI_PM_CAP_PME_D2 () {0x2000;}' unless defined(&PCI_PM_CAP_PME_D2);
    eval 'sub PCI_PM_CAP_PME_D3hot () {0x4000;}' unless defined(&PCI_PM_CAP_PME_D3hot);
    eval 'sub PCI_PM_CAP_PME_D3cold () {0x8000;}' unless defined(&PCI_PM_CAP_PME_D3cold);
    eval 'sub PCI_PM_CAP_PME_SHIFT () {11;}' unless defined(&PCI_PM_CAP_PME_SHIFT);
    eval 'sub PCI_PM_CTRL () {4;}' unless defined(&PCI_PM_CTRL);
    eval 'sub PCI_PM_CTRL_STATE_MASK () {0x3;}' unless defined(&PCI_PM_CTRL_STATE_MASK);
    eval 'sub PCI_PM_CTRL_NO_SOFT_RESET () {0x8;}' unless defined(&PCI_PM_CTRL_NO_SOFT_RESET);
    eval 'sub PCI_PM_CTRL_PME_ENABLE () {0x100;}' unless defined(&PCI_PM_CTRL_PME_ENABLE);
    eval 'sub PCI_PM_CTRL_DATA_SEL_MASK () {0x1e00;}' unless defined(&PCI_PM_CTRL_DATA_SEL_MASK);
    eval 'sub PCI_PM_CTRL_DATA_SCALE_MASK () {0x6000;}' unless defined(&PCI_PM_CTRL_DATA_SCALE_MASK);
    eval 'sub PCI_PM_CTRL_PME_STATUS () {0x8000;}' unless defined(&PCI_PM_CTRL_PME_STATUS);
    eval 'sub PCI_PM_PPB_EXTENSIONS () {6;}' unless defined(&PCI_PM_PPB_EXTENSIONS);
    eval 'sub PCI_PM_PPB_B2_B3 () {0x40;}' unless defined(&PCI_PM_PPB_B2_B3);
    eval 'sub PCI_PM_BPCC_ENABLE () {0x80;}' unless defined(&PCI_PM_BPCC_ENABLE);
    eval 'sub PCI_PM_DATA_REGISTER () {7;}' unless defined(&PCI_PM_DATA_REGISTER);
    eval 'sub PCI_PM_SIZEOF () {8;}' unless defined(&PCI_PM_SIZEOF);
    eval 'sub PCI_AGP_VERSION () {2;}' unless defined(&PCI_AGP_VERSION);
    eval 'sub PCI_AGP_RFU () {3;}' unless defined(&PCI_AGP_RFU);
    eval 'sub PCI_AGP_STATUS () {4;}' unless defined(&PCI_AGP_STATUS);
    eval 'sub PCI_AGP_STATUS_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_STATUS_RQ_MASK);
    eval 'sub PCI_AGP_STATUS_SBA () {0x200;}' unless defined(&PCI_AGP_STATUS_SBA);
    eval 'sub PCI_AGP_STATUS_64BIT () {0x20;}' unless defined(&PCI_AGP_STATUS_64BIT);
    eval 'sub PCI_AGP_STATUS_FW () {0x10;}' unless defined(&PCI_AGP_STATUS_FW);
    eval 'sub PCI_AGP_STATUS_RATE4 () {0x4;}' unless defined(&PCI_AGP_STATUS_RATE4);
    eval 'sub PCI_AGP_STATUS_RATE2 () {0x2;}' unless defined(&PCI_AGP_STATUS_RATE2);
    eval 'sub PCI_AGP_STATUS_RATE1 () {0x1;}' unless defined(&PCI_AGP_STATUS_RATE1);
    eval 'sub PCI_AGP_COMMAND () {8;}' unless defined(&PCI_AGP_COMMAND);
    eval 'sub PCI_AGP_COMMAND_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_COMMAND_RQ_MASK);
    eval 'sub PCI_AGP_COMMAND_SBA () {0x200;}' unless defined(&PCI_AGP_COMMAND_SBA);
    eval 'sub PCI_AGP_COMMAND_AGP () {0x100;}' unless defined(&PCI_AGP_COMMAND_AGP);
    eval 'sub PCI_AGP_COMMAND_64BIT () {0x20;}' unless defined(&PCI_AGP_COMMAND_64BIT);
    eval 'sub PCI_AGP_COMMAND_FW () {0x10;}' unless defined(&PCI_AGP_COMMAND_FW);
    eval 'sub PCI_AGP_COMMAND_RATE4 () {0x4;}' unless defined(&PCI_AGP_COMMAND_RATE4);
    eval 'sub PCI_AGP_COMMAND_RATE2 () {0x2;}' unless defined(&PCI_AGP_COMMAND_RATE2);
    eval 'sub PCI_AGP_COMMAND_RATE1 () {0x1;}' unless defined(&PCI_AGP_COMMAND_RATE1);
    eval 'sub PCI_AGP_SIZEOF () {12;}' unless defined(&PCI_AGP_SIZEOF);
    eval 'sub PCI_VPD_ADDR () {2;}' unless defined(&PCI_VPD_ADDR);
    eval 'sub PCI_VPD_ADDR_MASK () {0x7fff;}' unless defined(&PCI_VPD_ADDR_MASK);
    eval 'sub PCI_VPD_ADDR_F () {0x8000;}' unless defined(&PCI_VPD_ADDR_F);
    eval 'sub PCI_VPD_DATA () {4;}' unless defined(&PCI_VPD_DATA);
    eval 'sub PCI_CAP_VPD_SIZEOF () {8;}' unless defined(&PCI_CAP_VPD_SIZEOF);
    eval 'sub PCI_SID_ESR () {2;}' unless defined(&PCI_SID_ESR);
    eval 'sub PCI_SID_ESR_NSLOTS () {0x1f;}' unless defined(&PCI_SID_ESR_NSLOTS);
    eval 'sub PCI_SID_ESR_FIC () {0x20;}' unless defined(&PCI_SID_ESR_FIC);
    eval 'sub PCI_SID_CHASSIS_NR () {3;}' unless defined(&PCI_SID_CHASSIS_NR);
    eval 'sub PCI_MSI_FLAGS () {0x2;}' unless defined(&PCI_MSI_FLAGS);
    eval 'sub PCI_MSI_FLAGS_ENABLE () {0x1;}' unless defined(&PCI_MSI_FLAGS_ENABLE);
    eval 'sub PCI_MSI_FLAGS_QMASK () {0xe;}' unless defined(&PCI_MSI_FLAGS_QMASK);
    eval 'sub PCI_MSI_FLAGS_QSIZE () {0x70;}' unless defined(&PCI_MSI_FLAGS_QSIZE);
    eval 'sub PCI_MSI_FLAGS_64BIT () {0x80;}' unless defined(&PCI_MSI_FLAGS_64BIT);
    eval 'sub PCI_MSI_FLAGS_MASKBIT () {0x100;}' unless defined(&PCI_MSI_FLAGS_MASKBIT);
    eval 'sub PCI_MSI_RFU () {3;}' unless defined(&PCI_MSI_RFU);
    eval 'sub PCI_MSI_ADDRESS_LO () {0x4;}' unless defined(&PCI_MSI_ADDRESS_LO);
    eval 'sub PCI_MSI_ADDRESS_HI () {0x8;}' unless defined(&PCI_MSI_ADDRESS_HI);
    eval 'sub PCI_MSI_DATA_32 () {0x8;}' unless defined(&PCI_MSI_DATA_32);
    eval 'sub PCI_MSI_MASK_32 () {0xc;}' unless defined(&PCI_MSI_MASK_32);
    eval 'sub PCI_MSI_PENDING_32 () {0x10;}' unless defined(&PCI_MSI_PENDING_32);
    eval 'sub PCI_MSI_DATA_64 () {0xc;}' unless defined(&PCI_MSI_DATA_64);
    eval 'sub PCI_MSI_MASK_64 () {0x10;}' unless defined(&PCI_MSI_MASK_64);
    eval 'sub PCI_MSI_PENDING_64 () {0x14;}' unless defined(&PCI_MSI_PENDING_64);
    eval 'sub PCI_MSIX_FLAGS () {2;}' unless defined(&PCI_MSIX_FLAGS);
    eval 'sub PCI_MSIX_FLAGS_QSIZE () {0x7ff;}' unless defined(&PCI_MSIX_FLAGS_QSIZE);
    eval 'sub PCI_MSIX_FLAGS_MASKALL () {0x4000;}' unless defined(&PCI_MSIX_FLAGS_MASKALL);
    eval 'sub PCI_MSIX_FLAGS_ENABLE () {0x8000;}' unless defined(&PCI_MSIX_FLAGS_ENABLE);
    eval 'sub PCI_MSIX_TABLE () {4;}' unless defined(&PCI_MSIX_TABLE);
    eval 'sub PCI_MSIX_TABLE_BIR () {0x7;}' unless defined(&PCI_MSIX_TABLE_BIR);
    eval 'sub PCI_MSIX_TABLE_OFFSET () {0xfffffff8;}' unless defined(&PCI_MSIX_TABLE_OFFSET);
    eval 'sub PCI_MSIX_PBA () {8;}' unless defined(&PCI_MSIX_PBA);
    eval 'sub PCI_MSIX_PBA_BIR () {0x7;}' unless defined(&PCI_MSIX_PBA_BIR);
    eval 'sub PCI_MSIX_PBA_OFFSET () {0xfffffff8;}' unless defined(&PCI_MSIX_PBA_OFFSET);
    eval 'sub PCI_MSIX_FLAGS_BIRMASK () { &PCI_MSIX_PBA_BIR;}' unless defined(&PCI_MSIX_FLAGS_BIRMASK);
    eval 'sub PCI_CAP_MSIX_SIZEOF () {12;}' unless defined(&PCI_CAP_MSIX_SIZEOF);
    eval 'sub PCI_MSIX_ENTRY_SIZE () {16;}' unless defined(&PCI_MSIX_ENTRY_SIZE);
    eval 'sub PCI_MSIX_ENTRY_LOWER_ADDR () {0x;}' unless defined(&PCI_MSIX_ENTRY_LOWER_ADDR);
    eval 'sub PCI_MSIX_ENTRY_UPPER_ADDR () {0x4;}' unless defined(&PCI_MSIX_ENTRY_UPPER_ADDR);
    eval 'sub PCI_MSIX_ENTRY_DATA () {0x8;}' unless defined(&PCI_MSIX_ENTRY_DATA);
    eval 'sub PCI_MSIX_ENTRY_VECTOR_CTRL () {0xc;}' unless defined(&PCI_MSIX_ENTRY_VECTOR_CTRL);
    eval 'sub PCI_MSIX_ENTRY_CTRL_MASKBIT () {0x1;}' unless defined(&PCI_MSIX_ENTRY_CTRL_MASKBIT);
    eval 'sub PCI_MSIX_ENTRY_CTRL_ST () {0xffff0000;}' unless defined(&PCI_MSIX_ENTRY_CTRL_ST);
    eval 'sub PCI_CHSWP_CSR () {2;}' unless defined(&PCI_CHSWP_CSR);
    eval 'sub PCI_CHSWP_DHA () {0x1;}' unless defined(&PCI_CHSWP_DHA);
    eval 'sub PCI_CHSWP_EIM () {0x2;}' unless defined(&PCI_CHSWP_EIM);
    eval 'sub PCI_CHSWP_PIE () {0x4;}' unless defined(&PCI_CHSWP_PIE);
    eval 'sub PCI_CHSWP_LOO () {0x8;}' unless defined(&PCI_CHSWP_LOO);
    eval 'sub PCI_CHSWP_PI () {0x30;}' unless defined(&PCI_CHSWP_PI);
    eval 'sub PCI_CHSWP_EXT () {0x40;}' unless defined(&PCI_CHSWP_EXT);
    eval 'sub PCI_CHSWP_INS () {0x80;}' unless defined(&PCI_CHSWP_INS);
    eval 'sub PCI_AF_LENGTH () {2;}' unless defined(&PCI_AF_LENGTH);
    eval 'sub PCI_AF_CAP () {3;}' unless defined(&PCI_AF_CAP);
    eval 'sub PCI_AF_CAP_TP () {0x1;}' unless defined(&PCI_AF_CAP_TP);
    eval 'sub PCI_AF_CAP_FLR () {0x2;}' unless defined(&PCI_AF_CAP_FLR);
    eval 'sub PCI_AF_CTRL () {4;}' unless defined(&PCI_AF_CTRL);
    eval 'sub PCI_AF_CTRL_FLR () {0x1;}' unless defined(&PCI_AF_CTRL_FLR);
    eval 'sub PCI_AF_STATUS () {5;}' unless defined(&PCI_AF_STATUS);
    eval 'sub PCI_AF_STATUS_TP () {0x1;}' unless defined(&PCI_AF_STATUS_TP);
    eval 'sub PCI_CAP_AF_SIZEOF () {6;}' unless defined(&PCI_CAP_AF_SIZEOF);
    eval 'sub PCI_EA_NUM_ENT () {2;}' unless defined(&PCI_EA_NUM_ENT);
    eval 'sub PCI_EA_NUM_ENT_MASK () {0x3f;}' unless defined(&PCI_EA_NUM_ENT_MASK);
    eval 'sub PCI_EA_FIRST_ENT () {4;}' unless defined(&PCI_EA_FIRST_ENT);
    eval 'sub PCI_EA_FIRST_ENT_BRIDGE () {8;}' unless defined(&PCI_EA_FIRST_ENT_BRIDGE);
    eval 'sub PCI_EA_ES () {0x7;}' unless defined(&PCI_EA_ES);
    eval 'sub PCI_EA_BEI () {0xf0;}' unless defined(&PCI_EA_BEI);
    eval 'sub PCI_EA_SEC_BUS_MASK () {0xff;}' unless defined(&PCI_EA_SEC_BUS_MASK);
    eval 'sub PCI_EA_SUB_BUS_MASK () {0xff00;}' unless defined(&PCI_EA_SUB_BUS_MASK);
    eval 'sub PCI_EA_SUB_BUS_SHIFT () {8;}' unless defined(&PCI_EA_SUB_BUS_SHIFT);
    eval 'sub PCI_EA_BEI_BAR0 () {0;}' unless defined(&PCI_EA_BEI_BAR0);
    eval 'sub PCI_EA_BEI_BAR5 () {5;}' unless defined(&PCI_EA_BEI_BAR5);
    eval 'sub PCI_EA_BEI_BRIDGE () {6;}' unless defined(&PCI_EA_BEI_BRIDGE);
    eval 'sub PCI_EA_BEI_ENI () {7;}' unless defined(&PCI_EA_BEI_ENI);
    eval 'sub PCI_EA_BEI_ROM () {8;}' unless defined(&PCI_EA_BEI_ROM);
    eval 'sub PCI_EA_BEI_VF_BAR0 () {9;}' unless defined(&PCI_EA_BEI_VF_BAR0);
    eval 'sub PCI_EA_BEI_VF_BAR5 () {14;}' unless defined(&PCI_EA_BEI_VF_BAR5);
    eval 'sub PCI_EA_BEI_RESERVED () {15;}' unless defined(&PCI_EA_BEI_RESERVED);
    eval 'sub PCI_EA_PP () {0xff00;}' unless defined(&PCI_EA_PP);
    eval 'sub PCI_EA_SP () {0xff0000;}' unless defined(&PCI_EA_SP);
    eval 'sub PCI_EA_P_MEM () {0x;}' unless defined(&PCI_EA_P_MEM);
    eval 'sub PCI_EA_P_MEM_PREFETCH () {0x1;}' unless defined(&PCI_EA_P_MEM_PREFETCH);
    eval 'sub PCI_EA_P_IO () {0x2;}' unless defined(&PCI_EA_P_IO);
    eval 'sub PCI_EA_P_VF_MEM_PREFETCH () {0x3;}' unless defined(&PCI_EA_P_VF_MEM_PREFETCH);
    eval 'sub PCI_EA_P_VF_MEM () {0x4;}' unless defined(&PCI_EA_P_VF_MEM);
    eval 'sub PCI_EA_P_BRIDGE_MEM () {0x5;}' unless defined(&PCI_EA_P_BRIDGE_MEM);
    eval 'sub PCI_EA_P_BRIDGE_MEM_PREFETCH () {0x6;}' unless defined(&PCI_EA_P_BRIDGE_MEM_PREFETCH);
    eval 'sub PCI_EA_P_BRIDGE_IO () {0x7;}' unless defined(&PCI_EA_P_BRIDGE_IO);
    eval 'sub PCI_EA_P_MEM_RESERVED () {0xfd;}' unless defined(&PCI_EA_P_MEM_RESERVED);
    eval 'sub PCI_EA_P_IO_RESERVED () {0xfe;}' unless defined(&PCI_EA_P_IO_RESERVED);
    eval 'sub PCI_EA_P_UNAVAILABLE () {0xff;}' unless defined(&PCI_EA_P_UNAVAILABLE);
    eval 'sub PCI_EA_WRITABLE () {0x40000000;}' unless defined(&PCI_EA_WRITABLE);
    eval 'sub PCI_EA_ENABLE () {0x80000000;}' unless defined(&PCI_EA_ENABLE);
    eval 'sub PCI_EA_BASE () {4;}' unless defined(&PCI_EA_BASE);
    eval 'sub PCI_EA_MAX_OFFSET () {8;}' unless defined(&PCI_EA_MAX_OFFSET);
    eval 'sub PCI_EA_IS_64 () {0x2;}' unless defined(&PCI_EA_IS_64);
    eval 'sub PCI_EA_FIELD_MASK () {0xfffffffc;}' unless defined(&PCI_EA_FIELD_MASK);
    eval 'sub PCI_X_CMD () {2;}' unless defined(&PCI_X_CMD);
    eval 'sub PCI_X_CMD_DPERR_E () {0x1;}' unless defined(&PCI_X_CMD_DPERR_E);
    eval 'sub PCI_X_CMD_ERO () {0x2;}' unless defined(&PCI_X_CMD_ERO);
    eval 'sub PCI_X_CMD_READ_512 () {0x;}' unless defined(&PCI_X_CMD_READ_512);
    eval 'sub PCI_X_CMD_READ_1K () {0x4;}' unless defined(&PCI_X_CMD_READ_1K);
    eval 'sub PCI_X_CMD_READ_2K () {0x8;}' unless defined(&PCI_X_CMD_READ_2K);
    eval 'sub PCI_X_CMD_READ_4K () {0xc;}' unless defined(&PCI_X_CMD_READ_4K);
    eval 'sub PCI_X_CMD_MAX_READ () {0xc;}' unless defined(&PCI_X_CMD_MAX_READ);
    eval 'sub PCI_X_CMD_SPLIT_1 () {0x;}' unless defined(&PCI_X_CMD_SPLIT_1);
    eval 'sub PCI_X_CMD_SPLIT_2 () {0x10;}' unless defined(&PCI_X_CMD_SPLIT_2);
    eval 'sub PCI_X_CMD_SPLIT_3 () {0x20;}' unless defined(&PCI_X_CMD_SPLIT_3);
    eval 'sub PCI_X_CMD_SPLIT_4 () {0x30;}' unless defined(&PCI_X_CMD_SPLIT_4);
    eval 'sub PCI_X_CMD_SPLIT_8 () {0x40;}' unless defined(&PCI_X_CMD_SPLIT_8);
    eval 'sub PCI_X_CMD_SPLIT_12 () {0x50;}' unless defined(&PCI_X_CMD_SPLIT_12);
    eval 'sub PCI_X_CMD_SPLIT_16 () {0x60;}' unless defined(&PCI_X_CMD_SPLIT_16);
    eval 'sub PCI_X_CMD_SPLIT_32 () {0x70;}' unless defined(&PCI_X_CMD_SPLIT_32);
    eval 'sub PCI_X_CMD_MAX_SPLIT () {0x70;}' unless defined(&PCI_X_CMD_MAX_SPLIT);
    eval 'sub PCI_X_CMD_VERSION {
        my($x) = @_;
	    eval q(((($x) >> 12) & 3));
    }' unless defined(&PCI_X_CMD_VERSION);
    eval 'sub PCI_X_STATUS () {4;}' unless defined(&PCI_X_STATUS);
    eval 'sub PCI_X_STATUS_DEVFN () {0xff;}' unless defined(&PCI_X_STATUS_DEVFN);
    eval 'sub PCI_X_STATUS_BUS () {0xff00;}' unless defined(&PCI_X_STATUS_BUS);
    eval 'sub PCI_X_STATUS_64BIT () {0x10000;}' unless defined(&PCI_X_STATUS_64BIT);
    eval 'sub PCI_X_STATUS_133MHZ () {0x20000;}' unless defined(&PCI_X_STATUS_133MHZ);
    eval 'sub PCI_X_STATUS_SPL_DISC () {0x40000;}' unless defined(&PCI_X_STATUS_SPL_DISC);
    eval 'sub PCI_X_STATUS_UNX_SPL () {0x80000;}' unless defined(&PCI_X_STATUS_UNX_SPL);
    eval 'sub PCI_X_STATUS_COMPLEX () {0x100000;}' unless defined(&PCI_X_STATUS_COMPLEX);
    eval 'sub PCI_X_STATUS_MAX_READ () {0x600000;}' unless defined(&PCI_X_STATUS_MAX_READ);
    eval 'sub PCI_X_STATUS_MAX_SPLIT () {0x3800000;}' unless defined(&PCI_X_STATUS_MAX_SPLIT);
    eval 'sub PCI_X_STATUS_MAX_CUM () {0x1c000000;}' unless defined(&PCI_X_STATUS_MAX_CUM);
    eval 'sub PCI_X_STATUS_SPL_ERR () {0x20000000;}' unless defined(&PCI_X_STATUS_SPL_ERR);
    eval 'sub PCI_X_STATUS_266MHZ () {0x40000000;}' unless defined(&PCI_X_STATUS_266MHZ);
    eval 'sub PCI_X_STATUS_533MHZ () {0x80000000;}' unless defined(&PCI_X_STATUS_533MHZ);
    eval 'sub PCI_X_ECC_CSR () {8;}' unless defined(&PCI_X_ECC_CSR);
    eval 'sub PCI_CAP_PCIX_SIZEOF_V0 () {8;}' unless defined(&PCI_CAP_PCIX_SIZEOF_V0);
    eval 'sub PCI_CAP_PCIX_SIZEOF_V1 () {24;}' unless defined(&PCI_CAP_PCIX_SIZEOF_V1);
    eval 'sub PCI_CAP_PCIX_SIZEOF_V2 () { &PCI_CAP_PCIX_SIZEOF_V1;}' unless defined(&PCI_CAP_PCIX_SIZEOF_V2);
    eval 'sub PCI_X_BRIDGE_SSTATUS () {2;}' unless defined(&PCI_X_BRIDGE_SSTATUS);
    eval 'sub PCI_X_SSTATUS_64BIT () {0x1;}' unless defined(&PCI_X_SSTATUS_64BIT);
    eval 'sub PCI_X_SSTATUS_133MHZ () {0x2;}' unless defined(&PCI_X_SSTATUS_133MHZ);
    eval 'sub PCI_X_SSTATUS_FREQ () {0x3c0;}' unless defined(&PCI_X_SSTATUS_FREQ);
    eval 'sub PCI_X_SSTATUS_VERS () {0x3000;}' unless defined(&PCI_X_SSTATUS_VERS);
    eval 'sub PCI_X_SSTATUS_V1 () {0x1000;}' unless defined(&PCI_X_SSTATUS_V1);
    eval 'sub PCI_X_SSTATUS_V2 () {0x2000;}' unless defined(&PCI_X_SSTATUS_V2);
    eval 'sub PCI_X_SSTATUS_266MHZ () {0x4000;}' unless defined(&PCI_X_SSTATUS_266MHZ);
    eval 'sub PCI_X_SSTATUS_533MHZ () {0x8000;}' unless defined(&PCI_X_SSTATUS_533MHZ);
    eval 'sub PCI_X_BRIDGE_STATUS () {4;}' unless defined(&PCI_X_BRIDGE_STATUS);
    eval 'sub PCI_SSVID_VENDOR_ID () {4;}' unless defined(&PCI_SSVID_VENDOR_ID);
    eval 'sub PCI_SSVID_DEVICE_ID () {6;}' unless defined(&PCI_SSVID_DEVICE_ID);
    eval 'sub PCI_EXP_FLAGS () {0x2;}' unless defined(&PCI_EXP_FLAGS);
    eval 'sub PCI_EXP_FLAGS_VERS () {0xf;}' unless defined(&PCI_EXP_FLAGS_VERS);
    eval 'sub PCI_EXP_FLAGS_TYPE () {0xf0;}' unless defined(&PCI_EXP_FLAGS_TYPE);
    eval 'sub PCI_EXP_TYPE_ENDPOINT () {0x;}' unless defined(&PCI_EXP_TYPE_ENDPOINT);
    eval 'sub PCI_EXP_TYPE_LEG_END () {0x1;}' unless defined(&PCI_EXP_TYPE_LEG_END);
    eval 'sub PCI_EXP_TYPE_ROOT_PORT () {0x4;}' unless defined(&PCI_EXP_TYPE_ROOT_PORT);
    eval 'sub PCI_EXP_TYPE_UPSTREAM () {0x5;}' unless defined(&PCI_EXP_TYPE_UPSTREAM);
    eval 'sub PCI_EXP_TYPE_DOWNSTREAM () {0x6;}' unless defined(&PCI_EXP_TYPE_DOWNSTREAM);
    eval 'sub PCI_EXP_TYPE_PCI_BRIDGE () {0x7;}' unless defined(&PCI_EXP_TYPE_PCI_BRIDGE);
    eval 'sub PCI_EXP_TYPE_PCIE_BRIDGE () {0x8;}' unless defined(&PCI_EXP_TYPE_PCIE_BRIDGE);
    eval 'sub PCI_EXP_TYPE_RC_END () {0x9;}' unless defined(&PCI_EXP_TYPE_RC_END);
    eval 'sub PCI_EXP_TYPE_RC_EC () {0xa;}' unless defined(&PCI_EXP_TYPE_RC_EC);
    eval 'sub PCI_EXP_FLAGS_SLOT () {0x100;}' unless defined(&PCI_EXP_FLAGS_SLOT);
    eval 'sub PCI_EXP_FLAGS_IRQ () {0x3e00;}' unless defined(&PCI_EXP_FLAGS_IRQ);
    eval 'sub PCI_EXP_DEVCAP () {0x4;}' unless defined(&PCI_EXP_DEVCAP);
    eval 'sub PCI_EXP_DEVCAP_PAYLOAD () {0x7;}' unless defined(&PCI_EXP_DEVCAP_PAYLOAD);
    eval 'sub PCI_EXP_DEVCAP_PHANTOM () {0x18;}' unless defined(&PCI_EXP_DEVCAP_PHANTOM);
    eval 'sub PCI_EXP_DEVCAP_EXT_TAG () {0x20;}' unless defined(&PCI_EXP_DEVCAP_EXT_TAG);
    eval 'sub PCI_EXP_DEVCAP_L0S () {0x1c0;}' unless defined(&PCI_EXP_DEVCAP_L0S);
    eval 'sub PCI_EXP_DEVCAP_L1 () {0xe00;}' unless defined(&PCI_EXP_DEVCAP_L1);
    eval 'sub PCI_EXP_DEVCAP_ATN_BUT () {0x1000;}' unless defined(&PCI_EXP_DEVCAP_ATN_BUT);
    eval 'sub PCI_EXP_DEVCAP_ATN_IND () {0x2000;}' unless defined(&PCI_EXP_DEVCAP_ATN_IND);
    eval 'sub PCI_EXP_DEVCAP_PWR_IND () {0x4000;}' unless defined(&PCI_EXP_DEVCAP_PWR_IND);
    eval 'sub PCI_EXP_DEVCAP_RBER () {0x8000;}' unless defined(&PCI_EXP_DEVCAP_RBER);
    eval 'sub PCI_EXP_DEVCAP_PWR_VAL () {0x3fc0000;}' unless defined(&PCI_EXP_DEVCAP_PWR_VAL);
    eval 'sub PCI_EXP_DEVCAP_PWR_SCL () {0xc000000;}' unless defined(&PCI_EXP_DEVCAP_PWR_SCL);
    eval 'sub PCI_EXP_DEVCAP_FLR () {0x10000000;}' unless defined(&PCI_EXP_DEVCAP_FLR);
    eval 'sub PCI_EXP_DEVCTL () {0x8;}' unless defined(&PCI_EXP_DEVCTL);
    eval 'sub PCI_EXP_DEVCTL_CERE () {0x1;}' unless defined(&PCI_EXP_DEVCTL_CERE);
    eval 'sub PCI_EXP_DEVCTL_NFERE () {0x2;}' unless defined(&PCI_EXP_DEVCTL_NFERE);
    eval 'sub PCI_EXP_DEVCTL_FERE () {0x4;}' unless defined(&PCI_EXP_DEVCTL_FERE);
    eval 'sub PCI_EXP_DEVCTL_URRE () {0x8;}' unless defined(&PCI_EXP_DEVCTL_URRE);
    eval 'sub PCI_EXP_DEVCTL_RELAX_EN () {0x10;}' unless defined(&PCI_EXP_DEVCTL_RELAX_EN);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD () {0xe0;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD_128B () {0x;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD_128B);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD_256B () {0x20;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD_256B);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD_512B () {0x40;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD_512B);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD_1024B () {0x60;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD_1024B);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD_2048B () {0x80;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD_2048B);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD_4096B () {0xa0;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD_4096B);
    eval 'sub PCI_EXP_DEVCTL_EXT_TAG () {0x100;}' unless defined(&PCI_EXP_DEVCTL_EXT_TAG);
    eval 'sub PCI_EXP_DEVCTL_PHANTOM () {0x200;}' unless defined(&PCI_EXP_DEVCTL_PHANTOM);
    eval 'sub PCI_EXP_DEVCTL_AUX_PME () {0x400;}' unless defined(&PCI_EXP_DEVCTL_AUX_PME);
    eval 'sub PCI_EXP_DEVCTL_NOSNOOP_EN () {0x800;}' unless defined(&PCI_EXP_DEVCTL_NOSNOOP_EN);
    eval 'sub PCI_EXP_DEVCTL_READRQ () {0x7000;}' unless defined(&PCI_EXP_DEVCTL_READRQ);
    eval 'sub PCI_EXP_DEVCTL_READRQ_128B () {0x;}' unless defined(&PCI_EXP_DEVCTL_READRQ_128B);
    eval 'sub PCI_EXP_DEVCTL_READRQ_256B () {0x1000;}' unless defined(&PCI_EXP_DEVCTL_READRQ_256B);
    eval 'sub PCI_EXP_DEVCTL_READRQ_512B () {0x2000;}' unless defined(&PCI_EXP_DEVCTL_READRQ_512B);
    eval 'sub PCI_EXP_DEVCTL_READRQ_1024B () {0x3000;}' unless defined(&PCI_EXP_DEVCTL_READRQ_1024B);
    eval 'sub PCI_EXP_DEVCTL_READRQ_2048B () {0x4000;}' unless defined(&PCI_EXP_DEVCTL_READRQ_2048B);
    eval 'sub PCI_EXP_DEVCTL_READRQ_4096B () {0x5000;}' unless defined(&PCI_EXP_DEVCTL_READRQ_4096B);
    eval 'sub PCI_EXP_DEVCTL_BCR_FLR () {0x8000;}' unless defined(&PCI_EXP_DEVCTL_BCR_FLR);
    eval 'sub PCI_EXP_DEVSTA () {0xa;}' unless defined(&PCI_EXP_DEVSTA);
    eval 'sub PCI_EXP_DEVSTA_CED () {0x1;}' unless defined(&PCI_EXP_DEVSTA_CED);
    eval 'sub PCI_EXP_DEVSTA_NFED () {0x2;}' unless defined(&PCI_EXP_DEVSTA_NFED);
    eval 'sub PCI_EXP_DEVSTA_FED () {0x4;}' unless defined(&PCI_EXP_DEVSTA_FED);
    eval 'sub PCI_EXP_DEVSTA_URD () {0x8;}' unless defined(&PCI_EXP_DEVSTA_URD);
    eval 'sub PCI_EXP_DEVSTA_AUXPD () {0x10;}' unless defined(&PCI_EXP_DEVSTA_AUXPD);
    eval 'sub PCI_EXP_DEVSTA_TRPND () {0x20;}' unless defined(&PCI_EXP_DEVSTA_TRPND);
    eval 'sub PCI_CAP_EXP_RC_ENDPOINT_SIZEOF_V1 () {12;}' unless defined(&PCI_CAP_EXP_RC_ENDPOINT_SIZEOF_V1);
    eval 'sub PCI_EXP_LNKCAP () {0xc;}' unless defined(&PCI_EXP_LNKCAP);
    eval 'sub PCI_EXP_LNKCAP_SLS () {0xf;}' unless defined(&PCI_EXP_LNKCAP_SLS);
    eval 'sub PCI_EXP_LNKCAP_SLS_2_5GB () {0x1;}' unless defined(&PCI_EXP_LNKCAP_SLS_2_5GB);
    eval 'sub PCI_EXP_LNKCAP_SLS_5_0GB () {0x2;}' unless defined(&PCI_EXP_LNKCAP_SLS_5_0GB);
    eval 'sub PCI_EXP_LNKCAP_SLS_8_0GB () {0x3;}' unless defined(&PCI_EXP_LNKCAP_SLS_8_0GB);
    eval 'sub PCI_EXP_LNKCAP_SLS_16_0GB () {0x4;}' unless defined(&PCI_EXP_LNKCAP_SLS_16_0GB);
    eval 'sub PCI_EXP_LNKCAP_SLS_32_0GB () {0x5;}' unless defined(&PCI_EXP_LNKCAP_SLS_32_0GB);
    eval 'sub PCI_EXP_LNKCAP_SLS_64_0GB () {0x6;}' unless defined(&PCI_EXP_LNKCAP_SLS_64_0GB);
    eval 'sub PCI_EXP_LNKCAP_MLW () {0x3f0;}' unless defined(&PCI_EXP_LNKCAP_MLW);
    eval 'sub PCI_EXP_LNKCAP_ASPMS () {0xc00;}' unless defined(&PCI_EXP_LNKCAP_ASPMS);
    eval 'sub PCI_EXP_LNKCAP_ASPM_L0S () {0x400;}' unless defined(&PCI_EXP_LNKCAP_ASPM_L0S);
    eval 'sub PCI_EXP_LNKCAP_ASPM_L1 () {0x800;}' unless defined(&PCI_EXP_LNKCAP_ASPM_L1);
    eval 'sub PCI_EXP_LNKCAP_L0SEL () {0x7000;}' unless defined(&PCI_EXP_LNKCAP_L0SEL);
    eval 'sub PCI_EXP_LNKCAP_L1EL () {0x38000;}' unless defined(&PCI_EXP_LNKCAP_L1EL);
    eval 'sub PCI_EXP_LNKCAP_CLKPM () {0x40000;}' unless defined(&PCI_EXP_LNKCAP_CLKPM);
    eval 'sub PCI_EXP_LNKCAP_SDERC () {0x80000;}' unless defined(&PCI_EXP_LNKCAP_SDERC);
    eval 'sub PCI_EXP_LNKCAP_DLLLARC () {0x100000;}' unless defined(&PCI_EXP_LNKCAP_DLLLARC);
    eval 'sub PCI_EXP_LNKCAP_LBNC () {0x200000;}' unless defined(&PCI_EXP_LNKCAP_LBNC);
    eval 'sub PCI_EXP_LNKCAP_PN () {0xff000000;}' unless defined(&PCI_EXP_LNKCAP_PN);
    eval 'sub PCI_EXP_LNKCTL () {0x10;}' unless defined(&PCI_EXP_LNKCTL);
    eval 'sub PCI_EXP_LNKCTL_ASPMC () {0x3;}' unless defined(&PCI_EXP_LNKCTL_ASPMC);
    eval 'sub PCI_EXP_LNKCTL_ASPM_L0S () {0x1;}' unless defined(&PCI_EXP_LNKCTL_ASPM_L0S);
    eval 'sub PCI_EXP_LNKCTL_ASPM_L1 () {0x2;}' unless defined(&PCI_EXP_LNKCTL_ASPM_L1);
    eval 'sub PCI_EXP_LNKCTL_RCB () {0x8;}' unless defined(&PCI_EXP_LNKCTL_RCB);
    eval 'sub PCI_EXP_LNKCTL_LD () {0x10;}' unless defined(&PCI_EXP_LNKCTL_LD);
    eval 'sub PCI_EXP_LNKCTL_RL () {0x20;}' unless defined(&PCI_EXP_LNKCTL_RL);
    eval 'sub PCI_EXP_LNKCTL_CCC () {0x40;}' unless defined(&PCI_EXP_LNKCTL_CCC);
    eval 'sub PCI_EXP_LNKCTL_ES () {0x80;}' unless defined(&PCI_EXP_LNKCTL_ES);
    eval 'sub PCI_EXP_LNKCTL_CLKREQ_EN () {0x100;}' unless defined(&PCI_EXP_LNKCTL_CLKREQ_EN);
    eval 'sub PCI_EXP_LNKCTL_HAWD () {0x200;}' unless defined(&PCI_EXP_LNKCTL_HAWD);
    eval 'sub PCI_EXP_LNKCTL_LBMIE () {0x400;}' unless defined(&PCI_EXP_LNKCTL_LBMIE);
    eval 'sub PCI_EXP_LNKCTL_LABIE () {0x800;}' unless defined(&PCI_EXP_LNKCTL_LABIE);
    eval 'sub PCI_EXP_LNKSTA () {0x12;}' unless defined(&PCI_EXP_LNKSTA);
    eval 'sub PCI_EXP_LNKSTA_CLS () {0xf;}' unless defined(&PCI_EXP_LNKSTA_CLS);
    eval 'sub PCI_EXP_LNKSTA_CLS_2_5GB () {0x1;}' unless defined(&PCI_EXP_LNKSTA_CLS_2_5GB);
    eval 'sub PCI_EXP_LNKSTA_CLS_5_0GB () {0x2;}' unless defined(&PCI_EXP_LNKSTA_CLS_5_0GB);
    eval 'sub PCI_EXP_LNKSTA_CLS_8_0GB () {0x3;}' unless defined(&PCI_EXP_LNKSTA_CLS_8_0GB);
    eval 'sub PCI_EXP_LNKSTA_CLS_16_0GB () {0x4;}' unless defined(&PCI_EXP_LNKSTA_CLS_16_0GB);
    eval 'sub PCI_EXP_LNKSTA_CLS_32_0GB () {0x5;}' unless defined(&PCI_EXP_LNKSTA_CLS_32_0GB);
    eval 'sub PCI_EXP_LNKSTA_CLS_64_0GB () {0x6;}' unless defined(&PCI_EXP_LNKSTA_CLS_64_0GB);
    eval 'sub PCI_EXP_LNKSTA_NLW () {0x3f0;}' unless defined(&PCI_EXP_LNKSTA_NLW);
    eval 'sub PCI_EXP_LNKSTA_NLW_X1 () {0x10;}' unless defined(&PCI_EXP_LNKSTA_NLW_X1);
    eval 'sub PCI_EXP_LNKSTA_NLW_X2 () {0x20;}' unless defined(&PCI_EXP_LNKSTA_NLW_X2);
    eval 'sub PCI_EXP_LNKSTA_NLW_X4 () {0x40;}' unless defined(&PCI_EXP_LNKSTA_NLW_X4);
    eval 'sub PCI_EXP_LNKSTA_NLW_X8 () {0x80;}' unless defined(&PCI_EXP_LNKSTA_NLW_X8);
    eval 'sub PCI_EXP_LNKSTA_NLW_SHIFT () {4;}' unless defined(&PCI_EXP_LNKSTA_NLW_SHIFT);
    eval 'sub PCI_EXP_LNKSTA_LT () {0x800;}' unless defined(&PCI_EXP_LNKSTA_LT);
    eval 'sub PCI_EXP_LNKSTA_SLC () {0x1000;}' unless defined(&PCI_EXP_LNKSTA_SLC);
    eval 'sub PCI_EXP_LNKSTA_DLLLA () {0x2000;}' unless defined(&PCI_EXP_LNKSTA_DLLLA);
    eval 'sub PCI_EXP_LNKSTA_LBMS () {0x4000;}' unless defined(&PCI_EXP_LNKSTA_LBMS);
    eval 'sub PCI_EXP_LNKSTA_LABS () {0x8000;}' unless defined(&PCI_EXP_LNKSTA_LABS);
    eval 'sub PCI_CAP_EXP_ENDPOINT_SIZEOF_V1 () {20;}' unless defined(&PCI_CAP_EXP_ENDPOINT_SIZEOF_V1);
    eval 'sub PCI_EXP_SLTCAP () {0x14;}' unless defined(&PCI_EXP_SLTCAP);
    eval 'sub PCI_EXP_SLTCAP_ABP () {0x1;}' unless defined(&PCI_EXP_SLTCAP_ABP);
    eval 'sub PCI_EXP_SLTCAP_PCP () {0x2;}' unless defined(&PCI_EXP_SLTCAP_PCP);
    eval 'sub PCI_EXP_SLTCAP_MRLSP () {0x4;}' unless defined(&PCI_EXP_SLTCAP_MRLSP);
    eval 'sub PCI_EXP_SLTCAP_AIP () {0x8;}' unless defined(&PCI_EXP_SLTCAP_AIP);
    eval 'sub PCI_EXP_SLTCAP_PIP () {0x10;}' unless defined(&PCI_EXP_SLTCAP_PIP);
    eval 'sub PCI_EXP_SLTCAP_HPS () {0x20;}' unless defined(&PCI_EXP_SLTCAP_HPS);
    eval 'sub PCI_EXP_SLTCAP_HPC () {0x40;}' unless defined(&PCI_EXP_SLTCAP_HPC);
    eval 'sub PCI_EXP_SLTCAP_SPLV () {0x7f80;}' unless defined(&PCI_EXP_SLTCAP_SPLV);
    eval 'sub PCI_EXP_SLTCAP_SPLS () {0x18000;}' unless defined(&PCI_EXP_SLTCAP_SPLS);
    eval 'sub PCI_EXP_SLTCAP_EIP () {0x20000;}' unless defined(&PCI_EXP_SLTCAP_EIP);
    eval 'sub PCI_EXP_SLTCAP_NCCS () {0x40000;}' unless defined(&PCI_EXP_SLTCAP_NCCS);
    eval 'sub PCI_EXP_SLTCAP_PSN () {0xfff80000;}' unless defined(&PCI_EXP_SLTCAP_PSN);
    eval 'sub PCI_EXP_SLTCTL () {0x18;}' unless defined(&PCI_EXP_SLTCTL);
    eval 'sub PCI_EXP_SLTCTL_ABPE () {0x1;}' unless defined(&PCI_EXP_SLTCTL_ABPE);
    eval 'sub PCI_EXP_SLTCTL_PFDE () {0x2;}' unless defined(&PCI_EXP_SLTCTL_PFDE);
    eval 'sub PCI_EXP_SLTCTL_MRLSCE () {0x4;}' unless defined(&PCI_EXP_SLTCTL_MRLSCE);
    eval 'sub PCI_EXP_SLTCTL_PDCE () {0x8;}' unless defined(&PCI_EXP_SLTCTL_PDCE);
    eval 'sub PCI_EXP_SLTCTL_CCIE () {0x10;}' unless defined(&PCI_EXP_SLTCTL_CCIE);
    eval 'sub PCI_EXP_SLTCTL_HPIE () {0x20;}' unless defined(&PCI_EXP_SLTCTL_HPIE);
    eval 'sub PCI_EXP_SLTCTL_AIC () {0xc0;}' unless defined(&PCI_EXP_SLTCTL_AIC);
    eval 'sub PCI_EXP_SLTCTL_ATTN_IND_SHIFT () {6;}' unless defined(&PCI_EXP_SLTCTL_ATTN_IND_SHIFT);
    eval 'sub PCI_EXP_SLTCTL_ATTN_IND_ON () {0x40;}' unless defined(&PCI_EXP_SLTCTL_ATTN_IND_ON);
    eval 'sub PCI_EXP_SLTCTL_ATTN_IND_BLINK () {0x80;}' unless defined(&PCI_EXP_SLTCTL_ATTN_IND_BLINK);
    eval 'sub PCI_EXP_SLTCTL_ATTN_IND_OFF () {0xc0;}' unless defined(&PCI_EXP_SLTCTL_ATTN_IND_OFF);
    eval 'sub PCI_EXP_SLTCTL_PIC () {0x300;}' unless defined(&PCI_EXP_SLTCTL_PIC);
    eval 'sub PCI_EXP_SLTCTL_PWR_IND_ON () {0x100;}' unless defined(&PCI_EXP_SLTCTL_PWR_IND_ON);
    eval 'sub PCI_EXP_SLTCTL_PWR_IND_BLINK () {0x200;}' unless defined(&PCI_EXP_SLTCTL_PWR_IND_BLINK);
    eval 'sub PCI_EXP_SLTCTL_PWR_IND_OFF () {0x300;}' unless defined(&PCI_EXP_SLTCTL_PWR_IND_OFF);
    eval 'sub PCI_EXP_SLTCTL_PCC () {0x400;}' unless defined(&PCI_EXP_SLTCTL_PCC);
    eval 'sub PCI_EXP_SLTCTL_PWR_ON () {0x;}' unless defined(&PCI_EXP_SLTCTL_PWR_ON);
    eval 'sub PCI_EXP_SLTCTL_PWR_OFF () {0x400;}' unless defined(&PCI_EXP_SLTCTL_PWR_OFF);
    eval 'sub PCI_EXP_SLTCTL_EIC () {0x800;}' unless defined(&PCI_EXP_SLTCTL_EIC);
    eval 'sub PCI_EXP_SLTCTL_DLLSCE () {0x1000;}' unless defined(&PCI_EXP_SLTCTL_DLLSCE);
    eval 'sub PCI_EXP_SLTCTL_ASPL_DISABLE () {0x2000;}' unless defined(&PCI_EXP_SLTCTL_ASPL_DISABLE);
    eval 'sub PCI_EXP_SLTCTL_IBPD_DISABLE () {0x4000;}' unless defined(&PCI_EXP_SLTCTL_IBPD_DISABLE);
    eval 'sub PCI_EXP_SLTSTA () {0x1a;}' unless defined(&PCI_EXP_SLTSTA);
    eval 'sub PCI_EXP_SLTSTA_ABP () {0x1;}' unless defined(&PCI_EXP_SLTSTA_ABP);
    eval 'sub PCI_EXP_SLTSTA_PFD () {0x2;}' unless defined(&PCI_EXP_SLTSTA_PFD);
    eval 'sub PCI_EXP_SLTSTA_MRLSC () {0x4;}' unless defined(&PCI_EXP_SLTSTA_MRLSC);
    eval 'sub PCI_EXP_SLTSTA_PDC () {0x8;}' unless defined(&PCI_EXP_SLTSTA_PDC);
    eval 'sub PCI_EXP_SLTSTA_CC () {0x10;}' unless defined(&PCI_EXP_SLTSTA_CC);
    eval 'sub PCI_EXP_SLTSTA_MRLSS () {0x20;}' unless defined(&PCI_EXP_SLTSTA_MRLSS);
    eval 'sub PCI_EXP_SLTSTA_PDS () {0x40;}' unless defined(&PCI_EXP_SLTSTA_PDS);
    eval 'sub PCI_EXP_SLTSTA_EIS () {0x80;}' unless defined(&PCI_EXP_SLTSTA_EIS);
    eval 'sub PCI_EXP_SLTSTA_DLLSC () {0x100;}' unless defined(&PCI_EXP_SLTSTA_DLLSC);
    eval 'sub PCI_EXP_RTCTL () {0x1c;}' unless defined(&PCI_EXP_RTCTL);
    eval 'sub PCI_EXP_RTCTL_SECEE () {0x1;}' unless defined(&PCI_EXP_RTCTL_SECEE);
    eval 'sub PCI_EXP_RTCTL_SENFEE () {0x2;}' unless defined(&PCI_EXP_RTCTL_SENFEE);
    eval 'sub PCI_EXP_RTCTL_SEFEE () {0x4;}' unless defined(&PCI_EXP_RTCTL_SEFEE);
    eval 'sub PCI_EXP_RTCTL_PMEIE () {0x8;}' unless defined(&PCI_EXP_RTCTL_PMEIE);
    eval 'sub PCI_EXP_RTCTL_RRS_SVE () {0x10;}' unless defined(&PCI_EXP_RTCTL_RRS_SVE);
    eval 'sub PCI_EXP_RTCTL_CRSSVE () { &PCI_EXP_RTCTL_RRS_SVE;}' unless defined(&PCI_EXP_RTCTL_CRSSVE);
    eval 'sub PCI_EXP_RTCAP () {0x1e;}' unless defined(&PCI_EXP_RTCAP);
    eval 'sub PCI_EXP_RTCAP_RRS_SV () {0x1;}' unless defined(&PCI_EXP_RTCAP_RRS_SV);
    eval 'sub PCI_EXP_RTCAP_CRSVIS () { &PCI_EXP_RTCAP_RRS_SV;}' unless defined(&PCI_EXP_RTCAP_CRSVIS);
    eval 'sub PCI_EXP_RTSTA () {0x20;}' unless defined(&PCI_EXP_RTSTA);
    eval 'sub PCI_EXP_RTSTA_PME_RQ_ID () {0xffff;}' unless defined(&PCI_EXP_RTSTA_PME_RQ_ID);
    eval 'sub PCI_EXP_RTSTA_PME () {0x10000;}' unless defined(&PCI_EXP_RTSTA_PME);
    eval 'sub PCI_EXP_RTSTA_PENDING () {0x20000;}' unless defined(&PCI_EXP_RTSTA_PENDING);
    eval 'sub PCI_EXP_DEVCAP2 () {0x24;}' unless defined(&PCI_EXP_DEVCAP2);
    eval 'sub PCI_EXP_DEVCAP2_COMP_TMOUT_DIS () {0x10;}' unless defined(&PCI_EXP_DEVCAP2_COMP_TMOUT_DIS);
    eval 'sub PCI_EXP_DEVCAP2_ARI () {0x20;}' unless defined(&PCI_EXP_DEVCAP2_ARI);
    eval 'sub PCI_EXP_DEVCAP2_ATOMIC_ROUTE () {0x40;}' unless defined(&PCI_EXP_DEVCAP2_ATOMIC_ROUTE);
    eval 'sub PCI_EXP_DEVCAP2_ATOMIC_COMP32 () {0x80;}' unless defined(&PCI_EXP_DEVCAP2_ATOMIC_COMP32);
    eval 'sub PCI_EXP_DEVCAP2_ATOMIC_COMP64 () {0x100;}' unless defined(&PCI_EXP_DEVCAP2_ATOMIC_COMP64);
    eval 'sub PCI_EXP_DEVCAP2_ATOMIC_COMP128 () {0x200;}' unless defined(&PCI_EXP_DEVCAP2_ATOMIC_COMP128);
    eval 'sub PCI_EXP_DEVCAP2_LTR () {0x800;}' unless defined(&PCI_EXP_DEVCAP2_LTR);
    eval 'sub PCI_EXP_DEVCAP2_TPH_COMP_MASK () {0x3000;}' unless defined(&PCI_EXP_DEVCAP2_TPH_COMP_MASK);
    eval 'sub PCI_EXP_DEVCAP2_OBFF_MASK () {0xc0000;}' unless defined(&PCI_EXP_DEVCAP2_OBFF_MASK);
    eval 'sub PCI_EXP_DEVCAP2_OBFF_MSG () {0x40000;}' unless defined(&PCI_EXP_DEVCAP2_OBFF_MSG);
    eval 'sub PCI_EXP_DEVCAP2_OBFF_WAKE () {0x80000;}' unless defined(&PCI_EXP_DEVCAP2_OBFF_WAKE);
    eval 'sub PCI_EXP_DEVCAP2_EE_PREFIX () {0x200000;}' unless defined(&PCI_EXP_DEVCAP2_EE_PREFIX);
    eval 'sub PCI_EXP_DEVCTL2 () {0x28;}' unless defined(&PCI_EXP_DEVCTL2);
    eval 'sub PCI_EXP_DEVCTL2_COMP_TIMEOUT () {0xf;}' unless defined(&PCI_EXP_DEVCTL2_COMP_TIMEOUT);
    eval 'sub PCI_EXP_DEVCTL2_COMP_TMOUT_DIS () {0x10;}' unless defined(&PCI_EXP_DEVCTL2_COMP_TMOUT_DIS);
    eval 'sub PCI_EXP_DEVCTL2_ARI () {0x20;}' unless defined(&PCI_EXP_DEVCTL2_ARI);
    eval 'sub PCI_EXP_DEVCTL2_ATOMIC_REQ () {0x40;}' unless defined(&PCI_EXP_DEVCTL2_ATOMIC_REQ);
    eval 'sub PCI_EXP_DEVCTL2_ATOMIC_EGRESS_BLOCK () {0x80;}' unless defined(&PCI_EXP_DEVCTL2_ATOMIC_EGRESS_BLOCK);
    eval 'sub PCI_EXP_DEVCTL2_IDO_REQ_EN () {0x100;}' unless defined(&PCI_EXP_DEVCTL2_IDO_REQ_EN);
    eval 'sub PCI_EXP_DEVCTL2_IDO_CMP_EN () {0x200;}' unless defined(&PCI_EXP_DEVCTL2_IDO_CMP_EN);
    eval 'sub PCI_EXP_DEVCTL2_LTR_EN () {0x400;}' unless defined(&PCI_EXP_DEVCTL2_LTR_EN);
    eval 'sub PCI_EXP_DEVCTL2_OBFF_MSGA_EN () {0x2000;}' unless defined(&PCI_EXP_DEVCTL2_OBFF_MSGA_EN);
    eval 'sub PCI_EXP_DEVCTL2_OBFF_MSGB_EN () {0x4000;}' unless defined(&PCI_EXP_DEVCTL2_OBFF_MSGB_EN);
    eval 'sub PCI_EXP_DEVCTL2_OBFF_WAKE_EN () {0x6000;}' unless defined(&PCI_EXP_DEVCTL2_OBFF_WAKE_EN);
    eval 'sub PCI_EXP_DEVSTA2 () {0x2a;}' unless defined(&PCI_EXP_DEVSTA2);
    eval 'sub PCI_CAP_EXP_RC_ENDPOINT_SIZEOF_V2 () {0x2c;}' unless defined(&PCI_CAP_EXP_RC_ENDPOINT_SIZEOF_V2);
    eval 'sub PCI_EXP_LNKCAP2 () {0x2c;}' unless defined(&PCI_EXP_LNKCAP2);
    eval 'sub PCI_EXP_LNKCAP2_SLS_2_5GB () {0x2;}' unless defined(&PCI_EXP_LNKCAP2_SLS_2_5GB);
    eval 'sub PCI_EXP_LNKCAP2_SLS_5_0GB () {0x4;}' unless defined(&PCI_EXP_LNKCAP2_SLS_5_0GB);
    eval 'sub PCI_EXP_LNKCAP2_SLS_8_0GB () {0x8;}' unless defined(&PCI_EXP_LNKCAP2_SLS_8_0GB);
    eval 'sub PCI_EXP_LNKCAP2_SLS_16_0GB () {0x10;}' unless defined(&PCI_EXP_LNKCAP2_SLS_16_0GB);
    eval 'sub PCI_EXP_LNKCAP2_SLS_32_0GB () {0x20;}' unless defined(&PCI_EXP_LNKCAP2_SLS_32_0GB);
    eval 'sub PCI_EXP_LNKCAP2_SLS_64_0GB () {0x40;}' unless defined(&PCI_EXP_LNKCAP2_SLS_64_0GB);
    eval 'sub PCI_EXP_LNKCAP2_CROSSLINK () {0x100;}' unless defined(&PCI_EXP_LNKCAP2_CROSSLINK);
    eval 'sub PCI_EXP_LNKCTL2 () {0x30;}' unless defined(&PCI_EXP_LNKCTL2);
    eval 'sub PCI_EXP_LNKCTL2_TLS () {0xf;}' unless defined(&PCI_EXP_LNKCTL2_TLS);
    eval 'sub PCI_EXP_LNKCTL2_TLS_2_5GT () {0x1;}' unless defined(&PCI_EXP_LNKCTL2_TLS_2_5GT);
    eval 'sub PCI_EXP_LNKCTL2_TLS_5_0GT () {0x2;}' unless defined(&PCI_EXP_LNKCTL2_TLS_5_0GT);
    eval 'sub PCI_EXP_LNKCTL2_TLS_8_0GT () {0x3;}' unless defined(&PCI_EXP_LNKCTL2_TLS_8_0GT);
    eval 'sub PCI_EXP_LNKCTL2_TLS_16_0GT () {0x4;}' unless defined(&PCI_EXP_LNKCTL2_TLS_16_0GT);
    eval 'sub PCI_EXP_LNKCTL2_TLS_32_0GT () {0x5;}' unless defined(&PCI_EXP_LNKCTL2_TLS_32_0GT);
    eval 'sub PCI_EXP_LNKCTL2_TLS_64_0GT () {0x6;}' unless defined(&PCI_EXP_LNKCTL2_TLS_64_0GT);
    eval 'sub PCI_EXP_LNKCTL2_ENTER_COMP () {0x10;}' unless defined(&PCI_EXP_LNKCTL2_ENTER_COMP);
    eval 'sub PCI_EXP_LNKCTL2_TX_MARGIN () {0x380;}' unless defined(&PCI_EXP_LNKCTL2_TX_MARGIN);
    eval 'sub PCI_EXP_LNKCTL2_HASD () {0x20;}' unless defined(&PCI_EXP_LNKCTL2_HASD);
    eval 'sub PCI_EXP_LNKSTA2 () {0x32;}' unless defined(&PCI_EXP_LNKSTA2);
    eval 'sub PCI_EXP_LNKSTA2_FLIT () {0x400;}' unless defined(&PCI_EXP_LNKSTA2_FLIT);
    eval 'sub PCI_CAP_EXP_ENDPOINT_SIZEOF_V2 () {0x32;}' unless defined(&PCI_CAP_EXP_ENDPOINT_SIZEOF_V2);
    eval 'sub PCI_EXP_SLTCAP2 () {0x34;}' unless defined(&PCI_EXP_SLTCAP2);
    eval 'sub PCI_EXP_SLTCAP2_IBPD () {0x1;}' unless defined(&PCI_EXP_SLTCAP2_IBPD);
    eval 'sub PCI_EXP_SLTCTL2 () {0x38;}' unless defined(&PCI_EXP_SLTCTL2);
    eval 'sub PCI_EXP_SLTSTA2 () {0x3a;}' unless defined(&PCI_EXP_SLTSTA2);
    eval 'sub PCI_EXT_CAP_ID {
        my($header) = @_;
	    eval q(($header & 0xffff));
    }' unless defined(&PCI_EXT_CAP_ID);
    eval 'sub PCI_EXT_CAP_VER {
        my($header) = @_;
	    eval q((($header >> 16) & 0xf));
    }' unless defined(&PCI_EXT_CAP_VER);
    eval 'sub PCI_EXT_CAP_NEXT {
        my($header) = @_;
	    eval q((($header >> 20) & 0xffc));
    }' unless defined(&PCI_EXT_CAP_NEXT);
    eval 'sub PCI_EXT_CAP_ID_ERR () {0x1;}' unless defined(&PCI_EXT_CAP_ID_ERR);
    eval 'sub PCI_EXT_CAP_ID_VC () {0x2;}' unless defined(&PCI_EXT_CAP_ID_VC);
    eval 'sub PCI_EXT_CAP_ID_DSN () {0x3;}' unless defined(&PCI_EXT_CAP_ID_DSN);
    eval 'sub PCI_EXT_CAP_ID_PWR () {0x4;}' unless defined(&PCI_EXT_CAP_ID_PWR);
    eval 'sub PCI_EXT_CAP_ID_RCLD () {0x5;}' unless defined(&PCI_EXT_CAP_ID_RCLD);
    eval 'sub PCI_EXT_CAP_ID_RCILC () {0x6;}' unless defined(&PCI_EXT_CAP_ID_RCILC);
    eval 'sub PCI_EXT_CAP_ID_RCEC () {0x7;}' unless defined(&PCI_EXT_CAP_ID_RCEC);
    eval 'sub PCI_EXT_CAP_ID_MFVC () {0x8;}' unless defined(&PCI_EXT_CAP_ID_MFVC);
    eval 'sub PCI_EXT_CAP_ID_VC9 () {0x9;}' unless defined(&PCI_EXT_CAP_ID_VC9);
    eval 'sub PCI_EXT_CAP_ID_RCRB () {0xa;}' unless defined(&PCI_EXT_CAP_ID_RCRB);
    eval 'sub PCI_EXT_CAP_ID_VNDR () {0xb;}' unless defined(&PCI_EXT_CAP_ID_VNDR);
    eval 'sub PCI_EXT_CAP_ID_CAC () {0xc;}' unless defined(&PCI_EXT_CAP_ID_CAC);
    eval 'sub PCI_EXT_CAP_ID_ACS () {0xd;}' unless defined(&PCI_EXT_CAP_ID_ACS);
    eval 'sub PCI_EXT_CAP_ID_ARI () {0xe;}' unless defined(&PCI_EXT_CAP_ID_ARI);
    eval 'sub PCI_EXT_CAP_ID_ATS () {0xf;}' unless defined(&PCI_EXT_CAP_ID_ATS);
    eval 'sub PCI_EXT_CAP_ID_SRIOV () {0x10;}' unless defined(&PCI_EXT_CAP_ID_SRIOV);
    eval 'sub PCI_EXT_CAP_ID_MRIOV () {0x11;}' unless defined(&PCI_EXT_CAP_ID_MRIOV);
    eval 'sub PCI_EXT_CAP_ID_MCAST () {0x12;}' unless defined(&PCI_EXT_CAP_ID_MCAST);
    eval 'sub PCI_EXT_CAP_ID_PRI () {0x13;}' unless defined(&PCI_EXT_CAP_ID_PRI);
    eval 'sub PCI_EXT_CAP_ID_AMD_XXX () {0x14;}' unless defined(&PCI_EXT_CAP_ID_AMD_XXX);
    eval 'sub PCI_EXT_CAP_ID_REBAR () {0x15;}' unless defined(&PCI_EXT_CAP_ID_REBAR);
    eval 'sub PCI_EXT_CAP_ID_DPA () {0x16;}' unless defined(&PCI_EXT_CAP_ID_DPA);
    eval 'sub PCI_EXT_CAP_ID_TPH () {0x17;}' unless defined(&PCI_EXT_CAP_ID_TPH);
    eval 'sub PCI_EXT_CAP_ID_LTR () {0x18;}' unless defined(&PCI_EXT_CAP_ID_LTR);
    eval 'sub PCI_EXT_CAP_ID_SECPCI () {0x19;}' unless defined(&PCI_EXT_CAP_ID_SECPCI);
    eval 'sub PCI_EXT_CAP_ID_PMUX () {0x1a;}' unless defined(&PCI_EXT_CAP_ID_PMUX);
    eval 'sub PCI_EXT_CAP_ID_PASID () {0x1b;}' unless defined(&PCI_EXT_CAP_ID_PASID);
    eval 'sub PCI_EXT_CAP_ID_DPC () {0x1d;}' unless defined(&PCI_EXT_CAP_ID_DPC);
    eval 'sub PCI_EXT_CAP_ID_L1SS () {0x1e;}' unless defined(&PCI_EXT_CAP_ID_L1SS);
    eval 'sub PCI_EXT_CAP_ID_PTM () {0x1f;}' unless defined(&PCI_EXT_CAP_ID_PTM);
    eval 'sub PCI_EXT_CAP_ID_DVSEC () {0x23;}' unless defined(&PCI_EXT_CAP_ID_DVSEC);
    eval 'sub PCI_EXT_CAP_ID_DLF () {0x25;}' unless defined(&PCI_EXT_CAP_ID_DLF);
    eval 'sub PCI_EXT_CAP_ID_PL_16GT () {0x26;}' unless defined(&PCI_EXT_CAP_ID_PL_16GT);
    eval 'sub PCI_EXT_CAP_ID_NPEM () {0x29;}' unless defined(&PCI_EXT_CAP_ID_NPEM);
    eval 'sub PCI_EXT_CAP_ID_PL_32GT () {0x2a;}' unless defined(&PCI_EXT_CAP_ID_PL_32GT);
    eval 'sub PCI_EXT_CAP_ID_DOE () {0x2e;}' unless defined(&PCI_EXT_CAP_ID_DOE);
    eval 'sub PCI_EXT_CAP_ID_MAX () { &PCI_EXT_CAP_ID_DOE;}' unless defined(&PCI_EXT_CAP_ID_MAX);
    eval 'sub PCI_EXT_CAP_DSN_SIZEOF () {12;}' unless defined(&PCI_EXT_CAP_DSN_SIZEOF);
    eval 'sub PCI_EXT_CAP_MCAST_ENDPOINT_SIZEOF () {40;}' unless defined(&PCI_EXT_CAP_MCAST_ENDPOINT_SIZEOF);
    eval 'sub PCI_ERR_UNCOR_STATUS () {0x4;}' unless defined(&PCI_ERR_UNCOR_STATUS);
    eval 'sub PCI_ERR_UNC_UND () {0x1;}' unless defined(&PCI_ERR_UNC_UND);
    eval 'sub PCI_ERR_UNC_DLP () {0x10;}' unless defined(&PCI_ERR_UNC_DLP);
    eval 'sub PCI_ERR_UNC_SURPDN () {0x20;}' unless defined(&PCI_ERR_UNC_SURPDN);
    eval 'sub PCI_ERR_UNC_POISON_TLP () {0x1000;}' unless defined(&PCI_ERR_UNC_POISON_TLP);
    eval 'sub PCI_ERR_UNC_FCP () {0x2000;}' unless defined(&PCI_ERR_UNC_FCP);
    eval 'sub PCI_ERR_UNC_COMP_TIME () {0x4000;}' unless defined(&PCI_ERR_UNC_COMP_TIME);
    eval 'sub PCI_ERR_UNC_COMP_ABORT () {0x8000;}' unless defined(&PCI_ERR_UNC_COMP_ABORT);
    eval 'sub PCI_ERR_UNC_UNX_COMP () {0x10000;}' unless defined(&PCI_ERR_UNC_UNX_COMP);
    eval 'sub PCI_ERR_UNC_RX_OVER () {0x20000;}' unless defined(&PCI_ERR_UNC_RX_OVER);
    eval 'sub PCI_ERR_UNC_MALF_TLP () {0x40000;}' unless defined(&PCI_ERR_UNC_MALF_TLP);
    eval 'sub PCI_ERR_UNC_ECRC () {0x80000;}' unless defined(&PCI_ERR_UNC_ECRC);
    eval 'sub PCI_ERR_UNC_UNSUP () {0x100000;}' unless defined(&PCI_ERR_UNC_UNSUP);
    eval 'sub PCI_ERR_UNC_ACSV () {0x200000;}' unless defined(&PCI_ERR_UNC_ACSV);
    eval 'sub PCI_ERR_UNC_INTN () {0x400000;}' unless defined(&PCI_ERR_UNC_INTN);
    eval 'sub PCI_ERR_UNC_MCBTLP () {0x800000;}' unless defined(&PCI_ERR_UNC_MCBTLP);
    eval 'sub PCI_ERR_UNC_ATOMEG () {0x1000000;}' unless defined(&PCI_ERR_UNC_ATOMEG);
    eval 'sub PCI_ERR_UNC_TLPPRE () {0x2000000;}' unless defined(&PCI_ERR_UNC_TLPPRE);
    eval 'sub PCI_ERR_UNCOR_MASK () {0x8;}' unless defined(&PCI_ERR_UNCOR_MASK);
    eval 'sub PCI_ERR_UNCOR_SEVER () {0xc;}' unless defined(&PCI_ERR_UNCOR_SEVER);
    eval 'sub PCI_ERR_COR_STATUS () {0x10;}' unless defined(&PCI_ERR_COR_STATUS);
    eval 'sub PCI_ERR_COR_RCVR () {0x1;}' unless defined(&PCI_ERR_COR_RCVR);
    eval 'sub PCI_ERR_COR_BAD_TLP () {0x40;}' unless defined(&PCI_ERR_COR_BAD_TLP);
    eval 'sub PCI_ERR_COR_BAD_DLLP () {0x80;}' unless defined(&PCI_ERR_COR_BAD_DLLP);
    eval 'sub PCI_ERR_COR_REP_ROLL () {0x100;}' unless defined(&PCI_ERR_COR_REP_ROLL);
    eval 'sub PCI_ERR_COR_REP_TIMER () {0x1000;}' unless defined(&PCI_ERR_COR_REP_TIMER);
    eval 'sub PCI_ERR_COR_ADV_NFAT () {0x2000;}' unless defined(&PCI_ERR_COR_ADV_NFAT);
    eval 'sub PCI_ERR_COR_INTERNAL () {0x4000;}' unless defined(&PCI_ERR_COR_INTERNAL);
    eval 'sub PCI_ERR_COR_LOG_OVER () {0x8000;}' unless defined(&PCI_ERR_COR_LOG_OVER);
    eval 'sub PCI_ERR_COR_MASK () {0x14;}' unless defined(&PCI_ERR_COR_MASK);
    eval 'sub PCI_ERR_CAP () {0x18;}' unless defined(&PCI_ERR_CAP);
    eval 'sub PCI_ERR_CAP_FEP {
        my($x) = @_;
	    eval q((($x) & 0x1f));
    }' unless defined(&PCI_ERR_CAP_FEP);
    eval 'sub PCI_ERR_CAP_ECRC_GENC () {0x20;}' unless defined(&PCI_ERR_CAP_ECRC_GENC);
    eval 'sub PCI_ERR_CAP_ECRC_GENE () {0x40;}' unless defined(&PCI_ERR_CAP_ECRC_GENE);
    eval 'sub PCI_ERR_CAP_ECRC_CHKC () {0x80;}' unless defined(&PCI_ERR_CAP_ECRC_CHKC);
    eval 'sub PCI_ERR_CAP_ECRC_CHKE () {0x100;}' unless defined(&PCI_ERR_CAP_ECRC_CHKE);
    eval 'sub PCI_ERR_HEADER_LOG () {0x1c;}' unless defined(&PCI_ERR_HEADER_LOG);
    eval 'sub PCI_ERR_ROOT_COMMAND () {0x2c;}' unless defined(&PCI_ERR_ROOT_COMMAND);
    eval 'sub PCI_ERR_ROOT_CMD_COR_EN () {0x1;}' unless defined(&PCI_ERR_ROOT_CMD_COR_EN);
    eval 'sub PCI_ERR_ROOT_CMD_NONFATAL_EN () {0x2;}' unless defined(&PCI_ERR_ROOT_CMD_NONFATAL_EN);
    eval 'sub PCI_ERR_ROOT_CMD_FATAL_EN () {0x4;}' unless defined(&PCI_ERR_ROOT_CMD_FATAL_EN);
    eval 'sub PCI_ERR_ROOT_STATUS () {0x30;}' unless defined(&PCI_ERR_ROOT_STATUS);
    eval 'sub PCI_ERR_ROOT_COR_RCV () {0x1;}' unless defined(&PCI_ERR_ROOT_COR_RCV);
    eval 'sub PCI_ERR_ROOT_MULTI_COR_RCV () {0x2;}' unless defined(&PCI_ERR_ROOT_MULTI_COR_RCV);
    eval 'sub PCI_ERR_ROOT_UNCOR_RCV () {0x4;}' unless defined(&PCI_ERR_ROOT_UNCOR_RCV);
    eval 'sub PCI_ERR_ROOT_MULTI_UNCOR_RCV () {0x8;}' unless defined(&PCI_ERR_ROOT_MULTI_UNCOR_RCV);
    eval 'sub PCI_ERR_ROOT_FIRST_FATAL () {0x10;}' unless defined(&PCI_ERR_ROOT_FIRST_FATAL);
    eval 'sub PCI_ERR_ROOT_NONFATAL_RCV () {0x20;}' unless defined(&PCI_ERR_ROOT_NONFATAL_RCV);
    eval 'sub PCI_ERR_ROOT_FATAL_RCV () {0x40;}' unless defined(&PCI_ERR_ROOT_FATAL_RCV);
    eval 'sub PCI_ERR_ROOT_AER_IRQ () {0xf8000000;}' unless defined(&PCI_ERR_ROOT_AER_IRQ);
    eval 'sub PCI_ERR_ROOT_ERR_SRC () {0x34;}' unless defined(&PCI_ERR_ROOT_ERR_SRC);
    eval 'sub PCI_VC_PORT_CAP1 () {0x4;}' unless defined(&PCI_VC_PORT_CAP1);
    eval 'sub PCI_VC_CAP1_EVCC () {0x7;}' unless defined(&PCI_VC_CAP1_EVCC);
    eval 'sub PCI_VC_CAP1_LPEVCC () {0x70;}' unless defined(&PCI_VC_CAP1_LPEVCC);
    eval 'sub PCI_VC_CAP1_ARB_SIZE () {0xc00;}' unless defined(&PCI_VC_CAP1_ARB_SIZE);
    eval 'sub PCI_VC_PORT_CAP2 () {0x8;}' unless defined(&PCI_VC_PORT_CAP2);
    eval 'sub PCI_VC_CAP2_32_PHASE () {0x2;}' unless defined(&PCI_VC_CAP2_32_PHASE);
    eval 'sub PCI_VC_CAP2_64_PHASE () {0x4;}' unless defined(&PCI_VC_CAP2_64_PHASE);
    eval 'sub PCI_VC_CAP2_128_PHASE () {0x8;}' unless defined(&PCI_VC_CAP2_128_PHASE);
    eval 'sub PCI_VC_CAP2_ARB_OFF () {0xff000000;}' unless defined(&PCI_VC_CAP2_ARB_OFF);
    eval 'sub PCI_VC_PORT_CTRL () {0xc;}' unless defined(&PCI_VC_PORT_CTRL);
    eval 'sub PCI_VC_PORT_CTRL_LOAD_TABLE () {0x1;}' unless defined(&PCI_VC_PORT_CTRL_LOAD_TABLE);
    eval 'sub PCI_VC_PORT_STATUS () {0xe;}' unless defined(&PCI_VC_PORT_STATUS);
    eval 'sub PCI_VC_PORT_STATUS_TABLE () {0x1;}' unless defined(&PCI_VC_PORT_STATUS_TABLE);
    eval 'sub PCI_VC_RES_CAP () {0x10;}' unless defined(&PCI_VC_RES_CAP);
    eval 'sub PCI_VC_RES_CAP_32_PHASE () {0x2;}' unless defined(&PCI_VC_RES_CAP_32_PHASE);
    eval 'sub PCI_VC_RES_CAP_64_PHASE () {0x4;}' unless defined(&PCI_VC_RES_CAP_64_PHASE);
    eval 'sub PCI_VC_RES_CAP_128_PHASE () {0x8;}' unless defined(&PCI_VC_RES_CAP_128_PHASE);
    eval 'sub PCI_VC_RES_CAP_128_PHASE_TB () {0x10;}' unless defined(&PCI_VC_RES_CAP_128_PHASE_TB);
    eval 'sub PCI_VC_RES_CAP_256_PHASE () {0x20;}' unless defined(&PCI_VC_RES_CAP_256_PHASE);
    eval 'sub PCI_VC_RES_CAP_ARB_OFF () {0xff000000;}' unless defined(&PCI_VC_RES_CAP_ARB_OFF);
    eval 'sub PCI_VC_RES_CTRL () {0x14;}' unless defined(&PCI_VC_RES_CTRL);
    eval 'sub PCI_VC_RES_CTRL_LOAD_TABLE () {0x10000;}' unless defined(&PCI_VC_RES_CTRL_LOAD_TABLE);
    eval 'sub PCI_VC_RES_CTRL_ARB_SELECT () {0xe0000;}' unless defined(&PCI_VC_RES_CTRL_ARB_SELECT);
    eval 'sub PCI_VC_RES_CTRL_ID () {0x7000000;}' unless defined(&PCI_VC_RES_CTRL_ID);
    eval 'sub PCI_VC_RES_CTRL_ENABLE () {0x80000000;}' unless defined(&PCI_VC_RES_CTRL_ENABLE);
    eval 'sub PCI_VC_RES_STATUS () {0x1a;}' unless defined(&PCI_VC_RES_STATUS);
    eval 'sub PCI_VC_RES_STATUS_TABLE () {0x1;}' unless defined(&PCI_VC_RES_STATUS_TABLE);
    eval 'sub PCI_VC_RES_STATUS_NEGO () {0x2;}' unless defined(&PCI_VC_RES_STATUS_NEGO);
    eval 'sub PCI_CAP_VC_BASE_SIZEOF () {0x10;}' unless defined(&PCI_CAP_VC_BASE_SIZEOF);
    eval 'sub PCI_CAP_VC_PER_VC_SIZEOF () {0xc;}' unless defined(&PCI_CAP_VC_PER_VC_SIZEOF);
    eval 'sub PCI_PWR_DSR () {0x4;}' unless defined(&PCI_PWR_DSR);
    eval 'sub PCI_PWR_DATA () {0x8;}' unless defined(&PCI_PWR_DATA);
    eval 'sub PCI_PWR_DATA_BASE {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&PCI_PWR_DATA_BASE);
    eval 'sub PCI_PWR_DATA_SCALE {
        my($x) = @_;
	    eval q(((($x) >> 8) & 3));
    }' unless defined(&PCI_PWR_DATA_SCALE);
    eval 'sub PCI_PWR_DATA_PM_SUB {
        my($x) = @_;
	    eval q(((($x) >> 10) & 7));
    }' unless defined(&PCI_PWR_DATA_PM_SUB);
    eval 'sub PCI_PWR_DATA_PM_STATE {
        my($x) = @_;
	    eval q(((($x) >> 13) & 3));
    }' unless defined(&PCI_PWR_DATA_PM_STATE);
    eval 'sub PCI_PWR_DATA_TYPE {
        my($x) = @_;
	    eval q(((($x) >> 15) & 7));
    }' unless defined(&PCI_PWR_DATA_TYPE);
    eval 'sub PCI_PWR_DATA_RAIL {
        my($x) = @_;
	    eval q(((($x) >> 18) & 7));
    }' unless defined(&PCI_PWR_DATA_RAIL);
    eval 'sub PCI_PWR_CAP () {0xc;}' unless defined(&PCI_PWR_CAP);
    eval 'sub PCI_PWR_CAP_BUDGET {
        my($x) = @_;
	    eval q((($x) & 1));
    }' unless defined(&PCI_PWR_CAP_BUDGET);
    eval 'sub PCI_EXT_CAP_PWR_SIZEOF () {0x10;}' unless defined(&PCI_EXT_CAP_PWR_SIZEOF);
    eval 'sub PCI_RCEC_RCIEP_BITMAP () {4;}' unless defined(&PCI_RCEC_RCIEP_BITMAP);
    eval 'sub PCI_RCEC_BUSN () {8;}' unless defined(&PCI_RCEC_BUSN);
    eval 'sub PCI_RCEC_BUSN_REG_VER () {0x2;}' unless defined(&PCI_RCEC_BUSN_REG_VER);
    eval 'sub PCI_RCEC_BUSN_NEXT {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&PCI_RCEC_BUSN_NEXT);
    eval 'sub PCI_RCEC_BUSN_LAST {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xff));
    }' unless defined(&PCI_RCEC_BUSN_LAST);
    eval 'sub PCI_VNDR_HEADER () {4;}' unless defined(&PCI_VNDR_HEADER);
    eval 'sub PCI_VNDR_HEADER_ID {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&PCI_VNDR_HEADER_ID);
    eval 'sub PCI_VNDR_HEADER_REV {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xf));
    }' unless defined(&PCI_VNDR_HEADER_REV);
    eval 'sub PCI_VNDR_HEADER_LEN {
        my($x) = @_;
	    eval q(((($x) >> 20) & 0xfff));
    }' unless defined(&PCI_VNDR_HEADER_LEN);
    eval 'sub HT_3BIT_CAP_MASK () {0xe0;}' unless defined(&HT_3BIT_CAP_MASK);
    eval 'sub HT_CAPTYPE_SLAVE () {0x;}' unless defined(&HT_CAPTYPE_SLAVE);
    eval 'sub HT_CAPTYPE_HOST () {0x20;}' unless defined(&HT_CAPTYPE_HOST);
    eval 'sub HT_5BIT_CAP_MASK () {0xf8;}' unless defined(&HT_5BIT_CAP_MASK);
    eval 'sub HT_CAPTYPE_IRQ () {0x80;}' unless defined(&HT_CAPTYPE_IRQ);
    eval 'sub HT_CAPTYPE_REMAPPING_40 () {0xa0;}' unless defined(&HT_CAPTYPE_REMAPPING_40);
    eval 'sub HT_CAPTYPE_REMAPPING_64 () {0xa2;}' unless defined(&HT_CAPTYPE_REMAPPING_64);
    eval 'sub HT_CAPTYPE_UNITID_CLUMP () {0x90;}' unless defined(&HT_CAPTYPE_UNITID_CLUMP);
    eval 'sub HT_CAPTYPE_EXTCONF () {0x98;}' unless defined(&HT_CAPTYPE_EXTCONF);
    eval 'sub HT_CAPTYPE_MSI_MAPPING () {0xa8;}' unless defined(&HT_CAPTYPE_MSI_MAPPING);
    eval 'sub HT_MSI_FLAGS () {0x2;}' unless defined(&HT_MSI_FLAGS);
    eval 'sub HT_MSI_FLAGS_ENABLE () {0x1;}' unless defined(&HT_MSI_FLAGS_ENABLE);
    eval 'sub HT_MSI_FLAGS_FIXED () {0x2;}' unless defined(&HT_MSI_FLAGS_FIXED);
    eval 'sub HT_MSI_FIXED_ADDR () {0xfee00000;}' unless defined(&HT_MSI_FIXED_ADDR);
    eval 'sub HT_MSI_ADDR_LO () {0x4;}' unless defined(&HT_MSI_ADDR_LO);
    eval 'sub HT_MSI_ADDR_LO_MASK () {0xfff00000;}' unless defined(&HT_MSI_ADDR_LO_MASK);
    eval 'sub HT_MSI_ADDR_HI () {0x8;}' unless defined(&HT_MSI_ADDR_HI);
    eval 'sub HT_CAPTYPE_DIRECT_ROUTE () {0xb0;}' unless defined(&HT_CAPTYPE_DIRECT_ROUTE);
    eval 'sub HT_CAPTYPE_VCSET () {0xb8;}' unless defined(&HT_CAPTYPE_VCSET);
    eval 'sub HT_CAPTYPE_ERROR_RETRY () {0xc0;}' unless defined(&HT_CAPTYPE_ERROR_RETRY);
    eval 'sub HT_CAPTYPE_GEN3 () {0xd0;}' unless defined(&HT_CAPTYPE_GEN3);
    eval 'sub HT_CAPTYPE_PM () {0xe0;}' unless defined(&HT_CAPTYPE_PM);
    eval 'sub HT_CAP_SIZEOF_LONG () {28;}' unless defined(&HT_CAP_SIZEOF_LONG);
    eval 'sub HT_CAP_SIZEOF_SHORT () {24;}' unless defined(&HT_CAP_SIZEOF_SHORT);
    eval 'sub PCI_ARI_CAP () {0x4;}' unless defined(&PCI_ARI_CAP);
    eval 'sub PCI_ARI_CAP_MFVC () {0x1;}' unless defined(&PCI_ARI_CAP_MFVC);
    eval 'sub PCI_ARI_CAP_ACS () {0x2;}' unless defined(&PCI_ARI_CAP_ACS);
    eval 'sub PCI_ARI_CAP_NFN {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&PCI_ARI_CAP_NFN);
    eval 'sub PCI_ARI_CTRL () {0x6;}' unless defined(&PCI_ARI_CTRL);
    eval 'sub PCI_ARI_CTRL_MFVC () {0x1;}' unless defined(&PCI_ARI_CTRL_MFVC);
    eval 'sub PCI_ARI_CTRL_ACS () {0x2;}' unless defined(&PCI_ARI_CTRL_ACS);
    eval 'sub PCI_ARI_CTRL_FG {
        my($x) = @_;
	    eval q(((($x) >> 4) & 7));
    }' unless defined(&PCI_ARI_CTRL_FG);
    eval 'sub PCI_EXT_CAP_ARI_SIZEOF () {8;}' unless defined(&PCI_EXT_CAP_ARI_SIZEOF);
    eval 'sub PCI_ATS_CAP () {0x4;}' unless defined(&PCI_ATS_CAP);
    eval 'sub PCI_ATS_CAP_QDEP {
        my($x) = @_;
	    eval q((($x) & 0x1f));
    }' unless defined(&PCI_ATS_CAP_QDEP);
    eval 'sub PCI_ATS_MAX_QDEP () {32;}' unless defined(&PCI_ATS_MAX_QDEP);
    eval 'sub PCI_ATS_CAP_PAGE_ALIGNED () {0x20;}' unless defined(&PCI_ATS_CAP_PAGE_ALIGNED);
    eval 'sub PCI_ATS_CTRL () {0x6;}' unless defined(&PCI_ATS_CTRL);
    eval 'sub PCI_ATS_CTRL_ENABLE () {0x8000;}' unless defined(&PCI_ATS_CTRL_ENABLE);
    eval 'sub PCI_ATS_CTRL_STU {
        my($x) = @_;
	    eval q((($x) & 0x1f));
    }' unless defined(&PCI_ATS_CTRL_STU);
    eval 'sub PCI_ATS_MIN_STU () {12;}' unless defined(&PCI_ATS_MIN_STU);
    eval 'sub PCI_EXT_CAP_ATS_SIZEOF () {8;}' unless defined(&PCI_EXT_CAP_ATS_SIZEOF);
    eval 'sub PCI_PRI_CTRL () {0x4;}' unless defined(&PCI_PRI_CTRL);
    eval 'sub PCI_PRI_CTRL_ENABLE () {0x1;}' unless defined(&PCI_PRI_CTRL_ENABLE);
    eval 'sub PCI_PRI_CTRL_RESET () {0x2;}' unless defined(&PCI_PRI_CTRL_RESET);
    eval 'sub PCI_PRI_STATUS () {0x6;}' unless defined(&PCI_PRI_STATUS);
    eval 'sub PCI_PRI_STATUS_RF () {0x1;}' unless defined(&PCI_PRI_STATUS_RF);
    eval 'sub PCI_PRI_STATUS_UPRGI () {0x2;}' unless defined(&PCI_PRI_STATUS_UPRGI);
    eval 'sub PCI_PRI_STATUS_STOPPED () {0x100;}' unless defined(&PCI_PRI_STATUS_STOPPED);
    eval 'sub PCI_PRI_STATUS_PASID () {0x8000;}' unless defined(&PCI_PRI_STATUS_PASID);
    eval 'sub PCI_PRI_MAX_REQ () {0x8;}' unless defined(&PCI_PRI_MAX_REQ);
    eval 'sub PCI_PRI_ALLOC_REQ () {0xc;}' unless defined(&PCI_PRI_ALLOC_REQ);
    eval 'sub PCI_EXT_CAP_PRI_SIZEOF () {16;}' unless defined(&PCI_EXT_CAP_PRI_SIZEOF);
    eval 'sub PCI_PASID_CAP () {0x4;}' unless defined(&PCI_PASID_CAP);
    eval 'sub PCI_PASID_CAP_EXEC () {0x2;}' unless defined(&PCI_PASID_CAP_EXEC);
    eval 'sub PCI_PASID_CAP_PRIV () {0x4;}' unless defined(&PCI_PASID_CAP_PRIV);
    eval 'sub PCI_PASID_CAP_WIDTH () {0x1f00;}' unless defined(&PCI_PASID_CAP_WIDTH);
    eval 'sub PCI_PASID_CTRL () {0x6;}' unless defined(&PCI_PASID_CTRL);
    eval 'sub PCI_PASID_CTRL_ENABLE () {0x1;}' unless defined(&PCI_PASID_CTRL_ENABLE);
    eval 'sub PCI_PASID_CTRL_EXEC () {0x2;}' unless defined(&PCI_PASID_CTRL_EXEC);
    eval 'sub PCI_PASID_CTRL_PRIV () {0x4;}' unless defined(&PCI_PASID_CTRL_PRIV);
    eval 'sub PCI_EXT_CAP_PASID_SIZEOF () {8;}' unless defined(&PCI_EXT_CAP_PASID_SIZEOF);
    eval 'sub PCI_SRIOV_CAP () {0x4;}' unless defined(&PCI_SRIOV_CAP);
    eval 'sub PCI_SRIOV_CAP_VFM () {0x1;}' unless defined(&PCI_SRIOV_CAP_VFM);
    eval 'sub PCI_SRIOV_CAP_INTR {
        my($x) = @_;
	    eval q((($x) >> 21));
    }' unless defined(&PCI_SRIOV_CAP_INTR);
    eval 'sub PCI_SRIOV_CTRL () {0x8;}' unless defined(&PCI_SRIOV_CTRL);
    eval 'sub PCI_SRIOV_CTRL_VFE () {0x1;}' unless defined(&PCI_SRIOV_CTRL_VFE);
    eval 'sub PCI_SRIOV_CTRL_VFM () {0x2;}' unless defined(&PCI_SRIOV_CTRL_VFM);
    eval 'sub PCI_SRIOV_CTRL_INTR () {0x4;}' unless defined(&PCI_SRIOV_CTRL_INTR);
    eval 'sub PCI_SRIOV_CTRL_MSE () {0x8;}' unless defined(&PCI_SRIOV_CTRL_MSE);
    eval 'sub PCI_SRIOV_CTRL_ARI () {0x10;}' unless defined(&PCI_SRIOV_CTRL_ARI);
    eval 'sub PCI_SRIOV_STATUS () {0xa;}' unless defined(&PCI_SRIOV_STATUS);
    eval 'sub PCI_SRIOV_STATUS_VFM () {0x1;}' unless defined(&PCI_SRIOV_STATUS_VFM);
    eval 'sub PCI_SRIOV_INITIAL_VF () {0xc;}' unless defined(&PCI_SRIOV_INITIAL_VF);
    eval 'sub PCI_SRIOV_TOTAL_VF () {0xe;}' unless defined(&PCI_SRIOV_TOTAL_VF);
    eval 'sub PCI_SRIOV_NUM_VF () {0x10;}' unless defined(&PCI_SRIOV_NUM_VF);
    eval 'sub PCI_SRIOV_FUNC_LINK () {0x12;}' unless defined(&PCI_SRIOV_FUNC_LINK);
    eval 'sub PCI_SRIOV_VF_OFFSET () {0x14;}' unless defined(&PCI_SRIOV_VF_OFFSET);
    eval 'sub PCI_SRIOV_VF_STRIDE () {0x16;}' unless defined(&PCI_SRIOV_VF_STRIDE);
    eval 'sub PCI_SRIOV_VF_DID () {0x1a;}' unless defined(&PCI_SRIOV_VF_DID);
    eval 'sub PCI_SRIOV_SUP_PGSIZE () {0x1c;}' unless defined(&PCI_SRIOV_SUP_PGSIZE);
    eval 'sub PCI_SRIOV_SYS_PGSIZE () {0x20;}' unless defined(&PCI_SRIOV_SYS_PGSIZE);
    eval 'sub PCI_SRIOV_BAR () {0x24;}' unless defined(&PCI_SRIOV_BAR);
    eval 'sub PCI_SRIOV_NUM_BARS () {6;}' unless defined(&PCI_SRIOV_NUM_BARS);
    eval 'sub PCI_SRIOV_VFM () {0x3c;}' unless defined(&PCI_SRIOV_VFM);
    eval 'sub PCI_SRIOV_VFM_BIR {
        my($x) = @_;
	    eval q((($x) & 7));
    }' unless defined(&PCI_SRIOV_VFM_BIR);
    eval 'sub PCI_SRIOV_VFM_OFFSET {
        my($x) = @_;
	    eval q((($x) & ~7));
    }' unless defined(&PCI_SRIOV_VFM_OFFSET);
    eval 'sub PCI_SRIOV_VFM_UA () {0x;}' unless defined(&PCI_SRIOV_VFM_UA);
    eval 'sub PCI_SRIOV_VFM_MI () {0x1;}' unless defined(&PCI_SRIOV_VFM_MI);
    eval 'sub PCI_SRIOV_VFM_MO () {0x2;}' unless defined(&PCI_SRIOV_VFM_MO);
    eval 'sub PCI_SRIOV_VFM_AV () {0x3;}' unless defined(&PCI_SRIOV_VFM_AV);
    eval 'sub PCI_EXT_CAP_SRIOV_SIZEOF () {0x40;}' unless defined(&PCI_EXT_CAP_SRIOV_SIZEOF);
    eval 'sub PCI_LTR_MAX_SNOOP_LAT () {0x4;}' unless defined(&PCI_LTR_MAX_SNOOP_LAT);
    eval 'sub PCI_LTR_MAX_NOSNOOP_LAT () {0x6;}' unless defined(&PCI_LTR_MAX_NOSNOOP_LAT);
    eval 'sub PCI_LTR_VALUE_MASK () {0x3ff;}' unless defined(&PCI_LTR_VALUE_MASK);
    eval 'sub PCI_LTR_SCALE_MASK () {0x1c00;}' unless defined(&PCI_LTR_SCALE_MASK);
    eval 'sub PCI_LTR_SCALE_SHIFT () {10;}' unless defined(&PCI_LTR_SCALE_SHIFT);
    eval 'sub PCI_LTR_NOSNOOP_VALUE () {0x3ff0000;}' unless defined(&PCI_LTR_NOSNOOP_VALUE);
    eval 'sub PCI_LTR_NOSNOOP_SCALE () {0x1c000000;}' unless defined(&PCI_LTR_NOSNOOP_SCALE);
    eval 'sub PCI_EXT_CAP_LTR_SIZEOF () {8;}' unless defined(&PCI_EXT_CAP_LTR_SIZEOF);
    eval 'sub PCI_ACS_CAP () {0x4;}' unless defined(&PCI_ACS_CAP);
    eval 'sub PCI_ACS_SV () {0x1;}' unless defined(&PCI_ACS_SV);
    eval 'sub PCI_ACS_TB () {0x2;}' unless defined(&PCI_ACS_TB);
    eval 'sub PCI_ACS_RR () {0x4;}' unless defined(&PCI_ACS_RR);
    eval 'sub PCI_ACS_CR () {0x8;}' unless defined(&PCI_ACS_CR);
    eval 'sub PCI_ACS_UF () {0x10;}' unless defined(&PCI_ACS_UF);
    eval 'sub PCI_ACS_EC () {0x20;}' unless defined(&PCI_ACS_EC);
    eval 'sub PCI_ACS_DT () {0x40;}' unless defined(&PCI_ACS_DT);
    eval 'sub PCI_ACS_EGRESS_BITS () {0x5;}' unless defined(&PCI_ACS_EGRESS_BITS);
    eval 'sub PCI_ACS_CTRL () {0x6;}' unless defined(&PCI_ACS_CTRL);
    eval 'sub PCI_ACS_EGRESS_CTL_V () {0x8;}' unless defined(&PCI_ACS_EGRESS_CTL_V);
    eval 'sub PCI_VSEC_HDR () {4;}' unless defined(&PCI_VSEC_HDR);
    eval 'sub PCI_VSEC_HDR_LEN_SHIFT () {20;}' unless defined(&PCI_VSEC_HDR_LEN_SHIFT);
    eval 'sub PCI_SATA_REGS () {4;}' unless defined(&PCI_SATA_REGS);
    eval 'sub PCI_SATA_REGS_MASK () {0xf;}' unless defined(&PCI_SATA_REGS_MASK);
    eval 'sub PCI_SATA_REGS_INLINE () {0xf;}' unless defined(&PCI_SATA_REGS_INLINE);
    eval 'sub PCI_SATA_SIZEOF_SHORT () {8;}' unless defined(&PCI_SATA_SIZEOF_SHORT);
    eval 'sub PCI_SATA_SIZEOF_LONG () {16;}' unless defined(&PCI_SATA_SIZEOF_LONG);
    eval 'sub PCI_REBAR_CAP () {4;}' unless defined(&PCI_REBAR_CAP);
    eval 'sub PCI_REBAR_CAP_SIZES () {0xfffff0;}' unless defined(&PCI_REBAR_CAP_SIZES);
    eval 'sub PCI_REBAR_CTRL () {8;}' unless defined(&PCI_REBAR_CTRL);
    eval 'sub PCI_REBAR_CTRL_BAR_IDX () {0x7;}' unless defined(&PCI_REBAR_CTRL_BAR_IDX);
    eval 'sub PCI_REBAR_CTRL_NBAR_MASK () {0xe0;}' unless defined(&PCI_REBAR_CTRL_NBAR_MASK);
    eval 'sub PCI_REBAR_CTRL_NBAR_SHIFT () {5;}' unless defined(&PCI_REBAR_CTRL_NBAR_SHIFT);
    eval 'sub PCI_REBAR_CTRL_BAR_SIZE () {0x1f00;}' unless defined(&PCI_REBAR_CTRL_BAR_SIZE);
    eval 'sub PCI_REBAR_CTRL_BAR_SHIFT () {8;}' unless defined(&PCI_REBAR_CTRL_BAR_SHIFT);
    eval 'sub PCI_DPA_CAP () {4;}' unless defined(&PCI_DPA_CAP);
    eval 'sub PCI_DPA_CAP_SUBSTATE_MASK () {0x1f;}' unless defined(&PCI_DPA_CAP_SUBSTATE_MASK);
    eval 'sub PCI_DPA_BASE_SIZEOF () {16;}' unless defined(&PCI_DPA_BASE_SIZEOF);
    eval 'sub PCI_EXP_DEVCAP2_TPH_COMP_NONE () {0x;}' unless defined(&PCI_EXP_DEVCAP2_TPH_COMP_NONE);
    eval 'sub PCI_EXP_DEVCAP2_TPH_COMP_TPH_ONLY () {0x1;}' unless defined(&PCI_EXP_DEVCAP2_TPH_COMP_TPH_ONLY);
    eval 'sub PCI_EXP_DEVCAP2_TPH_COMP_EXT_TPH () {0x3;}' unless defined(&PCI_EXP_DEVCAP2_TPH_COMP_EXT_TPH);
    eval 'sub PCI_TPH_CAP () {4;}' unless defined(&PCI_TPH_CAP);
    eval 'sub PCI_TPH_CAP_ST_NS () {0x1;}' unless defined(&PCI_TPH_CAP_ST_NS);
    eval 'sub PCI_TPH_CAP_ST_IV () {0x2;}' unless defined(&PCI_TPH_CAP_ST_IV);
    eval 'sub PCI_TPH_CAP_ST_DS () {0x4;}' unless defined(&PCI_TPH_CAP_ST_DS);
    eval 'sub PCI_TPH_CAP_EXT_TPH () {0x100;}' unless defined(&PCI_TPH_CAP_EXT_TPH);
    eval 'sub PCI_TPH_CAP_LOC_MASK () {0x600;}' unless defined(&PCI_TPH_CAP_LOC_MASK);
    eval 'sub PCI_TPH_LOC_NONE () {0x;}' unless defined(&PCI_TPH_LOC_NONE);
    eval 'sub PCI_TPH_LOC_CAP () {0x200;}' unless defined(&PCI_TPH_LOC_CAP);
    eval 'sub PCI_TPH_LOC_MSIX () {0x400;}' unless defined(&PCI_TPH_LOC_MSIX);
    eval 'sub PCI_TPH_CAP_ST_MASK () {0x7ff0000;}' unless defined(&PCI_TPH_CAP_ST_MASK);
    eval 'sub PCI_TPH_CAP_ST_SHIFT () {16;}' unless defined(&PCI_TPH_CAP_ST_SHIFT);
    eval 'sub PCI_TPH_BASE_SIZEOF () {0xc;}' unless defined(&PCI_TPH_BASE_SIZEOF);
    eval 'sub PCI_TPH_CTRL () {8;}' unless defined(&PCI_TPH_CTRL);
    eval 'sub PCI_TPH_CTRL_MODE_SEL_MASK () {0x7;}' unless defined(&PCI_TPH_CTRL_MODE_SEL_MASK);
    eval 'sub PCI_TPH_ST_NS_MODE () {0x;}' unless defined(&PCI_TPH_ST_NS_MODE);
    eval 'sub PCI_TPH_ST_IV_MODE () {0x1;}' unless defined(&PCI_TPH_ST_IV_MODE);
    eval 'sub PCI_TPH_ST_DS_MODE () {0x2;}' unless defined(&PCI_TPH_ST_DS_MODE);
    eval 'sub PCI_TPH_CTRL_REQ_EN_MASK () {0x300;}' unless defined(&PCI_TPH_CTRL_REQ_EN_MASK);
    eval 'sub PCI_TPH_REQ_DISABLE () {0x;}' unless defined(&PCI_TPH_REQ_DISABLE);
    eval 'sub PCI_TPH_REQ_TPH_ONLY () {0x1;}' unless defined(&PCI_TPH_REQ_TPH_ONLY);
    eval 'sub PCI_TPH_REQ_EXT_TPH () {0x3;}' unless defined(&PCI_TPH_REQ_EXT_TPH);
    eval 'sub PCI_EXP_DPC_CAP () {0x4;}' unless defined(&PCI_EXP_DPC_CAP);
    eval 'sub PCI_EXP_DPC_IRQ () {0x1f;}' unless defined(&PCI_EXP_DPC_IRQ);
    eval 'sub PCI_EXP_DPC_CAP_RP_EXT () {0x20;}' unless defined(&PCI_EXP_DPC_CAP_RP_EXT);
    eval 'sub PCI_EXP_DPC_CAP_POISONED_TLP () {0x40;}' unless defined(&PCI_EXP_DPC_CAP_POISONED_TLP);
    eval 'sub PCI_EXP_DPC_CAP_SW_TRIGGER () {0x80;}' unless defined(&PCI_EXP_DPC_CAP_SW_TRIGGER);
    eval 'sub PCI_EXP_DPC_RP_PIO_LOG_SIZE () {0xf00;}' unless defined(&PCI_EXP_DPC_RP_PIO_LOG_SIZE);
    eval 'sub PCI_EXP_DPC_CAP_DL_ACTIVE () {0x1000;}' unless defined(&PCI_EXP_DPC_CAP_DL_ACTIVE);
    eval 'sub PCI_EXP_DPC_CTL () {0x6;}' unless defined(&PCI_EXP_DPC_CTL);
    eval 'sub PCI_EXP_DPC_CTL_EN_FATAL () {0x1;}' unless defined(&PCI_EXP_DPC_CTL_EN_FATAL);
    eval 'sub PCI_EXP_DPC_CTL_EN_NONFATAL () {0x2;}' unless defined(&PCI_EXP_DPC_CTL_EN_NONFATAL);
    eval 'sub PCI_EXP_DPC_CTL_INT_EN () {0x8;}' unless defined(&PCI_EXP_DPC_CTL_INT_EN);
    eval 'sub PCI_EXP_DPC_STATUS () {0x8;}' unless defined(&PCI_EXP_DPC_STATUS);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER () {0x1;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN () {0x6;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_UNCOR () {0x;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_UNCOR);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_NFE () {0x2;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_NFE);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_FE () {0x4;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_FE);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_IN_EXT () {0x6;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_IN_EXT);
    eval 'sub PCI_EXP_DPC_STATUS_INTERRUPT () {0x8;}' unless defined(&PCI_EXP_DPC_STATUS_INTERRUPT);
    eval 'sub PCI_EXP_DPC_RP_BUSY () {0x10;}' unless defined(&PCI_EXP_DPC_RP_BUSY);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_EXT () {0x60;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_EXT);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_RP_PIO () {0x;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_RP_PIO);
    eval 'sub PCI_EXP_DPC_STATUS_TRIGGER_RSN_SW_TRIGGER () {0x20;}' unless defined(&PCI_EXP_DPC_STATUS_TRIGGER_RSN_SW_TRIGGER);
    eval 'sub PCI_EXP_DPC_RP_PIO_FEP () {0x1f00;}' unless defined(&PCI_EXP_DPC_RP_PIO_FEP);
    eval 'sub PCI_EXP_DPC_SOURCE_ID () {0xa;}' unless defined(&PCI_EXP_DPC_SOURCE_ID);
    eval 'sub PCI_EXP_DPC_RP_PIO_STATUS () {0xc;}' unless defined(&PCI_EXP_DPC_RP_PIO_STATUS);
    eval 'sub PCI_EXP_DPC_RP_PIO_MASK () {0x10;}' unless defined(&PCI_EXP_DPC_RP_PIO_MASK);
    eval 'sub PCI_EXP_DPC_RP_PIO_SEVERITY () {0x14;}' unless defined(&PCI_EXP_DPC_RP_PIO_SEVERITY);
    eval 'sub PCI_EXP_DPC_RP_PIO_SYSERROR () {0x18;}' unless defined(&PCI_EXP_DPC_RP_PIO_SYSERROR);
    eval 'sub PCI_EXP_DPC_RP_PIO_EXCEPTION () {0x1c;}' unless defined(&PCI_EXP_DPC_RP_PIO_EXCEPTION);
    eval 'sub PCI_EXP_DPC_RP_PIO_HEADER_LOG () {0x20;}' unless defined(&PCI_EXP_DPC_RP_PIO_HEADER_LOG);
    eval 'sub PCI_EXP_DPC_RP_PIO_IMPSPEC_LOG () {0x30;}' unless defined(&PCI_EXP_DPC_RP_PIO_IMPSPEC_LOG);
    eval 'sub PCI_EXP_DPC_RP_PIO_TLPPREFIX_LOG () {0x34;}' unless defined(&PCI_EXP_DPC_RP_PIO_TLPPREFIX_LOG);
    eval 'sub PCI_PTM_CAP () {0x4;}' unless defined(&PCI_PTM_CAP);
    eval 'sub PCI_PTM_CAP_REQ () {0x1;}' unless defined(&PCI_PTM_CAP_REQ);
    eval 'sub PCI_PTM_CAP_RES () {0x2;}' unless defined(&PCI_PTM_CAP_RES);
    eval 'sub PCI_PTM_CAP_ROOT () {0x4;}' unless defined(&PCI_PTM_CAP_ROOT);
    eval 'sub PCI_PTM_GRANULARITY_MASK () {0xff00;}' unless defined(&PCI_PTM_GRANULARITY_MASK);
    eval 'sub PCI_PTM_CTRL () {0x8;}' unless defined(&PCI_PTM_CTRL);
    eval 'sub PCI_PTM_CTRL_ENABLE () {0x1;}' unless defined(&PCI_PTM_CTRL_ENABLE);
    eval 'sub PCI_PTM_CTRL_ROOT () {0x2;}' unless defined(&PCI_PTM_CTRL_ROOT);
    eval 'sub PCI_L1SS_CAP () {0x4;}' unless defined(&PCI_L1SS_CAP);
    eval 'sub PCI_L1SS_CAP_PCIPM_L1_2 () {0x1;}' unless defined(&PCI_L1SS_CAP_PCIPM_L1_2);
    eval 'sub PCI_L1SS_CAP_PCIPM_L1_1 () {0x2;}' unless defined(&PCI_L1SS_CAP_PCIPM_L1_1);
    eval 'sub PCI_L1SS_CAP_ASPM_L1_2 () {0x4;}' unless defined(&PCI_L1SS_CAP_ASPM_L1_2);
    eval 'sub PCI_L1SS_CAP_ASPM_L1_1 () {0x8;}' unless defined(&PCI_L1SS_CAP_ASPM_L1_1);
    eval 'sub PCI_L1SS_CAP_L1_PM_SS () {0x10;}' unless defined(&PCI_L1SS_CAP_L1_PM_SS);
    eval 'sub PCI_L1SS_CAP_CM_RESTORE_TIME () {0xff00;}' unless defined(&PCI_L1SS_CAP_CM_RESTORE_TIME);
    eval 'sub PCI_L1SS_CAP_P_PWR_ON_SCALE () {0x30000;}' unless defined(&PCI_L1SS_CAP_P_PWR_ON_SCALE);
    eval 'sub PCI_L1SS_CAP_P_PWR_ON_VALUE () {0xf80000;}' unless defined(&PCI_L1SS_CAP_P_PWR_ON_VALUE);
    eval 'sub PCI_L1SS_CTL1 () {0x8;}' unless defined(&PCI_L1SS_CTL1);
    eval 'sub PCI_L1SS_CTL1_PCIPM_L1_2 () {0x1;}' unless defined(&PCI_L1SS_CTL1_PCIPM_L1_2);
    eval 'sub PCI_L1SS_CTL1_PCIPM_L1_1 () {0x2;}' unless defined(&PCI_L1SS_CTL1_PCIPM_L1_1);
    eval 'sub PCI_L1SS_CTL1_ASPM_L1_2 () {0x4;}' unless defined(&PCI_L1SS_CTL1_ASPM_L1_2);
    eval 'sub PCI_L1SS_CTL1_ASPM_L1_1 () {0x8;}' unless defined(&PCI_L1SS_CTL1_ASPM_L1_1);
    eval 'sub PCI_L1SS_CTL1_L1_2_MASK () {0x5;}' unless defined(&PCI_L1SS_CTL1_L1_2_MASK);
    eval 'sub PCI_L1SS_CTL1_L1SS_MASK () {0xf;}' unless defined(&PCI_L1SS_CTL1_L1SS_MASK);
    eval 'sub PCI_L1SS_CTL1_CM_RESTORE_TIME () {0xff00;}' unless defined(&PCI_L1SS_CTL1_CM_RESTORE_TIME);
    eval 'sub PCI_L1SS_CTL1_LTR_L12_TH_VALUE () {0x3ff0000;}' unless defined(&PCI_L1SS_CTL1_LTR_L12_TH_VALUE);
    eval 'sub PCI_L1SS_CTL1_LTR_L12_TH_SCALE () {0xe0000000;}' unless defined(&PCI_L1SS_CTL1_LTR_L12_TH_SCALE);
    eval 'sub PCI_L1SS_CTL2 () {0xc;}' unless defined(&PCI_L1SS_CTL2);
    eval 'sub PCI_L1SS_CTL2_T_PWR_ON_SCALE () {0x3;}' unless defined(&PCI_L1SS_CTL2_T_PWR_ON_SCALE);
    eval 'sub PCI_L1SS_CTL2_T_PWR_ON_VALUE () {0xf8;}' unless defined(&PCI_L1SS_CTL2_T_PWR_ON_VALUE);
    eval 'sub PCI_DVSEC_HEADER1 () {0x4;}' unless defined(&PCI_DVSEC_HEADER1);
    eval 'sub PCI_DVSEC_HEADER1_VID {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&PCI_DVSEC_HEADER1_VID);
    eval 'sub PCI_DVSEC_HEADER1_REV {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xf));
    }' unless defined(&PCI_DVSEC_HEADER1_REV);
    eval 'sub PCI_DVSEC_HEADER1_LEN {
        my($x) = @_;
	    eval q(((($x) >> 20) & 0xfff));
    }' unless defined(&PCI_DVSEC_HEADER1_LEN);
    eval 'sub PCI_DVSEC_HEADER2 () {0x8;}' unless defined(&PCI_DVSEC_HEADER2);
    eval 'sub PCI_DVSEC_HEADER2_ID {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&PCI_DVSEC_HEADER2_ID);
    eval 'sub PCI_DLF_CAP () {0x4;}' unless defined(&PCI_DLF_CAP);
    eval 'sub PCI_DLF_EXCHANGE_ENABLE () {0x80000000;}' unless defined(&PCI_DLF_EXCHANGE_ENABLE);
    eval 'sub PCI_PL_16GT_LE_CTRL () {0x20;}' unless defined(&PCI_PL_16GT_LE_CTRL);
    eval 'sub PCI_PL_16GT_LE_CTRL_DSP_TX_PRESET_MASK () {0xf;}' unless defined(&PCI_PL_16GT_LE_CTRL_DSP_TX_PRESET_MASK);
    eval 'sub PCI_PL_16GT_LE_CTRL_USP_TX_PRESET_MASK () {0xf0;}' unless defined(&PCI_PL_16GT_LE_CTRL_USP_TX_PRESET_MASK);
    eval 'sub PCI_PL_16GT_LE_CTRL_USP_TX_PRESET_SHIFT () {4;}' unless defined(&PCI_PL_16GT_LE_CTRL_USP_TX_PRESET_SHIFT);
    eval 'sub PCI_NPEM_CAP () {0x4;}' unless defined(&PCI_NPEM_CAP);
    eval 'sub PCI_NPEM_CAP_CAPABLE () {0x1;}' unless defined(&PCI_NPEM_CAP_CAPABLE);
    eval 'sub PCI_NPEM_CTRL () {0x8;}' unless defined(&PCI_NPEM_CTRL);
    eval 'sub PCI_NPEM_CTRL_ENABLE () {0x1;}' unless defined(&PCI_NPEM_CTRL_ENABLE);
    eval 'sub PCI_NPEM_CMD_RESET () {0x2;}' unless defined(&PCI_NPEM_CMD_RESET);
    eval 'sub PCI_NPEM_IND_OK () {0x4;}' unless defined(&PCI_NPEM_IND_OK);
    eval 'sub PCI_NPEM_IND_LOCATE () {0x8;}' unless defined(&PCI_NPEM_IND_LOCATE);
    eval 'sub PCI_NPEM_IND_FAIL () {0x10;}' unless defined(&PCI_NPEM_IND_FAIL);
    eval 'sub PCI_NPEM_IND_REBUILD () {0x20;}' unless defined(&PCI_NPEM_IND_REBUILD);
    eval 'sub PCI_NPEM_IND_PFA () {0x40;}' unless defined(&PCI_NPEM_IND_PFA);
    eval 'sub PCI_NPEM_IND_HOTSPARE () {0x80;}' unless defined(&PCI_NPEM_IND_HOTSPARE);
    eval 'sub PCI_NPEM_IND_ICA () {0x100;}' unless defined(&PCI_NPEM_IND_ICA);
    eval 'sub PCI_NPEM_IND_IFA () {0x200;}' unless defined(&PCI_NPEM_IND_IFA);
    eval 'sub PCI_NPEM_IND_IDT () {0x400;}' unless defined(&PCI_NPEM_IND_IDT);
    eval 'sub PCI_NPEM_IND_DISABLED () {0x800;}' unless defined(&PCI_NPEM_IND_DISABLED);
    eval 'sub PCI_NPEM_IND_SPEC_0 () {0x1000000;}' unless defined(&PCI_NPEM_IND_SPEC_0);
    eval 'sub PCI_NPEM_IND_SPEC_1 () {0x2000000;}' unless defined(&PCI_NPEM_IND_SPEC_1);
    eval 'sub PCI_NPEM_IND_SPEC_2 () {0x4000000;}' unless defined(&PCI_NPEM_IND_SPEC_2);
    eval 'sub PCI_NPEM_IND_SPEC_3 () {0x8000000;}' unless defined(&PCI_NPEM_IND_SPEC_3);
    eval 'sub PCI_NPEM_IND_SPEC_4 () {0x10000000;}' unless defined(&PCI_NPEM_IND_SPEC_4);
    eval 'sub PCI_NPEM_IND_SPEC_5 () {0x20000000;}' unless defined(&PCI_NPEM_IND_SPEC_5);
    eval 'sub PCI_NPEM_IND_SPEC_6 () {0x40000000;}' unless defined(&PCI_NPEM_IND_SPEC_6);
    eval 'sub PCI_NPEM_IND_SPEC_7 () {0x80000000;}' unless defined(&PCI_NPEM_IND_SPEC_7);
    eval 'sub PCI_NPEM_STATUS () {0xc;}' unless defined(&PCI_NPEM_STATUS);
    eval 'sub PCI_NPEM_STATUS_CC () {0x1;}' unless defined(&PCI_NPEM_STATUS_CC);
    eval 'sub PCI_DOE_CAP () {0x4;}' unless defined(&PCI_DOE_CAP);
    eval 'sub PCI_DOE_CAP_INT_SUP () {0x1;}' unless defined(&PCI_DOE_CAP_INT_SUP);
    eval 'sub PCI_DOE_CAP_INT_MSG_NUM () {0xffe;}' unless defined(&PCI_DOE_CAP_INT_MSG_NUM);
    eval 'sub PCI_DOE_CTRL () {0x8;}' unless defined(&PCI_DOE_CTRL);
    eval 'sub PCI_DOE_CTRL_ABORT () {0x1;}' unless defined(&PCI_DOE_CTRL_ABORT);
    eval 'sub PCI_DOE_CTRL_INT_EN () {0x2;}' unless defined(&PCI_DOE_CTRL_INT_EN);
    eval 'sub PCI_DOE_CTRL_GO () {0x80000000;}' unless defined(&PCI_DOE_CTRL_GO);
    eval 'sub PCI_DOE_STATUS () {0xc;}' unless defined(&PCI_DOE_STATUS);
    eval 'sub PCI_DOE_STATUS_BUSY () {0x1;}' unless defined(&PCI_DOE_STATUS_BUSY);
    eval 'sub PCI_DOE_STATUS_INT_STATUS () {0x2;}' unless defined(&PCI_DOE_STATUS_INT_STATUS);
    eval 'sub PCI_DOE_STATUS_ERROR () {0x4;}' unless defined(&PCI_DOE_STATUS_ERROR);
    eval 'sub PCI_DOE_STATUS_DATA_OBJECT_READY () {0x80000000;}' unless defined(&PCI_DOE_STATUS_DATA_OBJECT_READY);
    eval 'sub PCI_DOE_WRITE () {0x10;}' unless defined(&PCI_DOE_WRITE);
    eval 'sub PCI_DOE_READ () {0x14;}' unless defined(&PCI_DOE_READ);
    eval 'sub PCI_DOE_CAP_SIZEOF () {0x18;}' unless defined(&PCI_DOE_CAP_SIZEOF);
    eval 'sub PCI_DOE_DATA_OBJECT_HEADER_1_VID () {0xffff;}' unless defined(&PCI_DOE_DATA_OBJECT_HEADER_1_VID);
    eval 'sub PCI_DOE_DATA_OBJECT_HEADER_1_TYPE () {0xff0000;}' unless defined(&PCI_DOE_DATA_OBJECT_HEADER_1_TYPE);
    eval 'sub PCI_DOE_DATA_OBJECT_HEADER_2_LENGTH () {0x3ffff;}' unless defined(&PCI_DOE_DATA_OBJECT_HEADER_2_LENGTH);
    eval 'sub PCI_DOE_DATA_OBJECT_DISC_REQ_3_INDEX () {0xff;}' unless defined(&PCI_DOE_DATA_OBJECT_DISC_REQ_3_INDEX);
    eval 'sub PCI_DOE_DATA_OBJECT_DISC_REQ_3_VER () {0xff00;}' unless defined(&PCI_DOE_DATA_OBJECT_DISC_REQ_3_VER);
    eval 'sub PCI_DOE_DATA_OBJECT_DISC_RSP_3_VID () {0xffff;}' unless defined(&PCI_DOE_DATA_OBJECT_DISC_RSP_3_VID);
    eval 'sub PCI_DOE_DATA_OBJECT_DISC_RSP_3_PROTOCOL () {0xff0000;}' unless defined(&PCI_DOE_DATA_OBJECT_DISC_RSP_3_PROTOCOL);
    eval 'sub PCI_DOE_DATA_OBJECT_DISC_RSP_3_NEXT_INDEX () {0xff000000;}' unless defined(&PCI_DOE_DATA_OBJECT_DISC_RSP_3_NEXT_INDEX);
    eval 'sub PCI_DVSEC_CXL_PORT () {3;}' unless defined(&PCI_DVSEC_CXL_PORT);
    eval 'sub PCI_DVSEC_CXL_PORT_CTL () {0xc;}' unless defined(&PCI_DVSEC_CXL_PORT_CTL);
    eval 'sub PCI_DVSEC_CXL_PORT_CTL_UNMASK_SBR () {0x1;}' unless defined(&PCI_DVSEC_CXL_PORT_CTL_UNMASK_SBR);
}
1;
