#!/bin/bash
DC=$1
REQUEST=$2
ARG=$3

LDC2_SHARED_OPTS="-link-defaultlib-shared"
GDC_SHARED_OPTS="-shared-libphobos"
DMD_SHARED_OPTS="-defaultlib=libphobos2.so"

LDC2_STATIC_OPTS="-defaultlib=:libphobos2-ldc.a,:libdruntime-ldc.a,:libz.a"
LDC2_STATIC_OPTS+=" -link-defaultlib-shared=false"
GDC_STATIC_OPTS="-static-libphobos"
DMD_STATIC_OPTS=""

# ldc2 flags
LDC2_DEBUG_OPTIONS="-d-debug --gc"
LDC2_OPTIM_OPTIONS="-O --release --gc"
# dmd flags
DMD_DEBUG_OPTIONS="-debug -g"
DMD_OPTIM_OPTIONS="-O -release"
# gdc flags
GDC_DEBUG_OPTIONS="-fdebug"
GDC_OPTIM_OPTIONS="-O2 -frelease"


if [[ $REQUEST == "phobos_options" && $ARG == static ]]; then
    [[ $ARG == static ]] && echo $(eval echo \$${DC^^}_STATIC_OPTS)
    [[ $ARG == dynamic ]] && echo $(eval echo \$${DC^^}_SHARED_OPTS)
elif [[ $REQUEST == "amalthea_options" ]]; then
    CFG="amalthea-${DC}"
    [[ ${ARG} == static ]] && CFG+="-static"
    pkg-config --libs --cflags "$CFG"
elif [[ $REQUEST == "release_options" ]]; then
    echo $(eval echo \$${DC^^}_OPTIM_OPTIONS)
elif [[ $REQUEST == "debug_options" ]]; then
    echo $(eval echo \$${DC^^}_DEBUG_OPTIONS)
fi

if [[ $REQUEST == "doc_dir" ]]; then
    read -ra distr_id_arr <<< "`lsb_release -i`"
    DISTRIBUTION=${distr_id_arr[2]}
    if [[ "${DISTRIBUTION}" != "openSUSE" ]]; then
        echo share/doc
    else
        echo share/doc/packages
    fi
fi
