/* Copying and distribution of this file, with or without modification,
 * are permitted in any medium without royalty provided the copyright
 * notice and this notice are preserved.  This file is offered as-is,
 * without any warranty.
 */

import std.algorithm : sort;
import std.stdio : writefln;

import amalthea.fs;
import amalthea.fileformats;

int main(string[] args) {
    string dir = args[1];
    if (args.length > 2) {
        writeln(args);
        addNewPathToFindFileFormats(args[2]);
    }
    FileEntry[] files = getFiles(
        dir, recursively: Yes.recursively, saveAbsolutePath: No.absPath
    );
    foreach(f; files.sort!((a, b) => a.path < b.path)) {
        writefln("File:        %s", f.path);
        FileFormat ff;
        try {
            ff = getFileFormat(f.path);
        } catch (FileException e) {
            writeln("Error:       this file is not regular or not readable.");
            continue;
        }
        writefln("Format:      %s", ff.format);
        writefln("Description: %s", ff.description);
        writeln("======================================");
    }
    return 0;
}
