// SPDX-FileCopyrightText: 2023 Jaime Marquínez Ferrándiz <jaime.marquinez.ferrandiz@fastmail.net>
//
// SPDX-License-Identifier: GPL-2.0-or-later

#ifndef QFONTMETRICSCOMPAT_H
#define QFONTMETRICSCOMPAT_H

#include <QFontMetrics>

class QFontMetricsCompat
{
public:
    static inline int horizontalAdvance(const QFontMetrics fm, const QString &text)
    {
#if (QT_VERSION >= QT_VERSION_CHECK(5, 11, 0))
        return fm.horizontalAdvance(text);
#else
        return fm.boundingRect(text).width();
#endif
    }
};

#endif // QFONTMETRICSCOMPAT_H
