// SPDX-FileCopyrightText: 2023 Jaime Marquínez Ferrándiz <jaime.marquinez.ferrandiz@fastmail.net>
//
// SPDX-License-Identifier: GPL-2.0-or-later

#include "qrandomgeneratorcompat.h"

#if QT_VERSION < QT_VERSION_CHECK(5, 10, 0)
#include <limits>
std::random_device QRandomGeneratorCompat::rand_device;
std::default_random_engine random_engine(QRandomGeneratorCompat::rand_device());

int QRandomGeneratorCompat::globalBounded(quint32 highest)
{
    std::uniform_int_distribution<quint32> dist(0, highest);
    return dist(random_engine);
}

quint32 QRandomGeneratorCompat::globalGenerate()
{
    std::uniform_int_distribution<quint32> dist(0, UINT32_MAX);
    auto x = dist(random_engine);
    return x;
}
#else

#include <QRandomGenerator>

int QRandomGeneratorCompat::globalBounded(quint32 highest)
{
    return QRandomGenerator::global()->bounded(highest);
}

quint32 QRandomGeneratorCompat::globalGenerate()
{

    return QRandomGenerator::global()->generate();
}
#endif
