// SPDX-FileCopyrightText: 2023 Jaime Marquínez Ferrándiz <jaime.marquinez.ferrandiz@fastmail.net>
//
// SPDX-License-Identifier: GPL-2.0-or-later

#ifndef QRANDOMGENERATORCOMPAT_H
#define QRANDOMGENERATORCOMPAT_H

#include <QtGlobal>

#if QT_VERSION < QT_VERSION_CHECK(5, 10, 0)
#include <random>
#endif

class QRandomGeneratorCompat
{
public:
#if QT_VERSION < QT_VERSION_CHECK(5, 10, 0)
    static std::default_random_engine engine;
    static std::random_device rand_device;
#endif
    static int globalBounded(quint32 highest);
    static quint32 globalGenerate();
};

#endif // QRANDOMGENERATORCOMPAT_H
