# Описание репозитория

Репозиторий содержит файл с макросами **cmake** для упрощения генерации файлов переводов **Qt** (**ts** и **qm** файлы). 

# Использование в проекте

1.  Перед использованием макросов должны быть обнаружены библиотеки **Qt** с компонентом **LinguistTools**, например:

    ```find_package(Qt5 COMPONENTS LinguistTools REQUIRED)```

    В настоящий момент поддерживаются версии **Qt5** и **Qt6**.	

    Если **LinguistTools** не будет обнаружен, то используемые далее макросы будут доступны, но не будут выполнять никаких действий. Это позволяет использовать макросы генерации переводов в **cmake**-файлах из других подрепозиториев, которые могут использоваться как в требующих  генерации перевода проектах, так и в не требующих. В этом случае в этих **cmake**-файлах можно всегда вызывать макросы перевода, а поиск **LinguistTools**, если переводы нужны, возлагается на основной проект.

2.  Перед использованием макросов генерации переводов можно переопределить ряд переменных, определяющих параметры, которые влияют на работу этих макросов. Для каждого параметра существует два варианта переменных, определяющих его значение:

    - **QTRANSLATION_GLOBAL_<имя параметра>** - общая переменная, которая определяет значение параметра, по умолчанию действующее для всех макросов генерации переводов, вызываемых после ее определения.
    - **QTRANSLATION_<базове имя>_<имя параметра>** - специфичная для конкретного файла переводов переменная. Действует только для вызовов макросов генерации документации, в которых значение аргумента **basename** совпадает с базовым именем в названии переменной. Значение данной переменной имеет приоритет над значением общей переменной.

    Доступны следующие параметры:
    - **UPDATE_ENABLE** - определяет, нужно ли обновлять список переводимых строк в **ts**-файле по исходным кодам:	
        -   Если **FALSE** (по умолчанию), то выполняется только компиляция бинарных файлов (**qm**-файлов) для установки с приложением по уже созданным файлам переводов (**ts**-файлам), хранящимися с исходными кодами проекта. Этот режим полезен, если не планируется изменять исходные коды (или их части, влияющие на перевод), на основе которых получается данный файл перевода, и позволяет избежать побочных эффектов, связанных с генерацией исходных файлов переводов (см. ниже).
        -   Если **TRUE**, то перед компиляцией дополнительно выполняется обновление (или создание) исходного текстового файла переводов (**ts**-файла) по указанным файлам исходных кодов проекта. Этот режим используется при изменении исходных кодов, влияющих на перевод (в том числе при создании нового проекта для создания нового файла переводов).

            Этот режим имеет побочный эффект, связанный с тем, что так как **ts**-файл обновляется не только вручную, но и системой сборки, то **cmake** считает его результатом сборки и удаляет при очистке проекта (цель ```clean```), удаляя все вручную добавленные строки перевода. Эта проблема может быть отчасти решена установкой свойства **CLEAN_NO_CUSTOM**, запрещающего очищать результаты генерации:

            ```set_property(DIRECTORY PROPERTY CLEAN_NO_CUSTOM ON)```

            Однако данное свойство действует одновременно на все файлы, получающиеся с помощью **cmake_add_custom_command** для текущей директории исходных кодов (включая не только **ts**-файлы, но и в частности **qm**-файлы). Это может быть особенно нежелательно, если используются другие команды генерации файлов, результаты которых должны быть очищены при очистке сборки, поэтому значение **CLEAN_NO_CUSTOM** не устанавливается автоматически. При желании его можно установить в проекте верхнего уровня, использующего данный макрос.

    - **LANGUAGES** - задает список сокращенных названий языков, на которые требуется выполнить перевод. Определяет суффиксы создаваемых файлов переводов. Макросы генерации создают по одному **ts** и  одному **qm** файлу на каждый язык с именем *"<базовое имя>_<сокращенное название языка>.<расширение>"*. По умолчанию имеет значение **ru** для генерации переводов на русский язык.
    - **BINARY_DIR** - задает директорию, в которую будут сохранены скомпилированные бинарные (**qm**) файлы с переводами, распространяемые вместе с программой. По умолчанию равна *"${CMAKE_CURRENT_BINARY_DIR}/translations"*.

3. Для использования макросов необходимо включить файл **qtranslation.cmake**:

    ``` include(<путь>/qtranslation.cmake)```

    Повторное включение файла не выполняет каких-либо действий и не приводит к конфликтам.

4. Для генерации каждого файла перевода необходимо вызывать макрос:

    ```qtranslation_generate(genfiles_var input_dir basename [source1] [source2 ...])```

    Аргументы макроса имеют следующие значения:
    - **genfiles_var** - имя переменной, в которую будут сохранены абсолютные имена файлов, полученных в качестве результата генерации перевода (**qm**-файлы)
    - **input_dir** - директория, в которой хранятся (или также обновляются при включении **UPDATE_ENABLE**) текстовые файлы с переводами строк (**ts**-файлы) для всех поддерживаемых языков
    - **basename** - определяет базовое имя файла перевода (уникальную часть имени файлов с данным переводом). Полное имя файла определяется как "*<базовое имя>_<сокращенное название языка>.<расширение>*". Также определяет имена переменных, которые могут переопределять параметры именно данного макроса перевода.
    - **source** - произвольное количество файлов исходных текстов программы, на основании строк из которых создаются и обновляются **ts**-файлы переводов при включении **UPDATE_ENABLE** (в противном случае не используются).

5. Полученный список сгенерированных **qm**-файлов может быть добавлен в список исходных файлов для команд **cmake_add_executable** и/или **cmake_add_library**, либо может быть создана отдельная цель для их получения с помощью **add_custom_target**:

    ```add_custom_target(<имя цели> DEPENDS ${GENFILES_VAR})```

    В последнем случае полученная цель должна сама использоваться в качестве зависимости для других целей.

### Процедура создания переводов

Создание/обновление строк переводов выполняется следующим образом:
1.  Необходимо установить параметр **UPDATE_ENABLE** в **TRUE** для создания/обновления исходных **ts**-файлов переводов.
2.  Собрать проект. При сборке на каждый макрос **qtranslation_generate** все созданные с использованием метода **QObject::tr** строки в указанных файлах исходных текстов, отсутствующие в **ts**-файле, добавляются в него как непереведенные (если **ts**-файла не существует, он будет создан).
3.  Необходимо открыть обновленные **ts**-файлы утилитой **Qt Linguist**, входящей в состав **Qt**, и внести переводы строк на соответствующий язык.
4.  Снова собрать проект для обновления результирующих бинарных **qm**-файлов в соответствии с изменениями в **ts**-файлах.
5.  **qm**-файлы должны быть распространены вместе с программой и загружены стандартными функциями **Qt**. Для упрощения последнего также можно использовать проект **QTranslationSwitch**.

Компиляция **qm**-файлов из обновленных **ts**-файлов выполняется при каждой сборке проекта, для которого **qm**-файлы указаны в списке исходных файлов или для которого явно указана зависимость от **qm**-файлов, вне зависимости от значения параметра **UPDATE_ENABLE**. 
