#ifndef TEDSWRITERDEVICEINFO_H
#define TEDSWRITERDEVICEINFO_H

#include <QString>
#include <QDateTime>
#include <QByteArray>

class TedsWriterDeviceInfo {
public:
    TedsWriterDeviceInfo() {}
    TedsWriterDeviceInfo(const QString &fwName, const QString &fwVersion,
                         const QString &fwAuthor, const QString &organization,
                         const QDateTime &burnDate, const QByteArray &hash) :
        m_fwName{fwName}, m_fwVer{fwVersion}, m_fwAuthor{fwAuthor},
        m_organization{organization}, m_burnDate{burnDate}, m_hash{hash} {

        for (char c : hash) {
            m_hashText += QString("%1").arg(static_cast<quint8>(c), 2, 16, QChar('0'));
        }

    }

    const QString &fwName() const {return m_fwName;}
    const QString &fwVersion() const {return m_fwVer;}
    const QString &fwAuthor() const {return m_fwAuthor;}
    const QString &organization() const {return m_organization;}
    const QDateTime &burnDate() const {return m_burnDate;}
    const QByteArray &fwHash() const {return m_hash;}
    const QString &fwHashText() const {return m_hashText;}
private:
    QString m_fwName;
    QString m_fwVer;
    QString m_fwAuthor;
    QString m_organization;
    QDateTime m_burnDate;
    QByteArray m_hash;
    QString m_hashText;

};

#endif // TEDSWRITERDEVICEINFO_H
