#ifndef USBDEVICE_H
#define USBDEVICE_H

#include <QObject>
class LQError;

class UsbDevice : public QObject {

    class ID {
    public:
        ID(quint16 vid, quint16 pid) : m_vid{vid}, m_pid{pid} {}

        quint16 vid() const {return m_vid;}
        quint16 pid() const {return m_pid;}
    private:
        quint16 m_vid;
        quint16 m_pid;
    };
public:

    UsbDevice();
    ~UsbDevice();

    void detect(LQError &err, const QList<ID> &idList);
    void close();

    void ctlVendorReqTx(quint8 req, quint16 wValue, quint16 wIndex, const QByteArray &data, LQError &err);
    void ctlVendorReqRx(quint8 req, quint16 wValue, quint16 wIndex, quint16 reqLen, QByteArray &data, LQError &err);
private:
    struct libusb_device_handle *m_usb_hnd {nullptr};

    const unsigned m_ioreq_tout {3000};
};

#endif // USBDEVICE_H
