#ifndef USBDEVICEERRORS_H
#define USBDEVICEERRORS_H

#include "LQError.h"
#include <QObject>

class UsbDeviceErrors: public QObject {
    Q_OBJECT
public:
    static LQError error(int code, const QString &msg);

    static LQError devNotDetected();
    static LQError devNotOpened();
    static LQError devOpen(int err_code);
    static LQError devIfaceClaim(int err_code);
    static LQError devCtlReqFailed(int req_code, int err_code);
    static LQError devCtlReqInsufSize(int req_code, int req_size, int done_size);
private:
    static LQError libUsbError(int base_err, const QString &text, int err_code);
};


#endif // USBDEVICEERRORS_H
