#ifndef TEDSWRTR_PROTO_H
#define TEDSWRTR_PROTO_H

#define TEDSWRTR_USB_VID                    0x0483 /* Vendor-ID для USB-устройства */
#define TEDSWRTR_USB_PID                    0xF0A7 /* Product-ID для USB-устройства */

#define TEDSWRTR_USBCMD_GET_INFO            1 /* получение информации о устройстве (в value передается одно из занчений TEDSWRTR_INFO_PARAM_xxx) */
#define TEDSWRTR_USBCMD_GET_LAST_ERR        2 /* получение кода последней ошибки */
#define TEDSWRTR_USBCMD_GET_STATUS          3 /* получение информации о состоянии устройства */
#define TEDSWRTR_USBCMD_TEDSMEM_WRITE       4 /* запись блока данных в TEDS память */
#define TEDSWRTR_USBCMD_TEDSMEM_READ        5 /* чтение блока данных в TEDS память */

/* Коды праметров, передаваемых в качестве value для запроса TEDSWRTR_USBCMD_GET_INFO */
#define TEDSWRTR_INFO_PARAM_FWNAME          1 /* название прошивки */
#define TEDSWRTR_INFO_PARAM_FWVER           2 /* версия прошивки */
#define TEDSWRTR_INFO_PARAM_ORGNAME         3 /* название организации */
#define TEDSWRTR_INFO_PARAM_FWAUTHOR        4 /* автор прошивки */
#define TEDSWRTR_INFO_PARAM_BURNDATE        5 /* дата и время записи прошивки в МК */
#define TEDSWRTR_INFO_PARAM_FWHASH          6 /* контрольная сумма */

/* Коды параметров, передаваемых в качестве value для запроса TEDSWRTR_USBCMD_GET_STATUS */
#define TEDSWRTR_STATUS_PARAM_TEDSMEM       1 /* признак наличия TEDS-памяти */


#define TEDSWRTR_MEM_EXCHANGE_MAX_SIZE    128 /* максимальный размер для обмена данными */

#define TEDSWRTR_ERR_OK                      0
#define TEDSWRTR_ERR_INVALID_REQ_TYPE        1 /* неподдерживаемый запрос по USB */
#define TEDSWRTR_ERR_INVALID_REQ_PARAM       2 /* нверное значение параметров USB-запроса */
#define TEDSWRTR_ERR_OW_LINE_LOW             3 /* постоянный нулевой уровень на OW-шине */
#define TEDSWRTR_ERR_OW_NO_PRESENT_RESP      4 /* нет признака наличия устройства на OW-шине */
#define TEDSWRTR_ERR_OW_IDROM_CRC            5 /* ошибка контрольной суммы идентификационных данных OW-устройства */
#define TEDSWRTR_ERR_OWFLASH_NOT_DETECTED    6 /* TEDS-память не подключена */
#define TEDSWRTR_ERR_OWFLASH_EXCH_ERROR      7 /* ошибка обмена с TEDS-памятью по однопроводному интерфейсу */
#define TEDSWRTR_ERR_OWFLASH_INVALID_ADDR    8 /* задан неверный адрес при обращении к TEDS-памяти */
#define TEDSWRTR_ERR_OWFLASH_INVALID_SIZE    9 /* задан неверный размер данных при обращении к TEDS-памяти */
#define TEDSWRTR_ERR_OWFLASH_WR_ADDR_ALIGN   10 /* адрес записи данных в TEDS-память не выровнен на начало строки */
#define TEDSWRTR_ERR_OWFLASH_WR_STATUS       11 /* Некорректное значение статуса TEDS-памяти при записи */
#define TEDSWRTR_ERR_OWFLASH_WR_DATA_CHECK   12 /* Ошибка проверки записанных данных в TEDS-память */
#define TEDSWRTR_ERR_OWFLASH_WR_DONE_ACK     13 /* Некотрректное подтверждение завершения записи от TEDS-памяти */


#endif // TEDSWRTR_PROTO_H
