#include "TedsWriterDevBaseWidget.h"
#include "Device/TedsWriterDevceDetector.h"

TedsWriterDevBaseWidget::TedsWriterDevBaseWidget(QWidget *parent) :
    QWidget{parent} {

}

void TedsWriterDevBaseWidget::init(TedsWriterDevceDetector &detector) {
    m_detector = &detector;
    connect(m_detector, &TedsWriterDevceDetector::connectionStatusChanged,
            this, &TedsWriterDevBaseWidget::onDevStateChanged);
    connect(m_detector, &TedsWriterDevceDetector::tedsMemStatusChanged,
            this, &TedsWriterDevBaseWidget::onMemStateChagned);
}

TedsWriterDevice &TedsWriterDevBaseWidget::device() {
    return m_detector->device();
}

void TedsWriterDevBaseWidget::onDevStateChanged(bool con) {
    devStateUpdate(con);
}

void TedsWriterDevBaseWidget::onMemStateChagned(bool con) {
    memStateUpdate(con);
}
