#ifndef TEDSWRITERDEVBASEWIDGET_H
#define TEDSWRITERDEVBASEWIDGET_H

#include <QWidget>
class TedsWriterDevceDetector;
class TedsWriterDevice;

class TedsWriterDevBaseWidget : public QWidget {
    Q_OBJECT
public:
    explicit TedsWriterDevBaseWidget(QWidget *parent = nullptr);

    void init(TedsWriterDevceDetector &detector);

    TedsWriterDevice &device();
protected:
    virtual void devStateUpdate(bool connected) {}
    virtual void memStateUpdate(bool connected) {}
private Q_SLOTS:
    void onDevStateChanged(bool con);
    void onMemStateChagned(bool con);
private:
    TedsWriterDevceDetector *m_detector {nullptr};
};

#endif // TEDSWRITERDEVBASEWIDGET_H
