#include "MainWindow.h"
#include "ui_MainWindow.h"
#include <QStringBuilder>
#include <QSettings>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow{parent},
    m_ui{new Ui::MainWindow} {

    m_ui->setupUi(this);

    setWindowTitle(QCoreApplication::applicationName() % QLatin1String(" - ") %
                   QCoreApplication::applicationVersion());

    loadUiState();
}

MainWindow::~MainWindow() {

}

void MainWindow::init() {
    m_ui->devState->init(m_devDetector);
    m_ui->devInfo->init(m_devDetector);
    m_ui->memTest->init(m_devDetector);
    m_devDetector.start();
}

void MainWindow::closeEvent(QCloseEvent *event) {
    saveUiState();
    QMainWindow::closeEvent(event);
}

void MainWindow::loadUiState() {
    QSettings set;
    set.beginGroup("MainWindows");
    restoreState(set.value("state").toByteArray());
    resize(set.value("size", QSize(900, 700)).toSize());
    move(set.value("pos", QPoint(200, 100)).toPoint());
}

void MainWindow::saveUiState() const {
    QSettings set;
    set.beginGroup("MainWindows");
    /* если коно в настоящий момент не свернуто - то сохраняем его текущие
       параметры */
    if (this->isVisible() && !isMinimized()) {
        set.setValue("state", saveState());
        set.setValue("size", size());
        set.setValue("pos", pos());
    }
}
