# makefile для включения в проект.
#
# на входе принимает параметры:
#  TARGET_CPU (или может быть переопределен через LTIMER_TARGET) - если явно
#                не установлена переменная LTIMER_PORT, то по данной переменной
#                выбирается подходящий порт
#  LTIMER_PORT - опционально можно явно указать порт (на случай, если несколько
#                портов могут относится к одной архитектуре)
#  LSCPEC_DIR  - путь к определениям к lcspec (по-умолчанию ../lcspec относительно данного файла)
#
# устанавливает следующие параметры:
#  LTIMER_SRC      - исходные файлы на C
#  LTIMER_INC_DIRS - директории с заголовками, которые должны быть добавлены
#                    в список директорий для поиска заголовков проекта


LTIMER_MAKEFILE = $(abspath $(lastword $(MAKEFILE_LIST)))
LTIMER_DIR := $(dir $(LTIMER_MAKEFILE))
LCSPEC_DIR ?= $(LTIMER_DIR)/../lcspec

LTIMER_TARGET ?= $(TARGET_CPU)


ifndef LTIMER_PORT
    ifeq ($(LTIMER_TARGET), lpc17xx)
        LTIMER_PORT = cm_systick
    else ifeq ($(LTIMER_TARGET), lpc43xx)
        LTIMER_PORT = cm_systick
    else ifeq ($(LTIMER_TARGET), lpc11u6x)
        LTIMER_PORT = cm_systick
    else ifeq ($(LTIMER_TARGET), bf609)
        LTIMER_PORT = bf_core_tmr
    else ifeq ($(LTIMER_TARGET), imx6)
        LTIMER_PORT = imx6_epit
    else ifeq ($(LTIMER_TARGET), stm32h7xx)
        LTIMER_PORT = cm_systick
    endif
endif

ifndef LTIMER_PORT
    $(error unknown port. LTIMER_PORT or one of supported target in LTIMER_TARGET or TARGET_CPU must be specified)
endif

LTIMER_SRC := $(LTIMER_DIR)/ports/$(LTIMER_PORT)/lclock.c
LTIMER_INC_DIRS := $(LCSPEC_DIR) $(LTIMER_DIR) $(LTIMER_DIR)/ports/$(LTIMER_PORT)
