-------------------
Wrapper For txt2man
===================

Author - Copyright (C) 2015-2020 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

This AutoTools project produces a wrapper for txt2man to perform some string
manipulation not possible in Makefile.am on parameters to be passed to txt2man.

Example
-------
For example, ignoring subsequent parameters, a Makefile might invoke txt2manwrap
with the makefile target which would become txt2manwrap -t mget.1 which
txt2manwrap would convert to txt2man -t mget stripping the final '.*'.

In the Makefile.am

	mget.1: Makefile
		...
		txt2manwrap $(@F) $$section "File Manual" $@.tmp $@
		...
	mget.1: $(srcdir)/mget.1.man.in

Would produce a man page titled mget, not mget.1.

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-

https://github.com/m-grant-prg/txt2manwrap/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Type './configure'

f) ... As root or sudo, type 'make install clean'

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/txt2manwrap/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

