/* 
 *  Simple Virtual Machine - A versatile and robust architecture to
 *  easily write applications.
 *  Copyright (C) 2021  Julien BRUGUIER
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef SVM_COMPATIBILITY
#define SVM_COMPATIBILITY
#define SVM_API_SIGNATURE "_106231:624761_611021:275361_258021:366081_603141:121191_352881:033001_037831:326541_406971:527221_455811:488941_116001:298801_142311:387811_133161:649771_254501:560281_603031:098341_107111:081551_041691:383741_575901:596081_021801:365091_388011:175001_302681:566961_317821:459771_399481:066721_230331:306431_635611:545851_430071:638301_098321:604871_287821:563051_644221:364921_488601:367391_355681:002061_528561:177451_099051:584421_338491:281831_257501:382991_637351:611571_385231:549941_306771:185031_264241:631621_479491:646261_547741:582661_540481:174181_298741:589911_477671:045591_152801:301451_588781:560851_486351:453631_187781:416031_446911:439481_313781:290821_562091:107811_378861:416091_105311:124581_402121:516361_125641:516091_397061:009141_448281:316861_087821:286411_024391:546181_034781:636061_050511:651501_161321:292631_236081:640321_421551:504011_420091:255261_260051:008681_143611:460041_251411:619231_430191:570531_448291:325051_629001:585711_430271:526941_389311:482531_336501:145781_295541:145141_651581:484901_545691:167421_504731:167411_020391:614561_391071:618341_258601:300351_627381:116951_422341:103911_271281:612641_276431:619701_237641:183541_404491:636201_131841:226641_313031:108691_220131:625241_203501:330631_019201:335031_015811:381381_319211:093661_043371:281861_442071:585101_550101:442131_465871:546321_589541:372541_625331:112321_322151:086281_015351:054941_198251:345451_079261:494271_618981:490301_027241:578511_299951:016621_634221:306701_496991:491461_612171:296831_049221:266981_517521:379181_570291:017071_594531:593461_205221:412941_299461:512881_625701:276781_543651:031941_213681:123971_022281:119131_306281:156261_195881:405941_407211:429901_420991:138961_631311:275261_307611:372301_121381:317901_407591:007731_044311:473241_043511:310541_037171:500661_502221:458831_481611:570841_415211:597581_248751:177921_554601:587341_215991:132341_223531:637021_653201:003261_412401:197241_528041:121961_264951:600731_351361:130601_291841:121341_457951:247511_466031:120661_278541:157921_030351:559571_529631:225341_270431:608591_089901:296821_522591:078331_266731:436951_195931:419471_285591:490121_051051:093941_201951:288151_460561:361451_568511:094901_430471:577221_116041:265261_148151:117631_050251:103061_096691:277521_513321:342831_001761:001621_262441:540441_173761:055421_112031:101971_596491:511051_110601:231791_130201:045691_454911:409361_398701:459251_028851:361591_306511:335791_298851:154361_212221:207991_261601:500381_279881:343791_261971:122091_456001:643611_155801:557221_212171:092731_032761:404741_278451:505171_170241:462281_534811:352691_645751:483111_242191:305371_537571:442281_025401:578611_367351:598171_636831:357491_049651:513451_021851:440871_494231:031321_266621:037991_259061:484861_255741:337021_151171:229171_270691:578271_257441:315411_256871:261351_053031:249191_064271:568451_395051:463351_283851:486141_422191:329631_433501:322461_567651:607401_513191:332661_309771:489311_573001:582431_113951:330441_072991:138121_335291:124601_069951:410121_197991:036781_440501:306011_076341:114111_330261:422281_289301:405781_024651:369591_300501:005871_194821:164371_554641:323931_104951:004111_244051:441831_172631:396291_486561:642911_077811:245021_036821:586451_432391:366281_514501:133021_283481:350491_473541:418801_282201:026341_446401:254781_404231:172621_478551:329071_545861:028131_533121:647161_242011:435761_582161:176991_295431:328391_365211:619741_299281:166961_614451:082561_443761:255471_611911:047171_546221:245761_366391:206531_077531:312821_505261:431971_365111:162561_077371:573551_653181:094151_600621:429571_091831:316441_618971:613981_307211:581511_580091:134631_174121:259011_477641:566941_501031:292921_633671:363471_106191:565471_628411:401441_109401:066131_110911:424731_543181:451471_175421:181221_010501:240441_267731:507271_556711:358711_636351:336141_323851:442891_236431:517291_378791:014851_217801:335371_468551:217151_642491:158451_495241:061241_400471:296221_443611:141801_588461:589941_301731:250411_236171:485811_502651:223041_648251:157371_262631:624691_631251:481121_144781:419031_429801:093641_315261:002171_518321:628941_141751:504151_045211:459491_576011:201281_267571:220191_184551:560121_288251:136011_481851:590551_573051:577981_633451:482771_202371:462731_007491:184131_524181:619241_136891:109141_499471:227771_410471:350881_071321:275851_119431:229581_455921:276601_123041:471391_456041:592881_130721:515561_456391:072571_547901:085261_018301:482831_653921:306971_130941:562631_316231:014441_401051:370021_155271:321381_057771:096701_424651:556071_052351:429931_237641:537091_086691:330731_496261:445931_555941:486651_303411:539931_502161:085411_267631:346651_623921:290551_467161:426621_185901:492931_355131:603541_239961:313661_207721:363201_085501:082391_515831:140311_096211:157931_316431:160911_054621:301451_481391:630611_527971:503291_235641:277661_611081:647421_644881:423701_367891:142751_578081:355491_437491:200871_506351:267031_480761:389281_651061:623201_358871:300831_260411:384771_255061:172041_309371:357731_543911:217581_124281:347871_639921:511091_104831:169281_637181:090531_186671:179511_295671:624351_183181:457151_027371:503481_198991:327881_363841:153901_324281:597871_646171:293701_276341:035231_132631:099351_146591:017621_456301:512651_006851:381681_339651:590611_404811:491011_265781:446241_008231:348661_305261:512101_351321:552901_319341:382981_416341:584471_444251:468241_597161:354781_490861:558131_556201:550191_489581:601381_154381:306131_155861:427841_646451:124491_354811:648661_204091:636951_641841:088881_155501:263231_422511:637121_375981:095621_048371:258431_113221:317631_569181:118401_285591:460081_051051:375521_413151:046211_356311:563751_047491:589701_500611:653251_383571:489721_406171:335721_604501:016571_340991:396501_189461:563391_188181:579681_566421:627021_263001:044421_316581:296171_091091:425801_195561:306361_451421:389101_065231:638991_190761:628891_264731:646981_360731:267351_126411:044371_527171:260531_459291:646421_456691:175521_392711:635711_545911:650831_099971:380821_409461:049411_306281:128021_322921:286291_018001:559141_400501:458661_146701:221601_026231:361791_035011:430891_556121:262971_325741:236461_323921:397001_564241:031151_447121:414591_630971:578541_545101:450621_038681:199881_446161:394381_504141:276881_037401:570611_446001:254071_045531:632161_330181:564681_006651:165281_543881:624631_092411:226661_166531:477721_006371:544491_524041:329241_278371:008851_337541:506441_319681:327191_091851:222161_413631:214841_411111:202911_525521:154821_041671:267441_534941:041541_085631:010521_126721:533601_160921:068121_313391:398861_584561:397841_646011:559121_244711:106601_654961:270571_408251:296341_635941:517621_134181:120981_336361:579541_099281:360521_499371:100401_403691:295341_622231:591841_013441:164131_517501:341811_128241:288121_541961:428261_397891:591611_203251:471751_479801:499131_308811:491591_280091:308811_616701:498791_489471:391721_029281:273871_622541:168831_619081:402331_049041:520961_375831:206591_383611:265471_217881:521171_190231:113791_305411:171381_029301:273881_383861:157881_337501:261541_409681:247291_414831:577541_569641:337681_542891:641571_408641:616551_313291:303631_358531:549391_480301:652381_296001:560231_192321:460841_084411:109571_085881:613601_226361:010961_649781:354311_560141:309751_397101:506161_130001:093761_373671:170881_596411:071101_459101:287801_305151:133631_552571:596131_322471:128881_316021:420631_"
#define SVM_VERSION "2.8.20250604"
#define SVM_API_DATABASE ":106231_(svm_accesscontrol_new)SVM_FUNCTION SVM_AccessControl svm_accesscontrol_new(const void *svm, const unsigned long int *max_instructions, const unsigned long int *max_memory):611021_(svm_kernel_get_accesscontrol)SVM_FUNCTION SVM_AccessControl svm_kernel_get_accesscontrol(const void* svm, const SVM_Kernel kernel):258021_(svm_code_label_get_address)SVM_FUNCTION SVM_Address svm_code_label_get_address(const void *svm, const SVM_Code code, const SVM_Value_String label):603141_(svm_code_label_get_address__raw)SVM_FUNCTION SVM_Address svm_code_label_get_address__raw(const void *svm, const SVM_Code code, const char *label):352881_(svm_code_label_get_address__string)SVM_FUNCTION SVM_Address svm_code_label_get_address__string(const void *svm, const SVM_Code code, const SVM_String label):037831_(svm_value_pointer_get_address)SVM_FUNCTION SVM_Address svm_value_pointer_get_address(const void *svm, const SVM_Value_Pointer pointer):406971_(svm_value_symbol_get_address)SVM_FUNCTION SVM_Address svm_value_symbol_get_address(const void *svm, const SVM_Value_Symbol symbol):455811_(svm_accesscontrol_has_instructions)SVM_FUNCTION SVM_Boolean svm_accesscontrol_has_instructions(const void *svm, const SVM_AccessControl access_control):116001_(svm_accesscontrol_has_memory)SVM_FUNCTION SVM_Boolean svm_accesscontrol_has_memory(const void *svm, const SVM_AccessControl access_control):142311_(svm_code_instruction_is_system)SVM_FUNCTION SVM_Boolean svm_code_instruction_is_system(const void *svm, const SVM_Code code, const SVM_Address address):133161_(svm_code_instruction_is_waiting)SVM_FUNCTION SVM_Boolean svm_code_instruction_is_waiting(const void *svm, const SVM_Code code, const SVM_Address address):254501_(svm_code_label_has_address)SVM_FUNCTION SVM_Boolean svm_code_label_has_address(const void *svm, const SVM_Code code, const SVM_Value_String label):603031_(svm_code_label_has_address__raw)SVM_FUNCTION SVM_Boolean svm_code_label_has_address__raw(const void *svm, const SVM_Code code, const char *label):107111_(svm_code_label_has_address__string)SVM_FUNCTION SVM_Boolean svm_code_label_has_address__string(const void *svm, const SVM_Code code, const SVM_String label):041691_(svm_code_symbol_has_address)SVM_FUNCTION SVM_Boolean svm_code_symbol_has_address(const void *svm, const SVM_Code code, const SVM_Value_String label):575901_(svm_code_symbol_has_address__raw)SVM_FUNCTION SVM_Boolean svm_code_symbol_has_address__raw(const void *svm, const SVM_Code code, const char *label):021801_(svm_code_symbol_has_address__string)SVM_FUNCTION SVM_Boolean svm_code_symbol_has_address__string(const void *svm, const SVM_Code code, const SVM_String label):388011_(svm_event_address_has_struct)SVM_FUNCTION SVM_Boolean svm_event_address_has_struct(const void *svm, const SVM_Event_Queue_Address address):302681_(svm_event_queue_check)SVM_FUNCTION SVM_Boolean svm_event_queue_check(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address destination, SVM_Event_Queue_Address *origin, SVM_Structure *event, const SVM_Value_Integer timeout, const SVM_Boolean soft):317821_(svm_event_queue_check__raw)SVM_FUNCTION SVM_Boolean svm_event_queue_check__raw(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address destination, SVM_Event_Queue_Address *origin, SVM_Structure *event, const unsigned long int timeout, const SVM_Boolean soft):399481_(svm_event_queue_pull)SVM_FUNCTION SVM_Boolean svm_event_queue_pull(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address destination, SVM_Event_Queue_Address *origin, SVM_Structure *event, const SVM_Boolean soft):230331_(svm_kernel_has_lastreturnisshutdown)SVM_FUNCTION SVM_Boolean svm_kernel_has_lastreturnisshutdown(const void* svm, const SVM_Kernel kernel):635611_(svm_kernel_has_protectedmode)SVM_FUNCTION SVM_Boolean svm_kernel_has_protectedmode(const void* svm, const SVM_Kernel kernel):430071_(svm_kernel_has_transmitinterruption)SVM_FUNCTION SVM_Boolean svm_kernel_has_transmitinterruption(const void* svm, const SVM_Kernel kernel):098321_(svm_kernel_is_runnable)SVM_FUNCTION SVM_Boolean svm_kernel_is_runnable(const void* svm, const SVM_Kernel kernel):287821_(svm_kernel_is_terminated)SVM_FUNCTION SVM_Boolean svm_kernel_is_terminated(const void* svm, const SVM_Kernel kernel):644221_(svm_machine_mode_is_debug)SVM_FUNCTION SVM_Boolean svm_machine_mode_is_debug(const void *svm):488601_(svm_machine_mode_is_performance)SVM_FUNCTION SVM_Boolean svm_machine_mode_is_performance(const void *svm):355681_(svm_memory_address_is_defined)SVM_FUNCTION SVM_Boolean svm_memory_address_is_defined(const void *svm, const SVM_Kernel kernel, const SVM_Address address):528561_(svm_memory_address_is_initialised)SVM_FUNCTION SVM_Boolean svm_memory_address_is_initialised(const void *svm, const SVM_Kernel kernel, const SVM_Address address):099051_(svm_memory_address_is_writable)SVM_FUNCTION SVM_Boolean svm_memory_address_is_writable(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Value value):338491_(svm_memory_has_alias)SVM_FUNCTION SVM_Boolean svm_memory_has_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_String alias):257501_(svm_memory_has_alias__raw)SVM_FUNCTION SVM_Boolean svm_memory_has_alias__raw(const void *svm, const SVM_Kernel kernel, const char *alias):637351_(svm_memory_has_alias__string)SVM_FUNCTION SVM_Boolean svm_memory_has_alias__string(const void *svm, const SVM_Kernel kernel, const SVM_String alias):385231_(svm_memory_pointer_has_alias)SVM_FUNCTION SVM_Boolean svm_memory_pointer_has_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):306771_(svm_parameter_type_is_keyword)SVM_FUNCTION SVM_Boolean svm_parameter_type_is_keyword(const void *svm, const SVM_Parameter parameter):264241_(svm_parameter_type_is_marker)SVM_FUNCTION SVM_Boolean svm_parameter_type_is_marker(const void *svm, const SVM_Parameter parameter):479491_(svm_parameter_type_is_structure)SVM_FUNCTION SVM_Boolean svm_parameter_type_is_structure(const void *svm, const SVM_Parameter parameter):547741_(svm_parameter_type_is_value)SVM_FUNCTION SVM_Boolean svm_parameter_type_is_value(const void *svm, const SVM_Parameter parameter):540481_(svm_parameter_type_is_variable)SVM_FUNCTION SVM_Boolean svm_parameter_type_is_variable(const void *svm, const SVM_Parameter parameter):298741_(svm_plugin_has_argument)SVM_FUNCTION SVM_Boolean svm_plugin_has_argument(const void *svm, const SVM_Value_PluginEntryPoint argument):477671_(svm_plugin_has_arguments)SVM_FUNCTION SVM_Boolean svm_plugin_has_arguments(const void *svm, const SVM_Value_PluginEntryPoint arguments):152801_(svm_plugin_has_function)SVM_FUNCTION SVM_Boolean svm_plugin_has_function(const void *svm, const SVM_Value_PluginEntryPoint function, const SVM_Size argc, const SVM_Parameter argv[], SVM_Parameter result):588781_(svm_plugin_has_instruction)SVM_FUNCTION SVM_Boolean svm_plugin_has_instruction(const void *svm, const SVM_Value_PluginEntryPoint instruction, const SVM_Size argc, const SVM_Parameter argv[], SVM_Parameter result):486351_(svm_plugin_has_interruption)SVM_FUNCTION SVM_Boolean svm_plugin_has_interruption(const void *svm, const SVM_Value_PluginEntryPoint interruption):187781_(svm_plugin_has_option)SVM_FUNCTION SVM_Boolean svm_plugin_has_option(const void *svm, const SVM_Value_PluginEntryPoint option):446911_(svm_plugin_has_scheduler)SVM_FUNCTION SVM_Boolean svm_plugin_has_scheduler(const void *svm, const SVM_Value_PluginEntryPoint scheduler):313781_(svm_plugin_has_sequencer)SVM_FUNCTION SVM_Boolean svm_plugin_has_sequencer(const void *svm, const SVM_Value_PluginEntryPoint sequencer):562091_(svm_plugin_has_structure)SVM_FUNCTION SVM_Boolean svm_plugin_has_structure(const void *svm, const SVM_Value_PluginEntryPoint structure):378861_(svm_plugin_has_type)SVM_FUNCTION SVM_Boolean svm_plugin_has_type(const void *svm, const SVM_Value_PluginEntryPoint type):105311_(svm_process_has_scheduler)SVM_FUNCTION SVM_Boolean svm_process_has_scheduler(const void *svm, const SVM_Process process):402121_(svm_process_kernel_attach)SVM_FUNCTION SVM_Boolean svm_process_kernel_attach(const void *svm, SVM_Process process, const SVM_Kernel kernel, const SVM_Size argc, SVM_Parameter argv[]):125641_(svm_process_kernel_detach)SVM_FUNCTION SVM_Boolean svm_process_kernel_detach(const void *svm, SVM_Process process, const SVM_Kernel kernel, const SVM_Size argc, SVM_Parameter argv[]):397061_(svm_process_ownership_check)SVM_FUNCTION SVM_Boolean svm_process_ownership_check(const void *svm, const SVM_Process process):448281_(svm_process_ownership_get_local)SVM_FUNCTION SVM_Boolean svm_process_ownership_get_local(const void *svm, const SVM_Process process):087821_(svm_processor_has_flag)SVM_FUNCTION SVM_Boolean svm_processor_has_flag(const void *svm, const SVM_Kernel kernel, const SVM_Value_String flag):024391_(svm_processor_has_flag__raw)SVM_FUNCTION SVM_Boolean svm_processor_has_flag__raw(const void *svm, const SVM_Kernel kernel, const char *flag):034781_(svm_processor_has_flag__string)SVM_FUNCTION SVM_Boolean svm_processor_has_flag__string(const void *svm, const SVM_Kernel kernel, const SVM_String flag):050511_(svm_processor_instructionoverride_has_global)SVM_FUNCTION SVM_Boolean svm_processor_instructionoverride_has_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol symbol, const SVM_Object_Level level):161321_(svm_processor_instructionoverride_has_local)SVM_FUNCTION SVM_Boolean svm_processor_instructionoverride_has_local(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Object_Level level):236081_(svm_processor_interruptionhandler_has)SVM_FUNCTION SVM_Boolean svm_processor_interruptionhandler_has(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption, const SVM_Object_Level level):421551_(svm_processor_is_hardwareinterrupted)SVM_FUNCTION SVM_Boolean svm_processor_is_hardwareinterrupted(const void *svm, const SVM_Kernel kernel):420091_(svm_scheduler_process_attach)SVM_FUNCTION SVM_Boolean svm_scheduler_process_attach(const void *svm, const SVM_Scheduler scheduler, const SVM_Process process, const SVM_Value_Integer parameter):260051_(svm_scheduler_process_attach__raw)SVM_FUNCTION SVM_Boolean svm_scheduler_process_attach__raw(const void *svm, const SVM_Scheduler scheduler, const SVM_Process process, const unsigned long int parameter):143611_(svm_scheduler_process_detach)SVM_FUNCTION SVM_Boolean svm_scheduler_process_detach(const void *svm, const SVM_Scheduler scheduler, const SVM_Process process, const SVM_Value_Integer parameter):251411_(svm_scheduler_process_detach__raw)SVM_FUNCTION SVM_Boolean svm_scheduler_process_detach__raw(const void *svm, const SVM_Scheduler scheduler, const SVM_Process process, const unsigned long int parameter):430191_(svm_string_is_equal)SVM_FUNCTION SVM_Boolean svm_string_is_equal(const void *svm, const SVM_String left, const SVM_String right):448291_(svm_string_is_equal__buffer)SVM_FUNCTION SVM_Boolean svm_string_is_equal__buffer(const void *svm, const SVM_String left, const char *buffer, const SVM_Size size):629001_(svm_string_is_equal__raw)SVM_FUNCTION SVM_Boolean svm_string_is_equal__raw(const void *svm, const SVM_String left, const char *right):430271_(svm_type_equal_external)SVM_FUNCTION SVM_Boolean svm_type_equal_external(const void *svm, const SVM_Type type, const SVM_Value_PluginEntryPoint external):389311_(svm_type_equal_internal)SVM_FUNCTION SVM_Boolean svm_type_equal_internal(const void *svm, const SVM_Type type, const SVM_Type_Internal internal):336501_(svm_type_is_external)SVM_FUNCTION SVM_Boolean svm_type_is_external(const void *svm, const SVM_Type type):295541_(svm_type_is_internal)SVM_FUNCTION SVM_Boolean svm_type_is_internal(const void *svm, const SVM_Type type):651581_(svm_value_boolean_get)SVM_FUNCTION SVM_Boolean svm_value_boolean_get(const void *svm, const SVM_Value_Boolean boolean):545691_(svm_value_interruption_is_external)SVM_FUNCTION SVM_Boolean svm_value_interruption_is_external(const void *svm, const SVM_Value_Interruption interruption):504731_(svm_value_interruption_is_internal)SVM_FUNCTION SVM_Boolean svm_value_interruption_is_internal(const void *svm, const SVM_Value_Interruption interruption):020391_(svm_value_is_equal)SVM_FUNCTION SVM_Boolean svm_value_is_equal(const void *svm, const SVM_Value left, const SVM_Value right):391071_(svm_value_state_is_constant)SVM_FUNCTION SVM_Boolean svm_value_state_is_constant(const void *svm, const SVM_Value value):258601_(svm_value_state_is_movable)SVM_FUNCTION SVM_Boolean svm_value_state_is_movable(const void *svm, const SVM_Value value):627381_(svm_value_state_is_null)SVM_FUNCTION SVM_Boolean svm_value_state_is_null(const void *svm, const SVM_Value value):422341_(svm_value_state_set_movable)SVM_FUNCTION SVM_Boolean svm_value_state_set_movable(const void *svm, const SVM_Value value):271281_(svm_value_type_is_boolean)SVM_FUNCTION SVM_Boolean svm_value_type_is_boolean(const void *svm, const SVM_Value value):276431_(svm_value_type_is_integer)SVM_FUNCTION SVM_Boolean svm_value_type_is_integer(const void *svm, const SVM_Value value):237641_(svm_value_type_is_interruption)SVM_FUNCTION SVM_Boolean svm_value_type_is_interruption(const void *svm, const SVM_Value value):404491_(svm_value_type_is_library)SVM_FUNCTION SVM_Boolean svm_value_type_is_library(const void *svm, const SVM_Value value):131841_(svm_value_type_is_plugin)SVM_FUNCTION SVM_Boolean svm_value_type_is_plugin(const void *svm, const SVM_Value value, const SVM_Value_PluginEntryPoint type):313031_(svm_value_type_is_pluginentrypoint)SVM_FUNCTION SVM_Boolean svm_value_type_is_pluginentrypoint(const void *svm, const SVM_Value value):220131_(svm_value_type_is_pointer)SVM_FUNCTION SVM_Boolean svm_value_type_is_pointer(const void *svm, const SVM_Value value):203501_(svm_value_type_is_string)SVM_FUNCTION SVM_Boolean svm_value_type_is_string(const void *svm, const SVM_Value value):019201_(svm_value_type_is_symbol)SVM_FUNCTION SVM_Boolean svm_value_type_is_symbol(const void *svm, const SVM_Value value):015811_(svm_variable_is_valid)SVM_FUNCTION SVM_Boolean svm_variable_is_valid(const void *svm, const SVM_Variable variable):319211_(svm_variable_scope_is_global)SVM_FUNCTION SVM_Boolean svm_variable_scope_is_global(const void *svm, const SVM_Variable variable):043371_(svm_variable_scope_is_local)SVM_FUNCTION SVM_Boolean svm_variable_scope_is_local(const void *svm, const SVM_Variable variable):442071_(svm_variable_scope_is_shared)SVM_FUNCTION SVM_Boolean svm_variable_scope_is_shared(const void *svm, const SVM_Variable variable):550101_(svm_variable_type_is_accesscontrol)SVM_FUNCTION SVM_Boolean svm_variable_type_is_accesscontrol(const void *svm, const SVM_Variable variable):465871_(svm_variable_type_is_code)SVM_FUNCTION SVM_Boolean svm_variable_type_is_code(const void *svm, const SVM_Variable variable):589541_(svm_variable_type_is_eventqueue)SVM_FUNCTION SVM_Boolean svm_variable_type_is_eventqueue(const void *svm, const SVM_Variable variable):625331_(svm_variable_type_is_eventqueueaddress)SVM_FUNCTION SVM_Boolean svm_variable_type_is_eventqueueaddress(const void *svm, const SVM_Variable variable):322151_(svm_variable_type_is_kernel)SVM_FUNCTION SVM_Boolean svm_variable_type_is_kernel(const void *svm, const SVM_Variable variable):015351_(svm_variable_type_is_lock)SVM_FUNCTION SVM_Boolean svm_variable_type_is_lock(const void *svm, const SVM_Variable variable):198251_(svm_variable_type_is_lockguardread)SVM_FUNCTION SVM_Boolean svm_variable_type_is_lockguardread(const void *svm, const SVM_Variable variable):079261_(svm_variable_type_is_lockguardwrite)SVM_FUNCTION SVM_Boolean svm_variable_type_is_lockguardwrite(const void *svm, const SVM_Variable variable):618981_(svm_variable_type_is_memoryzone)SVM_FUNCTION SVM_Boolean svm_variable_type_is_memoryzone(const void *svm, const SVM_Variable variable):027241_(svm_variable_type_is_parameter)SVM_FUNCTION SVM_Boolean svm_variable_type_is_parameter(const void *svm, const SVM_Variable variable):299951_(svm_variable_type_is_process)SVM_FUNCTION SVM_Boolean svm_variable_type_is_process(const void *svm, const SVM_Variable variable):634221_(svm_variable_type_is_processlock)SVM_FUNCTION SVM_Boolean svm_variable_type_is_processlock(const void *svm, const SVM_Variable variable):496991_(svm_variable_type_is_scheduler)SVM_FUNCTION SVM_Boolean svm_variable_type_is_scheduler(const void *svm, const SVM_Variable variable):612171_(svm_variable_type_is_structure)SVM_FUNCTION SVM_Boolean svm_variable_type_is_structure(const void *svm, const SVM_Variable variable):049221_(svm_variable_type_is_value)SVM_FUNCTION SVM_Boolean svm_variable_type_is_value(const void *svm, const SVM_Variable variable):517521_(svm_code_new)SVM_FUNCTION SVM_Code svm_code_new(const void *svm, const SVM_Value_String name, const SVM_Value_String source):570291_(svm_code_new__raw)SVM_FUNCTION SVM_Code svm_code_new__raw(const void *svm, const char *name, const char *source):594531_(svm_code_new__string)SVM_FUNCTION SVM_Code svm_code_new__string(const void *svm, const SVM_String name, const SVM_String source):205221_(svm_processor_get_currentcode)SVM_FUNCTION SVM_Code svm_processor_get_currentcode(const void *svm, const SVM_Kernel kernel):299461_(svm_value_library_get_code)SVM_FUNCTION SVM_Code svm_value_library_get_code(const void *svm, const SVM_Value_Library library):625701_(svm_value_symbol_get_code)SVM_FUNCTION SVM_Code svm_value_symbol_get_code(const void *svm, const SVM_Value_Symbol symbol):543651_(svm_type_compare)SVM_FUNCTION SVM_Comparison_Result svm_type_compare(const void *svm, const SVM_Type left, const SVM_Type right):213681_(svm_value_compare)SVM_FUNCTION SVM_Comparison_Result svm_value_compare(const void *svm, const SVM_Value left, const SVM_Value right):022281_(svm_debug_form_new)SVM_FUNCTION SVM_Debug_Form svm_debug_form_new(const void *svm, const char *title):306281_(svm_event_queue_new)SVM_FUNCTION SVM_Event_Queue svm_event_queue_new(const void *svm):195881_(svm_event_address_new)SVM_FUNCTION SVM_Event_Queue_Address svm_event_address_new(const void *svm):407211_(svm_event_address_new_struct)SVM_FUNCTION SVM_Event_Queue_Address svm_event_address_new_struct(const void *svm, const SVM_Structure structure):420991_(svm_memory_zone_find_memory_zone)SVM_FUNCTION SVM_Index svm_memory_zone_find_memory_zone(const void *svm, SVM_Memory_Zone zone, const SVM_Index index, const SVM_Memory_Zone find):631311_(svm_parameter_marker_find)SVM_FUNCTION SVM_Index svm_parameter_marker_find(const void *svm, const SVM_Size argc, const SVM_Parameter argv[], const SVM_Index start, const SVM_String marker):307611_(svm_parameter_marker_find__raw)SVM_FUNCTION SVM_Index svm_parameter_marker_find__raw(const void *svm, const SVM_Size argc, const SVM_Parameter argv[], const SVM_Index start, const char *marker):121381_(svm_parameter_marker_find_closing)SVM_FUNCTION SVM_Index svm_parameter_marker_find_closing(const void *svm, const SVM_Size argc, const SVM_Parameter argv[], const SVM_Index opening):407591_(svm_parameter_marker_find_separator)SVM_FUNCTION SVM_Index svm_parameter_marker_find_separator(const void *svm, const SVM_Size argc, const SVM_Parameter argv[], const SVM_Index start):044311_(svm_processor_returnstack_find_flag)SVM_FUNCTION SVM_Index svm_processor_returnstack_find_flag(const void *svm, const SVM_Kernel kernel, const SVM_Value_String flag, const SVM_Index start):043511_(svm_processor_returnstack_find_flag__raw)SVM_FUNCTION SVM_Index svm_processor_returnstack_find_flag__raw(const void *svm, const SVM_Kernel kernel, const char *flag, const SVM_Index start):037171_(svm_processor_returnstack_find_flag__string)SVM_FUNCTION SVM_Index svm_processor_returnstack_find_flag__string(const void *svm, const SVM_Kernel kernel, const SVM_String flag, const SVM_Index start):502221_(svm_value_interruption_get_internal)SVM_FUNCTION SVM_Interruption_Internal svm_value_interruption_get_internal(const void *svm, const SVM_Value_Interruption interruption):481611_(svm_value_interruption_get_kind)SVM_FUNCTION SVM_Interruption_Kind svm_value_interruption_get_kind(const void *svm, const SVM_Value_Interruption interruption):415211_(svm_kernel_get_current)SVM_FUNCTION SVM_Kernel svm_kernel_get_current(const void *svm):248751_(svm_kernel_new_code)SVM_FUNCTION SVM_Kernel svm_kernel_new_code(const void *svm, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control, const SVM_Code code):554601_(svm_kernel_new_symbol)SVM_FUNCTION SVM_Kernel svm_kernel_new_symbol(const void *svm, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control, const SVM_Value_Symbol symbol):215991_(svm_process_kernel_get_current)SVM_FUNCTION SVM_Kernel svm_process_kernel_get_current(const void *svm, const SVM_Process process):223531_(svm_kernel_get_state)SVM_FUNCTION SVM_Kernel_State svm_kernel_get_state(const void* svm, const SVM_Kernel kernel):653201_(svm_lock_new)SVM_FUNCTION SVM_Lock svm_lock_new(const void *svm):412401_(svm_lock_readguard_new)SVM_FUNCTION SVM_LockGuard_Read svm_lock_readguard_new(const void *svm, const SVM_Lock lock, const SVM_Boolean soft):528041_(svm_lock_writeguard_new)SVM_FUNCTION SVM_LockGuard_Write svm_lock_writeguard_new(const void *svm, const SVM_Lock lock, const SVM_Boolean soft):264951_(svm_memory_pointer_get_zone)SVM_FUNCTION SVM_Memory_Zone svm_memory_pointer_get_zone(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):351361_(svm_memory_zone_copy)SVM_FUNCTION SVM_Memory_Zone svm_memory_zone_copy(const void *svm, const SVM_Memory_Zone zone):291841_(svm_memory_zone_new)SVM_FUNCTION SVM_Memory_Zone svm_memory_zone_new(const void *svm):457951_(svm_parameter_keyword_new)SVM_FUNCTION SVM_Parameter svm_parameter_keyword_new(const void *svm, const SVM_String keyword):466031_(svm_parameter_keyword_new__raw)SVM_FUNCTION SVM_Parameter svm_parameter_keyword_new__raw(const void *svm, const char *keyword):278541_(svm_parameter_marker_new)SVM_FUNCTION SVM_Parameter svm_parameter_marker_new(const void *svm, const SVM_String marker):030351_(svm_parameter_marker_new__raw)SVM_FUNCTION SVM_Parameter svm_parameter_marker_new__raw(const void *svm, const char *marker):529631_(svm_parameter_structure_new)SVM_FUNCTION SVM_Parameter svm_parameter_structure_new(const void *svm, const SVM_Structure structure):270431_(svm_parameter_value_new)SVM_FUNCTION SVM_Parameter svm_parameter_value_new(const void *svm, const SVM_Value value):089901_(svm_parameter_variable_new)SVM_FUNCTION SVM_Parameter svm_parameter_variable_new(const void *svm, const SVM_Variable variable):522591_(svm_parameter_array_new)SVM_FUNCTION SVM_Parameter* svm_parameter_array_new(const void *svm, const SVM_Size argc):266731_(svm_kernel_get_process)SVM_FUNCTION SVM_Process svm_kernel_get_process(const void *svm, const SVM_Kernel kernel):195931_(svm_process_get_current)SVM_FUNCTION SVM_Process svm_process_get_current(const void *svm):285591_(svm_process_new)SVM_FUNCTION SVM_Process svm_process_new(const void *svm, const SVM_Value_String name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Kernel kernel):051051_(svm_process_new__raw)SVM_FUNCTION SVM_Process svm_process_new__raw(const void *svm, const char *name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Kernel kernel):201951_(svm_process_new__string)SVM_FUNCTION SVM_Process svm_process_new__string(const void *svm, const SVM_String name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Kernel kernel):460561_(svm_process_new_code)SVM_FUNCTION SVM_Process svm_process_new_code(const void *svm, const SVM_Value_String name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Code code, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control):568511_(svm_process_new_code__raw)SVM_FUNCTION SVM_Process svm_process_new_code__raw(const void *svm, const char *name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Code code, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control):430471_(svm_process_new_code__string)SVM_FUNCTION SVM_Process svm_process_new_code__string(const void *svm, const SVM_String name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Code code, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control):116041_(svm_process_new_symbol)SVM_FUNCTION SVM_Process svm_process_new_symbol(const void *svm, const SVM_Value_String name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Value_Symbol symbol, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control):148151_(svm_process_new_symbol__raw)SVM_FUNCTION SVM_Process svm_process_new_symbol__raw(const void *svm, const char *name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Value_Symbol symbol, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control):050251_(svm_process_new_symbol__string)SVM_FUNCTION SVM_Process svm_process_new_symbol__string(const void *svm, const SVM_String name, const SVM_Value_PluginEntryPoint sequencer, const SVM_Boolean auto_terminated, const SVM_Value_Symbol symbol, const SVM_Boolean transmit_interruptions, const SVM_Boolean last_return_is_shutdown, const SVM_Boolean protected_mode, const SVM_AccessControl access_control):096691_(svm_process_ownership_lock)SVM_FUNCTION SVM_Process_Lock svm_process_ownership_lock(const void *svm, const SVM_Process process):513321_(svm_process_ownership_lock_critical)SVM_FUNCTION SVM_Process_Lock svm_process_ownership_lock_critical(const void *svm):001761_(svm_process_get_state)SVM_FUNCTION SVM_Process_State svm_process_get_state(const void *svm, const SVM_Process process):262441_(svm_scheduler_get)SVM_FUNCTION SVM_Scheduler svm_scheduler_get(const void *svm, const SVM_Value_PluginEntryPoint name):173761_(svm_scheduler_get_current)SVM_FUNCTION SVM_Scheduler svm_scheduler_get_current(const void *svm):112031_(svm_code_get_size)SVM_FUNCTION SVM_Size svm_code_get_size(const void *svm, const SVM_Code code):596491_(svm_memory_zone_get_size)SVM_FUNCTION SVM_Size svm_memory_zone_get_size(const void *svm, const SVM_Memory_Zone zone):110601_(svm_processor_returnstack_get_size)SVM_FUNCTION SVM_Size svm_processor_returnstack_get_size(const void *svm, const SVM_Kernel kernel):130201_(svm_value_pointer_get_size)SVM_FUNCTION SVM_Size svm_value_pointer_get_size(const void *svm, const SVM_Value_Pointer pointer):454911_(svm_plugin_has_function_details)SVM_FUNCTION SVM_Status_Boolean svm_plugin_has_function_details(const void *svm, const SVM_Value_PluginEntryPoint function, const SVM_Size argc, const SVM_Parameter argv[], SVM_Parameter result):398701_(svm_code_get_name)SVM_FUNCTION SVM_String svm_code_get_name(const void *svm, const SVM_Code code):028851_(svm_code_get_source)SVM_FUNCTION SVM_String svm_code_get_source(const void *svm, const SVM_Code code):306511_(svm_code_instruction_get_location)SVM_FUNCTION SVM_String svm_code_instruction_get_location(const void *svm, const SVM_Code code, const SVM_Address address):298851_(svm_code_instruction_get_text)SVM_FUNCTION SVM_String svm_code_instruction_get_text(const void *svm, const SVM_Code code, const SVM_Address address):212221_(svm_code_print)SVM_FUNCTION SVM_String svm_code_print(const void *svm, const SVM_Code code):261601_(svm_function_get_prototype)SVM_FUNCTION SVM_String svm_function_get_prototype(const void *svm, const SVM_Value_PluginEntryPoint name):279881_(svm_kernel_get_coredump)SVM_FUNCTION SVM_String svm_kernel_get_coredump(const void *svm, const SVM_Kernel kernel):261971_(svm_kernel_print)SVM_FUNCTION SVM_String svm_kernel_print(const void* svm, const SVM_Kernel kernel):456001_(svm_machine_config)SVM_FUNCTION SVM_String svm_machine_config(const void *svm, const char *key):155801_(svm_memory_zone_print)SVM_FUNCTION SVM_String svm_memory_zone_print(const void *svm, const SVM_Memory_Zone zone):212171_(svm_parameter_keyword_get)SVM_FUNCTION SVM_String svm_parameter_keyword_get(const void *svm, const SVM_Parameter parameter):032761_(svm_parameter_marker_get)SVM_FUNCTION SVM_String svm_parameter_marker_get(const void *svm, const SVM_Parameter parameter):278451_(svm_plugin_print)SVM_FUNCTION SVM_String svm_plugin_print(const void *svm):170241_(svm_process_get_coredump)SVM_FUNCTION SVM_String svm_process_get_coredump(const void *svm, const SVM_Process process):534811_(svm_process_get_name)SVM_FUNCTION SVM_String svm_process_get_name(const void *svm, const SVM_Process process):645751_(svm_process_print)SVM_FUNCTION SVM_String svm_process_print(const void *svm, const SVM_Process process):242191_(svm_process_sequencer_print)SVM_FUNCTION SVM_String svm_process_sequencer_print(const void *svm, const SVM_Process process):537571_(svm_scheduler_print)SVM_FUNCTION SVM_String svm_scheduler_print(const void *svm, const SVM_Scheduler scheduler):025401_(svm_string_join)SVM_FUNCTION SVM_String svm_string_join(const void *svm, const SVM_String first, const SVM_String second):367351_(svm_string_join__buffer)SVM_FUNCTION SVM_String svm_string_join__buffer(const void *svm, const SVM_String first, const char *second, const SVM_Size size):636831_(svm_string_join__raw)SVM_FUNCTION SVM_String svm_string_join__raw(const void *svm, const SVM_String first, const char *second):049651_(svm_string_new)SVM_FUNCTION SVM_String svm_string_new(const void *svm, const char *buffer, const SVM_Size size):021851_(svm_string_new__buffer)SVM_FUNCTION SVM_String svm_string_new__buffer(const void *svm, const SVM_Size size):494231_(svm_string_new__raw)SVM_FUNCTION SVM_String svm_string_new__raw(const void *svm, const char *string):266621_(svm_type_print)SVM_FUNCTION SVM_String svm_type_print(const void *svm, const SVM_Type type):259061_(svm_value_interruption_get_location)SVM_FUNCTION SVM_String svm_value_interruption_get_location(const void *svm, const SVM_Value_Interruption interruption):255741_(svm_value_interruption_get_message)SVM_FUNCTION SVM_String svm_value_interruption_get_message(const void *svm, const SVM_Value_Interruption interruption):151171_(svm_value_pluginentrypoint_get_entry)SVM_FUNCTION SVM_String svm_value_pluginentrypoint_get_entry(const void *svm, const SVM_Value_PluginEntryPoint pep):270691_(svm_value_pluginentrypoint_get_plugin)SVM_FUNCTION SVM_String svm_value_pluginentrypoint_get_plugin(const void *svm, const SVM_Value_PluginEntryPoint pep):257441_(svm_value_print)SVM_FUNCTION SVM_String svm_value_print(const void *svm, const SVM_Value value):256871_(svm_value_string_get)SVM_FUNCTION SVM_String svm_value_string_get(const void *svm, const SVM_Value_String string):053031_(svm_value_symbol_get_location)SVM_FUNCTION SVM_String svm_value_symbol_get_location(const void *svm, const SVM_Value_Symbol symbol):064271_(svm_value_type_print)SVM_FUNCTION SVM_String svm_value_type_print(const void *svm, const SVM_Value value):395051_(svm_event_address_get_struct)SVM_FUNCTION SVM_Structure svm_event_address_get_struct(const void *svm, const SVM_Event_Queue_Address address):283851_(svm_parameter_structure_get)SVM_FUNCTION SVM_Structure svm_parameter_structure_get(const void *svm, const SVM_Parameter parameter):422191_(svm_structure_copy)SVM_FUNCTION SVM_Structure svm_structure_copy(const void *svm, const SVM_Structure structure):433501_(svm_structure_new)SVM_FUNCTION SVM_Structure svm_structure_new(const void *svm, const SVM_Value_PluginEntryPoint type, void *value):567651_(svm_structure_new_null)SVM_FUNCTION SVM_Structure svm_structure_new_null(const void *svm, const SVM_Value_PluginEntryPoint type):513191_(svm_memory_address_get_type)SVM_FUNCTION SVM_Type svm_memory_address_get_type(const void *svm, const SVM_Kernel kernel, const SVM_Address address):309771_(svm_memory_zone_get_type)SVM_FUNCTION SVM_Type svm_memory_zone_get_type(const void *svm, const SVM_Memory_Zone zone, const SVM_Index index):573001_(svm_type_copy)SVM_FUNCTION SVM_Type svm_type_copy(const void *svm, const SVM_Type type):113951_(svm_type_new_external)SVM_FUNCTION SVM_Type svm_type_new_external(const void *svm, const SVM_Value_PluginEntryPoint external):072991_(svm_type_new_internal)SVM_FUNCTION SVM_Type svm_type_new_internal(const void *svm, const SVM_Type_Internal internal):335291_(svm_value_type_get)SVM_FUNCTION SVM_Type svm_value_type_get(const void *svm, const SVM_Value value):069951_(svm_type_get_internal)SVM_FUNCTION SVM_Type_Internal svm_type_get_internal(const void *svm, const SVM_Type type):197991_(svm_memory_extract_address)SVM_FUNCTION SVM_Value svm_memory_extract_address(const void *svm, const SVM_Kernel kernel, const SVM_Address address):440501_(svm_memory_read_address)SVM_FUNCTION SVM_Value svm_memory_read_address(const void *svm, const SVM_Kernel kernel, const SVM_Address address):076341_(svm_memory_read_address_type)SVM_FUNCTION SVM_Value svm_memory_read_address_type(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Type type):330261_(svm_memory_read_address_type_external)SVM_FUNCTION SVM_Value svm_memory_read_address_type_external(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Value_PluginEntryPoint type):289301_(svm_memory_read_address_type_internal)SVM_FUNCTION SVM_Value svm_memory_read_address_type_internal(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Type_Internal type):024651_(svm_parameter_value_get)SVM_FUNCTION SVM_Value svm_parameter_value_get(const void *svm, const SVM_Parameter parameter):300501_(svm_plugin_get_argument)SVM_FUNCTION SVM_Value svm_plugin_get_argument(const void *svm, const SVM_Value_PluginEntryPoint argument):194821_(svm_plugin_get_option)SVM_FUNCTION SVM_Value svm_plugin_get_option(const void *svm, const SVM_Value_PluginEntryPoint option):554641_(svm_value_copy)SVM_FUNCTION SVM_Value svm_value_copy(const void *svm, const SVM_Value value):104951_(svm_debug_form_request)SVM_FUNCTION SVM_Value* svm_debug_form_request(const void *svm, const SVM_Debug_Form form):244051_(svm_memory_extract_pointer)SVM_FUNCTION SVM_Value* svm_memory_extract_pointer(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):172631_(svm_memory_extract_pointer__raw)SVM_FUNCTION SVM_Value* svm_memory_extract_pointer__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size):486561_(svm_memory_read_pointer)SVM_FUNCTION SVM_Value* svm_memory_read_pointer(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):077811_(svm_memory_read_pointer__raw)SVM_FUNCTION SVM_Value* svm_memory_read_pointer__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size):036821_(svm_memory_read_pointer_type)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_type(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer, const SVM_Type type):432391_(svm_memory_read_pointer_type__raw)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_type__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size, const SVM_Type type):514501_(svm_memory_read_pointer_type_external)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_type_external(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer, const SVM_Value_PluginEntryPoint type):283481_(svm_memory_read_pointer_type_external__raw)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_type_external__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size, const SVM_Value_PluginEntryPoint type):473541_(svm_memory_read_pointer_type_internal)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_type_internal(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer, const SVM_Type_Internal type):282201_(svm_memory_read_pointer_type_internal__raw)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_type_internal__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size, const SVM_Type_Internal type):446401_(svm_memory_read_pointer_zone)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_zone(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer, const SVM_Memory_Zone zone):404231_(svm_memory_read_pointer_zone__raw)SVM_FUNCTION SVM_Value* svm_memory_read_pointer_zone__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size, const SVM_Memory_Zone zone):478551_(svm_plugin_get_arguments)SVM_FUNCTION SVM_Value* svm_plugin_get_arguments(const void *svm, const SVM_Value_PluginEntryPoint arguments):545861_(svm_value_array_new)SVM_FUNCTION SVM_Value* svm_value_array_new(const void *svm, SVM_Size size):533121_(svm_value_automatic_new_null)SVM_FUNCTION SVM_Value_Automatic svm_value_automatic_new_null(const void *svm):242011_(svm_value_boolean_new)SVM_FUNCTION SVM_Value_Boolean svm_value_boolean_new(const void *svm, const SVM_Boolean boolean):582161_(svm_value_boolean_new__raw)SVM_FUNCTION SVM_Value_Boolean svm_value_boolean_new__raw(const void *svm, const int boolean):295431_(svm_value_boolean_new_null)SVM_FUNCTION SVM_Value_Boolean svm_value_boolean_new_null(const void *svm):365211_(svm_value_integer_new)SVM_FUNCTION SVM_Value_Integer svm_value_integer_new(const void *svm, const long int integer):299281_(svm_value_integer_new_null)SVM_FUNCTION SVM_Value_Integer svm_value_integer_new_null(const void *svm):614451_(svm_kernel_get_interruption)SVM_FUNCTION SVM_Value_Interruption svm_kernel_get_interruption(const void* svm, const SVM_Kernel kernel):443761_(svm_process_get_interruption)SVM_FUNCTION SVM_Value_Interruption svm_process_get_interruption(const void* svm, const SVM_Process process):611911_(svm_processor_get_currentinterruption)SVM_FUNCTION SVM_Value_Interruption svm_processor_get_currentinterruption(const void *svm, const SVM_Kernel kernel):546221_(svm_value_interruption_new_external)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_external(const void *svm, const SVM_Value_PluginEntryPoint name, const SVM_Value_String message):366391_(svm_value_interruption_new_external__raw)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_external__raw(const void *svm, const SVM_Value_PluginEntryPoint name, const char *message):077531_(svm_value_interruption_new_external__string)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_external__string(const void *svm, const SVM_Value_PluginEntryPoint name, const SVM_String message):505261_(svm_value_interruption_new_internal)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_internal(const void *svm, const SVM_Interruption_Internal interruption, const SVM_Value_String message, const SVM_Interruption_Kind kind):365111_(svm_value_interruption_new_internal__raw)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_internal__raw(const void *svm, const SVM_Interruption_Internal interruption, const char *message, const SVM_Interruption_Kind kind):077371_(svm_value_interruption_new_internal__string)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_internal__string(const void *svm, const SVM_Interruption_Internal interruption, const SVM_String message, const SVM_Interruption_Kind kind):653181_(svm_value_interruption_new_null)SVM_FUNCTION SVM_Value_Interruption svm_value_interruption_new_null(const void *svm):600621_(svm_machine_list_interruption)SVM_FUNCTION SVM_Value_Interruption* svm_machine_list_interruption(const void *svm):091831_(svm_processor_list_interruption)SVM_FUNCTION SVM_Value_Interruption* svm_processor_list_interruption(const void *svm, const SVM_Kernel kernel):618971_(svm_value_library_new)SVM_FUNCTION SVM_Value_Library svm_value_library_new(const void *svm, const SVM_Code code):307211_(svm_value_library_new_null)SVM_FUNCTION SVM_Value_Library svm_value_library_new_null(const void *svm):580091_(svm_value_plugin_new)SVM_FUNCTION SVM_Value_Plugin svm_value_plugin_new(const void *svm, const SVM_Value_PluginEntryPoint type, void *value):174121_(svm_value_plugin_new_const)SVM_FUNCTION SVM_Value_Plugin svm_value_plugin_new_const(const void *svm, const SVM_Value_PluginEntryPoint type, const SVM_Value_String value):477641_(svm_value_plugin_new_const__raw)SVM_FUNCTION SVM_Value_Plugin svm_value_plugin_new_const__raw(const void *svm, const SVM_Value_PluginEntryPoint type, const char *value):501031_(svm_value_plugin_new_const__string)SVM_FUNCTION SVM_Value_Plugin svm_value_plugin_new_const__string(const void *svm, const SVM_Value_PluginEntryPoint type, const SVM_String value):633671_(svm_value_plugin_new_null)SVM_FUNCTION SVM_Value_Plugin svm_value_plugin_new_null(const void *svm, const SVM_Value_PluginEntryPoint type):106191_(svm_process_get_scheduler)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_process_get_scheduler(const void *svm, const SVM_Process process):628411_(svm_process_get_sequencer)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_process_get_sequencer(const void *svm, const SVM_Process process):109401_(svm_structure_get_type)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_structure_get_type(const void *svm, const SVM_Structure structure):110911_(svm_type_get_external)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_type_get_external(const void *svm, const SVM_Type type):543181_(svm_value_interruption_get_external)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_interruption_get_external(const void *svm, const SVM_Value_Interruption interruption):175421_(svm_value_plugin_get_type)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_plugin_get_type(const void *svm, const SVM_Value_Plugin plugin):010501_(svm_value_pluginentrypoint_new)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_pluginentrypoint_new(const void *svm, const SVM_Value_String plugin_name, const SVM_Value_String entry_name):267731_(svm_value_pluginentrypoint_new__raw)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_pluginentrypoint_new__raw(const void *svm, const char *plugin_name, const char *entry_name):556711_(svm_value_pluginentrypoint_new__string)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_pluginentrypoint_new__string(const void *svm, const SVM_String plugin_name, const SVM_String entry_name):636351_(svm_value_pluginentrypoint_new_null)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_pluginentrypoint_new_null(const void *svm):323851_(svm_value_pluginentrypoint_new_prefix)SVM_FUNCTION SVM_Value_PluginEntryPoint svm_value_pluginentrypoint_new_prefix(const void *svm, const SVM_Value_PluginEntryPoint pep, const char *prefix):236431_(svm_value_plugin_compare_convert)SVM_FUNCTION SVM_Value_Plugin_Comparison svm_value_plugin_compare_convert(const void *svm, const SVM_Comparison_Result compare):378791_(svm_memory_alias_get_pointer)SVM_FUNCTION SVM_Value_Pointer svm_memory_alias_get_pointer(const void *svm, const SVM_Kernel kernel, const SVM_Value_String alias):217801_(svm_memory_alias_get_pointer__raw)SVM_FUNCTION SVM_Value_Pointer svm_memory_alias_get_pointer__raw(const void *svm, const SVM_Kernel kernel, const char *alias):468551_(svm_memory_alias_get_pointer__string)SVM_FUNCTION SVM_Value_Pointer svm_memory_alias_get_pointer__string(const void *svm, const SVM_Kernel kernel, const SVM_String alias):642491_(svm_memory_allocate)SVM_FUNCTION SVM_Value_Pointer svm_memory_allocate(const void *svm, const SVM_Kernel kernel, const SVM_Memory_Zone zone):495241_(svm_memory_allocate_address)SVM_FUNCTION SVM_Value_Pointer svm_memory_allocate_address(const void *svm, const SVM_Kernel kernel, const SVM_Memory_Zone zone, const SVM_Address address):400471_(svm_processor_get_currentpointer)SVM_FUNCTION SVM_Value_Pointer svm_processor_get_currentpointer(const void *svm, const SVM_Kernel kernel):443611_(svm_value_pointer_new)SVM_FUNCTION SVM_Value_Pointer svm_value_pointer_new(const void *svm, const SVM_Value_Integer address, const SVM_Value_Integer size):588461_(svm_value_pointer_new__raw)SVM_FUNCTION SVM_Value_Pointer svm_value_pointer_new__raw(const void *svm, const SVM_Address address, const SVM_Size size):301731_(svm_value_pointer_new_null)SVM_FUNCTION SVM_Value_Pointer svm_value_pointer_new_null(const void *svm):236171_(svm_memory_pointer_list_accessible)SVM_FUNCTION SVM_Value_Pointer* svm_memory_pointer_list_accessible(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):502651_(svm_value_string_new)SVM_FUNCTION SVM_Value_String svm_value_string_new(const void *svm, const SVM_String string):648251_(svm_value_string_new__buffer)SVM_FUNCTION SVM_Value_String svm_value_string_new__buffer(const void *svm, const char *string, const SVM_Size size):262631_(svm_value_string_new__raw)SVM_FUNCTION SVM_Value_String svm_value_string_new__raw(const void *svm, const char *string):631251_(svm_value_string_new_null)SVM_FUNCTION SVM_Value_String svm_value_string_new_null(const void *svm):144781_(svm_code_label_list)SVM_FUNCTION SVM_Value_String* svm_code_label_list(const void *svm, const SVM_Code code):429801_(svm_code_symbol_list)SVM_FUNCTION SVM_Value_String* svm_code_symbol_list(const void *svm, const SVM_Code code):315261_(svm_memory_pointer_expand_alias)SVM_FUNCTION SVM_Value_String* svm_memory_pointer_expand_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):518321_(svm_memory_pointer_list_alias)SVM_FUNCTION SVM_Value_String* svm_memory_pointer_list_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):141751_(svm_processor_list_flag)SVM_FUNCTION SVM_Value_String* svm_processor_list_flag(const void *svm, const SVM_Kernel kernel):045211_(svm_code_symbol_get_address)SVM_FUNCTION SVM_Value_Symbol svm_code_symbol_get_address(const void *svm, const SVM_Code code, const SVM_Value_String label):576011_(svm_code_symbol_get_address__raw)SVM_FUNCTION SVM_Value_Symbol svm_code_symbol_get_address__raw(const void *svm, const SVM_Code code, const char *label):267571_(svm_code_symbol_get_address__string)SVM_FUNCTION SVM_Value_Symbol svm_code_symbol_get_address__string(const void *svm, const SVM_Code code, const SVM_String label):184551_(svm_processor_get_currentinstruction)SVM_FUNCTION SVM_Value_Symbol svm_processor_get_currentinstruction(const void *svm, const SVM_Kernel kernel):288251_(svm_processor_get_nextinstruction)SVM_FUNCTION SVM_Value_Symbol svm_processor_get_nextinstruction(const void *svm, const SVM_Kernel kernel):481851_(svm_processor_interruptionhandler_get)SVM_FUNCTION SVM_Value_Symbol svm_processor_interruptionhandler_get(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption, const SVM_Object_Level level):573051_(svm_value_symbol_new)SVM_FUNCTION SVM_Value_Symbol svm_value_symbol_new(const void *svm, const SVM_Code code, const SVM_Address symbol):633451_(svm_value_symbol_new_null)SVM_FUNCTION SVM_Value_Symbol svm_value_symbol_new_null(const void *svm):202371_(svm_code_compile)SVM_FUNCTION SVM_Variable svm_code_compile(const void *svm, const SVM_Value_String name, const SVM_Value_String source):007491_(svm_code_compile__raw)SVM_FUNCTION SVM_Variable svm_code_compile__raw(const void *svm, const char *name, const char *source):524181_(svm_code_compile__string)SVM_FUNCTION SVM_Variable svm_code_compile__string(const void *svm, const SVM_String name, const SVM_String source):136891_(svm_function_call)SVM_FUNCTION SVM_Variable svm_function_call(const void *svm, const SVM_Value_PluginEntryPoint name, const SVM_Size argc, SVM_Parameter argv[]):499471_(svm_parameter_variable_get)SVM_FUNCTION SVM_Variable svm_parameter_variable_get(const void *svm, const SVM_Parameter parameter):410471_(svm_variable_array_new)SVM_FUNCTION SVM_Variable* svm_variable_array_new(const void *svm, SVM_Size size):071321_(svm_api_get_signature)SVM_FUNCTION const char* svm_api_get_signature():119431_(svm_value_integer_get)SVM_FUNCTION long long int svm_value_integer_get(const void *svm, const SVM_Value_Integer integer):455921_(svm_accesscontrol_get_instructions)SVM_FUNCTION unsigned long int svm_accesscontrol_get_instructions(const void *svm, const SVM_AccessControl access_control):123041_(svm_accesscontrol_get_memory)SVM_FUNCTION unsigned long int svm_accesscontrol_get_memory(const void *svm, const SVM_AccessControl access_control):456041_(svm_accesscontrol_set_instructions)SVM_FUNCTION void svm_accesscontrol_set_instructions(const void *svm, SVM_AccessControl access_control, const unsigned long int instructions):130721_(svm_accesscontrol_set_memory)SVM_FUNCTION void svm_accesscontrol_set_memory(const void *svm, SVM_AccessControl access_control, const unsigned long int memory):456391_(svm_debug_break)SVM_FUNCTION void svm_debug_break(const void *svm, const SVM_Kernel kernel, const SVM_Value_String message):547901_(svm_debug_break__raw)SVM_FUNCTION void svm_debug_break__raw(const void *svm, const SVM_Kernel kernel, const char *message):018301_(svm_debug_break__string)SVM_FUNCTION void svm_debug_break__string(const void *svm, const SVM_Kernel kernel, const SVM_String message):653921_(svm_debug_breakpoint_add_break)SVM_FUNCTION void svm_debug_breakpoint_add_break(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol symbol):130941_(svm_debug_breakpoint_add_interruption)SVM_FUNCTION void svm_debug_breakpoint_add_interruption(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption):316231_(svm_debug_breakpoint_add_memoryaccess)SVM_FUNCTION void svm_debug_breakpoint_add_memoryaccess(const void *svm, const SVM_Kernel kernel, const SVM_Address address):401051_(svm_debug_breakpoint_add_memoryfree)SVM_FUNCTION void svm_debug_breakpoint_add_memoryfree(const void *svm, const SVM_Kernel kernel, const SVM_Address address):155271_(svm_debug_breakpoint_add_memoryread)SVM_FUNCTION void svm_debug_breakpoint_add_memoryread(const void *svm, const SVM_Kernel kernel, const SVM_Address address):057771_(svm_debug_breakpoint_add_memorywrite)SVM_FUNCTION void svm_debug_breakpoint_add_memorywrite(const void *svm, const SVM_Kernel kernel, const SVM_Address address):424651_(svm_debug_breakpoint_remove_break)SVM_FUNCTION void svm_debug_breakpoint_remove_break(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol symbol):052351_(svm_debug_breakpoint_remove_interruption)SVM_FUNCTION void svm_debug_breakpoint_remove_interruption(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption):237641_(svm_debug_breakpoint_remove_memoryaccess)SVM_FUNCTION void svm_debug_breakpoint_remove_memoryaccess(const void *svm, const SVM_Kernel kernel, const SVM_Address address):086691_(svm_debug_breakpoint_remove_memoryfree)SVM_FUNCTION void svm_debug_breakpoint_remove_memoryfree(const void *svm, const SVM_Kernel kernel, const SVM_Address address):496261_(svm_debug_breakpoint_remove_memoryread)SVM_FUNCTION void svm_debug_breakpoint_remove_memoryread(const void *svm, const SVM_Kernel kernel, const SVM_Address address):555941_(svm_debug_breakpoint_remove_memorywrite)SVM_FUNCTION void svm_debug_breakpoint_remove_memorywrite(const void *svm, const SVM_Kernel kernel, const SVM_Address address):303411_(svm_debug_form_append_checkbox)SVM_FUNCTION void svm_debug_form_append_checkbox(const void *svm, SVM_Debug_Form form, const char *label, const SVM_Value_Boolean default_value):502161_(svm_debug_form_append_checkbox__raw)SVM_FUNCTION void svm_debug_form_append_checkbox__raw(const void *svm, SVM_Debug_Form form, const char *label, const int default_value):267631_(svm_debug_form_append_integer)SVM_FUNCTION void svm_debug_form_append_integer(const void *svm, SVM_Debug_Form form, const char *label, const SVM_Value_Integer default_value, const long long int min_value, const long long int max_value):623921_(svm_debug_form_append_integer__raw)SVM_FUNCTION void svm_debug_form_append_integer__raw(const void *svm, SVM_Debug_Form form, const char *label, const long long int default_value, const long long int min_value, const long long int max_value):467161_(svm_debug_form_append_selection)SVM_FUNCTION void svm_debug_form_append_selection(const void *svm, SVM_Debug_Form form, const char *label, const SVM_Size size, const SVM_Value *values):185901_(svm_debug_form_append_string)SVM_FUNCTION void svm_debug_form_append_string(const void *svm, SVM_Debug_Form form, const char *label, const SVM_Value_String default_value, const SVM_Size min_size, const SVM_Size max_size):355131_(svm_debug_form_append_string__raw)SVM_FUNCTION void svm_debug_form_append_string__raw(const void *svm, SVM_Debug_Form form, const char *label, const char *default_value, const SVM_Size min_size, const SVM_Size max_size):239961_(svm_debug_form_append_string__string)SVM_FUNCTION void svm_debug_form_append_string__string(const void *svm, SVM_Debug_Form form, const char *label, const SVM_String default_value, const SVM_Size min_size, const SVM_Size max_size):207721_(svm_debug_form_append_text)SVM_FUNCTION void svm_debug_form_append_text(const void *svm, SVM_Debug_Form form, const char *label, const SVM_Size width, const SVM_Size height):085501_(svm_debug_notify)SVM_FUNCTION void svm_debug_notify(const void *svm, const SVM_Kernel kernel, const SVM_Value_String message):515831_(svm_debug_notify__raw)SVM_FUNCTION void svm_debug_notify__raw(const void *svm, const SVM_Kernel kernel, const char *message):096211_(svm_debug_notify__string)SVM_FUNCTION void svm_debug_notify__string(const void *svm, const SVM_Kernel kernel, const SVM_String message):316431_(svm_debug_synchronise)SVM_FUNCTION void svm_debug_synchronise(const void *svm, const SVM_Value value):054621_(svm_event_queue_broadcast)SVM_FUNCTION void svm_event_queue_broadcast(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address origin, const SVM_Structure event):481391_(svm_event_queue_join)SVM_FUNCTION void svm_event_queue_join(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address address):527971_(svm_event_queue_leave)SVM_FUNCTION void svm_event_queue_leave(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address address):235641_(svm_event_queue_push)SVM_FUNCTION void svm_event_queue_push(const void *svm, SVM_Event_Queue event_queue, const SVM_Event_Queue_Address destination, const SVM_Event_Queue_Address origin, const SVM_Structure event):611081_(svm_kernel_set_accesscontrol)SVM_FUNCTION void svm_kernel_set_accesscontrol(const void* svm, const SVM_Kernel kernel, const SVM_AccessControl access_control):644881_(svm_kernel_suspend)SVM_FUNCTION void svm_kernel_suspend(const void *svm, const SVM_Kernel kernel):367891_(svm_kernel_swap_memory)SVM_FUNCTION void svm_kernel_swap_memory(const void *svm, SVM_Kernel kernel1, SVM_Kernel kernel2):578081_(svm_kernel_terminate)SVM_FUNCTION void svm_kernel_terminate(const void *svm, const SVM_Kernel kernel):437491_(svm_machine_shutdown)SVM_FUNCTION void svm_machine_shutdown(const void *svm, const SVM_Value_Integer return_code):506351_(svm_machine_shutdown__raw)SVM_FUNCTION void svm_machine_shutdown__raw(const void *svm, const unsigned long int return_code):480761_(svm_machine_trace)SVM_FUNCTION void svm_machine_trace(const void *svm, const SVM_Value_String trace):651061_(svm_machine_trace__raw)SVM_FUNCTION void svm_machine_trace__raw(const void *svm, const char *trace):358871_(svm_machine_trace__string)SVM_FUNCTION void svm_machine_trace__string(const void *svm, const SVM_String trace):260411_(svm_memory_add_alias)SVM_FUNCTION void svm_memory_add_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_String alias, const SVM_Value_Pointer pointer):255061_(svm_memory_add_alias__raw)SVM_FUNCTION void svm_memory_add_alias__raw(const void *svm, const SVM_Kernel kernel, const char *alias, const SVM_Value_Pointer pointer):309371_(svm_memory_add_alias__string)SVM_FUNCTION void svm_memory_add_alias__string(const void *svm, const SVM_Kernel kernel, const SVM_String alias, const SVM_Value_Pointer pointer):543911_(svm_memory_address_set_type)SVM_FUNCTION void svm_memory_address_set_type(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Type type):124281_(svm_memory_address_shift)SVM_FUNCTION void svm_memory_address_shift(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Value_Integer shift):639921_(svm_memory_address_shift__raw)SVM_FUNCTION void svm_memory_address_shift__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, signed long int shift):104831_(svm_memory_copy)SVM_FUNCTION void svm_memory_copy(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer origin, const SVM_Kernel remote, const SVM_Value_Pointer target):637181_(svm_memory_free)SVM_FUNCTION void svm_memory_free(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):186671_(svm_memory_move)SVM_FUNCTION void svm_memory_move(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer origin, const SVM_Kernel remote, const SVM_Value_Pointer target):295671_(svm_memory_pointer_set_zone)SVM_FUNCTION void svm_memory_pointer_set_zone(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer, const SVM_Memory_Zone zone):183181_(svm_memory_remove_alias)SVM_FUNCTION void svm_memory_remove_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_String alias):027371_(svm_memory_remove_alias__raw)SVM_FUNCTION void svm_memory_remove_alias__raw(const void *svm, const SVM_Kernel kernel, const char *alias):198991_(svm_memory_remove_alias__string)SVM_FUNCTION void svm_memory_remove_alias__string(const void *svm, const SVM_Kernel kernel, const SVM_String alias):363841_(svm_memory_scope_set_global)SVM_FUNCTION void svm_memory_scope_set_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):324281_(svm_memory_scope_set_global_alias)SVM_FUNCTION void svm_memory_scope_set_global_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_String alias):646171_(svm_memory_scope_set_global_alias__raw)SVM_FUNCTION void svm_memory_scope_set_global_alias__raw(const void *svm, const SVM_Kernel kernel, const char *alias):276341_(svm_memory_scope_set_global_alias__string)SVM_FUNCTION void svm_memory_scope_set_global_alias__string(const void *svm, const SVM_Kernel kernel, const SVM_String alias):132631_(svm_memory_scope_set_local)SVM_FUNCTION void svm_memory_scope_set_local(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):146591_(svm_memory_scope_set_local_alias)SVM_FUNCTION void svm_memory_scope_set_local_alias(const void *svm, const SVM_Kernel kernel, const SVM_Value_String alias):456301_(svm_memory_scope_set_local_alias__raw)SVM_FUNCTION void svm_memory_scope_set_local_alias__raw(const void *svm, const SVM_Kernel kernel, const char *alias):006851_(svm_memory_scope_set_local_alias__string)SVM_FUNCTION void svm_memory_scope_set_local_alias__string(const void *svm, const SVM_Kernel kernel, const SVM_String alias):339651_(svm_memory_share)SVM_FUNCTION void svm_memory_share(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer origin, const SVM_Kernel remote, const SVM_Value_Pointer target):404811_(svm_memory_synchronisation_disable)SVM_FUNCTION void svm_memory_synchronisation_disable(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):265781_(svm_memory_synchronisation_enable)SVM_FUNCTION void svm_memory_synchronisation_enable(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):008231_(svm_memory_translate)SVM_FUNCTION void svm_memory_translate(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer zone, const SVM_Value_Pointer origin, const SVM_Value_Pointer target):305261_(svm_memory_write_address)SVM_FUNCTION void svm_memory_write_address(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Value value):351321_(svm_memory_write_pointer)SVM_FUNCTION void svm_memory_write_pointer(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer, const SVM_Value* values):319341_(svm_memory_write_pointer__raw)SVM_FUNCTION void svm_memory_write_pointer__raw(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Size size, const SVM_Value* values):416341_(svm_memory_zone_append)SVM_FUNCTION void svm_memory_zone_append(const void *svm, SVM_Memory_Zone zone, const SVM_Type type, const SVM_Value_Integer times):444251_(svm_memory_zone_append__raw)SVM_FUNCTION void svm_memory_zone_append__raw(const void *svm, SVM_Memory_Zone zone, const SVM_Type type, const SVM_Size times):597161_(svm_memory_zone_append_external)SVM_FUNCTION void svm_memory_zone_append_external(const void *svm, SVM_Memory_Zone zone, const SVM_Value_PluginEntryPoint type, const SVM_Value_Integer times):490861_(svm_memory_zone_append_external__raw)SVM_FUNCTION void svm_memory_zone_append_external__raw(const void *svm, SVM_Memory_Zone zone, const SVM_Value_PluginEntryPoint type, const SVM_Size times):556201_(svm_memory_zone_append_internal)SVM_FUNCTION void svm_memory_zone_append_internal(const void *svm, SVM_Memory_Zone zone, const SVM_Type_Internal type, const SVM_Value_Integer times):489581_(svm_memory_zone_append_internal__raw)SVM_FUNCTION void svm_memory_zone_append_internal__raw(const void *svm, SVM_Memory_Zone zone, const SVM_Type_Internal type, const SVM_Size times):154381_(svm_memory_zone_append_memory_zone)SVM_FUNCTION void svm_memory_zone_append_memory_zone(const void *svm, SVM_Memory_Zone zone, const SVM_Memory_Zone append):155861_(svm_memory_zone_insert_memory_zone)SVM_FUNCTION void svm_memory_zone_insert_memory_zone(const void *svm, SVM_Memory_Zone zone, const SVM_Index index, const SVM_Memory_Zone insert):646451_(svm_memory_zone_remove_memory_zone)SVM_FUNCTION void svm_memory_zone_remove_memory_zone(const void *svm, SVM_Memory_Zone zone, const SVM_Index index, const SVM_Size size):354811_(svm_memory_zone_replace_memory_zone)SVM_FUNCTION void svm_memory_zone_replace_memory_zone(const void *svm, SVM_Memory_Zone zone, const SVM_Index index, const SVM_Memory_Zone replace):204091_(svm_plugin_configure)SVM_FUNCTION void svm_plugin_configure(void *plugin_handler, const char *plugin_configuration, const char api_signature[], const char svm_version[]):641841_(svm_process_interrupt)SVM_FUNCTION void svm_process_interrupt(const void *svm, const SVM_Process process, const SVM_Value_Interruption interruption):155501_(svm_process_interruptionnotification_disable)SVM_FUNCTION void svm_process_interruptionnotification_disable(const void *svm, const SVM_Process process):422511_(svm_process_interruptionnotification_enable)SVM_FUNCTION void svm_process_interruptionnotification_enable(const void *svm, const SVM_Process process):375981_(svm_process_interruptionnotification_send)SVM_FUNCTION void svm_process_interruptionnotification_send(const void *svm, const SVM_Process process):048371_(svm_process_interruptionnotification_wait)SVM_FUNCTION void svm_process_interruptionnotification_wait(const void *svm):113221_(svm_process_pause)SVM_FUNCTION void svm_process_pause(const void *svm):569181_(svm_process_resume)SVM_FUNCTION void svm_process_resume(const void *svm):285591_(svm_process_run)SVM_FUNCTION void svm_process_run(const void *svm, const SVM_Process process, const SVM_Value_Integer delay):051051_(svm_process_run__raw)SVM_FUNCTION void svm_process_run__raw(const void *svm, const SVM_Process process, const unsigned long int delay):413151_(svm_process_suspend)SVM_FUNCTION void svm_process_suspend(const void *svm, const SVM_Process process):356311_(svm_process_terminate)SVM_FUNCTION void svm_process_terminate(const void *svm, const SVM_Process process):047491_(svm_processor_add_interruption)SVM_FUNCTION void svm_processor_add_interruption(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption):500611_(svm_processor_call_global)SVM_FUNCTION void svm_processor_call_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol function, const SVM_Value_Pointer parameters):383571_(svm_processor_call_identical)SVM_FUNCTION void svm_processor_call_identical(const void *svm, const SVM_Kernel kernel, const SVM_Boolean transfer):406171_(svm_processor_call_local)SVM_FUNCTION void svm_processor_call_local(const void *svm, const SVM_Kernel kernel, const SVM_Address function, const SVM_Value_Pointer parameters):604501_(svm_processor_clear_interruption)SVM_FUNCTION void svm_processor_clear_interruption(const void *svm, const SVM_Kernel kernel):340991_(svm_processor_current_raise_error)SVM_FUNCTION void svm_processor_current_raise_error(const void *svm, const SVM_Value_Interruption interruption):189461_(svm_processor_current_raise_error_external__raw)SVM_FUNCTION void svm_processor_current_raise_error_external__raw(const void *svm, const SVM_Value_PluginEntryPoint interruption, const char *message):188181_(svm_processor_current_raise_error_internal__raw)SVM_FUNCTION void svm_processor_current_raise_error_internal__raw(const void *svm, const SVM_Interruption_Internal interruption, const char *message):566421_(svm_processor_current_shutdown)SVM_FUNCTION void svm_processor_current_shutdown(const void *svm):263001_(svm_processor_current_sleep)SVM_FUNCTION void svm_processor_current_sleep(const void *svm, const SVM_Value_Integer seconds, const SVM_Value_Integer milliseconds, const SVM_Boolean soft):316581_(svm_processor_current_sleep__raw)SVM_FUNCTION void svm_processor_current_sleep__raw(const void *svm, const unsigned long int seconds, const unsigned long int milliseconds, const SVM_Boolean soft):091091_(svm_processor_hold_interruption)SVM_FUNCTION void svm_processor_hold_interruption(const void *svm, const SVM_Kernel kernel):195561_(svm_processor_instructionoverride_reset_global)SVM_FUNCTION void svm_processor_instructionoverride_reset_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol symbol, const SVM_Object_Level level):451421_(svm_processor_instructionoverride_reset_local)SVM_FUNCTION void svm_processor_instructionoverride_reset_local(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Object_Level level):065231_(svm_processor_instructionoverride_set_global)SVM_FUNCTION void svm_processor_instructionoverride_set_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol symbol, const SVM_Value_PluginEntryPoint name, const SVM_Size argc, const SVM_Parameter argv[], const SVM_Object_Level level):190761_(svm_processor_instructionoverride_set_local)SVM_FUNCTION void svm_processor_instructionoverride_set_local(const void *svm, const SVM_Kernel kernel, const SVM_Address address, const SVM_Value_PluginEntryPoint name, const SVM_Size argc, const SVM_Parameter argv[], const SVM_Object_Level level):264731_(svm_processor_interruptionhandler_reset)SVM_FUNCTION void svm_processor_interruptionhandler_reset(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption, const SVM_Object_Level level):360731_(svm_processor_interruptionhandler_set_global)SVM_FUNCTION void svm_processor_interruptionhandler_set_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption, const SVM_Value_Symbol symbol, const SVM_Object_Level level):126411_(svm_processor_interruptionhandler_set_local)SVM_FUNCTION void svm_processor_interruptionhandler_set_local(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption, const SVM_Address address, const SVM_Object_Level level):527171_(svm_processor_jump_global)SVM_FUNCTION void svm_processor_jump_global(const void *svm, const SVM_Kernel kernel, const SVM_Value_Symbol symbol):459291_(svm_processor_jump_local)SVM_FUNCTION void svm_processor_jump_local(const void *svm, const SVM_Kernel kernel, const SVM_Address address):456691_(svm_processor_release_interruption)SVM_FUNCTION void svm_processor_release_interruption(const void *svm, const SVM_Kernel kernel):392711_(svm_processor_reset_flag)SVM_FUNCTION void svm_processor_reset_flag(const void *svm, const SVM_Kernel kernel, const SVM_Value_String flag, const SVM_Object_Level level):545911_(svm_processor_reset_flag__raw)SVM_FUNCTION void svm_processor_reset_flag__raw(const void *svm, const SVM_Kernel kernel, const char *flag, const SVM_Object_Level level):099971_(svm_processor_reset_flag__string)SVM_FUNCTION void svm_processor_reset_flag__string(const void *svm, const SVM_Kernel kernel, const SVM_String flag, const SVM_Object_Level level):409461_(svm_processor_return)SVM_FUNCTION void svm_processor_return(const void *svm, const SVM_Kernel kernel):306281_(svm_processor_returnstack_move_level)SVM_FUNCTION void svm_processor_returnstack_move_level(const void *svm, const SVM_Kernel kernel, const SVM_Index start, const SVM_Index end, const SVM_Index target):322921_(svm_processor_returnstack_swap_level)SVM_FUNCTION void svm_processor_returnstack_swap_level(const void *svm, const SVM_Kernel kernel, const SVM_Index level):018001_(svm_processor_set_currentinterruption)SVM_FUNCTION void svm_processor_set_currentinterruption(const void *svm, const SVM_Kernel kernel, const SVM_Value_Interruption interruption):400501_(svm_processor_set_currentpointer)SVM_FUNCTION void svm_processor_set_currentpointer(const void *svm, const SVM_Kernel kernel, const SVM_Value_Pointer pointer):146701_(svm_processor_set_flag)SVM_FUNCTION void svm_processor_set_flag(const void *svm, const SVM_Kernel kernel, const SVM_Value_String flag, const SVM_Object_Level level):026231_(svm_processor_set_flag__raw)SVM_FUNCTION void svm_processor_set_flag__raw(const void *svm, const SVM_Kernel kernel, const char *flag, const SVM_Object_Level level):035011_(svm_processor_set_flag__string)SVM_FUNCTION void svm_processor_set_flag__string(const void *svm, const SVM_Kernel kernel, const SVM_String flag, const SVM_Object_Level level):556121_(svm_scheduler_notify)SVM_FUNCTION void svm_scheduler_notify(const void *svm, const SVM_Scheduler scheduler, const SVM_Value_Integer parameter):325741_(svm_scheduler_notify__raw)SVM_FUNCTION void svm_scheduler_notify__raw(const void *svm, const SVM_Scheduler scheduler, const unsigned long int parameter):323921_(svm_value_boolean_set)SVM_FUNCTION void svm_value_boolean_set(const void *svm, SVM_Value_Boolean value, const SVM_Boolean boolean):564241_(svm_value_boolean_set__raw)SVM_FUNCTION void svm_value_boolean_set__raw(const void *svm, SVM_Value_Boolean value, const int boolean):447121_(svm_value_integer_set)SVM_FUNCTION void svm_value_integer_set(const void *svm, SVM_Value_Integer value, const long long int integer):630971_(svm_value_interruption_set)SVM_FUNCTION void svm_value_interruption_set(const void *svm, SVM_Value_Interruption value, const SVM_Value_Interruption interruption):545101_(svm_value_interruption_set_external)SVM_FUNCTION void svm_value_interruption_set_external(const void *svm, SVM_Value_Interruption value, const SVM_Value_PluginEntryPoint name, const SVM_Value_String message):038681_(svm_value_interruption_set_external__raw)SVM_FUNCTION void svm_value_interruption_set_external__raw(const void *svm, SVM_Value_Interruption value, const SVM_Value_PluginEntryPoint name, const char *message):446161_(svm_value_interruption_set_external__string)SVM_FUNCTION void svm_value_interruption_set_external__string(const void *svm, SVM_Value_Interruption value, const SVM_Value_PluginEntryPoint name, const SVM_String message):504141_(svm_value_interruption_set_internal)SVM_FUNCTION void svm_value_interruption_set_internal(const void *svm, SVM_Value_Interruption value, const SVM_Interruption_Internal type, const SVM_Value_String message, const SVM_Interruption_Kind kind):037401_(svm_value_interruption_set_internal__raw)SVM_FUNCTION void svm_value_interruption_set_internal__raw(const void *svm, SVM_Value_Interruption value, const SVM_Interruption_Internal type, const char *message, const SVM_Interruption_Kind kind):446001_(svm_value_interruption_set_internal__string)SVM_FUNCTION void svm_value_interruption_set_internal__string(const void *svm, SVM_Value_Interruption value, const SVM_Interruption_Internal type, const SVM_String message, const SVM_Interruption_Kind kind):045531_(svm_value_library_set)SVM_FUNCTION void svm_value_library_set(const void *svm, SVM_Value_Library value, const SVM_Value_Library library):330181_(svm_value_library_set_code)SVM_FUNCTION void svm_value_library_set_code(const void *svm, SVM_Value_Library value, const SVM_Code code):006651_(svm_value_plugin_set)SVM_FUNCTION void svm_value_plugin_set(const void *svm, SVM_Value_Plugin value, const SVM_Value_Plugin plugin):543881_(svm_value_plugin_set_internal)SVM_FUNCTION void svm_value_plugin_set_internal(const void *svm, SVM_Value_Plugin value, const SVM_Value_PluginEntryPoint type, void *internal_value):092411_(svm_value_pluginentrypoint_set)SVM_FUNCTION void svm_value_pluginentrypoint_set(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_Value_PluginEntryPoint pluginentrypoint):166531_(svm_value_pluginentrypoint_set_entry)SVM_FUNCTION void svm_value_pluginentrypoint_set_entry(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_Value_String entry_name, const char *prefix):006371_(svm_value_pluginentrypoint_set_entry__raw)SVM_FUNCTION void svm_value_pluginentrypoint_set_entry__raw(const void *svm, SVM_Value_PluginEntryPoint value, const char *entry_name, const char *prefix):524041_(svm_value_pluginentrypoint_set_entry__string)SVM_FUNCTION void svm_value_pluginentrypoint_set_entry__string(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_String entry_name, const char *prefix):278371_(svm_value_pluginentrypoint_set_plugin)SVM_FUNCTION void svm_value_pluginentrypoint_set_plugin(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_Value_String plugin_name):337541_(svm_value_pluginentrypoint_set_plugin__raw)SVM_FUNCTION void svm_value_pluginentrypoint_set_plugin__raw(const void *svm, SVM_Value_PluginEntryPoint value, const char *plugin_name):319681_(svm_value_pluginentrypoint_set_plugin__string)SVM_FUNCTION void svm_value_pluginentrypoint_set_plugin__string(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_String plugin_name):091851_(svm_value_pluginentrypoint_set_pluginentry)SVM_FUNCTION void svm_value_pluginentrypoint_set_pluginentry(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_Value_String plugin_name, const SVM_Value_String entry_name, const char *prefix):413631_(svm_value_pluginentrypoint_set_pluginentry__raw)SVM_FUNCTION void svm_value_pluginentrypoint_set_pluginentry__raw(const void *svm, SVM_Value_PluginEntryPoint value, const char *plugin_name, const char *entry_name, const char *prefix):411111_(svm_value_pluginentrypoint_set_pluginentry__string)SVM_FUNCTION void svm_value_pluginentrypoint_set_pluginentry__string(const void *svm, SVM_Value_PluginEntryPoint value, const SVM_String plugin_name, const SVM_String entry_name, const char *prefix):525521_(svm_value_pointer_set)SVM_FUNCTION void svm_value_pointer_set(const void *svm, SVM_Value_Pointer value, const SVM_Value_Pointer pointer):041671_(svm_value_pointer_set_address)SVM_FUNCTION void svm_value_pointer_set_address(const void *svm, SVM_Value_Pointer value, const SVM_Value_Integer address):534941_(svm_value_pointer_set_address__raw)SVM_FUNCTION void svm_value_pointer_set_address__raw(const void *svm, SVM_Value_Pointer value, const SVM_Address address):085631_(svm_value_pointer_set_addresssize)SVM_FUNCTION void svm_value_pointer_set_addresssize(const void *svm, SVM_Value_Pointer value, const SVM_Value_Integer address, const SVM_Value_Integer size):126721_(svm_value_pointer_set_addresssize__raw)SVM_FUNCTION void svm_value_pointer_set_addresssize__raw(const void *svm, SVM_Value_Pointer value, const SVM_Address address, const SVM_Size size):160921_(svm_value_pointer_set_size)SVM_FUNCTION void svm_value_pointer_set_size(const void *svm, SVM_Value_Pointer value, const SVM_Value_Integer size):313391_(svm_value_pointer_set_size__raw)SVM_FUNCTION void svm_value_pointer_set_size__raw(const void *svm, SVM_Value_Pointer value, const SVM_Size size):584561_(svm_value_string_set)SVM_FUNCTION void svm_value_string_set(const void *svm, SVM_Value_String value, const SVM_String string):646011_(svm_value_string_set__buffer)SVM_FUNCTION void svm_value_string_set__buffer(const void *svm, SVM_Value_String value, const char *string, const SVM_Size size):244711_(svm_value_string_set__raw)SVM_FUNCTION void svm_value_string_set__raw(const void *svm, SVM_Value_String value, const char *string):654961_(svm_value_symbol_set)SVM_FUNCTION void svm_value_symbol_set(const void *svm, SVM_Value_Symbol value, const SVM_Value_Symbol symbol):408251_(svm_value_symbol_set_address)SVM_FUNCTION void svm_value_symbol_set_address(const void *svm, SVM_Value_Symbol value, const SVM_Address address):635941_(svm_value_symbol_set_code)SVM_FUNCTION void svm_value_symbol_set_code(const void *svm, SVM_Value_Symbol value, const SVM_Code code):134181_(svm_value_symbol_set_codeaddress)SVM_FUNCTION void svm_value_symbol_set_codeaddress(const void *svm, SVM_Value_Symbol value, const SVM_Code code, const SVM_Address address):336361_(svm_variable_delete)SVM_FUNCTION void svm_variable_delete(const void *svm, const SVM_Variable variable):099281_(svm_variable_scope_reset_shared)SVM_FUNCTION void svm_variable_scope_reset_shared(const void *svm, const SVM_Variable variable):499371_(svm_variable_scope_set_global)SVM_FUNCTION void svm_variable_scope_set_global(const void *svm, const SVM_Variable variable):403691_(svm_variable_scope_set_local)SVM_FUNCTION void svm_variable_scope_set_local(const void *svm, const SVM_Variable variable):622231_(svm_variable_scope_set_shared)SVM_FUNCTION void svm_variable_scope_set_shared(const void *svm, const SVM_Variable variable):013441_(svm_process_sequencer_get_internal)SVM_FUNCTION void* svm_process_sequencer_get_internal(const void *svm, const SVM_Process process):517501_(svm_scheduler_get_internal)SVM_FUNCTION void* svm_scheduler_get_internal(const void *svm, const SVM_Scheduler scheduler):128241_(svm_structure_get_internal)SVM_FUNCTION void* svm_structure_get_internal(const void *svm, const SVM_Value_PluginEntryPoint type, const SVM_Structure structure):541961_(svm_value_plugin_get_internal)SVM_FUNCTION void* svm_value_plugin_get_internal(const void *svm, const SVM_Value_Plugin plugin):397891_(SVM_Kernel_State)SVM_TYPE typedef SVM_Process_State SVM_Kernel_State;:203251_(SVM_AccessControl)SVM_TYPE typedef const void* SVM_AccessControl;:479801_(SVM_Code)SVM_TYPE typedef const void* SVM_Code;:308811_(SVM_Debug_Form)SVM_TYPE typedef const void* SVM_Debug_Form;:280091_(SVM_Event_Queue)SVM_TYPE typedef const void* SVM_Event_Queue;:616701_(SVM_Event_Queue_Address)SVM_TYPE typedef const void* SVM_Event_Queue_Address;:489471_(SVM_Kernel)SVM_TYPE typedef const void* SVM_Kernel;:029281_(SVM_Lock)SVM_TYPE typedef const void* SVM_Lock;:622541_(SVM_LockGuard_Read)SVM_TYPE typedef const void* SVM_LockGuard_Read;:619081_(SVM_LockGuard_Write)SVM_TYPE typedef const void* SVM_LockGuard_Write;:049041_(SVM_Memory_Zone)SVM_TYPE typedef const void* SVM_Memory_Zone;:375831_(SVM_Parameter)SVM_TYPE typedef const void* SVM_Parameter;:383611_(SVM_Process)SVM_TYPE typedef const void* SVM_Process;:217881_(SVM_Process_Lock)SVM_TYPE typedef const void* SVM_Process_Lock;:190231_(SVM_Scheduler)SVM_TYPE typedef const void* SVM_Scheduler;:305411_(SVM_Structure)SVM_TYPE typedef const void* SVM_Structure;:029301_(SVM_Type)SVM_TYPE typedef const void* SVM_Type;:383861_(SVM_Value)SVM_TYPE typedef const void* SVM_Value;:337501_(SVM_Value_Automatic)SVM_TYPE typedef const void* SVM_Value_Automatic;:409681_(SVM_Value_Boolean)SVM_TYPE typedef const void* SVM_Value_Boolean;:414831_(SVM_Value_Integer)SVM_TYPE typedef const void* SVM_Value_Integer;:569641_(SVM_Value_Interruption)SVM_TYPE typedef const void* SVM_Value_Interruption;:542891_(SVM_Value_Library)SVM_TYPE typedef const void* SVM_Value_Library;:408641_(SVM_Value_Plugin)SVM_TYPE typedef const void* SVM_Value_Plugin;:313291_(SVM_Value_PluginEntryPoint)SVM_TYPE typedef const void* SVM_Value_PluginEntryPoint;:358531_(SVM_Value_Pointer)SVM_TYPE typedef const void* SVM_Value_Pointer;:480301_(SVM_Value_String)SVM_TYPE typedef const void* SVM_Value_String;:296001_(SVM_Value_Symbol)SVM_TYPE typedef const void* SVM_Value_Symbol;:192321_(SVM_Variable)SVM_TYPE typedef const void* SVM_Variable;:084411_(SVM_Type_Internal)SVM_TYPE typedef enum { AUTOMATIC, INTEGER, STRING, BOOLEAN, POINTER, LIBRARY, SYMBOL, PLUGIN_ENTRY_POINT, INTERRUPTION } SVM_Type_Internal;:085881_(SVM_Interruption_Internal)SVM_TYPE typedef enum { CLONE, DEVICE, FAILURE, FIRST, MEMORY, NUMERIC, PROCESSOR, SECOND, SECURITY, TERMINATE, TERMINAL, GENERIC } SVM_Interruption_Internal;:226361_(SVM_Value_Plugin_Comparison)SVM_TYPE typedef enum { EQUIVALENCE_EQUAL = 0x0, EQUIVALENCE_DIFFERENT = 0x3, ORDER_EQUAL = 0x4, ORDER_INFERIOR = 0x5, ORDER_SUPERIOR = 0x6, ORDER_UNCOMPARABLE = 0x7, ORDER_TOTAL = 0x0, ORDER_PARTIAL = 0x8, COMPARISON_STRONG = 0x0, COMPARISON_WEAK = 0x10 } SVM_Value_Plugin_Comparison;:649781_(SVM_Boolean)SVM_TYPE typedef enum { FALSE = 0, TRUE = 1 } SVM_Boolean;:560141_(SVM_Object_Level)SVM_TYPE typedef enum { LOCAL, CASCADE, GLOBAL } SVM_Object_Level;:397101_(SVM_Notification_Type)SVM_TYPE typedef enum { NOTIFICATION, TIMER } SVM_Notification_Type;:130001_(SVM_Process_State)SVM_TYPE typedef enum { RUNNING, SUSPENDED, WAITING, CONTINUE, LOCKED, DEBUG, ZOMBIE, INTERRUPTED, ERROR } SVM_Process_State;:373671_(SVM_Interruption_Kind)SVM_TYPE typedef enum { SOFTWARE, HARDWARE } SVM_Interruption_Kind;:596411_(SVM_Status_Boolean)SVM_TYPE typedef struct { SVM_Boolean _value; SVM_String _details; } SVM_Status_Boolean;:459101_(SVM_Comparison_Result)SVM_TYPE typedef struct { SVM_Boolean equal; SVM_Boolean different; SVM_Boolean inferior; SVM_Boolean inferior_or_equal; SVM_Boolean superior; SVM_Boolean superior_or_equal; SVM_Boolean order; SVM_Boolean total; SVM_Boolean weak; SVM_Boolean type; SVM_Boolean null; } SVM_Comparison_Result;:305151_(SVM_String)SVM_TYPE typedef struct { const char *string; SVM_Size size; } SVM_String;:552571_(SVM_Address)SVM_TYPE typedef unsigned long int SVM_Address;:322471_(SVM_Index)SVM_TYPE typedef unsigned long int SVM_Index;:316021_(SVM_Size)SVM_TYPE typedef unsigned long int SVM_Size;:"
#endif
