.TH "Simple Virtual Machine - Package generator" 1 "2020-12-10"
.SH NAME
.BR svm_package
\- generates packages for SVM applications, libraries and plugins.
.SH SYNOPSIS
svm_package [-i input_file] [-o output_file] [-O] [-d] [-l] [h] [-v]
.SH DESCRIPTION
This command produces a shell script acting as a SVM applications/libraries/plugins local installer.
.P
This installation script can be transmitted for local installations on other systems, and comes with some options presented in its own help.
.P
.I This command is suitable only for applications/libraries/plugins installed locally. For system wide applications/libraries/plugins installation, please use the distribution package manager.
.SH OPTIONS
.TP
.B -i input_file
By default, svm_package reads the package description from the standard input.
This option indicates which file to use (the file extension .svm_pkg is recommended) to get the package description.
.TP
.B -o output_file
By default, svm_package writes the installation script to the standard output.
This option indicates which file to use (the file extension .sh is recommended) to write the package installer script.
.TP
.B -O
This option behaves like the -o one with a file name set to:
.nf
<package name>-<package version>-installer.sh
.fi
.TP
.B -d
By default, the generated package is created in release mode.
This option switches the creation in developper mode.
(See variables below.)
.TP
.B -l
This option does not generate a package, but list all supported options and configuration names, with their arguments description.
.TP
.B -h
This option displays the help of the command.
.TP
.B -v
This option displays the version and the licence of the command.
.SH PACKAGE FILE
The package file is made of three sections:
 - A header for general package description,
 - A list of package options,
 - A list of package elements.
.P
Within the package file:
 - Comments starts by a hash (#) and ends at the end of the line,
 - Commands are always terminated by an end of line.
.SS Package header
The header always starts with the package command:
.nf

PACKAGE <package name>

.fi
This command specifies the name of the package.
.P
Then, an optional licence block can follow:
.nf

LICENCE
<licence text>
END

.fi
This command describes the licence and the usage of the package installer.
.SS Package options
Some options can be set at package level with this command:
.nf

OPTION <option name> <list of values>

.fi
.P
The supported option names are displayed by the option -l, please refer to its display for more information.
The values are described in the section "Values and variables" below.
.P
Options are always refering to the package itself, and is unrelated to its content. (Please refer to Package content: Configuration below for options on package content.)
.SS Package content: Application
An application can be added to the package with the command:
.nf

APP	<file name>

.fi
The file name is specified without quotes, and shall be separated from the APP command name by a single space (or a single tabulation).
The specified file name can contain a relative or an absolute path to the real file on the file system.
The file will be inserted in the current package path (Please refer to the 'path' configuration on the list provided by the -l option).
.P
The installer can perform various transformations on the file (Please refer to Package content: Configuration below) and set the file as executable by the user installing the package.
.SS Package content: Library
A library (in SVM machine language) can be added to the package with the command:
.nf

LIB	<file name>

.fi
The file name is specified like in the APP command. Please refer to this command for more information.
.P
The file is inserted inside the package like in the APP command and has no specific transformations or setup.
.SS Package content: Plugin
A plugin can be added to the package with this command:
.nf

PLUGIN	<file name>

.fi
The file name is specified like in the APP command. Please refer to this command for more information.
.P
Depending on the configuration (Please refer to Package content: Configuration below), the plugin can be automatically generated and built during the installation.
.SS Package content: File
A generic file can be added to the package with the command:
.nf

FILE	<file name>

.fi
The file name is specified like in the APP command. Please refer to this command for more information.
.P
The file is inserted inside the package like in the APP command and has no specific transformations or setup.
.SS Package content: Shell code
This command inserts shell code directly inside the package installer:
.nf

SHELL
<shell code>
END

.fi
This can be used for installation customisation.
.SS Package content: Configuration
The package content installation can be altered by some dedicated configuration.
Each configuration key is associated to some arguments having a default value and some accepted types.
(The option -l also gives the possible configuration keys with the arguments.)
.P
The configuration can be controled with this command:
.nf

SET <configuration name> <list of values>

.fi
All subsequent content definitions using a modified key will use the corresponding values for their installation.
.SS Package content: Variable
A package description can use variables to avoid value replication within the file.
.P
A variable can be created or updated with the command:
.nf

VAR <variable name> <value>

.fi
.P
A variable can be read by using its name at the place of a value.
.SS Values and variables
Options, configurations and variables use values.
When a list of values is used, each value is separated from others with spaces or tabulations.
.P
Accepted values are:
 - Integers written in decimal,
 - Strings surrounded by double-quotes ("),
 - The YES boolean and the NO boolean,
 - The DEFAULT value, replaced by the real default value,
 - A variable name.
.P
Variables are names referencing a value, and are set by the VAR command.
Two variables are automatically created by svm_package:
 - only_in_dev: Set to NO by default, or to YES when the -d option is present,
 - only_in_release: Set to YES by default, or to NO when the -d option is present.
.SH PACKAGE FILE EXAMPLE
.nf

PACKAGE myapp
LICENCE
This program comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it under certain conditions.
See GNU GPLv3 terms for details.
END

OPTION	version "1.1"
OPTION	author "A. Nonymous"
OPTION	maintainer "A. Nonymous" "a.nonymous@somemail.com"
OPTION	svm_api_version_check YES

VAR	plugin_root ".plugins"

SET	app_change_sheebang YES
SET	app_local_plugins_root plugin_root

APP	myapp.svm

LIB	list.lib.svm
LIB	toolbox.lib.svm

SET	plugin_keep_build NO
SET	plugin_check only_in_dev
SET	path plugin_root
PLUGIN	map.svm_plugin
PLUGIN	myapp.svm_plugin

SET	path DEFAULT
FILE	default.cfg

# Extra content
APP	asidetool.svm

.fi
.SH RETURN VALUES
The svm_package command returns 0 when the Simple Virtual Machine package installer has been successfully generated, and another value otherwise.
.P
.SH SEE ALSO
.BR svm (1)
.BR svm_plugin (1)
for general documentation on the Simple Virtual Machine, in particular with plugin objects usage and low-level C/C++ plugin interface.
.SH AUTHOR
The Simple Virtual Machine is designed, implemented and maintained by Julien Bruguier <===EMAILCONTACT===>.
.SH BUGS
In case of bug on the virtual machine or on a plugin delivered with it, please send an email to the address above.
Other plugins can not be covered here, so please contact preferably the author of the plugin whenever possible.
