/*
 * Copyright (C) 2023-11-15  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 691 "../plugins/array/core/array.svm_plugin"
#include <vector>
#line 25 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN array \n"
		"DEFINE \n"
		"	OPTION array.wrap -w BLN \n"
		"	INTERRUPTION array.out_of_range \n"
		"	INSTRUCTION array.append MUTABLE PTR:array ( INT:size | { VALUE + }:values ) -> PTR \n"
		"	INSTRUCTION array.insert MUTABLE PTR:array INT:index ( INT:size | { VALUE + }:values ) -> PTR \n"
		"	INSTRUCTION array.erase MUTABLE PTR:array INT:index INT:size \n"
		"	INSTRUCTION array.sub PTR:array INT:index INT:size -> PTR \n"
		"	INSTRUCTION array.copy PTR:array -> PTR:copy \n"
		"	INSTRUCTION array.print PTR:array -> STR \n"
		"	INSTRUCTION array.update PTR:array ( PEP:function INT:element ? { . * } | [ STR SYM ]:function { VALUE * } ) \n"
		"	INTERRUPTION array.invalid_return \n"
		"	INSTRUCTION array.map PTR:array ( PEP:function INT:element ? { . * } | [ STR SYM ]:function { VALUE * } ) -> PTR \n"
		"	INSTRUCTION array.accumulate PTR:array ( PEP:function ( INT:element INT:accumulator ) ? { . * } VALUE:init | [ STR SYM ]:function { VALUE * } PTR:accumulator ) -> [ VALUE PTR ] \n"
		"	INSTRUCTION array.filter PTR:array PEP:predicate INT:index ? { . * } -> PTR \n"
		"	INSTRUCTION array.sort PTR:array PEP:comparator ( INT:left INT:right ) ? { . * } -> PTR \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 696 "../plugins/array/core/array.svm_plugin"
namespace Array
{
	unsigned long long int index(const void *svm, const SVM_Index index, const SVM_Size size)
	{
		unsigned long long int i=index;
		SVM_Value_Boolean b = ::svm_plugin_get_option(svm,CONST_PEP(array,wrap));	
		if(::svm_value_boolean_get(svm,b))
		{
			i = i%(size+1);
			if(i<0)
			{
				i+=(size+1);
			}
		}
		else
		{
			if((i<0) or (i>size))
			{
				ERROR_EXTERNAL(array,out_of_range,"Index out of range");
			}
		}
		return i;
	}
	void swap(SVM_Value *&l, SVM_Value *& r)
	{
		SVM_Value t = *l;
		*l=*r;
		*r=t;
	}
	/*
	void display(const void *svm, const std::string& header, SVM_Value *start, SVM_Value *end, SVM_Value *pivot)
	{
		std::ostringstream oss;
		oss << header << " " << (pivot-start) << " |";
		for(SVM_Value *i=start ; i<end ; ++i)
		{
			SVM_String s = ::svm_value_print(svm,*i);
			oss << " " << RAW_STRING(s);
		}
		::svm_machine_trace__raw(svm,oss.str().c_str());
	}
	*/
	void sort(const void *svm, SVM_Value *start, SVM_Value *end, SVM_Value_PluginEntryPoint f, SVM_Size argc, SVM_Parameter *argv, const SVM_Index left, const SVM_Index right)
	{
		if(start>=end) return;
		SVM_Value *t = end-1;
		SVM_Value *s = start;
		for(SVM_Value *i=start ; i<t ; ++i)
		{
			argv[left] = ::svm_parameter_value_new(svm,*i);
			argv[right] = ::svm_parameter_value_new(svm,*t);
			SVM_Variable rv = ::svm_function_call(svm,f,argc,argv);
			if(not rv or not ::svm_variable_type_is_value(svm,rv) or not ::svm_value_type_is_boolean(svm,rv))
			{
				ERROR_EXTERNAL(array,invalid_return,"Function shall return a boolean value");
			}
			if(::svm_value_boolean_get(svm,rv))
			{
				Array::swap(i,s);
				s++;
			}
			VARIABLE_DELETE(argv[left]);
			VARIABLE_DELETE(argv[right]);
		}
		Array::swap(s,t);
		Array::sort(svm,start,s,f,argc,argv,left,right);
		Array::sort(svm,s+1,end,f,argc,argv,left,right);
	}
}
#line 199 "src/plugin.cpp"

extern "C"
{

/* OPTION array.wrap -w BLN */


/* INTERRUPTION array.out_of_range */


/* INSTRUCTION array.append MUTABLE PTR:array ( INT:size | { VALUE + }:values ) -> PTR */

SVM_Value instruction_append(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 785 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	long long int s = 0;
	std::vector<SVM_Value> v;
	if(::svm_parameter_type_is_value(svm,argv[1]))
	{
		s = ARGV_VALUE(1,integer);
	}
	else
	{
		for(SVM_Index ii=2 ; ii<(argc-1) ; ++ii)
		{
			v.push_back(::svm_parameter_value_get(svm,argv[ii]));
		}
		s = v.size();
	}
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	bool e = false;
	for(SVM_Index ii=0 ; ii<s ; ++ii)
	{
		if(::svm_memory_address_is_defined(svm,CURRENT(kernel),aa+as+ii))
		{
			e=true;
			break;
		}
	}
	if(e)
	{
		SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
		::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,as+s);
		SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
		SVM_Address pa = ::svm_value_pointer_get_address(svm,p);
		SVM_Size ps = ::svm_value_pointer_get_size(svm,p);
		SVM_Value_Pointer t = ::svm_value_pointer_new__raw(svm,pa,ps-s);
		::svm_memory_move(svm,CURRENT(kernel),a,CURRENT(kernel),t);
		if(not v.empty())
		{
			for(SVM_Index ii=0 ; ii<s ; ++ii)
			{
				::svm_memory_write_address(svm,CURRENT(kernel),pa+as+ii,v[ii]);
			}
		}
		::svm_memory_free(svm,CURRENT(kernel),a);
		::svm_memory_scope_set_global(svm,CURRENT(kernel),a);
		::svm_value_pointer_set_addresssize__raw(svm,a,pa,ps);
		return ::svm_value_pointer_new__raw(svm,pa+as,s);
	}
	else
	{
		SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
		::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,s);
		SVM_Value_Pointer r = ::svm_memory_allocate_address(svm,CURRENT(kernel),z,aa+as);
		if(not v.empty())
		{
			for(SVM_Index ii=0 ; ii<s ; ++ii)
			{
				::svm_memory_write_address(svm,CURRENT(kernel),aa+as+ii,v[ii]);
			}
		}
		::svm_value_pointer_set_size__raw(svm,a,as+s);
		return r;
	}
#line 277 "src/plugin.cpp"
}


/* INSTRUCTION array.insert MUTABLE PTR:array INT:index ( INT:size | { VALUE + }:values ) -> PTR */

SVM_Value instruction_insert(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 863 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	auto i = ARGV_VALUE(1,integer);
	long long int s = 0;
	std::vector<SVM_Value> v;
	if(::svm_parameter_type_is_value(svm,argv[2]))
	{
		s = ARGV_VALUE(2,integer);
	}
	else
	{
		for(SVM_Index ii=3 ; ii<(argc-1) ; ++ii)
		{
			v.push_back(::svm_parameter_value_get(svm,argv[ii]));
		}
		s = v.size();
	}
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	i = Array::index(svm,i,as);
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,as+s);
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	SVM_Address pa = ::svm_value_pointer_get_address(svm,p);
	SVM_Size ps = ::svm_value_pointer_get_size(svm,p);
	SVM_Value_Pointer ts = ::svm_value_pointer_new__raw(svm,aa,i);
	SVM_Value_Pointer td = ::svm_value_pointer_new__raw(svm,pa,i);
	::svm_memory_move(svm,CURRENT(kernel),ts,CURRENT(kernel),td);
	if(not v.empty())
	{
		for(SVM_Index ii=0 ; ii<s ; ++ii)
		{
			::svm_memory_write_address(svm,CURRENT(kernel),pa+i+ii,v[ii]);
		}
	}
	ts = ::svm_value_pointer_new__raw(svm,aa+i,as-i);
	td = ::svm_value_pointer_new__raw(svm,pa+i+s,as-i);
	::svm_memory_move(svm,CURRENT(kernel),ts,CURRENT(kernel),td);
	::svm_memory_free(svm,CURRENT(kernel),a);
	::svm_memory_scope_set_global(svm,CURRENT(kernel),a);
	::svm_value_pointer_set_addresssize__raw(svm,a,pa,ps);
	return ::svm_value_pointer_new__raw(svm,pa+i,s);
#line 327 "src/plugin.cpp"
}


/* INSTRUCTION array.erase MUTABLE PTR:array INT:index INT:size */

SVM_Value instruction_erase(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 920 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	auto i = ARGV_VALUE(1,integer);
	auto s = ARGV_VALUE(2,integer);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	i = Array::index(svm,i,as);
	if(s<0)
	{
		ERROR_INTERNAL(FAILURE,"Invalid size");
	}
	if(i+s>as)
	{
		ERROR_EXTERNAL(array,out_of_range,"Exceding array");
	}
	if(s==0)
		RETURN;
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,as-s);
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	SVM_Address pa = ::svm_value_pointer_get_address(svm,p);
	SVM_Size ps = ::svm_value_pointer_get_size(svm,p);
	SVM_Value_Pointer ts = ::svm_value_pointer_new__raw(svm,aa,i);
	SVM_Value_Pointer td = ::svm_value_pointer_new__raw(svm,pa,i);
	::svm_memory_move(svm,CURRENT(kernel),ts,CURRENT(kernel),td);
	ts = ::svm_value_pointer_new__raw(svm,aa+i+s,as-i-s);
	td = ::svm_value_pointer_new__raw(svm,pa+i,as-i-s);
	::svm_memory_move(svm,CURRENT(kernel),ts,CURRENT(kernel),td);
	::svm_memory_free(svm,CURRENT(kernel),a);
	::svm_memory_scope_set_global(svm,CURRENT(kernel),a);
	::svm_value_pointer_set_addresssize__raw(svm,a,pa,ps);
#line 366 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION array.sub PTR:array INT:index INT:size -> PTR */

SVM_Value instruction_sub(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 960 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	auto i = ARGV_VALUE(1,integer);
	auto s = ARGV_VALUE(2,integer);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	i = Array::index(svm,i,as);
	if(s<0)
	{
		ERROR_INTERNAL(FAILURE,"Invalid size");
	}
	if(i+s>as)
	{
		ERROR_EXTERNAL(array,out_of_range,"Exceding array");
	}
	return ::svm_value_pointer_new__raw(svm,aa+i,s);
#line 391 "src/plugin.cpp"
}


/* INSTRUCTION array.copy PTR:array -> PTR:copy */

SVM_Value instruction_copy(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 987 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,as);
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	::svm_memory_copy(svm,CURRENT(kernel),a,CURRENT(kernel),p);
	return p;
#line 407 "src/plugin.cpp"
}


/* INSTRUCTION array.print PTR:array -> STR */

SVM_Value instruction_print(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1002 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	std::ostringstream oss;
	oss << "[";
	bool b = false;
	for(SVM_Address ii=aa ; ii<(aa+as) ; ++ii)
	{
		if(b)
		{
			oss << " ,";
		}
		b = true;
		oss << " ";
		if(::svm_memory_address_is_initialised(svm,CURRENT(kernel),ii))
		{
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),ii);
			SVM_String s = ::svm_value_print(svm,v);
			oss << RAW_STRING(s);
		}
	}
	oss << " ]";
	return ::svm_value_string_new__buffer(svm,oss.str().c_str(),oss.str().size());
#line 439 "src/plugin.cpp"
}


/* INSTRUCTION array.update PTR:array ( PEP:function INT:element ? { . * } | [ STR SYM ]:function { VALUE * } ) */

SVM_Value instruction_update(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1033 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	SVM_Value f = ::svm_parameter_value_get(svm,argv[1]);
	if(::svm_value_type_is_pluginentrypoint(svm,f))
	{
		SVM_Index index = 3;
		SVM_Index element = 0;
		if(::svm_parameter_type_is_value(svm,argv[2]))
		{
			auto i = ARGV_VALUE(2,integer);
			if((i<0) or (i>=argc-4))
			{
				ERROR_INTERNAL(FAILURE,"Invalid element index");
			}
			element = i;
			index = 4;
		}
		SVM_Parameter *p = ::svm_parameter_array_new(svm,argc-index);
		SVM_Index iii = 0;
		for(SVM_Index ii=index ; ii<(argc-1) ; ++ii)
		{
			for( ; ; )
			{
				if(iii==element)
				{
					++iii;
				}
				else
				{
					break;
				}
			}
			p[iii++]=argv[ii];
		}
		for(SVM_Address ii=aa ; ii<(aa+as) ; ++ii)
		{
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),ii);
			p[element] = ::svm_parameter_value_new(svm,v);
			::svm_function_call(svm,f,argc-index,p);
			VARIABLE_DELETE(p[element]);
		}
	}
	else
	{
		SVM_Address fa = 0;
		SVM_Value_Symbol fs = nullptr;
		if(::svm_value_type_is_symbol(svm,f))
		{
			fs = f;
		}
		else
		{
			SVM_Code c = ::svm_processor_get_currentcode(svm,CURRENT(kernel));
			fa = ::svm_code_label_get_address(svm,c,f);
		}
		SVM_Value *pv = ::svm_value_array_new(svm,argc-4);
		for(SVM_Index ii=3 ; ii<(argc-1) ; ++ii)
		{
			pv[ii-3] = ::svm_parameter_value_get(svm,argv[ii]);
		}
		SVM_Value_Pointer pc = ::svm_processor_get_currentpointer(svm,CURRENT(kernel));
		for(SVM_Address ii=(aa+as) ; ii>aa ; --ii)
		{
			if(fs)
			{
				::svm_processor_call_global(svm,CURRENT(kernel),fs,pc);
			}
			else
			{
				::svm_processor_call_local(svm,CURRENT(kernel),fa,pc);
			}
			auto rii = ii-1;
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),rii);
			SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
			::svm_memory_zone_append_internal__raw(svm,z,POINTER,1);
			::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,argc-3);
			SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
			SVM_Address pa = ::svm_value_pointer_get_address(svm,p);
			SVM_Size ps = ::svm_value_pointer_get_size(svm,p);
			SVM_Value_Pointer vs = ::svm_value_pointer_new__raw(svm,rii,1);
			SVM_Value_Pointer vd = ::svm_value_pointer_new__raw(svm,pa+1,1);
			::svm_memory_share(svm,CURRENT(kernel),vs,CURRENT(kernel),vd);
			::svm_memory_write_pointer__raw(svm,CURRENT(kernel),pa+2,ps-2,pv);
			::svm_processor_set_currentpointer(svm,CURRENT(kernel),p);
		}
	}
#line 535 "src/plugin.cpp"
	return nullptr;
}


/* INTERRUPTION array.invalid_return */


/* INSTRUCTION array.map PTR:array ( PEP:function INT:element ? { . * } | [ STR SYM ]:function { VALUE * } ) -> PTR */

SVM_Value instruction_map(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1142 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	SVM_Value f = ::svm_parameter_value_get(svm,argv[1]);
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,as);
	SVM_Value_Pointer r = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	SVM_Address ra = ::svm_value_pointer_get_address(svm,r);
	if(::svm_value_type_is_pluginentrypoint(svm,f))
	{
		SVM_Index index = 3;
		SVM_Index element = 0;
		if(::svm_parameter_type_is_value(svm,argv[2]))
		{
			auto i = ARGV_VALUE(2,integer);
			if((i<0) or (i>=argc-4))
			{
				ERROR_INTERNAL(FAILURE,"Invalid element index");
			}
			element = i;
			index = 4;
		}
		SVM_Parameter *p = ::svm_parameter_array_new(svm,argc-index);
		SVM_Index iii = 0;
		for(SVM_Index ii=index ; ii<(argc-1) ; ++ii)
		{
			for( ; ; )
			{
				if(iii==element)
				{
					++iii;
				}
				else
				{
					break;
				}
			}
			p[iii++]=argv[ii];
		}
		for(SVM_Address ii=aa ; ii<(aa+as) ; ++ii,++ra)
		{
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),ii);
			p[element] = ::svm_parameter_value_new(svm,v);
			SVM_Variable rv = ::svm_function_call(svm,f,argc-index,p);
			if(not rv or not ::svm_variable_type_is_value(svm,rv))
			{
				ERROR_EXTERNAL(array,invalid_return,"Function shall return a value");
			}
			::svm_value_state_set_movable(svm,rv);
			::svm_memory_write_address(svm,CURRENT(kernel),ra,rv);
			VARIABLE_DELETE(p[element]);
		}
	}
	else
	{
		SVM_Address fa = 0;
		SVM_Value_Symbol fs = nullptr;
		if(::svm_value_type_is_symbol(svm,f))
		{
			fs = f;
		}
		else
		{
			SVM_Code c = ::svm_processor_get_currentcode(svm,CURRENT(kernel));
			fa = ::svm_code_label_get_address(svm,c,f);
		}
		SVM_Value *pv = ::svm_value_array_new(svm,argc-4);
		for(SVM_Index ii=3 ; ii<(argc-1) ; ++ii)
		{
			pv[ii-3] = ::svm_parameter_value_get(svm,argv[ii]);
		}
		SVM_Value_Pointer pc = ::svm_processor_get_currentpointer(svm,CURRENT(kernel));
		SVM_Size rs = ::svm_value_pointer_get_size(svm,r);
		ra += rs;
		for(SVM_Address ii=(aa+as) ; ii>aa ; --ii)
		{
			--ra;
			if(fs)
			{
				::svm_processor_call_global(svm,CURRENT(kernel),fs,pc);
			}
			else
			{
				::svm_processor_call_local(svm,CURRENT(kernel),fa,pc);
			}
			auto rii = ii-1;
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),rii);
			SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
			::svm_memory_zone_append_internal__raw(svm,z,POINTER,1);
			::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,argc-2);
			SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
			SVM_Address pa = ::svm_value_pointer_get_address(svm,p);
			SVM_Size ps = ::svm_value_pointer_get_size(svm,p);
			::svm_memory_write_address(svm,CURRENT(kernel),pa+1,v);
			SVM_Value_Pointer vs = ::svm_value_pointer_new__raw(svm,ra,1);
			SVM_Value_Pointer vd = ::svm_value_pointer_new__raw(svm,pa+2,1);
			::svm_memory_share(svm,CURRENT(kernel),vs,CURRENT(kernel),vd);
			::svm_memory_write_pointer__raw(svm,CURRENT(kernel),pa+3,ps-3,pv);
			::svm_processor_set_currentpointer(svm,CURRENT(kernel),p);
		}
	}
	return r;
#line 650 "src/plugin.cpp"
}


/* INSTRUCTION array.accumulate PTR:array ( PEP:function ( INT:element INT:accumulator ) ? { . * } VALUE:init | [ STR SYM ]:function { VALUE * } PTR:accumulator ) -> [ VALUE PTR ] */

SVM_Value instruction_accumulate(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1260 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	SVM_Value f = ::svm_parameter_value_get(svm,argv[1]);
	if(::svm_value_type_is_pluginentrypoint(svm,f))
	{
		SVM_Index index = 3;
		SVM_Index element = 0;
		SVM_Index accumulator = 1;
		if(::svm_parameter_type_is_value(svm,argv[2]))
		{
			auto i = ARGV_VALUE(2,integer);
			if((i<0) or (i>=argc-4))
			{
				ERROR_INTERNAL(FAILURE,"Invalid element index");
			}
			element = i;
			i = ARGV_VALUE(3,integer);
			if((i<0) or (i>=argc-4))
			{
				ERROR_INTERNAL(FAILURE,"Invalid accumulator index");
			}
			if(element==accumulator)
			{
				ERROR_INTERNAL(FAILURE,"Element and accumulator indexes can not be equal");
			}
			accumulator = i;
			index = 5;
		}
		SVM_Parameter *p = ::svm_parameter_array_new(svm,argc-index);
		SVM_Index iii = 0;
		for(SVM_Index ii=index ; ii<(argc-1) ; ++ii)
		{
			for( ; ; )
			{
				if(iii==element or iii==accumulator)
				{
					++iii;
				}
				else
				{
					break;
				}
			}
			p[iii++]=argv[ii];
		}
		p[accumulator] = argv[argc-1];
		for(SVM_Address ii=aa ; ii<(aa+as) ; ++ii)
		{
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),ii);
			p[element] = ::svm_parameter_value_new(svm,v);
			SVM_Variable rv = ::svm_function_call(svm,f,argc-index,p);
			if(not rv or not ::svm_variable_type_is_value(svm,rv))
			{
				ERROR_EXTERNAL(array,invalid_return,"Function shall return a value");
			}
			VARIABLE_DELETE(p[element]);
			VARIABLE_DELETE(p[accumulator]);
			p[accumulator] = ::svm_parameter_value_new(svm,rv);
		}
		return ::svm_parameter_value_get(svm,p[accumulator]);
	}
	else
	{
		SVM_Address fa = 0;
		SVM_Value_Symbol fs = nullptr;
		if(::svm_value_type_is_symbol(svm,f))
		{
			fs = f;
		}
		else
		{
			SVM_Code c = ::svm_processor_get_currentcode(svm,CURRENT(kernel));
			fa = ::svm_code_label_get_address(svm,c,f);
		}
		SVM_Value *pv = ::svm_value_array_new(svm,argc-5);
		for(SVM_Index ii=3 ; ii<(argc-2) ; ++ii)
		{
			pv[ii-3] = ::svm_parameter_value_get(svm,argv[ii]);
		}
		SVM_Value_Pointer pp = ::svm_parameter_value_get(svm,argv[argc-1]);
		SVM_Value_Pointer pc = ::svm_processor_get_currentpointer(svm,CURRENT(kernel));
		for(SVM_Address ii=(aa+as) ; ii>aa ; --ii)
		{
			if(fs)
			{
				::svm_processor_call_global(svm,CURRENT(kernel),fs,pc);
			}
			else
			{
				::svm_processor_call_local(svm,CURRENT(kernel),fa,pc);
			}
			auto rii = ii-1;
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),rii);
			SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
			::svm_memory_zone_append_internal__raw(svm,z,POINTER,1);
			::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,1);
			::svm_memory_zone_append_internal__raw(svm,z,POINTER,1);
			::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,argc-5);
			SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
			SVM_Address pa = ::svm_value_pointer_get_address(svm,p);
			SVM_Size ps = ::svm_value_pointer_get_size(svm,p);
			::svm_memory_write_address(svm,CURRENT(kernel),pa+1,v);
			::svm_memory_write_address(svm,CURRENT(kernel),pa+2,pp);
			::svm_memory_write_pointer__raw(svm,CURRENT(kernel),pa+3,ps-3,pv);
			::svm_processor_set_currentpointer(svm,CURRENT(kernel),p);
		}
		return pp;
	}
#line 768 "src/plugin.cpp"
}


/* INSTRUCTION array.filter PTR:array PEP:predicate INT:index ? { . * } -> PTR */

SVM_Value instruction_filter(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1385 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Address aa = ::svm_value_pointer_get_address(svm,a);
	SVM_Size as = ::svm_value_pointer_get_size(svm,a);
	SVM_Value_PluginEntryPoint f = ::svm_parameter_value_get(svm,argv[1]);
	SVM_Value *r = ::svm_value_array_new(svm,as);
	SVM_Size rs = 0;
	SVM_Index index = 3;
	SVM_Index element = 0;
	if(::svm_parameter_type_is_value(svm,argv[2]))
	{
		auto i = ARGV_VALUE(2,integer);
		if((i<0) or (i>=argc-4))
		{
			ERROR_INTERNAL(FAILURE,"Invalid element index");
		}
		element = i;
		index = 4;
	}
	SVM_Parameter *p = ::svm_parameter_array_new(svm,argc-index);
	SVM_Index iii = 0;
	for(SVM_Index ii=index ; ii<(argc-1) ; ++ii)
	{
		for( ; ; )
		{
			if(iii==element)
			{
				++iii;
			}
			else
			{
				break;
			}
		}
		p[iii++]=argv[ii];
	}
	for(SVM_Address ii=aa ; ii<(aa+as) ; ++ii)
	{
		SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),ii);
		p[element] = ::svm_parameter_value_new(svm,v);
		SVM_Variable rv = ::svm_function_call(svm,f,argc-index,p);
		if(not rv or not ::svm_variable_type_is_value(svm,rv) or not ::svm_value_type_is_boolean(svm,rv))
		{
			ERROR_EXTERNAL(array,invalid_return,"Function shall return a boolean value");
		}
		if(::svm_value_boolean_get(svm,rv))
		{
			r[rs++]=v;
		}
		VARIABLE_DELETE(p[element]);
	}
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,rs);
	SVM_Value_Pointer pr = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	::svm_memory_write_pointer(svm,CURRENT(kernel),pr,r);
	return pr;
#line 832 "src/plugin.cpp"
}


/* INSTRUCTION array.sort PTR:array PEP:comparator ( INT:left INT:right ) ? { . * } -> PTR */

SVM_Value instruction_sort(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1452 "../plugins/array/core/array.svm_plugin"
	SVM_Value_Pointer a = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Value_PluginEntryPoint f = ::svm_parameter_value_get(svm,argv[1]);
	SVM_Index index=2;
	SVM_Index left = 0;
	SVM_Index right = 1;
	if(::svm_parameter_type_is_value(svm,argv[2]))
	{
		auto i = ARGV_VALUE(2,integer);
		if((i<0) or (i>=argc-4))
		{
			ERROR_INTERNAL(FAILURE,"Invalid left index");
		}
		left = i;
		i = ARGV_VALUE(3,integer);
		if((i<0) or (i>=argc-4))
		{
			ERROR_INTERNAL(FAILURE,"Invalid right index");
		}
		right = i;
		if(left==right)
		{
			ERROR_INTERNAL(FAILURE,"Left and right indexes can not be equal");
		}
		index = 4;
	}
	SVM_Parameter *p = ::svm_parameter_array_new(svm,argc-index);
	SVM_Index iii=0;
	for(SVM_Index ii=index+1 ; ii<(argc-1) ; ++ii)
	{
		for( ; ; )
		{
			if(iii==left or iii==right)
			{
				++iii;
			}
			else
			{
				break;
			}
		}
		p[iii++]=argv[ii];
	}
	SVM_Value *v = ::svm_memory_read_pointer(svm,CURRENT(kernel),a);
	SVM_Size vs=0;
	for(SVM_Value *ii=v ; *ii ; ++ii)
	{
		v[vs] = ::svm_value_copy(svm,v[vs]);
		::svm_value_state_set_movable(svm,v[vs]);
		++vs;
	}
	Array::sort(svm,v,v+vs,f,argc-index,p,left,right);
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,vs);
	SVM_Value_Pointer r = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	::svm_memory_write_pointer(svm,CURRENT(kernel),r,v);
	return r;
#line 897 "src/plugin.cpp"
}


/* Generic handling functions */

}
