#!/bin/sh

#
# Copyright (C) 2023-11-15  Julien BRUGUIER
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

cat > op.svm_plugin << EOM 
PLUGIN op

DEFINE

FUNCTION op.inc MUTABLE INT INT
:{
	auto l = ARGV_VALUE(0,integer);
	auto r = ARGV_VALUE(1,integer);
	::svm_value_integer_set(svm,::svm_parameter_value_get(svm,argv[0]),l+r);
:}

FUNCTION op.add INT INT -> INT
:{
	auto l = ARGV_VALUE(0,integer);
	auto r = ARGV_VALUE(1,integer);
	return NEW_VALUE(integer,l+r);
:}

code:
:{
template<typename T>
bool comp(const T& l, const T& r, const std::string& c)
{
	if(c=="<")
		return l<r;
	if(c=="<=")
		return l<=r;
	if(c=="=")
		return l==r;
	if(c=="=>")
		return l>=r;
	if(c==">")
		return l>r;
	if(c=="<>")
		return l!=r;
}
:}

FUNCTION op.cmp INT INT [ < <= = => > <> ] -> BLN
:{
	auto l = ARGV_VALUE(0,integer);
	auto r = ARGV_VALUE(1,integer);
	auto c = ARGV_MARKER(2);
	return NEW_VALUE(boolean,comp(l,r,c)?TRUE:FALSE);
:}

FUNCTION op.odd INT -> BLN
:{
	auto i = ARGV_VALUE(0,integer);
	return NEW_VALUE(boolean,(i%2==1)?TRUE:FALSE);
:}
EOM
$svm_plugin -fi op.svm_plugin | bash && ./svmpluginop/plugin_install -l
