.TH "Simple Virtual Machine - Plugin bit" 7 "2023-03-13"
.SH SYNOPSIS
.B svm_plugin_bit
An implementation of bit sets for SVM.
.SH DESCRIPTION
This plugin enables bit set manipulation.
.P
It also allows conversion from strings and to strings.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginbit/libsvmbit.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS TYPE bit.set
This type contains a set of bit.
The set has a length fixed at construction time, and supports copy and constant construction.
.SS INTERRUPTION bit.size_mismatch
This interruption is raised when a bit set has an invalid size.
.SS INTERRUPTION bit.out_of_range
This interruption is raised when an index for a bit is outside the set range.
.SS INSTRUCTION bit.set [ INT STR ]:size_or_bits -> bit.set
This instruction creates a bit set.
.P
When an integer is specified, the bit set is built with non-set bit with a length described by the integer.
A FAILURE interruption is raised when the size is negative.
.P
When a string is specified, the bit set is built using the string length and the bit are initialised from the string characters.
.SS INSTRUCTION bit.string bit.set -> STR
This instruction transforms a bit set into a string, using the bit to initialise the characters.
A bit.size_mismatch interruption is raised when the bit set has a size not being a multiple of 8.
.SS INSTRUCTION bit.format bit.set STR:false STR:true ( INT:block STR:separator ) ? -> STR
This instruction builds a text representation of the bit set.
.P
The two first strings shall be non-empty or a FAILURE interruption will be raised.
The first character of the first string is used to represent a non-set bit, and the first character of the second string is used to represent a set bit.
.P
When an integer and an extra string are specified, the integer shall be a positive number or a FAILURE interruption will be raised, and the string shall be non-empty or a FAILURE will also be raised.
When this two extra parameters are specified, the resulting string will show the bit packed in blocks having the integer as size and blocks will be separated by the first character of the string.
.SS INSTRUCTION bit.check bit.set INT:index -> BLN
This instruction returns the value of a bit as a boolean.
The index shall be within 0 and the size minus 1 or a bit.out_of_range interruption will be raised.
.P
The index 0 is placed on the right of the format representation of the bit set.
.SS INSTRUCTION bit.modify MUTABLE bit.set INT:index [ BLN 'SWAP' ]:value
This instruction changes the value of a bit.
The index shall be within 0 and the size minus 1 or a bit.out_of_range interruption will be raised.
The bit can be fixed to a dedicated value by specifying a boolean, or inversed using the SWAP keyword.
.P
The index 0 is placed on the right of the format representation of the bit set.
.SS INSTRUCTION bit.pattern MUTABLE bit.set ( PTR | BLN + )
This instruction fills the bit set with a repeated pattern.
.P
The pattern can be provided as a list of booleans, or a pointer towards at least two booleans.
.P
The pattern is applied with the last boolean of the pattern at the index 0 of the set, then the one before of the pattern at the index 1, etc...
.P
As an example:
.nf
	:memory bit.set/set, STR/result
	:bit.set 18 -> &set
	:bit.pattern @&set FALSE FALSE TRUE FALSE
	:bit.format @&set "." "X" 8 " " -> &result
.fi
will produce the string:
.nf
	"X. ..X...X. ..X...X."
.fi
.SS INSTRUCTION bit.size bit.set -> INT
This instruction returns the number of bits of a set.
.SS INSTRUCTION bit.count bit.set -> INT
This instruction returns the number of activated bits of a set.
.SS INSTRUCTION bit.empty bit.set -> BLN
This instruction returns TRUE when the set has no activated bit in the set, and FALSE otherwise.
.SS INSTRUCTION bit.index bit.set -> PTR
This instruction returns a pointer to an allocated memory zone containing integers.
.P
Each integer is the index of an activated bit within the bit set.
.SS INSTRUCTION bit.shift bit.set INT:shift -> bit.set
This instruction builds a bit set having the same size of the given bit set, with activated bits shifted.
The shift value is specfied with the integer.
.P
A positive shift value will increase the index of activated bits, and a negative shift value will decrease them.
Activated bits going outside the new bit set are lost.
.SS INSTRUCTION bit.rotate bit.set INT:shift -> bit.set
This instruction builds a bit set having the same size of the given bit set, with activated bits shifted.
The shift value is specfied with the integer.
.P
A positive shift value will increase the index of activated bits, and a negative shift value will decrease them.
Activated bits going outside the new bit set are wrapped to the other side of the bit set.
.SS INSTRUCTION bit.not bit.set -> bit.set
This instruction creates a bit set containing the inversed bits of the given bit set.
.SS INSTRUCTION bit.all bit.set bit.set + -> bit.set
This instruction creates a bit set containing the logical and of bits of the given bit sets.
The operation is executed between bits at the same index.
.P
The interruption bit.size_mismatch is raised if at least bit set has not the same size as other sets.
.SS INSTRUCTION bit.any bit.set bit.set + -> bit.set
This instruction creates a bit set containing the logical or of bits of the given bit sets.
The operation is executed between bits at the same index.
.P
The interruption bit.size_mismatch is raised if at least bit set has not the same size as other sets.
.SS INSTRUCTION bit.operation [ = <> < <= > => ]:operation INT:threshold ( PTR | bit.set bit.set + ) -> bit.set
This instruction performs a generic boolean operation on each bit of the bit sets, specified either by a pointer towards an array of bit sets or by the explicit list.
When the pointer has a size below 2, a FAILURE interruption is raised.
When a bit set has a different size as other, a bit.size_mismatch interruption is raised.
.P
When bit sets are correct, the instruction counts among all bit sets the number of activated bits for each index, and apply the condition specified by the two first arguments.
When the result is true, the bit at the corresponding index is activated into the resulting bit set.
.P
Common operations can be performed with this single instruction:
.nf
	= 0           NOR operation
	= 1           XOR operation
	> 0           OR operation
	= nb of sets  AND operation
	< nb of sets  NAND operation
.fi
For example, this code:
.nf
	:memory bit.set*3/t, bit.set/r, STR/s
	:bit.set 32 -> (t/0)
	:bit.set 32 -> (t/1)
	:bit.set 32 -> (t/2)
	:bit.pattern @(t/0) FALSE TRUE
	:bit.pattern @(t/1) FALSE FALSE TRUE
	:bit.pattern @(t/2) FALSE FALSE FALSE TRUE
	:bit.operation < SIZE t t -> &r
	:bit.format @&r "." "X" 8 " " -> &s
.fi
will produce the string (result of the NAND operation here):
.nf
	"XXXXXXX. XXXXXXXX XXX.XXXX XXXXXXX."
.fi
.SS INSTRUCTION bit.cmp bit.set [ = <> ] bit.set -> BLN
This instructions compares two bit sets having the same size.
When the bit sets have not the same size, a bit.size_mismatch interruption is raised.
.P
Equality is obtained when the same bits are activated in both bit sets.
.SS FUNCTION bit.map MUTABLE bit.set PEP:function . *:parameters
Please refer to the instruction bit.map.
.SS INSTRUCTION bit.map MUTABLE bit.set PEP:function . *:parameters
This instruction applies a function with extra parameters on a bit set.
.P
The function prototype shall be:
.nf
	FUNCTION <name> INT : index BLN : bit <extra parameters> -> BLN : new_bit
.fi
When the function does not exist, a FAILURE interruption is raised.
.P
The function is called for each bit of the set with the bit index and its value, and the returned value modifies the value of the bit within the bit set. 
.SH EXAMPLE
.SS Prime numbers
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "svmint.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT INT nb
PROCESS "prime"
        CODE "main" INLINE
                :memory bit.set/acc, bit.set/m, INT/i, INT/stop
                :bit.set @&nb -> &acc
                :bit.set @&nb -> &m
                2 -> &i
        :label main_loop
                :call set_m P
                :bit.any @&acc @&m -> &acc
                :shift &i
                :int.mul @&i @&i -> &stop
                :goto main_loop :when @&stop IN &0*@&nb
                :bit.not @&acc -> &acc
                :bit.modify @&acc 0 FALSE
                :bit.modify @&acc 1 FALSE
                :memory PTR/p
                :bit.index @&acc -> &p
                0 -> &i
        :label display
                :com.message @(@&p/@&i)
                :shift &i
                :goto display :when @&i IN @&p
                :shutdown
        :label set_m
                :memory BLN*@&i/t, INT/j
                0 -> &j
        :label loop_set_m
                FALSE -> (t/@&j)
                :shift &j
                :goto loop_set_m :when @&j IN t
                TRUE -> ((&t+@&i)-1)
                :bit.pattern @&m t
                :int.mul @&i @&i -> &j
                :bit.shift @&m @&j -> &m
                :return
        END
        MEMORY nb
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
