/*
 * Copyright (C) 2025-09-22  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 322 "../plugins/config/core/config.svm_plugin"
#include <string.h>
#include <mutex>
#include <src/includes.h>
#line 27 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN config \n"
		"DEFINE \n"
		"	TYPE config.database \n"
		"	INTERRUPTION config.invalid \n"
		"	INTERRUPTION config.invalid_file \n"
		"	SYSTEM INSTRUCTION config.read [ 'FILE' 'STR' ] STR:source ( PTR | { STR * } ):flags -> config.database \n"
		"	SYSTEM INSTRUCTION config.merge ( PTR | config.database config.database + ) -> config.database \n"
		"	INSTRUCTION config.value config.database ( PTR | < STR * > ) ( 'DEFAULT' VALUE ) ? -> VALUE ? \n"
		"	FUNCTION config.value config.database ( PTR | < STR * > ) ( 'DEFAULT' VALUE ) ? -> VALUE \n"
		"	INSTRUCTION config.array config.database ( PTR | < STR * > ) -> PTR ? \n"
		"	INSTRUCTION config.find config.database STR -> PTR \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 329 "../plugins/config/core/config.svm_plugin"
struct yy_buffer_state;

void parserlex_init(void **);
void parserlex_destroy(void *);
yy_buffer_state* parser_scan_buffer(char *, size_t, void*);
yy_buffer_state* parser_create_buffer(FILE*, int, void *scanner);
void parser_switch_to_buffer(yy_buffer_state*, void *scanner);
void parser_delete_buffer(yy_buffer_state *buffer, void *scanner);
int parserparse(void *scanner, std::shared_ptr<Config::ConfigObject>& object, Config::FlagSet& flags, std::shared_ptr<Config::Error>& error);

std::mutex _lock;
#line 138 "src/plugin.cpp"

extern "C"
{

/* TYPE config.database */

struct type_database
{
#line 1128 "../plugins/config/core/config.svm_plugin"
	operator std::string () const
	{
		std::ostringstream oss;
		_database->format(oss,0);
		return oss.str();
	}

	std::shared_ptr<Config::ConfigObject> _database;
	std::shared_ptr<Config::Error> _error;
#line 157 "src/plugin.cpp"
};

void type_database_delete(const void *svm, void *handler)
{
	type_database * const object = reinterpret_cast<type_database*>(handler);
	{
#line 1139 "../plugins/config/core/config.svm_plugin"

#line 166 "src/plugin.cpp"
	}
	delete object;
}

SVM_String type_database_print(const void *svm, const void *handler)
{
	const type_database *object = reinterpret_cast<const type_database*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 1140 "../plugins/config/core/config.svm_plugin"

#line 178 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* INTERRUPTION config.invalid */


/* INTERRUPTION config.invalid_file */


/* SYSTEM INSTRUCTION config.read [ 'FILE' 'STR' ] STR:source ( PTR | { STR * } ):flags -> config.database */

SVM_Value instruction_read(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1154 "../plugins/config/core/config.svm_plugin"
	auto type = ARGV_KEYWORD(0);
	SVM_String source = ARGV_VALUE(1,string);
	std::set<std::string> flags;
	if(::svm_parameter_type_is_value(svm,argv[2]))
	{
		SVM_Value_Pointer p = ::svm_parameter_value_get(svm,argv[2]);
		SVM_Value_String *flags_array = ::svm_memory_read_pointer_type_internal(svm,CURRENT(kernel),p,STRING);
		for( ; *flags_array ; ++flags_array)
		{
			SVM_String s = ::svm_value_string_get(svm,*flags_array);
			flags.insert(RAW_STRING(s));
		}
	}
	else
	{
		for(SVM_Index i=3 ; i<(argc-1) ; ++i)
		{
			SVM_String s = ARGV_VALUE(i,string);
			flags.insert(RAW_STRING(s));
		}
	}
	Config::FlagSet flagset { flags };
	std::lock_guard<std::mutex> protection(_lock);
	type_database *t = new type_database;
	void *scanner;
	::parserlex_init(&scanner);
	if(type=="FILE")
	{
		auto s = RAW_STRING(source);
		FILE* file = ::fopen(s.c_str(),"r");
		if(not file)
		{
			std::ostringstream oss;
			oss << "Unable to open file " << s << ": " << ::strerror(errno);
			delete t;
			::parserlex_destroy(scanner);
			ERROR_EXTERNAL(config,invalid_file,oss.str().c_str());
		}
		yy_buffer_state* buffer = ::parser_create_buffer(file,16*1024,scanner);
		::parser_switch_to_buffer(buffer,scanner);
		::parserparse(scanner,t->_database,flagset,t->_error);
		::parser_delete_buffer(buffer,scanner);
		::fclose(file);
	}
	else
	{
		char *src = new char[source.size+2];
		::memcpy(src,source.string,source.size);
		src[source.size] = src[source.size+1] = '\0';
		yy_buffer_state *buffer = ::parser_scan_buffer(src,source.size+2,scanner);
		::parserparse(scanner,t->_database,flagset,t->_error);
		::parser_delete_buffer(buffer,scanner);
		delete [] src;
	}
	::parserlex_destroy(scanner);
	if(static_cast<bool>(t->_error))
	{
		std::ostringstream oss;
		oss << (*(t->_error));
		delete t;
		ERROR_EXTERNAL(config,invalid,oss.str().c_str());
	}
	return NEW_PLUGIN(config,database,t);
#line 258 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION config.merge ( PTR | config.database config.database + ) -> config.database */

SVM_Value instruction_merge(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1231 "../plugins/config/core/config.svm_plugin"
	std::list<std::shared_ptr<Config::ConfigObject> > dbs;
	if(argc==1)
	{
		SVM_Value_Plugin *t = ::svm_memory_read_pointer_type_external(svm,CURRENT(kernel),::svm_parameter_value_get(svm,argv[1]),CONST_PEP(config,database));
		for( ; *t ; ++t)
		{
			auto s = reinterpret_cast<type_database*>(::svm_value_plugin_get_internal(svm,*t));
			dbs.push_back(s->_database);
		}
	}
	else
	{
		for(SVM_Index i=0 ; i<argc ; ++i)
		{
			auto s = ARGV_PLUGIN(i,config,database);
			dbs.push_back(s->_database);
		}
	}
	if(dbs.size()<2)
	{
		ERROR_INTERNAL(FAILURE,"Need at least 2 config.database to merge.");
	}
	std::shared_ptr<Config::ConfigElement> merged = dbs.front();
	dbs.pop_front();
	while(not dbs.empty())
	{
		merged = merged->merge(dbs.front());
		dbs.pop_front();
	}
	auto db = std::dynamic_pointer_cast<Config::ConfigObject>(merged);
	if(not db)
	{
		ERROR_INTERNAL(FAILURE,"Resulting merge is not an object.");
	}
	auto r = new type_database;
	r->_database = db;
	return NEW_PLUGIN(config,database,r);
#line 304 "src/plugin.cpp"
}


/* INSTRUCTION config.value config.database ( PTR | < STR * > ) ( 'DEFAULT' VALUE ) ? -> VALUE ? */

SVM_Value instruction_value(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1281 "../plugins/config/core/config.svm_plugin"
	auto db = ARGV_PLUGIN(0,config,database);
	std::list<std::string> path;
	SVM_Index default_index;
	if(::svm_parameter_type_is_value(svm,argv[1]))
	{
		SVM_Value_String *t = ::svm_memory_read_pointer_type_internal(svm,CURRENT(kernel),::svm_parameter_value_get(svm,argv[1]),STRING);
		for( ; *t ; ++t)
		{
			SVM_String s = ::svm_value_string_get(svm,*t);
			path.push_back(RAW_STRING(s));
		}
		default_index = 2;
	}
	else
	{
		SVM_Index end = ::svm_parameter_marker_find_closing(svm,argc,argv,1);
		for(SVM_Index i=2 ; i<(end) ; ++i)
		{
			auto s = ARGV_VALUE(i,string);
			path.push_back(RAW_STRING(s));
		}
		default_index = end+1;
	}
	auto value = db->_database->value(path);
	if(not value)
	{
		SVM_Value default_value = NEW_NULL_VALUE(automatic);
		if(default_index<argc)
		{
			default_value = ::svm_parameter_value_get(svm,argv[argc-1]);
		}
		return default_value;
	}
	return value->value(svm);
#line 347 "src/plugin.cpp"
}


/* FUNCTION config.value config.database ( PTR | < STR * > ) ( 'DEFAULT' VALUE ) ? -> VALUE */

SVM_Variable function_value(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1327 "../plugins/config/core/config.svm_plugin"
	SVM_Value v = instruction_value(svm,argc,argv);
	if(not ::svm_value_state_is_null(svm,v)) return v;
	return NEW_VALUE(string,NEW_STRING(std::string()));
#line 359 "src/plugin.cpp"
}


/* INSTRUCTION config.array config.database ( PTR | < STR * > ) -> PTR ? */

SVM_Value instruction_array(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1338 "../plugins/config/core/config.svm_plugin"
	auto db = ARGV_PLUGIN(0,config,database);
	std::list<std::string> path;
	if(::svm_parameter_type_is_value(svm,argv[1]))
	{
		SVM_Value_String *t = ::svm_memory_read_pointer_type_internal(svm,CURRENT(kernel),::svm_parameter_value_get(svm,argv[1]),STRING);
		for( ; *t ; ++t)
		{
			SVM_String s = ::svm_value_string_get(svm,*t);
			path.push_back(RAW_STRING(s));
		}
	}
	else
	{
		for(SVM_Index i=2 ; i<(argc-1) ; ++i)
		{
			auto s = ARGV_VALUE(i,string);
			path.push_back(RAW_STRING(s));
		}
	}
	auto value = db->_database->array(path);
	if(value.empty())
	{
		return ::svm_value_pointer_new__raw(svm,0,0);
	}
	SVM_Value *t = ::svm_value_array_new(svm,value.size());
	SVM_Value *it=t;
	for(const auto& v:value)
	{
		*it = v->value(svm);
		++it;
	}
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,AUTOMATIC,value.size());
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	::svm_memory_write_pointer(svm,CURRENT(kernel),p,t);
	return p;
#line 404 "src/plugin.cpp"
}


/* INSTRUCTION config.find config.database STR -> PTR */

SVM_Value instruction_find(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1388 "../plugins/config/core/config.svm_plugin"
	auto db = ARGV_PLUGIN(0,config,database);
	auto f = ARGV_VALUE(1,string);
	std::list<std::list<std::string> > paths;
	db->_database->find(RAW_STRING(f),paths,{});
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,POINTER,paths.size());
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	SVM_Value_Pointer *tp = ::svm_value_array_new(svm,paths.size());
	SVM_Index i=0;
	for(const auto& p:paths)
	{
		SVM_Memory_Zone zz = ::svm_memory_zone_new(svm);
		::svm_memory_zone_append_internal__raw(svm,zz,STRING,p.size());
		SVM_Value_Pointer pp = ::svm_memory_allocate(svm,CURRENT(kernel),zz);
		SVM_Value_String *tpp = ::svm_value_array_new(svm,p.size());
		SVM_Index ii = 0;
		for(const auto& s:p)
		{
			SVM_Value_String vs = ::svm_value_string_new__buffer(svm,s.c_str(),s.size());
			tpp[ii++] = vs;
		}
		::svm_memory_write_pointer(svm,CURRENT(kernel),pp,tpp);
		tp[i++]=pp;
	}
	::svm_memory_write_pointer(svm,CURRENT(kernel),p,tp);
	return p;
#line 439 "src/plugin.cpp"
}


/* Generic handling functions */

}
