.TH "Simple Virtual Machine - Plugin enc" 7 "2022-01-30"
.SH SYNOPSIS
.B svm_plugin_enc
A basic encoding and hashing plugin.
.SH DESCRIPTION
This plugin provides low-level encoding and hashing instructions.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginenc/libsvmenc.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS INTERRUPTION enc.bad_encoding
Interruption raised when a decoding from an invalid string is performed.
.SS INSTRUCTION enc.hex [ 'ENCODE' 'DECODE' ] STR -> STR
Encode or decode a string in hexadecimal format.
.P
The encoding produces a string with low case characters.
The decoding can decode a string with mixed case characters, and raises the interruption !enc.bad_encoding if the input string contains characters outside 0-9, a-f and A-F.
.SS INSTRUCTION enc.base64 [ 'ENCODE' 'DECODE' ] STR -> STR
Encode or decode a string in base 64 format.
.TP
The decoding raises the interruption !enc.bad_encoding if the input string contains characters outside base 64 allowed characters.
.SS INSTRUCTION enc.sha1 STR -> STR
Compute the raw SHA-1 hash of the input string.
.SH EXAMPLES
.SS Simple example
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
PROCESS "main"
        CODE "main" INLINE
                :memory STR/s, STR/r
                [ "A test string" ] -> s
                :enc.hex ENCODE @&s -> &r
                :com.message @&r
                :enc.hex DECODE @&r -> &r
                :com.message @&r
                :enc.base64 ENCODE @&r -> &r
                :com.message @&r
                :enc.base64 DECODE @&r -> &r
                :com.message @&r
                :enc.sha1 @&r -> &r
                :enc.hex ENCODE @&r -> &r
                :com.message @&r
        END
END
.fi
.SS A WebSocket handshake response
.nf
#!===SVMBIN===
LOG
PLUGIN "svmstr.so"
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT STR key
PROCESS "websocket"
        CODE "main" INLINE
                :memory STR/r
                :str.join @&key "258EAFA5-E914-47DA-95CA-C5AB0DC85B11" -> &r
                :enc.sha1 @&r -> &r
                :enc.base64 ENCODE @&r -> &r
                :com.message @&r
        END
        MEMORY key
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
