.TH "Simple Virtual Machine - Plugin funccache" 7 "2024-10-27"
.SH SYNOPSIS
.B svm_plugin_funccache
Function call cache optimization
.SH DESCRIPTION
This plugin implements a function call cache to optimize code on deterministic functions.
.P
The cache is available in two flavours: Either unlimited or limited to a certain number of entries when the option funccache.limit is set.
.P
When the limit is set, the eviction policy is an hybrid between the "Oldest" call and the "Less used" call: Among all the cache entries,
.IP
1) The funccache.policy option% (70% per default) oldest entries are selected,
.IP
2) Among the selected, the least used are selected,
.IP
3) Among the remaining ones, the oldest is selected.
.P
The cache is populated when a cached function call returns.
.I To ensure a correct cache population, the cached function shall be deterministic and ensure only input and output parameters are kept in the P pointer.
All input parameters should be left untouched by the function.
Also, all local variables within the P pointer shall be cleared, or more cache misses will occurs, leading to less performance.
.P
The cache is ordered by the function symbol and its parameters.
A total order is required on each parameter type to have a function eligible to call caching.
By default, only strong order is accepted, but the option funccache.weak allows weak ordering as well.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginfunccache/libsvmfunccache.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS OPTION funccache.weak -w BLN
This option allows weak total ordering of parameters in the cache.
.SS OPTION funccache.limit -l INT
This option enables cache entries limitation.
.SS OPTION funccache.policy -p INT
This option sets the eviction policy when the cache limit is set and the size of the cache reached the limit.
.SS WAITING INSTRUCTION funccache.call [ STR SYM ] PTR
This instruction performs a cached call to the function with its parameters.
.P
The instruction first searchs whether the function call is already in cache.
During this process, each non-initialised address in the function parameters is ignored to check the cache entries conformity.
.P
If a cache entry matches the function call, all parameters are filled with cache entry parameters.
Otherwise, the function call is performed after setting a callback on function return to store the function call result.
.P
.I
The function shall ensure to clean all local values in the function parameters before returning to avoid cache polution.
.SS WAITING INSTRUCTION funccache.statistics MUTABLE INT 6
This instruction returns some statistics about the cache.
.IP
The first integer is the cache size.
.IP
The second integer is the number of cache reads.
.IP
The third integer is the number of cache hits.
.IP
The fourth integer is the number of cache misses (when the call has to be performed).
.IP
The fifth integer is the number of cache writes.
.IP
The sixth integer is the number of cache evictions.
.SS SYSTEM INSTRUCTION funccache.print
This instruction prints on a trace the cache content, mainly for debugging purpose.
.SH EXAMPLE
.SS Fibonacci
.nf
#!/usr/bin/env svm
LOG
PLUGIN "===PLUGINLIB===" -l 3
PLUGIN "svmint.so"
PLUGIN "svmcom.so"
ARGUMENT INT nb
PROCESS "fib"
	CODE "main" INLINE
		:memory (PTR, INT, INT)/p
		[ , @&nb , ] -> p
		:funccache.call "fib" p
		:com.message @(p/2)
		:shutdown
	:label fib
		:goto fib_rec :unless @(P/1) IN &0*2
		@(P/1) -> (P/2)
		:return
	:label fib_rec
		:memory (PTR, INT, INT)*2 -> &P
		:int.sub @(P/1) 1 -> (@&P/1)
		:funccache.call "fib" &@&P*3
		:int.sub @(P/1) 2 -> (@&P/4)
		:funccache.call "fib" (@&P/3)*3
		:int.add @(@&P/2) @(@&P/5) -> (P/2)
		# This instruction is crucial for the cache population:
		# Local variables shall never be part of the cache.
		[ ] -> &P*1
		:return
	END
	MEMORY nb
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
