.TH "Simple Virtual Machine - Plugin html" 7 "2022-03-20"
.SH SYNOPSIS
.B svm_plugin_html
Plugin to manage HTML documents
.SH DESCRIPTION
This plugin is an HTML document manager allowing operations on the DOM.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginhtml/libsvmhtml.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS TYPE html.dom
This type contains a representation of a full HTML document.
.SS TYPE html.element
This type contains a representation of an HTML node or text.
.SS INSTRUCTION html.text STR -> html.element
This instruction creates an HTML element containing a raw text.
.SS INSTRUCTION html.comment STR -> html.element
This instruction creates an HTML element containing the text surrounded by <!-- and -->.
.SS INSTRUCTION html.meta STR -> html.element
This instruction creates an HTML element containing the text surrounded by <? and ?>.
.SS INSTRUCTION html.node STR:type ( , STR:attribute_key = STR:attribute_value ) * ( { html.element + } ) ? -> html.element
This instruction creates an HTML node with a type (the name between < and >), attributes (key="value") and optional content (between <name> and </name>).
.SS INSTRUCTION html.insert MUTABLE html.element:parent INT:index 'END' ? html.element:child
This instruction inserts into a node a child element.

The child element is insert at the specified index.
When the keyword END is present, the index 0 matches the element after the last element (Inserting at 0 END means adding at the end).

If the parent element is not a node, or when the insertion index is outside the node children list, a FAILURE interruption is raised.

.I Adding as child an element being the parent of the node will also raise a FAILURE interruption.
.SS INSTRUCTION html.replace MUTABLE html.element:parent INT:index 'END' ? html.element:child
This instruction replaces a child of a node by another element.

The child element is replaced at the specified index.
When the keyword END is present, the index 0 matches the element after the last element (Inserting at 0 END means adding at the end).

If the parent element is not a node, or when the replacement index is outside the node children list, a FAILURE interruption is raised.

.I Adding as child an element being the parent of the node will also raise a FAILURE interruption.
.SS INSTRUCTION html.remove MUTABLE html.element:parent ( INT:index 'END' ? | html.element:child )
This instruction removes a child of a node.

The child element is removed at the specified index.
When the keyword END is present, the index 0 matches the element after the last element (Inserting at 0 END means adding at the end).

If the parent element is not a node, or when the replacement index is outside the node children list, a FAILURE interruption is raised.
.SS INSTRUCTION html.dom html.element + -> html.dom
This instruction transforms a list of HTML element into an HTML DOM.
.SS INSTRUCTION html.id html.dom STR:id -> html.element ?
This instruction returns the first HTML element within the DOM having the "id" attribute set to the parameter.

When not found, the null HTML element is returned.
.SS INSTRUCTION html.class html.dom STR:class -> PTR
This instruction returns a pointer on an array of HTML elements within the DOM having the "class" attribute containing the parameter.
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
