/*
 * Copyright (C) 2022-03-20  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 32 "../plugins/html/core/html.svm_plugin"
#include <iostream>
#include <algorithm>
#include <mutex>
#include <string.h>
#include <src/html.h>
#include <src/parser/includes.h>
#line 30 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN html \n"
		"DEFINE \n"
		"	TYPE html.dom \n"
		"	TYPE html.element \n"
		"	INSTRUCTION html.text STR -> html.element \n"
		"	INSTRUCTION html.comment STR -> html.element \n"
		"	INSTRUCTION html.meta STR -> html.element \n"
		"	INSTRUCTION html.node STR:type ( , STR:attribute_key = STR:attribute_value ) * ( { html.element + } ) ? -> html.element \n"
		"	INSTRUCTION html.insert MUTABLE html.element:parent INT:index 'END' ? html.element:child \n"
		"	INSTRUCTION html.replace MUTABLE html.element:parent INT:index 'END' ? html.element:child \n"
		"	INSTRUCTION html.remove MUTABLE html.element:parent ( INT:index 'END' ? | html.element:child ) \n"
		"	INSTRUCTION html.dom html.element + -> html.dom \n"
		"	INSTRUCTION html.id html.dom STR:id -> html.element ? \n"
		"	INSTRUCTION html.class html.dom STR:class -> PTR \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 42 "../plugins/html/core/html.svm_plugin"
struct yy_buffer_state;

void htmlparserlex_init(void **);
void htmlparserlex_destroy(void *);
yy_buffer_state* htmlparser_scan_buffer(char *, size_t, void*);
void htmlparser_delete_buffer(yy_buffer_state *buffer, void *scanner);
int htmlparserparse(void *scanner, Html::Dom &dom);

std::mutex _lock;
#line 142 "src/plugin.cpp"

extern "C"
{

/* TYPE html.dom */

struct type_dom
{
#line 660 "../plugins/html/core/html.svm_plugin"
	type_dom()
	:_dom(std::make_shared<Html::Dom>())
	{ }
	type_dom(const type_dom& dom)
	:_dom(std::make_shared<Html::Dom>(*(dom._dom)))
	{
	}
	Html::Dom::SP _dom;
	operator std::string () const
	{
		std::ostringstream oss;
		oss << (*_dom);
		return oss.str();
	}
#line 166 "src/plugin.cpp"
};

void type_dom_delete(const void *svm, void *handler)
{
	type_dom * const object = reinterpret_cast<type_dom*>(handler);
	{
#line 676 "../plugins/html/core/html.svm_plugin"

#line 175 "src/plugin.cpp"
	}
	delete object;
}

void* type_dom_copy(const void *svm, const void *handler)
{
	const type_dom *object = reinterpret_cast<const type_dom*>(handler);
	type_dom *copy = new type_dom(*object);
	{
#line 677 "../plugins/html/core/html.svm_plugin"

#line 187 "src/plugin.cpp"
	}
	return copy;
}

void* type_dom_constant(const void *svm, const SVM_String value)
{
#line 679 "../plugins/html/core/html.svm_plugin"
	std::lock_guard<std::mutex> protection(_lock);
	void *scanner;
	::htmlparserlex_init(&scanner);
	char *src = new char[value.size+2];
	::memcpy(src,value.string,value.size);
	src[value.size] = src[value.size+1] = '\0';
	yy_buffer_state *buffer = ::htmlparser_scan_buffer(src,value.size+2,scanner);
	type_dom *t = new type_dom;
	::htmlparserparse(scanner,*(t->_dom));
	::htmlparser_delete_buffer(buffer,scanner);
	delete [] src;
	::htmlparserlex_destroy(scanner);
	return t;
#line 208 "src/plugin.cpp"
}

SVM_String type_dom_print(const void *svm, const void *handler)
{
	const type_dom *object = reinterpret_cast<const type_dom*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 694 "../plugins/html/core/html.svm_plugin"

#line 218 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* TYPE html.element */

struct type_element
{
#line 698 "../plugins/html/core/html.svm_plugin"
	type_element() = default;
	type_element(const type_element& te)
	{
		_element = te._element->clone();
	}
	operator std::string () const
	{
		std::ostringstream oss;
		oss << _element;
		return oss.str();
	}
	Html::Element::SP _element;

#line 242 "src/plugin.cpp"
};

void type_element_delete(const void *svm, void *handler)
{
	type_element * const object = reinterpret_cast<type_element*>(handler);
	{
#line 713 "../plugins/html/core/html.svm_plugin"

#line 251 "src/plugin.cpp"
	}
	delete object;
}

void* type_element_copy(const void *svm, const void *handler)
{
	const type_element *object = reinterpret_cast<const type_element*>(handler);
	type_element *copy = new type_element(*object);
	{
#line 714 "../plugins/html/core/html.svm_plugin"

#line 263 "src/plugin.cpp"
	}
	return copy;
}

SVM_String type_element_print(const void *svm, const void *handler)
{
	const type_element *object = reinterpret_cast<const type_element*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 715 "../plugins/html/core/html.svm_plugin"

#line 275 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* INSTRUCTION html.text STR -> html.element */

SVM_Value instruction_text(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 719 "../plugins/html/core/html.svm_plugin"
	auto text = ARGV_VALUE(0,string);
	type_element *t = new type_element;
	t->_element = std::make_shared<Html::Text>(std::string(text.string,text.size));
	return NEW_PLUGIN(html,element,t);
#line 290 "src/plugin.cpp"
}


/* INSTRUCTION html.comment STR -> html.element */

SVM_Value instruction_comment(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 728 "../plugins/html/core/html.svm_plugin"
	auto text = ARGV_VALUE(0,string);
	type_element *t = new type_element;
	t->_element = std::make_shared<Html::Comment>(std::string(text.string,text.size));
	return NEW_PLUGIN(html,element,t);
#line 303 "src/plugin.cpp"
}


/* INSTRUCTION html.meta STR -> html.element */

SVM_Value instruction_meta(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 737 "../plugins/html/core/html.svm_plugin"
	auto text = ARGV_VALUE(0,string);
	type_element *t = new type_element;
	t->_element = std::make_shared<Html::Meta>(std::string(text.string,text.size));
	return NEW_PLUGIN(html,element,t);
#line 316 "src/plugin.cpp"
}


/* INSTRUCTION html.node STR:type ( , STR:attribute_key = STR:attribute_value ) * ( { html.element + } ) ? -> html.element */

SVM_Value instruction_node(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 746 "../plugins/html/core/html.svm_plugin"
	auto type = ARGV_VALUE(0,string);
	auto node = std::make_shared<Html::Node>(std::string(type.string,type.size));
	std::map<std::string, std::string> attributes;
	size_t index = 1;
	for( ; index<argc ; index+=4)
	{
		auto marker = ARGV_MARKER(index);
		if(marker=="{") break;
		auto key = ARGV_VALUE(index+1,string);
		auto value = ARGV_VALUE(index+3,string);
		attributes.insert(std::make_pair(std::string(key.string,key.size),std::string(value.string,value.size)));
	}
	std::vector<Html::Element::SP> children;
	for( ++index ; index<argc ; ++index)
	{
		if(::svm_parameter_type_is_marker(svm,argv[index])) break;
		auto child = ARGV_PLUGIN(index,html,element);
		child->_element->_parents.insert(node);
		children.push_back(child->_element);
	}
	type_element *t = new type_element;
	node->_attributes = attributes;
	node->_children = children;
	node->id_and_class();
	t->_element = node;
	return NEW_PLUGIN(html,element,t);

#line 352 "src/plugin.cpp"
}


/* INSTRUCTION html.insert MUTABLE html.element:parent INT:index 'END' ? html.element:child */

SVM_Value instruction_insert(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 781 "../plugins/html/core/html.svm_plugin"
	auto raw_parent = ARGV_PLUGIN(0,html,element);
	auto parent = std::dynamic_pointer_cast<Html::Node>(raw_parent->_element);
	if(not parent)
	{
		ERROR_INTERNAL(FAILURE,"Parent is not a node");
	}
	auto index = ARGV_VALUE(1,integer);
	size_t position = 2;
	if(::svm_parameter_type_is_keyword(svm,argv[position]))
	{
		++position;
		index += parent->_children.size();
	}
	auto child = ARGV_PLUGIN(position,html,element);
	if((index>=0) and (index<parent->_children.size()))
	{
		parent->_children.insert(parent->_children.begin()+index,child->_element);
	}
	else if(index==parent->_children.size())
	{
		if(not parent->verification(child->_element))
		{
			ERROR_INTERNAL(FAILURE,"HTML element cycle detected");
		}
		parent->_children.push_back(child->_element);
		child->_element->_parents.insert(parent);
	}
	else
	{
		ERROR_INTERNAL(FAILURE,"Out of range");
	}
#line 392 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION html.replace MUTABLE html.element:parent INT:index 'END' ? html.element:child */

SVM_Value instruction_replace(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 827 "../plugins/html/core/html.svm_plugin"
	auto raw_parent = ARGV_PLUGIN(0,html,element);
	auto parent = std::dynamic_pointer_cast<Html::Node>(raw_parent->_element);
	if(not parent)
	{
		ERROR_INTERNAL(FAILURE,"Parent is not a node");
	}
	auto index = ARGV_VALUE(1,integer);
	size_t position = 2;
	if(::svm_parameter_type_is_keyword(svm,argv[position]))
	{
		++position;
		index += parent->_children.size();
	}
	auto child = ARGV_PLUGIN(position,html,element);
	if((index>=0) and (index<parent->_children.size()))
	{
		if(not parent->verification(child->_element))
		{
			ERROR_INTERNAL(FAILURE,"HTML element cycle detected");
		}
		auto it = parent->_children[index]->_parents.find(parent);
		parent->_children[index]->_parents.erase(it);
		parent->_children[index] = child->_element;
		child->_element->_parents.insert(parent);
	}
	else
	{
		ERROR_INTERNAL(FAILURE,"Out of range");
	}
#line 431 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION html.remove MUTABLE html.element:parent ( INT:index 'END' ? | html.element:child ) */

SVM_Value instruction_remove(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 871 "../plugins/html/core/html.svm_plugin"
	auto raw_parent = ARGV_PLUGIN(0,html,element);
	auto parent = std::dynamic_pointer_cast<Html::Node>(raw_parent->_element);
	if(not parent)
	{
		ERROR_INTERNAL(FAILURE,"Parent is not a node");
	}
	SVM_Value value = ::svm_parameter_value_get(svm,argv[1]);
	if(::svm_value_type_is_integer(svm,value))
	{
		auto index = ::svm_value_integer_get(svm,value);
		size_t position = 2;
		if(::svm_parameter_type_is_keyword(svm,argv[position]))
		{
			++position;
			index += parent->_children.size();
		}
		if((index>=0) and (index<parent->_children.size()))
		{
			auto it = parent->_children[index]->_parents.find(parent);
			parent->_children[index]->_parents.erase(it);
			parent->_children.erase(parent->_children.begin()+index);
		}
		else
		{
			ERROR_INTERNAL(FAILURE,"Out of range");
		}
	}
	else
	{
		auto child = ARGV_PLUGIN(1,html,element);
		auto it = std::find(parent->_children.begin(),parent->_children.end(),child->_element);
		if(it!=parent->_children.end())
		{
			auto itt = (*it)->_parents.find(parent);
			(*it)->_parents.erase(itt);
			parent->_children.erase(it);
		}
	}
#line 479 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION html.dom html.element + -> html.dom */

SVM_Value instruction_dom(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 922 "../plugins/html/core/html.svm_plugin"
	type_dom *t = new type_dom;
	for(size_t index=0 ; index<argc ; ++index)
	{
		auto element = ARGV_PLUGIN(index,html,element);
		t->_dom->_root.push_back(element->_element);
	}
	return NEW_PLUGIN(html,dom,t);
#line 496 "src/plugin.cpp"
}


/* INSTRUCTION html.id html.dom STR:id -> html.element ? */

SVM_Value instruction_id(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 937 "../plugins/html/core/html.svm_plugin"
	auto dom = ARGV_PLUGIN(0,html,dom);
	auto id = ARGV_VALUE(1,string);
	auto element = dom->_dom->id(std::string(id.string,id.size));
	if(not element)
	{
		return NEW_NULL_PLUGIN(html,element);
	}
	type_element *t = new type_element();
	t->_element = element;
	return NEW_PLUGIN(html,element,t);
#line 515 "src/plugin.cpp"
}


/* INSTRUCTION html.class html.dom STR:class -> PTR */

SVM_Value instruction_class(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 957 "../plugins/html/core/html.svm_plugin"
	auto dom = ARGV_PLUGIN(0,html,dom);
	auto class_name = ARGV_VALUE(1,string);
	auto elements = dom->_dom->in_class(std::string(class_name.string,class_name.size));
	SVM_Memory_Zone zone = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_external__raw(svm,zone,CONST_PEP(html,element),elements.size());
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),zone);
	SVM_Address a = ::svm_value_pointer_get_address(svm,p);
	for(auto& e:elements)
	{
		type_element *t = new type_element();
		t->_element = e;
		::svm_memory_write_address(svm,CURRENT(kernel),a++,NEW_PLUGIN(html,element,t));
	}
	return p;
#line 538 "src/plugin.cpp"
}


/* Generic handling functions */

}
