.TH "Simple Virtual Machine - Plugin http" 7 "2022-01-30"
.SH SYNOPSIS
.B svm_plugin_http
Low level HTTP support plugin.
.SH DESCRIPTION
This plugin provides low level handling of HTTP queries and replies.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginhttp/libsvmhttp.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH DEPENDENCIES
.SS TYPE com.device
This plugin is designed to work with the official plugin com.
.SH CONTENT
.SS FUNCTION http.protocol_mesg_1_1 STR BLN -> INT ?
Define the http.mesg_1_1 protocol.
.SS TYPE http.mesg_1_1
Contain an HTTP query or reply.
.TP
This type supports copy, constant construction and string rendering.
.SS INTERRUPTION http.bad_mesg_1_1
Interruption raised when a wrong string is parsed to create an HTTP message.
.SS INSTRUCTION http.decode STR -> http.mesg_1_1
Create an HTTP query or reply from a string.
The string can be received from a com.device.
.TP
This instruction raises an !http.bad_mesg_1_1 when the string is ill-formed.
.SS INSTRUCTION http.encode http.mesg_1_1 -> STR
Create a string representing the HTTP query or reply.
This string can be sent over a com.device.
.SS INTERRUPTION http.bad_returncode
Interruption raised when a reply is set with an invalid return code.
.SS INSTRUCTION http.new ( 'QUERY' [ 'GET' 'HEAD' 'POST' 'PUT' 'DELETE' 'CONNECT' 'OPTIONS' 'TRACE' 'PATCH' ]:method STR:uri STR:hostname | 'REPLY' INT:return_code ) -> http.mesg_1_1
Create a new HTTP query or reply with mandatory parameters.
.TP
The instruction raises an !http.bad_returncode when an invalid return code is provided.
.SS INSTRUCTION http.query http.mesg_1_1 -> BLN
Return TRUE when the HTTP message is a query.
.SS INSTRUCTION http.reply http.mesg_1_1 -> BLN
Return TRUE when the HTTP message is a reply.
.SS INTERRUPTION http.bad_mesgtype
Interruption raised when an instruction is applied on the wrong HTTP message type.
.SS INSTRUCTION http.get_method http.mesg_1_1 -> STR
Return the method on HTTP queries.
.SS INSTRUCTION http.set_method MUTABLE http.mesg_1_1 STR
Change the method on HTTP queries.
.SS INSTRUCTION http.get_uri http.mesg_1_1 -> STR
Return the URI on HTTP queries.
.SS INSTRUCTION http.set_uri MUTABLE http.mesg_1_1 STR
Change the URI on HTTP queries.
.SS INSTRUCTION http.get_returncode http.mesg_1_1 -> INT
Return the return code on HTTP replies.
.SS INSTRUCTION http.set_returncode MUTABLE http.mesg_1_1 INT
Change the return code on HTTP replies.
.SS INSTRUCTION http.get_header http.mesg_1_1 STR:key -> STR ?:value
Return the value of an header on HTTP query or reply from its key.
.TP
Return the null string when the header key is not found.
.SS INSTRUCTION http.set_header MUTABLE http.mesg_1_1 STR:key STR ?:value
Change a value of an header on HTTP query or reply.
.TP
When the value parameter is a null string, the header is removed.
Otherwise, the header value is added or modified.
.SS INSTRUCTION http.get_headers http.mesg_1_1 -> PTR
Return a pointer on an array of arrays.
The main array contains one pointer by header in the HTTP query or reply.
Each header pointer contains a two strings array:
 - The first one is the header key,
 - The second one is the header value.
.SS INSTRUCTION http.set_headers MUTABLE http.mesg_1_1 PTR
Change the headers on an HTTP query or reply.
The pointer references an array of arrays like the return value of the instruction
.IR :http.get_headers .
.SS INSTRUCTION http.get_payload http.mesg_1_1 -> STR
Return the payload on an HTTP query or reply.
.SS INSTRUCTION http.set_payload MUTABLE http.mesg_1_1 STR 'LENGTH' ?
Change the payload on an HTTP query or reply.
.TP
The instruction also adds/modifies the Content-Length header with the size of the payload when the keyword LENGTH is present.
.SH EXAMPLE
.SS A simple HTTP echo server
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT STR port
PROCESS "main"
        CODE "main" INLINE
                :memory com.device/s, com.device/c, http.mesg_1_1/h, STR/t
                :com.open com.tcp < "0.0.0.0" @&port -> &s
        :label loop
                :com.command @&s CLIENT -> &c
                :com.read @&c http.mesg_1_1 -> &t
                :http.new REPLY 200 -> &h
                :http.set_payload @&h @&t LENGTH
                :com.write @&c @&h
                :goto loop
        END
        MEMORY port
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.BR svm_plugin_com (7)
for networking.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
