.TH "Simple Virtual Machine - Plugin inline" 7 "2022-03-07"
.SH SYNOPSIS
.B svm_plugin_inline
Plugin engine to inline code within files
.SH DESCRIPTION
This plugin allows construction of files by inlining SVM code in the file.
.P
The inlined code shall be surrounded by a starting and an ending tag.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmplugininline/libsvminline.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH DEPENDENCIES
.SS TYPE com.device
The inline plugin provides a com.device interface to generate the file.
.SS WAITING INSTRUCTION com.write com.device STR
This instruction is used to render constant parts of the file.
.SH CONTENT
.SS INSTRUCTION inline.generate STR:file STR:start STR:end PTR:arguments 'PROTECTED' ?
This instruction is the core of this plugin, and can be called to compute an instance of a inlined file.
.P
 - The first parameter contains the source of the file with inlined code,
 - The second and third parameters contains the SVM code delimiters within the inlined code (like <?svm and ?> in HTML),
 - The fourth parameter are the arguments available within the inlined code,
 - The optional fifth parameter switch the execution of inlined code in protected mode.
.P
Please note that the inlined code shall be surrounded by the start and end delimiters.
.P
Among the arguments available to the inlined code, it is required to put at the first position a com.device value accepting the write operation, like the inline.file device.
This first argument can be used by the code to provide the content of the generated file.
Other arguments are free and can be used as input and output by the inlined code.
.P
Finally, it is recommended to run this instruction in a process having the sequencer inline.generator, and use the inline.file device type to generate the file.
.SS STRUCT inline.file
This structure contains the definition of the device containing the resulting file.
.SS FUNCTION inline.device_file_open -> $inline.file
This function is used to open an inline.file device.
.SS FUNCTION inline.device_file_print $inline.file -> STR
This function is used to print an inline.file device.
.SS FUNCTION inline.device_file_read $inline.file -> STR ?
This function is used to read from an inline.file device.
.SS FUNCTION inline.device_file_write $inline.file STR
This function is used to write to an inline.file device.
.SS FUNCTION inline.device_file_command $inline.file . * -> VALUE ?
This function is used to get the full content of an inline.file device, by using the GET command on the device.
.SS FUNCTION inline.device_file_close $inline.file -> BLN
This function is used to close an inline.file device.
.SS SEQUENCER inline.generator
This sequencer is specific to the instruction inline.generate.
.P
The instruction creates several kernels, attachs them in a particular way supported by this sequencer and suspends the current kernel.
Then this sequencer will run the attached kernels in the order the instruction attached them, and will provide to all the kernels the same memory.
.P
When an attached kernel is interrupted or the last attached kernel is terminated, the main kernel is activated back.
The eventual interruption is transmitted to the main kernel.
.SH EXAMPLE
.SS HTML
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="

PROCESS "test"
	CODE "main" INLINE
		:memory com.device/file, STR/text, com.device/result
		:com.open com.file < "text.html" -> &file
		:com.read @&file com.all -> &text
		:com.open inline.file -> &result
		:interruption FAILURE fail
		:interruption MEMORY fail
		:interruption SECURITY fail
		:inline.generate @&text "<?svm" "?>" result PROTECTED
		:com.command @&result GET -> &text
		:com.message @&text
		:shutdown
	:label fail
		:com.message STDERR "Error occured"
	END
	SEQUENCER inline.generator
END
.fi
.B
Content of text.html:
.nf
<html>
	<head>
		<title>Example</title>
		<style>
			table, th, td
			{
				border: solid 1px;
			}
		</style>
	</head>
	<body>
		<?svm
	:memory INT/i, INT/j
	2 -> &i
	2 -> &j
	?><p>2+2=<?svm
	:shift @&j &i
	:com.write @&P @&i
	?>.</p>
		<table>
			<tr><th>i</th><th>sum 0 -&gt; i</th></tr>
<?svm
	:interruption MEMORY ignore
	:memory INT/s
	0 -> &s
	0 -> &i
:label loop
	:com.write @&P "\t\t\t<tr><td>" @&i "</td><td>" @&s "</td></tr>\n"
	:shift @&i &s
	:shift &i
	:shift &P
	:goto loop :when @&i IN &0*10
	:shutdown
:label ignore
	:return
	?>		</table>
	</body>
</html>
.fi
.B
Produces:
.nf
<html>
	<head>
		<title>Example</title>
		<style>
			table, th, td
			{
				border: solid 1px;
			}
		</style>
	</head>
	<body>
		<p>2+2=4.</p>
		<table>
			<tr><th>i</th><th>sum 0 -&gt; i</th></tr>
			<tr><td>0</td><td>0</td></tr>
			<tr><td>1</td><td>0</td></tr>
			<tr><td>2</td><td>1</td></tr>
			<tr><td>3</td><td>3</td></tr>
			<tr><td>4</td><td>6</td></tr>
			<tr><td>5</td><td>10</td></tr>
			<tr><td>6</td><td>15</td></tr>
			<tr><td>7</td><td>21</td></tr>
			<tr><td>8</td><td>28</td></tr>
			<tr><td>9</td><td>36</td></tr>
		</table>
	</body>
</html>

.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
