/*
 * Copyright (C) 2022-03-07  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 128 "../plugins/inline/core/inline.svm_plugin"
#include <list>
#include <vector>
#line 26 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN inline \n"
		"USE \n"
		"	TYPE com.device \n"
		"	WAITING INSTRUCTION com.write com.device STR \n"
		"DEFINE \n"
		"	INSTRUCTION inline.generate STR:file STR:start STR:end PTR:arguments 'PROTECTED' ? \n"
		"	STRUCT inline.file \n"
		"	FUNCTION inline.device_file_open -> $inline.file \n"
		"	FUNCTION inline.device_file_print $inline.file -> STR \n"
		"	FUNCTION inline.device_file_read $inline.file -> STR ? \n"
		"	FUNCTION inline.device_file_write $inline.file STR \n"
		"	FUNCTION inline.device_file_command $inline.file . * -> VALUE ? \n"
		"	FUNCTION inline.device_file_close $inline.file -> BLN \n"
		"	SEQUENCER inline.generator \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif


/* INSTRUCTION inline.generate STR:file STR:start STR:end PTR:arguments 'PROTECTED' ? */

SVM_Value instruction_generate(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 144 "../plugins/inline/core/inline.svm_plugin"
	SVM_String raw_file = ARGV_VALUE(0,string);
	SVM_String raw_start = ARGV_VALUE(1,string);
	SVM_String raw_end = ARGV_VALUE(2,string);
	std::string file(raw_file.string,raw_file.size);
	std::string start(raw_start.string,raw_start.size);
	std::string end(raw_end.string,raw_end.size);
	std::vector<std::string> fragments;
	for( ; ; )
	{
		auto its = file.find(start);
		if(its==std::string::npos)
		{
			fragments.push_back(file);
			break;
		}
		fragments.push_back(file.substr(0,its));
		file = file.substr(its+start.size());
		auto ite = file.find(end);
		if(ite==std::string::npos)
		{
			fragments.push_back(file);
			break;
		}
		fragments.push_back(file.substr(0,ite));
		file = file.substr(ite+end.size());
	}
	bool text = true;
	bool first = true;
	for(auto& f:fragments)
	{
		SVM_Code code;
		if(text)
		{
			std::ostringstream oss;
			oss << ":com.write @&P \"\"\"" << f << "\"\"\"\n";
			code = ::svm_code_new__raw(svm,"text",oss.str().c_str());
		}
		else
		{
			code = ::svm_code_new__raw(svm,"inline",f.c_str());
		}
		SVM_Kernel k = ::svm_kernel_new_code(svm,TRUE,FALSE,argc>4?TRUE:FALSE,nullptr,code);
		if(first)
		{
			SVM_Value_Pointer p = ::svm_parameter_value_get(svm,argv[3]);
			SVM_Memory_Zone zone = ::svm_memory_zone_new(svm);
			::svm_memory_zone_append_internal__raw(svm,zone,AUTOMATIC,::svm_value_pointer_get_size(svm,p));
			SVM_Value_Pointer cp = ::svm_memory_allocate(svm,k,zone);
			::svm_memory_share(svm,::svm_kernel_get_current(svm),p,k,cp);
			::svm_memory_synchronisation_disable(svm,k,cp);
			::svm_processor_set_currentpointer(svm,k,cp);
			first = false;
		}
		::svm_process_kernel_attach(svm,::svm_process_get_current(svm),k,1,nullptr);
		text = not text;
	}
	::svm_kernel_suspend(svm,::svm_kernel_get_current(svm));
#line 189 "src/plugin.cpp"
	return nullptr;
}


/* STRUCT inline.file */

struct struct_file
{
#line 222 "../plugins/inline/core/inline.svm_plugin"
	std::ostringstream _oss;
	std::ostringstream _dump;
#line 201 "src/plugin.cpp"
};

void struct_file_delete(const void *svm, void *handler)
{
	struct_file * const object = reinterpret_cast<struct_file*>(handler);
	{
#line 226 "../plugins/inline/core/inline.svm_plugin"

#line 210 "src/plugin.cpp"
	}
	delete object;
}


/* FUNCTION inline.device_file_open -> $inline.file */

SVM_Variable function_device_file_open(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 230 "../plugins/inline/core/inline.svm_plugin"
	struct_file *f = new struct_file();
	return NEW_STRUCT(inline,file,f);
#line 223 "src/plugin.cpp"
}


/* FUNCTION inline.device_file_print $inline.file -> STR */

SVM_Variable function_device_file_print(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 237 "../plugins/inline/core/inline.svm_plugin"
	struct_file *f = ARGV_STRUCT(0,inline,file);
	return ::svm_value_string_new__buffer(svm,f->_dump.str().c_str(),f->_dump.str().size());
#line 234 "src/plugin.cpp"
}


/* FUNCTION inline.device_file_read $inline.file -> STR ? */

SVM_Variable function_device_file_read(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 244 "../plugins/inline/core/inline.svm_plugin"
	struct_file *f = ARGV_STRUCT(0,inline,file);
	std::string s = f->_oss.str();
	f->_oss.str("");
	if(s.empty())
	{
		return NEW_NULL_VALUE(string);
	}
	return ::svm_value_string_new__buffer(svm,s.c_str(),s.size());
#line 251 "src/plugin.cpp"
}


/* FUNCTION inline.device_file_write $inline.file STR */

SVM_Variable function_device_file_write(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 257 "../plugins/inline/core/inline.svm_plugin"
	struct_file *f = ARGV_STRUCT(0,inline,file);
	SVM_String rs = ARGV_VALUE(1,string);
	std::string s(rs.string,rs.size);
	f->_oss << s;
	f->_dump << s;
#line 265 "src/plugin.cpp"
	return nullptr;
}


/* FUNCTION inline.device_file_command $inline.file . * -> VALUE ? */

SVM_Variable function_device_file_command(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 267 "../plugins/inline/core/inline.svm_plugin"
	struct_file *f = ARGV_STRUCT(0,inline,file);
	if(argc<2)
	{
		ERROR_INTERNAL(DEVICE,"Missing command");
	}
	if(not ::svm_parameter_type_is_keyword(svm,argv[1]))
	{
		ERROR_INTERNAL(DEVICE,"Invalid command");
	}
	auto cmd = ARGV_KEYWORD(1);
	if(cmd=="GET")
	{
		std::string s = f->_dump.str();
		f->_oss.str("");
		f->_dump.str("");
		return ::svm_value_string_new__buffer(svm,s.c_str(),s.size());
	}
	return NEW_NULL_VALUE(string);
#line 293 "src/plugin.cpp"
}


/* FUNCTION inline.device_file_close $inline.file -> BLN */

SVM_Variable function_device_file_close(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 293 "../plugins/inline/core/inline.svm_plugin"
	return NEW_VALUE(boolean,TRUE);
#line 303 "src/plugin.cpp"
}


/* SEQUENCER inline.generator */

struct sequencer_generator
{
#line 300 "../plugins/inline/core/inline.svm_plugin"
	sequencer_generator()
	:_main(nullptr) {};
	SVM_Kernel _main;
	std::list<SVM_Kernel> _workers;
#line 316 "src/plugin.cpp"
};

void* sequencer_generator_create(const void *svm)
{
	sequencer_generator *object = new sequencer_generator();
	{
#line 307 "../plugins/inline/core/inline.svm_plugin"

#line 325 "src/plugin.cpp"
	}
	return object;
}

void sequencer_generator_delete(const void *svm, void *handler)
{
	sequencer_generator * const object = reinterpret_cast<sequencer_generator*>(handler);
	{
#line 310 "../plugins/inline/core/inline.svm_plugin"
	if(object->_main)
	{
		::svm_variable_scope_set_local(svm,object->_main);
	}
	for(auto& k:object->_workers)
	{
		::svm_variable_scope_set_local(svm,k);
	}
#line 343 "src/plugin.cpp"
	}
	delete object;
}

SVM_Kernel sequencer_generator_current(const void *svm, void *handler)
{
	sequencer_generator *object = reinterpret_cast<sequencer_generator*>(handler);
	{
#line 321 "../plugins/inline/core/inline.svm_plugin"
	if(not object->_workers.empty())
	{
		return object->_workers.front();
	}
	return object->_main;
#line 358 "src/plugin.cpp"
	}
}

SVM_Boolean sequencer_generator_attach(const void *svm, void *handler, const SVM_Kernel kernel, const unsigned long int argc, const SVM_Parameter argv[])
{
	sequencer_generator *object = reinterpret_cast<sequencer_generator*>(handler);
	{
#line 329 "../plugins/inline/core/inline.svm_plugin"
	if(argc==0)
	{
		if(object->_main!=nullptr)
		{
			return FALSE;
		}
		::svm_variable_scope_set_global(svm,kernel);
		object->_main = kernel;
		return TRUE;
	}
	else
	{
		::svm_variable_scope_set_global(svm,kernel);
		object->_workers.push_back(kernel);
		return TRUE;
	}
#line 383 "src/plugin.cpp"
	}
}

SVM_Boolean sequencer_generator_detach(const void *svm, void *handler, const SVM_Kernel kernel, const unsigned long int argc, const SVM_Parameter argv[])
{
	sequencer_generator *object = reinterpret_cast<sequencer_generator*>(handler);
	{
#line 348 "../plugins/inline/core/inline.svm_plugin"
	if(kernel==object->_main)
	{
		::svm_variable_scope_set_local(svm,kernel);
		object->_main = nullptr;
		for(auto& k:object->_workers)
		{
			::svm_variable_scope_set_local(svm,k);
		}
		object->_workers.clear();
		return TRUE;
	}
	else
	{
		// std::find() fails to compile
		auto it = object->_workers.begin();
		for( ; it!=object->_workers.end() ; ++it)
		{
			if(*it==kernel) break;
		}
		if(it==object->_workers.end()) return FALSE;
		if(it!=object->_workers.begin()) { ERROR_INTERNAL(FAILURE,"Removing non next worker."); }
		SVM_Kernel k = object->_workers.front();
		::svm_variable_scope_set_local(svm,k);
		object->_workers.pop_front();
		if(::svm_kernel_get_interruption(svm,k)!=nullptr)
		{
			for(auto& k:object->_workers)
			{
				::svm_variable_scope_set_local(svm,k);
			}
			object->_workers.clear();
		}
		if(not object->_workers.empty())
		{
			::svm_kernel_swap_memory(svm,k,object->_workers.front());
		}
		return TRUE;
	}
#line 430 "src/plugin.cpp"
	}
}

SVM_String sequencer_generator_print(const void *svm, const void *handler)
{
	const sequencer_generator *object = reinterpret_cast<const sequencer_generator*>(handler);
	{
#line 389 "../plugins/inline/core/inline.svm_plugin"
	std::ostringstream oss;
	oss << "main: ";
	if(object->_main) { oss << ::svm_kernel_print(svm,object->_main).string; }
	oss << std::endl;
	for(auto& k:object->_workers)
	{
		oss << "Worker: " << ::svm_kernel_print(svm,k).string << std::endl;
	}
	return ::svm_string_new__raw(svm,oss.str().c_str());
#line 448 "src/plugin.cpp"
	}
}


/* Generic handling functions */

}
