.TH "Simple Virtual Machine - Plugin json" 7 "2022-05-24"
.SH SYNOPSIS
.B svm_plugin_json
Plugin to manage JSON documents
.SH DESCRIPTION
This plugin is a JSON document manager.

It allows JSON parsing, JSON generation, objects and arrays manipulations.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginjson/libsvmjson.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS TYPE json.value
This type is a generic container for all JSON values: integers, strings, booleans, objects, arrays and the null object.
.P
It is used for generic manipulations of JSON values, and can be converted from and to raw values.
.P
This type is copyable, and can be constructed from a constant.
.SS TYPE json.object
This type represents a raw JSON object.
.P
It can be used to manipulate JSON object members.
.SS TYPE json.array
This type represents a raw JSON array.
.P
It can be used to manipulate JSON arrays elements.
.SS TYPE json.null
This type represents a raw null JSON value.
.SS INTERRUPTION json.invalid
Interruption raised when an invalid JSON value is detected.
.SS INSTRUCTION json.parse STR -> json.value
Create a JSON value from a textual representation.
.P
This instruction raises the json.invalid interruption if the string does not represent a valid JSON value.
.SS INSTRUCTION json.print json.value -> STR
Generate a string corresponding to the JSON value.
.P
This string can be parsed again to produce a clone of the JSON value.
.SS INSTRUCTION json.value [ INT STR BLN json.object json.array json.null ] ? -> json.value
Convert a raw value into a JSON value.
.P
When no raw value is provided, the JSON null value is contained into the returned value.
.SS INSTRUCTION json.raw json.value -> [ INT STR BLN json.object json.array json.null ]
Convert a JSON value into a raw value.
.P
The type of the returned value depends on the contained raw value: This can be used for hard type checking.
Soft type checking can be performed using the AUTO type and the IS condition.
.SS INSTRUCTION json.object ( STR = json.value ( , STR = json.value ) * ) ? -> json.object
Create a raw JSON object.
.P
Some members can be specified at creation time.
When a key is repeated, only the first one is taken into account.
.SS INSTRUCTION json.keys json.object -> PTR
Return the keys of a JSON object as an array of strings, referenced by the returned pointer.
.SS INSTRUCTION json.member json.object STR:key -> json.value ?
Return the member from a JSON object from its key.
.P
When the key is invalid, a null value is returned.
.SS INSTRUCTION json.add_member MUTABLE json.object STR:key json.value:value -> BLN
Add a member to a JSON object.
.P
Return true when the member has been added, false otherwise.
.SS INSTRUCTION json.change_member MUTABLE json.object STR:key json.value:value -> BLN
Change a member from a JSON object.
.P
Return true when the member has been changed, false otherwise.
.SS INSTRUCTION json.remove_member MUTABLE json.object STR:key -> BLN
Remove a member from a JSON object.
.P
Return true when the member has been removed, false otherwise.
.SS INSTRUCTION json.array json.value * -> json.array
Create a JSON array from its elements.
.SS INSTRUCTION json.size json.array -> INT:size
Return a JSON array size.
.SS INSTRUCTION json.element json.array INT:index 'END' ? -> json.value ?
Return the element from a JSON array at the specified index. The END keyword specify the origin of indexes at the end of the array.
.P
When the index is invalid, a null value is returned.
.SS INSTRUCTION json.add_element MUTABLE json.array INT:index 'END' ? json.value:element -> BLN
Add an element to a JSON array at the specified index. The END keyword specify the origin of indexes at the end of the array.
.SS INSTRUCTION json.change_element MUTABLE json.array INT:index 'END' ? json.value:element -> BLN
Change an element from a JSON array at the specified index. The END keyword specify the origin of indexes at the end of the array.
.SS INSTRUCTION json.remove_element MUTABLE json.array INT:index 'END' ? -> BLN
Remove an element from a JSON array at the specified index. The END keyword specify the origin of indexes at the end of the array.
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
