/*
 * Copyright (C) 2022-05-24  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 34 "../plugins/json/core/json.svm_plugin"
#include <iostream>
#include <algorithm>
#include <mutex>
#include <string.h>
#include <src/json.h>
#include <src/parser/includes.h>
#line 30 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN json \n"
		"DEFINE \n"
		"	TYPE json.value \n"
		"	TYPE json.object \n"
		"	TYPE json.array \n"
		"	TYPE json.null \n"
		"	INTERRUPTION json.invalid \n"
		"	INSTRUCTION json.parse STR -> json.value \n"
		"	INSTRUCTION json.print json.value -> STR \n"
		"	INSTRUCTION json.value [ INT STR BLN json.object json.array json.null ] ? -> json.value \n"
		"	INSTRUCTION json.raw json.value -> [ INT STR BLN json.object json.array json.null ] \n"
		"	INSTRUCTION json.object ( STR = json.value ( , STR = json.value ) * ) ? -> json.object \n"
		"	INSTRUCTION json.keys json.object -> PTR \n"
		"	INSTRUCTION json.member json.object STR:key -> json.value ? \n"
		"	INSTRUCTION json.add_member MUTABLE json.object STR:key json.value:value -> BLN \n"
		"	INSTRUCTION json.change_member MUTABLE json.object STR:key json.value:value -> BLN \n"
		"	INSTRUCTION json.remove_member MUTABLE json.object STR:key -> BLN \n"
		"	INSTRUCTION json.array json.value * -> json.array \n"
		"	INSTRUCTION json.size json.array -> INT:size \n"
		"	INSTRUCTION json.element json.array INT:index 'END' ? -> json.value ? \n"
		"	INSTRUCTION json.add_element MUTABLE json.array INT:index 'END' ? json.value:element -> BLN \n"
		"	INSTRUCTION json.change_element MUTABLE json.array INT:index 'END' ? json.value:element -> BLN \n"
		"	INSTRUCTION json.remove_element MUTABLE json.array INT:index 'END' ? -> BLN \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 44 "../plugins/json/core/json.svm_plugin"
struct yy_buffer_state;

void jsonparserlex_init(void **);
void jsonparserlex_destroy(void *);
yy_buffer_state* jsonparser_scan_buffer(char *, size_t, void*);
void jsonparser_delete_buffer(yy_buffer_state *buffer, void *scanner);
int jsonparserparse(void *scanner, JSON::Value &value, std::string& error);

std::mutex _lock;
#line 151 "src/plugin.cpp"

extern "C"
{

/* TYPE json.value */

struct type_value
{
#line 612 "../plugins/json/core/json.svm_plugin"
	type_value() = default;
	explicit type_value(const JSON::Value::SP& v)
	:_value(v) {}

	type_value(const type_value& v)
	:_error(v._error)
	{
		if(static_cast<bool>(v._value))
		{
			_value = v._value->clone();
		}
	}

	operator std::string () const
	{
		std::ostringstream oss;
		if(not _error.empty())
		{
			oss << "\"Error: " << _error << "\"";
		}
		else
		{
			oss << (_value);
		}
		return oss.str();
	}

	JSON::Value::SP _value;
	std::string _error;
#line 190 "src/plugin.cpp"
};

void type_value_delete(const void *svm, void *handler)
{
	type_value * const object = reinterpret_cast<type_value*>(handler);
	{
#line 643 "../plugins/json/core/json.svm_plugin"

#line 199 "src/plugin.cpp"
	}
	delete object;
}

void* type_value_copy(const void *svm, const void *handler)
{
	const type_value *object = reinterpret_cast<const type_value*>(handler);
	type_value *copy = new type_value(*object);
	{
#line 644 "../plugins/json/core/json.svm_plugin"

#line 211 "src/plugin.cpp"
	}
	return copy;
}

void* type_value_constant(const void *svm, const SVM_String value)
{
#line 646 "../plugins/json/core/json.svm_plugin"
	std::lock_guard<std::mutex> protection(_lock);
	void *scanner;
	::jsonparserlex_init(&scanner);
	char *src = new char[value.size+2];
	::memcpy(src,value.string,value.size);
	src[value.size] = src[value.size+1] = '\0';
	yy_buffer_state *buffer = ::jsonparser_scan_buffer(src,value.size+2,scanner);
	type_value *t = new type_value;
	::jsonparserparse(scanner,t->_value,t->_error);
	::jsonparser_delete_buffer(buffer,scanner);
	delete [] src;
	::jsonparserlex_destroy(scanner);
	if(not t->_error.empty())
	{
		std::string e = t->_error;
		delete t;
		ERROR_EXTERNAL(json,invalid,e.c_str());
	}
	return t;
#line 238 "src/plugin.cpp"
}

SVM_String type_value_print(const void *svm, const void *handler)
{
	const type_value *object = reinterpret_cast<const type_value*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 667 "../plugins/json/core/json.svm_plugin"

#line 248 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* TYPE json.object */

struct type_object
{
#line 678 "../plugins/json/core/json.svm_plugin"
	explicit type_object(const JSON::Object::SP& o)
	:_object(o) {}
	type_object(const type_object& o)
	:_object(o._object->strict_clone())
	{ }
	
	operator std::string () const
	{
		std::ostringstream oss;
		_object->print(oss);
		return oss.str();
	}

	JSON::Object::SP _object;
#line 273 "src/plugin.cpp"
};

void type_object_delete(const void *svm, void *handler)
{
	type_object * const object = reinterpret_cast<type_object*>(handler);
	{
#line 694 "../plugins/json/core/json.svm_plugin"

#line 282 "src/plugin.cpp"
	}
	delete object;
}

void* type_object_copy(const void *svm, const void *handler)
{
	const type_object *object = reinterpret_cast<const type_object*>(handler);
	type_object *copy = new type_object(*object);
	{
#line 695 "../plugins/json/core/json.svm_plugin"

#line 294 "src/plugin.cpp"
	}
	return copy;
}

SVM_String type_object_print(const void *svm, const void *handler)
{
	const type_object *object = reinterpret_cast<const type_object*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 696 "../plugins/json/core/json.svm_plugin"

#line 306 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* TYPE json.array */

struct type_array
{
#line 705 "../plugins/json/core/json.svm_plugin"
	explicit type_array(const JSON::Array::SP& a)
	:_array(a) {}
	type_array(const type_array& a)
	:_array(a._array->strict_clone())
	{ }
	
	operator std::string () const
	{
		std::ostringstream oss;
		_array->print(oss);
		return oss.str();
	}

	JSON::Array::SP _array;
#line 331 "src/plugin.cpp"
};

void type_array_delete(const void *svm, void *handler)
{
	type_array * const object = reinterpret_cast<type_array*>(handler);
	{
#line 721 "../plugins/json/core/json.svm_plugin"

#line 340 "src/plugin.cpp"
	}
	delete object;
}

void* type_array_copy(const void *svm, const void *handler)
{
	const type_array *object = reinterpret_cast<const type_array*>(handler);
	type_array *copy = new type_array(*object);
	{
#line 722 "../plugins/json/core/json.svm_plugin"

#line 352 "src/plugin.cpp"
	}
	return copy;
}

SVM_String type_array_print(const void *svm, const void *handler)
{
	const type_array *object = reinterpret_cast<const type_array*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 723 "../plugins/json/core/json.svm_plugin"

#line 364 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* TYPE json.null */

struct type_null
{
#line 732 "../plugins/json/core/json.svm_plugin"
	explicit type_null(const JSON::Null::SP& n)
	:_null(n) {}
	type_null(const type_null& n)
	:_null(n._null->strict_clone())
	{ }
	
	operator std::string () const
	{
		std::ostringstream oss;
		_null->print(oss);
		return oss.str();
	}
	JSON::Null::SP _null;
#line 388 "src/plugin.cpp"
};

void type_null_delete(const void *svm, void *handler)
{
	type_null * const object = reinterpret_cast<type_null*>(handler);
	{
#line 747 "../plugins/json/core/json.svm_plugin"

#line 397 "src/plugin.cpp"
	}
	delete object;
}

void* type_null_copy(const void *svm, const void *handler)
{
	const type_null *object = reinterpret_cast<const type_null*>(handler);
	type_null *copy = new type_null(*object);
	{
#line 748 "../plugins/json/core/json.svm_plugin"

#line 409 "src/plugin.cpp"
	}
	return copy;
}

SVM_String type_null_print(const void *svm, const void *handler)
{
	const type_null *object = reinterpret_cast<const type_null*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 749 "../plugins/json/core/json.svm_plugin"

#line 421 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* INTERRUPTION json.invalid */


/* INSTRUCTION json.parse STR -> json.value */

SVM_Value instruction_parse(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 762 "../plugins/json/core/json.svm_plugin"
	auto s = ARGV_VALUE(0,string);
	auto t = ::type_value_constant(svm,s);
	return NEW_PLUGIN(json,value,t);
#line 438 "src/plugin.cpp"
}


/* INSTRUCTION json.print json.value -> STR */

SVM_Value instruction_print(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 775 "../plugins/json/core/json.svm_plugin"
	auto j = ARGV_PLUGIN(0,json,value);
	std::string s = *j;
	SVM_String ss = ::svm_string_new(svm,s.c_str(),s.size());
	return NEW_VALUE(string,ss);
#line 451 "src/plugin.cpp"
}


/* INSTRUCTION json.value [ INT STR BLN json.object json.array json.null ] ? -> json.value */

SVM_Value instruction_value(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 789 "../plugins/json/core/json.svm_plugin"
	if(argc==0)
	{
		auto t = new type_value(std::make_shared<JSON::Null>());
		return NEW_PLUGIN(json,value,t);
	}
	SVM_Value v = ::svm_parameter_value_get(svm,argv[0]);
	if(::svm_value_type_is_integer(svm,v))
	{
		auto r = ::svm_value_integer_get(svm,v);
		auto t = new type_value(std::make_shared<JSON::Integer>(r));
		return NEW_PLUGIN(json,value,t);
	}
	if(::svm_value_type_is_string(svm,v))
	{
		auto r = ::svm_value_string_get(svm,v);
		auto t = new type_value(std::make_shared<JSON::String>(std::string(r.string,r.size)));
		return NEW_PLUGIN(json,value,t);
	}
	if(::svm_value_type_is_boolean(svm,v))
	{
		auto r = ::svm_value_boolean_get(svm,v);
		auto t = new type_value(std::make_shared<JSON::Boolean>(r==TRUE));
		return NEW_PLUGIN(json,value,t);
	}
	auto type = ::svm_value_plugin_get_type(svm,v);
	std::string p = ::svm_value_pluginentrypoint_get_entry(svm,type).string;
	if(p=="object")
	{
		auto r = ARGV_PLUGIN(0,json,object);
		auto t = new type_value(r->_object);
		return NEW_PLUGIN(json,value,t);
	}
	if(p=="array")
	{
		auto r = ARGV_PLUGIN(0,json,array);
		auto t = new type_value(r->_array);
		return NEW_PLUGIN(json,value,t);
	}
	if(p=="null")
	{
		auto r = ARGV_PLUGIN(0,json,null);
		auto t = new type_value(r->_null);
		return NEW_PLUGIN(json,value,t);
	}
	ERROR_INTERNAL(FAILURE,"Unknown raw type");
	return nullptr;
#line 506 "src/plugin.cpp"
}


/* INSTRUCTION json.raw json.value -> [ INT STR BLN json.object json.array json.null ] */

SVM_Value instruction_raw(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 845 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,value);
	auto n = std::dynamic_pointer_cast<JSON::Null>(t->_value);
	if(static_cast<bool>(n))
	{
		type_null *tt = new type_null(n);
		return NEW_PLUGIN(json,null,tt);
	}
	auto i = std::dynamic_pointer_cast<JSON::Integer>(t->_value);
	if(static_cast<bool>(i))
	{
		return NEW_VALUE(integer,i->_i);
	}
	auto s = std::dynamic_pointer_cast<JSON::String>(t->_value);
	if(static_cast<bool>(s))
	{
		SVM_String ss = ::svm_string_new(svm,s->_s.c_str(),s->_s.size());
		return NEW_VALUE(string,ss);
	}
	auto b = std::dynamic_pointer_cast<JSON::Boolean>(t->_value);
	if(static_cast<bool>(b))
	{
		return NEW_VALUE(boolean,b->_b?TRUE:FALSE);
	}
	auto o = std::dynamic_pointer_cast<JSON::Object>(t->_value);
	if(static_cast<bool>(o))
	{
		type_object *tt = new type_object(o);
		return NEW_PLUGIN(json,object,tt);
	}
	auto a = std::dynamic_pointer_cast<JSON::Array>(t->_value);
	if(static_cast<bool>(a))
	{
		type_array *tt = new type_array(a);
		return NEW_PLUGIN(json,array,tt);
	}
	ERROR_INTERNAL(FAILURE,"Unknown JSON type");
	return nullptr;
#line 552 "src/plugin.cpp"
}


/* INSTRUCTION json.object ( STR = json.value ( , STR = json.value ) * ) ? -> json.object */

SVM_Value instruction_object(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 893 "../plugins/json/core/json.svm_plugin"
	auto o = std::make_shared<JSON::Object>();
	for(SVM_Index index=0 ; index<argc ; index+=4)
	{
		auto key = ARGV_VALUE(index,string);
		auto value = ARGV_PLUGIN(index+2,json,value);
		o->_members.insert(std::make_pair(std::string(key.string,key.size),value->_value->clone()));
	}
	type_object *t = new type_object(o);
	return NEW_PLUGIN(json,object,t);
#line 570 "src/plugin.cpp"
}


/* INSTRUCTION json.keys json.object -> PTR */

SVM_Value instruction_keys(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 913 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,object);
	std::vector<std::string> keys;
	for(const auto& m: t->_object->_members)
	{
		keys.push_back(m.first);
	}
	SVM_Memory_Zone zone = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,zone,STRING,keys.size());
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),zone);
	SVM_Address a = ::svm_value_pointer_get_address(svm,p);
	for(const auto& k:keys)
	{
		::svm_memory_write_address(svm,CURRENT(kernel),a++,NEW_VALUE(string,::svm_string_new(svm,k.c_str(),k.size())));
	}
	return p;
#line 594 "src/plugin.cpp"
}


/* INSTRUCTION json.member json.object STR:key -> json.value ? */

SVM_Value instruction_member(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 936 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,object);
	auto k = ARGV_VALUE(1,string);
	auto it = t->_object->_members.find(std::string(k.string,k.size));
	if(it==t->_object->_members.end())
	{
		return NEW_NULL_PLUGIN(json,value);
	}
	auto v = new type_value(it->second);
	return NEW_PLUGIN(json,value,v);
#line 612 "src/plugin.cpp"
}


/* INSTRUCTION json.add_member MUTABLE json.object STR:key json.value:value -> BLN */

SVM_Value instruction_add_member(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 955 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,object);
	auto k = ARGV_VALUE(1,string);
	auto v = ARGV_PLUGIN(2,json,value);
	auto b = t->_object->_members.insert(std::make_pair(std::string(k.string,k.size),v->_value->clone())).second;
	return NEW_VALUE(boolean,b?TRUE:FALSE);
#line 626 "src/plugin.cpp"
}


/* INSTRUCTION json.change_member MUTABLE json.object STR:key json.value:value -> BLN */

SVM_Value instruction_change_member(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 970 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,object);
	auto k = ARGV_VALUE(1,string);
	auto v = ARGV_PLUGIN(2,json,value);
	auto it = t->_object->_members.find(std::string(k.string,k.size));
	if(it==t->_object->_members.end())
	{
		return NEW_VALUE(boolean,FALSE);
	}
	it->second = v->_value->clone();
	return NEW_VALUE(boolean,TRUE);
#line 645 "src/plugin.cpp"
}


/* INSTRUCTION json.remove_member MUTABLE json.object STR:key -> BLN */

SVM_Value instruction_remove_member(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 990 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,object);
	auto k = ARGV_VALUE(1,string);
	auto it = t->_object->_members.find(std::string(k.string,k.size));
	if(it==t->_object->_members.end())
	{
		return NEW_VALUE(boolean,FALSE);
	}
	t->_object->_members.erase(it);
	return NEW_VALUE(boolean,TRUE);
#line 663 "src/plugin.cpp"
}


/* INSTRUCTION json.array json.value * -> json.array */

SVM_Value instruction_array(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1009 "../plugins/json/core/json.svm_plugin"
	auto a = std::make_shared<JSON::Array>();
	for(SVM_Index index=0 ; index<argc ; ++index)
	{
		auto value = ARGV_PLUGIN(index,json,value);
		a->_elements.push_back(value->_value->clone());
	}
	type_array *t = new type_array(a);
	return NEW_PLUGIN(json,array,t);
#line 680 "src/plugin.cpp"
}


/* INSTRUCTION json.size json.array -> INT:size */

SVM_Value instruction_size(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1025 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,array);
	return NEW_VALUE(integer,t->_array->_elements.size());
#line 691 "src/plugin.cpp"
}


/* INSTRUCTION json.element json.array INT:index 'END' ? -> json.value ? */

SVM_Value instruction_element(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1035 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,array);
	auto i = ARGV_VALUE(1,integer);
	if(argc==3)
	{
		i += t->_array->_elements.size();
	}
	if(not ((i>=0) and (i<t->_array->_elements.size())))
	{
		return NEW_NULL_PLUGIN(json,value);
	}
	auto v = new type_value(t->_array->_elements[i]);
	return NEW_PLUGIN(json,value,v);
#line 712 "src/plugin.cpp"
}


/* INSTRUCTION json.add_element MUTABLE json.array INT:index 'END' ? json.value:element -> BLN */

SVM_Value instruction_add_element(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1057 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,array);
	auto i = ARGV_VALUE(1,integer);
	SVM_Index iv = 2;
	if(argc==4)
	{
		++iv;
		i += t->_array->_elements.size();
	}
	auto v = ARGV_PLUGIN(iv,json,value);
	if(not ((i>=0) and (i<=t->_array->_elements.size())))
	{
		return NEW_VALUE(boolean,FALSE);
	}
	if(i==t->_array->_elements.size())
	{
		t->_array->_elements.push_back(v->_value->clone());
		return NEW_VALUE(boolean,TRUE);
	}
	t->_array->_elements.insert(t->_array->_elements.begin()+i,v->_value->clone());
	return NEW_VALUE(boolean,TRUE);
#line 741 "src/plugin.cpp"
}


/* INSTRUCTION json.change_element MUTABLE json.array INT:index 'END' ? json.value:element -> BLN */

SVM_Value instruction_change_element(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1085 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,array);
	auto i = ARGV_VALUE(1,integer);
	SVM_Index iv = 2;
	if(argc==4)
	{
		++iv;
		i += t->_array->_elements.size();
	}
	auto v = ARGV_PLUGIN(iv,json,value);
	if(not ((i>=0) and (i<t->_array->_elements.size())))
	{
		return NEW_VALUE(boolean,FALSE);
	}
	t->_array->_elements[i] = v->_value->clone();
	return NEW_VALUE(boolean,TRUE);
#line 765 "src/plugin.cpp"
}


/* INSTRUCTION json.remove_element MUTABLE json.array INT:index 'END' ? -> BLN */

SVM_Value instruction_remove_element(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 1108 "../plugins/json/core/json.svm_plugin"
	auto t = ARGV_PLUGIN(0,json,array);
	auto i = ARGV_VALUE(1,integer);
	if(argc==3)
	{
		i += t->_array->_elements.size();
	}
	if(not ((i>=0) and (i<t->_array->_elements.size())))
	{
		return NEW_VALUE(boolean,FALSE);
	}
	t->_array->_elements.erase(t->_array->_elements.begin()+i);
	return NEW_VALUE(boolean,TRUE);
#line 786 "src/plugin.cpp"
}


/* Generic handling functions */

}
