.TH "Simple Virtual Machine - Plugin library" 7 "2024-08-06"
.SH SYNOPSIS
.B svm_plugin_library
Libraries helper
.SH DESCRIPTION
The virtual machine is able to load libraries written in machine language.
.P
This plugin enhances library loading and provides some tools around libraries.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginlibrary/libsvmlibrary.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS INSTRUCTION library.load STR:filename -> LIB
This instructions opens the file specified in argument in read-only, reads the full content of the file and compile the code within the file and returns the library.
.P
The name of the library is the file name.
.SS INSTRUCTION library.entries LIB -> PTR
This instruction returns the name of all symbols of the library, as an array of strings.
.SS SYSTEM INSTRUCTION library.get SYM -> LIB
This instruction returns the library contained into a symbol.
.P
As this instruction can allow code to run unexpected code, it is limited to non-protected kernels.
.SS INSTRUCTION library.name LIB -> STR
This instruction returns the name of the given library.
.SS SYSTEM INSTRUCTION library.code LIB -> STR
This instruction returns the source code of the given library.
.P
As this instruction can allow code to run unexpected code, it is limited to non-protected kernels.
.SS SYSTEM INSTRUCTION library.current -> LIB
This instruction returns the current code executed by the processor.
.P
As this instruction can allow code to run unexpected code, it is limited to non-protected kernels.
.SH EXAMPLE
.SS Basic handling
Main code
.nf
#!/usr/bin/env svm
LOG
PLUGIN "===PLUGINLIB==="
PLUGIN "svmcom.so"
PLUGIN "svmstr.so"
PROCESS "basic"
	CODE "main" INLINE
		:memory LIB/lib, PTR/entries, INT*3/p
		:library.load "library.lib.svm" -> &lib
		:library.entries @&lib -> &entries
		[ 12 , 5 , ] -> p
		:call $(@&lib/@&@&entries) p
		:com.message @(p/2)
	END
END
.fi
Library code
.nf
	:shutdown
:symbol concat
	:str.join "<lib>" @&P "</lib>" -> &P
	:return
:symbol add
	@&P -> (P/2)
	:shift @(P/1) (P/2)
	:return
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
