/*
 * Copyright (C) 2024-08-06  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 58 "../plugins/library/core/library.svm_plugin"
#include <fstream>
#line 25 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN library \n"
		"DEFINE \n"
		"	INSTRUCTION library.load STR:filename -> LIB \n"
		"	INSTRUCTION library.entries LIB -> PTR \n"
		"	SYSTEM INSTRUCTION library.get SYM -> LIB \n"
		"	INSTRUCTION library.name LIB -> STR \n"
		"	SYSTEM INSTRUCTION library.code LIB -> STR \n"
		"	SYSTEM INSTRUCTION library.current -> LIB \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif


/* INSTRUCTION library.load STR:filename -> LIB */

SVM_Value instruction_load(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 231 "../plugins/library/core/library.svm_plugin"
	auto fn = ARGV_VALUE(0,string);	
	std::fstream f;
	f.open(RAW_STRING(fn).c_str(),std::fstream::in);
	if(not f.is_open())
	{
		std::ostringstream oss;
		oss << "Can not open " << RAW_STRING(fn) << " library";
		ERROR_INTERNAL(FAILURE,oss.str().c_str());
	}
	f.seekg (0, f.end);
	int length = f.tellg();
	f.seekg (0, f.beg);
	char * buffer = new char [length];
	f.read (buffer,length);
	if(not f)
	{
		delete [] buffer;
		std::ostringstream oss;
		oss << "Can not read " << RAW_STRING(fn) << " library";
		ERROR_INTERNAL(DEVICE,oss.str().c_str());
	}
	SVM_Variable code = ::svm_code_compile__string(svm,fn,::svm_string_new(svm,buffer,length));
	delete [] buffer;
	if(not ::svm_variable_type_is_code(svm,code))
	{
		SVM_String e = ::svm_value_string_get(svm,code);
		std::ostringstream oss;
		oss << "Can not compile " << RAW_STRING(fn) << " library: " << RAW_STRING(e);
		ERROR_INTERNAL(FAILURE,oss.str().c_str());
	}
	return ::svm_value_library_new(svm,code);
#line 156 "src/plugin.cpp"
}


/* INSTRUCTION library.entries LIB -> PTR */

SVM_Value instruction_entries(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 272 "../plugins/library/core/library.svm_plugin"
	SVM_Value_Library l = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Code code = ::svm_value_library_get_code(svm,l);
	SVM_Value_String *s = ::svm_code_symbol_list(svm,code);
	SVM_Size ls = 0;
	for(SVM_Value_String* it=s ; *it ; ++it)
	{
		::svm_value_state_is_movable(svm,*it);
		++ls;
	}
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,STRING,ls);
	SVM_Value_Pointer p = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	::svm_memory_write_pointer(svm,CURRENT(kernel),p,s);
	return p;
#line 179 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION library.get SYM -> LIB */

SVM_Value instruction_get(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 294 "../plugins/library/core/library.svm_plugin"
	SVM_Value_Symbol s = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Code code = ::svm_value_symbol_get_code(svm,s);
	return ::svm_value_library_new(svm,code);
#line 191 "src/plugin.cpp"
}


/* INSTRUCTION library.name LIB -> STR */

SVM_Value instruction_name(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 307 "../plugins/library/core/library.svm_plugin"
	SVM_Value_Library l = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Code code = ::svm_value_library_get_code(svm,l);
	SVM_String n = ::svm_code_get_name(svm,code);
	return NEW_VALUE(string,n);
#line 204 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION library.code LIB -> STR */

SVM_Value instruction_code(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 319 "../plugins/library/core/library.svm_plugin"
	SVM_Value_Library l = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Code code = ::svm_value_library_get_code(svm,l);
	SVM_String n = ::svm_code_get_source(svm,code);
	return NEW_VALUE(string,n);
#line 217 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION library.current -> LIB */

SVM_Value instruction_current(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 333 "../plugins/library/core/library.svm_plugin"
	SVM_Code code = ::svm_processor_get_currentcode(svm,CURRENT(kernel));
	return ::svm_value_library_new(svm,code);
#line 228 "src/plugin.cpp"
}


/* Generic handling functions */

}
