.TH "Simple Virtual Machine - Plugin sandbox. Sandbox" 7 "2023-02-02"
.SH SYNOPSIS
.B svm_plugin_sandbox
A plugin to ensure accessed files are always contained within a folder.
.SH DESCRIPTION
This plugin implements file opening restrictions so that no files can be accessed outside the folder specified as sandbox.
Any file or folder name can be provided absolute or relative interchangeably.
It aims at being homogenous with com.file management from com plugin.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginsandbox/libsvmsandbox.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH DEPENDENCIES
.SS STRUCT com.file

.SS TYPE com.device

.SS FUNCTION com.device_file_close $com.file -> BLN

.SS FUNCTION com.device_file_command $com.file . * -> VALUE ?

.SS FUNCTION com.device_file_open [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> $com.file

.SS FUNCTION com.device_file_print $com.file -> STR

.SS FUNCTION com.device_file_read $com.file -> STR ?

.SS FUNCTION com.device_file_write $com.file STR

.SS FUNCTION com.device $sandbox.file -> com.device ?

.SH CONTENT
.SS TYPE sandbox.folder
Contains a folder path validated as such at construction time.
It represents the desired sandbox location.
The path provided must exist on the filesystem and match a directory.

This type supports copy, constant construction and string rendering.
.SS SYSTEM INSTRUCTION sandbox.new STR -> sandbox.folder
Creates a verified sandbox.folder object from a string.
.SS WAITING INSTRUCTION sandbox.open sandbox.folder [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> com.device
Opens a sandboxed file from a given sandbox.folder.
It is the equivalent to com.open for a sandboxed file, but accessible from protected kernels.
.SS STRUCT sandbox.file
Represents a sandboxed file.
.SS FUNCTION sandbox.device_file_open sandbox.folder [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> $sandbox.file
This function implements com.open instruction for sandbox.file struct.
Notice the addition of the sandbox.folder parameter compared to the classic com.file struct usage of com.open instruction.
It opens a sandboxed file device and reserves the corresponding system resources.

Otherwise it will raise an interruption:

- FAILURE when the path of the file to open does not exist on the filesystem.

- com.interrupted for any issue in managing the underlying com.file of the sandboxed file.

- sandbox.out when the file to open is not contained in the sandbox.
.SS FUNCTION sandbox.device_file_read $sandbox.file -> STR ?
This function implements com.read instruction for a sandbox.file file. More details on
.BR svm_plugin_com (7)
.SS FUNCTION sandbox.device_file_write $sandbox.file STR
This function implements com.write instruction for a sandbox.file struct. More details on
.BR svm_plugin_com (7)
.SS FUNCTION sandbox.device_file_close $sandbox.file -> BLN
This function implements closure of a sandbox.file struct.
.SS FUNCTION sandbox.device_file_print $sandbox.file -> STR
This function implements string casting for a sanbox.file type.
.SS FUNCTION sandbox.device_file_command $sandbox.file . * -> VALUE ?
This function implements the same features as com.command instruction for com.file struct but for a sandbox.file struct.
.SS INTERRUPTION sandbox.out
This interruption is raised by com.open instruction when the required file to open is not part of the sandbox folder.
.SH EXAMPLE
.SS basic
.nf
:memory sandbox.folder/fld, com.device/file, STR/s
:sandbox.new "testsandbox" -> &fld
:com.open sandbox.file @&fld < "testsandbox/test.txt" -> &file
:com.read @&file com.all -> &s
:com.message @&file
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.BR svm_plugin_com (7)
for com plugin documentation.
.SH AUTHOR
This plugin has been written by Julien TALLON and is maintained by Julien TALLON <jlntlln7+svm@gmail.com> Julien BRUGUIER <projet.svm@pappy.tf>.
