/*
 * Copyright (C) 2023-02-02  Julien TALLON
 * 
 * Sandbox
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 217 "../plugins/sandbox/core/sandbox.svm_plugin"
#include <filesystem>
#include <system_error>
#include <string>
#include <sstream>
#line 30 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN sandbox \n"
		"USE \n"
		"	STRUCT com.file \n"
		"	TYPE com.device \n"
		"	FUNCTION com.device_file_close $com.file -> BLN \n"
		"	FUNCTION com.device_file_command $com.file . * -> VALUE ? \n"
		"	FUNCTION com.device_file_open [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> $com.file \n"
		"	FUNCTION com.device_file_print $com.file -> STR \n"
		"	FUNCTION com.device_file_read $com.file -> STR ? \n"
		"	FUNCTION com.device_file_write $com.file STR \n"
		"	FUNCTION com.device $sandbox.file -> com.device ? \n"
		"DEFINE \n"
		"	TYPE sandbox.folder \n"
		"	SYSTEM INSTRUCTION sandbox.new STR -> sandbox.folder \n"
		"	WAITING INSTRUCTION sandbox.open sandbox.folder [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> com.device \n"
		"	STRUCT sandbox.file \n"
		"	FUNCTION sandbox.device_file_open sandbox.folder [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> $sandbox.file \n"
		"	FUNCTION sandbox.device_file_read $sandbox.file -> STR ? \n"
		"	FUNCTION sandbox.device_file_write $sandbox.file STR \n"
		"	FUNCTION sandbox.device_file_close $sandbox.file -> BLN \n"
		"	FUNCTION sandbox.device_file_print $sandbox.file -> STR \n"
		"	FUNCTION sandbox.device_file_command $sandbox.file . * -> VALUE ? \n"
		"	INTERRUPTION sandbox.out \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 233 "../plugins/sandbox/core/sandbox.svm_plugin"

#line 143 "src/plugin.cpp"

extern "C"
{

/* TYPE sandbox.folder */

struct type_folder
{
#line 275 "../plugins/sandbox/core/sandbox.svm_plugin"
        type_folder(const std::string& iStr) : _path(iStr) {}
        type_folder(const type_folder& iRhs) = default;
        type_folder(type_folder&& iRhs) = default;
        operator std::string() const {
                std::stringstream out;
                out << "Path : " << _path.string() << "\nRealpath : " << _canonicalpath.string();
                return out.str();
        }

        std::filesystem::path _path;
        std::filesystem::path _canonicalpath;
#line 164 "src/plugin.cpp"
};

void type_folder_delete(const void *svm, void *handler)
{
	type_folder * const object = reinterpret_cast<type_folder*>(handler);
	{
#line 290 "../plugins/sandbox/core/sandbox.svm_plugin"

#line 173 "src/plugin.cpp"
	}
	delete object;
}

void* type_folder_copy(const void *svm, const void *handler)
{
	const type_folder *object = reinterpret_cast<const type_folder*>(handler);
	type_folder *copy = new type_folder(*object);
	{
#line 293 "../plugins/sandbox/core/sandbox.svm_plugin"

#line 185 "src/plugin.cpp"
	}
	return copy;
}

void* type_folder_constant(const void *svm, const SVM_String value)
{
	std::string string(value.string,value.size);
	type_folder *object = new type_folder(string);
	{
#line 296 "../plugins/sandbox/core/sandbox.svm_plugin"
std::error_code err, direrr;
object->_canonicalpath = std::filesystem::canonical(object->_path, err);
if(err != std::error_code()) {
        std::stringstream out;
        out << "Requested folder : " << object->_path.string() << " not found on filesystem.";
        ERROR_INTERNAL(FAILURE, out.str().c_str());
}
bool isdir = std::filesystem::is_directory(object->_canonicalpath, direrr);
if(!isdir || (direrr != std::error_code())) {
        std::stringstream out;
        out << "Requested folder : " << object->_path.string() << " is not a directory.";
        ERROR_INTERNAL(FAILURE, out.str().c_str());
}
#line 209 "src/plugin.cpp"
	}
	return object;
}

SVM_String type_folder_print(const void *svm, const void *handler)
{
	const type_folder *object = reinterpret_cast<const type_folder*>(handler);
	std::string string = static_cast<std::string>(*object);
	{
#line 313 "../plugins/sandbox/core/sandbox.svm_plugin"

#line 221 "src/plugin.cpp"
	}
	return ::svm_string_new(svm,string.c_str(),string.size());
}


/* SYSTEM INSTRUCTION sandbox.new STR -> sandbox.folder */

SVM_Value instruction_new(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 325 "../plugins/sandbox/core/sandbox.svm_plugin"
return NEW_PLUGIN(sandbox, folder, ::type_folder_constant(svm, ARGV_VALUE(0,string)));
#line 233 "src/plugin.cpp"
}


/* WAITING INSTRUCTION sandbox.open sandbox.folder [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> com.device */

SVM_Value instruction_open(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 335 "../plugins/sandbox/core/sandbox.svm_plugin"
auto sandboxfile = ::svm_function_call(svm, CONST_PEP(sandbox, device_file_open), argc, argv);
argv[0] = ::svm_parameter_structure_new(svm, sandboxfile);
auto comfile_as_device = ::svm_function_call(svm, CONST_PEP(com, device), 1, argv);
return comfile_as_device;
#line 246 "src/plugin.cpp"
}


/* STRUCT sandbox.file */

struct struct_file
{
#line 349 "../plugins/sandbox/core/sandbox.svm_plugin"
SVM_Structure _comfile;
#line 256 "src/plugin.cpp"
};

void struct_file_delete(const void *svm, void *handler)
{
	struct_file * const object = reinterpret_cast<struct_file*>(handler);
	{
#line 356 "../plugins/sandbox/core/sandbox.svm_plugin"
::svm_variable_scope_set_local(svm, object->_comfile);
#line 265 "src/plugin.cpp"
	}
	delete object;
}


/* FUNCTION sandbox.device_file_open sandbox.folder [ < > <> >> ] STR [ 'EXEC' 'PRIV' ] * -> $sandbox.file */

SVM_Variable function_device_file_open(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 366 "../plugins/sandbox/core/sandbox.svm_plugin"
auto folder = ARGV_PLUGIN(0, sandbox, folder);
std::string mode = ARGV_MARKER(1);
SVM_String filenamesvmstr = ARGV_VALUE(2, string);
auto filenamestr = RAW_STRING(filenamesvmstr);

auto filenamepath = std::filesystem::path(filenamestr).remove_filename();
if(filenamepath.empty()) {
        filenamepath = std::filesystem::current_path();
}
std::error_code err;
auto canonicalfilename = std::filesystem::canonical(filenamepath, err);
if(err != std::error_code()) {
        std::stringstream outstream;
        outstream << "Requested file : " << filenamestr << " not found on filesystem.";
        ERROR_INTERNAL(FAILURE, outstream.str().c_str());
}

std::stringstream debuggerevent;
debuggerevent << std::string(*folder) << " | " << filenamestr << " " << canonicalfilename.string();
::svm_debug_notify__raw(svm, CURRENT(kernel), debuggerevent.str().c_str());

if(!canonicalfilename.string().starts_with(folder->_canonicalpath.string())) {
        std::stringstream outstream;
        outstream << "Requested file : "<< filenamestr << " is not included in the sandbox folder : " << folder->_path.string();
        ERROR_EXTERNAL(sandbox, out, outstream.str().c_str());
}

auto comfile = ::svm_function_call(svm, CONST_PEP(com, device_file_open), argc-1, argv+1);
::svm_variable_scope_set_global(svm, comfile);
return NEW_STRUCT(sandbox, file, new struct_file{comfile});
#line 306 "src/plugin.cpp"
}


/* FUNCTION sandbox.device_file_read $sandbox.file -> STR ? */

SVM_Variable function_device_file_read(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 415 "../plugins/sandbox/core/sandbox.svm_plugin"
auto* sandboxfile = ARGV_STRUCT(0, sandbox, file);
argv[0] = ::svm_parameter_structure_new(svm, sandboxfile->_comfile);
return ::svm_function_call(svm, CONST_PEP(com, device_file_read), argc, argv);
#line 318 "src/plugin.cpp"
}


/* FUNCTION sandbox.device_file_write $sandbox.file STR */

SVM_Variable function_device_file_write(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 428 "../plugins/sandbox/core/sandbox.svm_plugin"
auto* sandboxfile = ARGV_STRUCT(0, sandbox, file);
argv[0] = ::svm_parameter_structure_new(svm, sandboxfile->_comfile);
::svm_function_call(svm, CONST_PEP(com, device_file_write), argc, argv);
#line 330 "src/plugin.cpp"
	return nullptr;
}


/* FUNCTION sandbox.device_file_close $sandbox.file -> BLN */

SVM_Variable function_device_file_close(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 441 "../plugins/sandbox/core/sandbox.svm_plugin"
auto* sandboxfile = ARGV_STRUCT(0, sandbox,file);
SVM_Parameter* p = ::svm_parameter_array_new(svm, 1);
p[0] = ::svm_parameter_structure_new(svm, sandboxfile->_comfile);
return ::svm_function_call(svm, CONST_PEP(com, device_file_close), 1, p);
#line 344 "src/plugin.cpp"
}


/* FUNCTION sandbox.device_file_print $sandbox.file -> STR */

SVM_Variable function_device_file_print(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 454 "../plugins/sandbox/core/sandbox.svm_plugin"
auto* sandboxfile = ARGV_STRUCT(0, sandbox, file);
argv[0] = ::svm_parameter_structure_new(svm, sandboxfile->_comfile);
SVM_String output = ::svm_value_string_get(svm, ::svm_function_call(svm, CONST_PEP(com, device_file_print), argc, argv));
auto realoutput = RAW_STRING(output);
using std::string_literals::operator""s;
realoutput = "Sandboxed"s + realoutput;
return NEW_VALUE(string,::svm_string_new(svm, realoutput.c_str(), realoutput.size()));
#line 360 "src/plugin.cpp"
}


/* FUNCTION sandbox.device_file_command $sandbox.file . * -> VALUE ? */

SVM_Variable function_device_file_command(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 470 "../plugins/sandbox/core/sandbox.svm_plugin"
auto* sandboxfile = ARGV_STRUCT(0, sandbox, file);
argv[0] = ::svm_parameter_structure_new(svm, sandboxfile->_comfile);
return ::svm_function_call(svm, CONST_PEP(com, device_file_command), argc, argv);
#line 372 "src/plugin.cpp"
}


/* INTERRUPTION sandbox.out */


/* Generic handling functions */

void plugin_initialisation(const void *svm)
{
#line 225 "../plugins/sandbox/core/sandbox.svm_plugin"

#line 385 "src/plugin.cpp"
}

void plugin_finalisation(const void *svm)
{
#line 229 "../plugins/sandbox/core/sandbox.svm_plugin"

#line 392 "src/plugin.cpp"
}

}
