.TH "Simple Virtual Machine - Plugin secret" 7 "2024-07-09"
.SH SYNOPSIS
.B svm_plugin_secret
A plugin to conceal sensitive values within memory.
.SH DESCRIPTION
This plugin allows sensitive values being concealed within memory, to avoid sensitive data leak from logs and coredumps.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginsecret/libsvmsecret.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS OPTION secret.debug -D BLN
Enable display of secret values in debug mode only. (Concealed by default even in debug mode)
.SS TYPE secret.value
This type contains a concealed value.
The type of the value can be variant.
.P
When the value is built, an extra boolean is specified: when this boolean is true, kernels in protected mode can retrieve the concealed value.
By default, protected kernels can not get the value.
.SS SYSTEM INSTRUCTION secret.new VALUE BLN ? -> secret.value
This instruction creates a secret value from a value.
.P
The last optional parameter controls whether the value is accessible from protected kernels.
.SS SYSTEM INSTRUCTION secret.transfer PTR BLN ? -> secret.value
This instruction moves a value from the memory to a secret value.
.P
The last optional parameter controls whether the value is accessible from protected kernels.
.SS SYSTEM WAITING INSTRUCTION secret.prompt ( [ 'STDOUT' 'STDERR' ] ? STR ):prompt ? [ 'STR' 'INT' ]:output_type BLN ? -> secret.value
This instruction prompts from the terminal a sensitive value, and emits it under a secret value.
When the value is entered, the terminal echoing is disabled.
.P
The last optional parameter controls whether the value is accessible from protected kernels.
See also the :com.prompt instruction for more details about the parameters.
.SS SYSTEM INSTRUCTION secret.set MUTABLE secret.value VALUE
This instructions changes the value stored into a secret value.
.SS INSTRUCTION secret.get secret.value -> VALUE
This instructions returns the value stored into a secret value.
.P
When the flag associated to the secret value is false and the kernel is in protected mode, a SECURITY interruption is raised.
.SS INSTRUCTION secret.protect BLN
This instruction puts the interruptions on hold when the boolean is true, and release them otherwise.
.P
This instruction allows safe management of sensitive data stored in secret values within two calls of this instruction by preventing an interruption producing a core dump with values in clear.
.SH EXAMPLES
.SS Concealed value
.nf
#!/usr/bin/env svm
LOG
PLUGIN "svmcom.so"
PLUGIN "svmrun.so"
PLUGIN "===PLUGINLIB==="

PROCESS "conceal"
        CODE "main" INLINE
		:memory secret.value/vi, secret.value/vs, STR/s
		:secret.new 17 -> &vi
		:secret.new "abc" -> &vs
		:secret.get @&vs -> &s
		:com.message @&vi " " @&vs " / " @&s
		:run.coredump STDOUT
        END
END
.fi
.SS Concealed data handling
.nf
#!/usr/bin/env svm
LOG
PLUGIN "svmstr.so"
PLUGIN "===PLUGINLIB==="

PROCESS "handling"
        CODE "main" INLINE
		:memory secret.value/vs, STR/s, BLN/b
		:secret.prompt "Password" STR -> &vs
		:secret.protect TRUE
		:secret.get @&vs -> &s
		:str.cmp @&s = "pass" -> &b # Ok, this is for the example, it is a too weak method for password checking!
		[ ] -> s
		:secret.protect FALSE
		:shutdown 1 :unless @&b TRUE
		:shutdown 0
        END
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
