/*
 * Copyright (C) 2024-07-09  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 69 "../plugins/secret/core/secret.svm_plugin"
#include <iostream>
#include <memory>
#include <mutex>
#include <unistd.h>
#include <termios.h>
#line 29 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN secret \n"
		"DEFINE \n"
		"	OPTION secret.debug -D BLN \n"
		"	TYPE secret.value \n"
		"	SYSTEM INSTRUCTION secret.new VALUE BLN ? -> secret.value \n"
		"	SYSTEM INSTRUCTION secret.transfer PTR BLN ? -> secret.value \n"
		"	SYSTEM WAITING INSTRUCTION secret.prompt ( [ 'STDOUT' 'STDERR' ] ? STR ):prompt ? [ 'STR' 'INT' ]:output_type BLN ? -> secret.value \n"
		"	SYSTEM INSTRUCTION secret.set MUTABLE secret.value VALUE \n"
		"	INSTRUCTION secret.get secret.value -> VALUE \n"
		"	INSTRUCTION secret.protect BLN \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 78 "../plugins/secret/core/secret.svm_plugin"
	std::mutex& verrou_terminal()
	{
		static std::mutex terminal;
		return terminal;
	}
#line 133 "src/plugin.cpp"

extern "C"
{

/* OPTION secret.debug -D BLN */


/* TYPE secret.value */

struct type_value
{
#line 196 "../plugins/secret/core/secret.svm_plugin"
	type_value(const SVM_Value v, const bool p)
	:_value(v), _protected(p) {}
	SVM_Value _value;
	bool _protected { false };
#line 150 "src/plugin.cpp"
};

void type_value_delete(const void *svm, void *handler)
{
	type_value * const object = reinterpret_cast<type_value*>(handler);
	{
#line 203 "../plugins/secret/core/secret.svm_plugin"
	VARIABLE_LOCAL(object->_value);
#line 159 "src/plugin.cpp"
	}
	delete object;
}

void* type_value_copy(const void *svm, const void *handler)
{
	const type_value *object = reinterpret_cast<const type_value*>(handler);
	{
#line 207 "../plugins/secret/core/secret.svm_plugin"
	SVM_Value v = ::svm_value_copy(svm,object->_value);
	VARIABLE_GLOBAL(v);
	return new type_value ( v, object->_protected );
#line 172 "src/plugin.cpp"
	}
}

unsigned char type_value_compare(const void *svm, const void *handler_left, const void *handler_right)
{
	const type_value *object_left = reinterpret_cast<const type_value*>(handler_left);
	const type_value *object_right = reinterpret_cast<const type_value*>(handler_right);
	{
#line 213 "../plugins/secret/core/secret.svm_plugin"
	SVM_Comparison_Result c = ::svm_value_compare(svm,object_left->_value,object_right->_value);
	return ::svm_value_plugin_compare_convert(svm,c);
#line 184 "src/plugin.cpp"
	}
}

SVM_String type_value_print(const void *svm, const void *handler)
{
	const type_value *object = reinterpret_cast<const type_value*>(handler);
	{
#line 218 "../plugins/secret/core/secret.svm_plugin"
	std::ostringstream oss;
	SVM_String t = ::svm_value_type_print(svm,object->_value);
	oss << RAW_STRING(t) << " ***";
	if(::svm_machine_mode_is_debug(svm) and ::svm_value_boolean_get(svm,::svm_plugin_get_option(svm,CONST_PEP(secret,debug))))
	{
		SVM_String v = ::svm_value_print(svm,object->_value);
		oss << " (" << RAW_STRING(v) << ")";
	}
	return NEW_STRING(oss.str());
#line 202 "src/plugin.cpp"
	}
}


/* SYSTEM INSTRUCTION secret.new VALUE BLN ? -> secret.value */

SVM_Value instruction_new(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 239 "../plugins/secret/core/secret.svm_plugin"
	SVM_Value v = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Boolean b = FALSE;
	if(argc>1)
	{
		b = ARGV_VALUE(1,boolean);
	}
	type_value *sv = new type_value(v,b);
	VARIABLE_GLOBAL(v);
	return NEW_PLUGIN(secret,value,sv);
#line 221 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION secret.transfer PTR BLN ? -> secret.value */

SVM_Value instruction_transfer(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 258 "../plugins/secret/core/secret.svm_plugin"
	SVM_Value_Pointer vp = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Boolean b = FALSE;
	if(argc>1)
	{
		b = ARGV_VALUE(1,boolean);
	}
	SVM_Address a = ::svm_value_pointer_get_address(svm,vp);
	SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),a);
	::svm_memory_write_address(svm,CURRENT(kernel),a,NEW_NULL_VALUE(automatic));
	type_value *sv = new type_value(v,b);
	VARIABLE_GLOBAL(v);
	return NEW_PLUGIN(secret,value,sv);
#line 242 "src/plugin.cpp"
}


/* SYSTEM WAITING INSTRUCTION secret.prompt ( [ 'STDOUT' 'STDERR' ] ? STR ):prompt ? [ 'STR' 'INT' ]:output_type BLN ? -> secret.value */

SVM_Value instruction_prompt(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 280 "../plugins/secret/core/secret.svm_plugin"
	std::shared_ptr<std::string> prompt;
	bool sortie_erreur = false;
	std::string type;
	size_t indice = 0;
	if(::svm_parameter_type_is_value(svm,argv[0]))
	{
		SVM_String s = ARGV_VALUE(0,string);
		prompt = std::make_shared<std::string>(s.string,s.size);
		++indice;
	}
	else
	{
		std::string sortie = ARGV_KEYWORD(0);
		if((sortie=="STDERR") or (sortie=="STDOUT"))
		{
			sortie_erreur = (sortie=="STDERR");
			indice += 2;
			SVM_String s = ARGV_VALUE(1,string);
			prompt = std::make_shared<std::string>(s.string,s.size);
		}
	}
	type = ARGV_KEYWORD(indice);
	SVM_Boolean p = FALSE;
	if((indice+1)<argc)
	{
		p = ARGV_VALUE(indice+1,boolean);
	}
	{
		std::lock_guard<std::mutex> protection(::verrou_terminal());
		if(static_cast<bool>(prompt))
		{
			if(sortie_erreur)
			{
				std::cerr << (*prompt) << ": ";
			}
			else
			{
				std::cout << (*prompt) << ": ";
			}
		}
	}
	std::string ligne;
	struct termios term;
	::tcgetattr(0, &term);
	term.c_lflag &= ~ECHO;
	::tcsetattr(0, TCSANOW, &term);
	SVM_Process processus_courant = CURRENT(process);
	::svm_process_pause(svm);
	::svm_process_interruptionnotification_enable(svm,processus_courant);
	std::getline(std::cin,ligne);
	::svm_process_interruptionnotification_disable(svm,processus_courant);
	::svm_process_resume(svm);
	::tcgetattr(0, &term);
	term.c_lflag |= ECHO;
	::tcsetattr(0, TCSANOW, &term);
	if(sortie_erreur)
	{
		std::cerr << std::endl;
	}
	else
	{
		std::cout << std::endl;
	}
	SVM_Value v;
	if(type=="STR")
	{
		v = ::svm_value_string_new__buffer(svm,ligne.c_str(),ligne.size());

	}
	else
	{
		char *end;
		long int integer = ::strtol(ligne.c_str(),&end,0);
		if((static_cast<size_t>(end-ligne.c_str())!=ligne.size()))
		{
			ERROR_INTERNAL(NUMERIC,"Input is not an integer number");
		}
		v = NEW_VALUE(integer,integer);
	}
	type_value *sv = new type_value(v,p);
	VARIABLE_GLOBAL(v);
	return NEW_PLUGIN(secret,value,sv);
#line 333 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION secret.set MUTABLE secret.value VALUE */

SVM_Value instruction_set(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 374 "../plugins/secret/core/secret.svm_plugin"
	auto sv = ARGV_PLUGIN(0,secret,value);
	SVM_Value v = ::svm_parameter_value_get(svm,argv[1]);
	VARIABLE_LOCAL(sv->_value);
	VARIABLE_GLOBAL(v);
	sv->_value = v;
#line 347 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION secret.get secret.value -> VALUE */

SVM_Value instruction_get(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 387 "../plugins/secret/core/secret.svm_plugin"
	auto sv = ARGV_PLUGIN(0,secret,value);
	if(::svm_kernel_has_protectedmode(svm,CURRENT(kernel)) and not sv->_protected)
	{
		ERROR_INTERNAL(SECURITY,"Secret value retrieval in protected mode attempt");
	}
	return sv->_value;
#line 363 "src/plugin.cpp"
}


/* INSTRUCTION secret.protect BLN */

SVM_Value instruction_protect(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 403 "../plugins/secret/core/secret.svm_plugin"
	SVM_Boolean b = ARGV_VALUE(0,boolean);
	if(b)
	{
		::svm_processor_hold_interruption(svm,CURRENT(kernel));
	}
	else
	{
		::svm_processor_release_interruption(svm,CURRENT(kernel));
	}
#line 381 "src/plugin.cpp"
	return nullptr;
}


/* Generic handling functions */

}
