.TH "Simple Virtual Machine - Plugin serial" 7 "2022-11-01"
.SH SYNOPSIS
.B svm_plugin_serial
An efficient scheduler for tasking.
.SH DESCRIPTION
This plugin adds a scheduler to the Simple Virtual Machine dedicated to execute tasks.
.P
The controlled processes are executed in parallel within a given limit.
.P
The limit of executed processes in parallel can be tuned by a dedicated instruction.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginserial/libsvmserial.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS OPTION serial.limit -l INT
Starts serial scheduler with a process limit. Shall be above 0. When not present, serial uses 1 as a limit.
.SS SCHEDULER serial.scheduler
The scheduler accepts processes without any limitation.
.P
It will execute processes in parallel until a certain limit.
This limit is 1 by default, but can be modified by the serial.limit instruction.
.P
When a process ends, another suspended process is executed at its place if available.
When a process is put on hold (waiting or locked), another suspended process is executed at its place as well.
The process put on hold will be restarted as soon as possible by the scheduler.
.SS SYSTEM INSTRUCTION serial.limit INT
This instruction changes the limit of parallel processes executed by the serial.scheduler.
.P
The instruction raises a FAILURE interruption if the limit is under 1.
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
