/*
 * Copyright (C) 2022-11-01  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 27 "../plugins/serial/core/serial.svm_plugin"
#include <list>
#include <algorithm>
#include <sstream>
#line 27 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN serial \n"
		"DEFINE \n"
		"	OPTION serial.limit -l INT \n"
		"	SCHEDULER serial.scheduler \n"
		"	SYSTEM INSTRUCTION serial.limit INT \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif


/* OPTION serial.limit -l INT */


/* SCHEDULER serial.scheduler */

struct scheduler_scheduler
{
#line 52 "../plugins/serial/core/serial.svm_plugin"
	enum class List { RUNNING, SUSPENDED, WAITING, READY, OTHER, NONE };
	List remove(const SVM_Process p)
	{
		std::list<SVM_Process>::iterator it = std::find(_running.begin(),_running.end(),p);
		if(it!=_running.end()) { _running.erase(it); return List::RUNNING; }
		it = std::find(_ready.begin(),_ready.end(),p);
		if(it!=_ready.end()) { _ready.erase(it); return List::READY; }
		it = std::find(_suspended.begin(),_suspended.end(),p);
		if(it!=_suspended.end()) { _suspended.erase(it); return List::SUSPENDED; }
		it = std::find(_waiting.begin(),_waiting.end(),p);
		if(it!=_waiting.end()) { _waiting.erase(it); return List::WAITING; }
		it = std::find(_others.begin(),_others.end(),p);
		if(it!=_others.end()) { _others.erase(it); return List::OTHER; }
		return List::NONE;
	}
	void print(const void *svm, std::ostream& os) const
	{
		os << "Limit " << _limit << std::endl
			<< "Desired running:" << std::endl;
		scheduler_scheduler::print(svm,_running,os);
		os << "Desired waiting:" << std::endl;
		scheduler_scheduler::print(svm,_waiting,os);
		os << "Desired ready:" << std::endl;
		scheduler_scheduler::print(svm,_ready,os);
		os << "Desired suspended:" << std::endl;
		scheduler_scheduler::print(svm,_suspended,os);
		os << "Desired others:" << std::endl;
		scheduler_scheduler::print(svm,_others,os);
	}
	static void print(const void *svm, const std::list<SVM_Process>& l, std::ostream& os)
	{
		for(const auto& p: l)
		{
			SVM_String s = ::svm_process_print(svm,p);
			os << "  " << std::string(s.string,s.size) << std::endl;
		}
	}


	static void local(const void *svm, std::list<SVM_Process>& l)
	{
		for(auto& p: l)
		{
			::svm_variable_scope_set_local(svm,p);
		}
	}

	void command(const void *svm)
	{
		if(_running.size()>_limit)
		{
			auto it = _running.begin();
			for(size_t i=0 ; i<_limit ; ++i)
			{
				++it;
			}
			size_t s = _suspended.size();
			std::move(it,_running.end(),std::back_inserter(_suspended));
			_running.erase(it,_running.end());
			for(auto p: _suspended)
			{
				if(s==0)
				{
					::svm_process_suspend(svm,p);
				}
				else
				{
					--s;
				}
			}
		}
		else if(_running.size()<_limit)
		{
			size_t s = _running.size();
			auto itc = _ready.begin();
			for(size_t i=_running.size() ; i<_limit ; ++i)
			{
				if(itc==_ready.end()) break;
				++itc;
			}
			std::move(_ready.begin(),itc,std::back_inserter(_running));
			_ready.erase(_ready.begin(),itc);
			if(_running.size()<_limit)
			{
				auto its = _suspended.begin();
				for(size_t i=_running.size() ; i<_limit ; ++i)
				{
					if(its==_suspended.end()) break;
					++its;
				}
				std::move(_suspended.begin(),its,std::back_inserter(_running));
				_suspended.erase(_suspended.begin(),its);
			}
			for(auto p: _running)
			{
				if(s==0)
				{
					::svm_process_run__raw(svm,p,0);
				}
				else
				{
					--s;
				}
			}
		}
	}

	std::list<SVM_Process> _running;
	std::list<SVM_Process> _ready;
	std::list<SVM_Process> _suspended;
	std::list<SVM_Process> _waiting;
	std::list<SVM_Process> _others;
	size_t _limit = 1;
#line 240 "src/plugin.cpp"
};

void* scheduler_scheduler_create(const void *svm)
{
	scheduler_scheduler *object = new scheduler_scheduler();
	{
#line 167 "../plugins/serial/core/serial.svm_plugin"

#line 249 "src/plugin.cpp"
	}
	return object;
}

void scheduler_scheduler_delete(const void *svm, void *handler)
{
	scheduler_scheduler * const object = reinterpret_cast<scheduler_scheduler*>(handler);
	{
#line 169 "../plugins/serial/core/serial.svm_plugin"
	scheduler_scheduler::local(svm,object->_running);
	scheduler_scheduler::local(svm,object->_ready);
	scheduler_scheduler::local(svm,object->_suspended);
	scheduler_scheduler::local(svm,object->_waiting);
	scheduler_scheduler::local(svm,object->_running);
#line 264 "src/plugin.cpp"
	}
	delete object;
}

unsigned long int scheduler_scheduler_schedule(const void *svm, void *handler, const SVM_Process process, const SVM_Process_State state)
{
	scheduler_scheduler *object = reinterpret_cast<scheduler_scheduler*>(handler);
	{
#line 177 "../plugins/serial/core/serial.svm_plugin"
	auto l = object->remove(process);
	if(l==scheduler_scheduler::List::NONE) return 0;
	switch(state)
	{
		case RUNNING:
		case DEBUG:
			{
				object->_running.push_back(process);
			}
			break;
		case CONTINUE:
			{
				object->_ready.push_back(process);
			}
			break;
		case SUSPENDED:
			{
				object->_suspended.push_back(process);
			}
			break;
		case LOCKED:
		case WAITING:
			{
				object->_waiting.push_back(process);
			}
			break;
		case ZOMBIE:
		case INTERRUPTED:
		case ERROR:
			{
				object->_others.push_back(process);
			}
			break;
	}
	object->command(svm);
	return 0;
#line 310 "src/plugin.cpp"
	}
}

unsigned long int scheduler_scheduler_notification(const void *svm, void *handler, const SVM_Notification_Type type, unsigned long int parameter)
{
	scheduler_scheduler *object = reinterpret_cast<scheduler_scheduler*>(handler);
	{
#line 216 "../plugins/serial/core/serial.svm_plugin"
	if(parameter<1)
	{
		ERROR_INTERNAL(FAILURE,"Invalid process limit");
	}
	object->_limit = parameter;
	object->command(svm);
	return 0;
#line 326 "src/plugin.cpp"
	}
}

SVM_Boolean scheduler_scheduler_attach(const void *svm, void *handler, const SVM_Process process, unsigned long int parameter)
{
	scheduler_scheduler *object = reinterpret_cast<scheduler_scheduler*>(handler);
	{
#line 226 "../plugins/serial/core/serial.svm_plugin"
	::svm_variable_scope_set_global(svm,process);
	object->_others.push_back(process);
	return TRUE;
#line 338 "src/plugin.cpp"
	}
}

SVM_Boolean scheduler_scheduler_detach(const void *svm, void *handler, const SVM_Process process, unsigned long int parameter)
{
	scheduler_scheduler *object = reinterpret_cast<scheduler_scheduler*>(handler);
	{
#line 232 "../plugins/serial/core/serial.svm_plugin"
	auto l = object->remove(process);
	if(l==scheduler_scheduler::List::NONE) return FALSE;
	::svm_variable_scope_set_local(svm,process);
	return TRUE;
#line 351 "src/plugin.cpp"
	}
}

SVM_String scheduler_scheduler_print(const void *svm, const void *handler)
{
	const scheduler_scheduler *object = reinterpret_cast<const scheduler_scheduler*>(handler);
	{
#line 239 "../plugins/serial/core/serial.svm_plugin"
	std::ostringstream os;
	object->print(svm,os);
	return ::svm_string_new(svm,os.str().c_str(),os.str().size());
#line 363 "src/plugin.cpp"
	}
}


/* SYSTEM INSTRUCTION serial.limit INT */

SVM_Value instruction_limit(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 257 "../plugins/serial/core/serial.svm_plugin"
	auto limit = ARGV_VALUE(0,integer);
	if(limit<1)
	{
		ERROR_INTERNAL(FAILURE,"Serial limit shall be above 1");
	}
	::svm_scheduler_notify__raw(svm,::svm_scheduler_get(svm,CONST_PEP(serial,scheduler)),limit);
#line 379 "src/plugin.cpp"
	return nullptr;
}


/* Generic handling functions */

void plugin_startup(const void *svm)
{
#line 34 "../plugins/serial/core/serial.svm_plugin"
	SVM_Value_Integer l = ::svm_plugin_get_option(svm,CONST_PEP(serial,limit));
	if(not ::svm_value_state_is_null(svm,l))
	{
		auto rl = ::svm_value_integer_get(svm,l);
		if(rl>0)
		{
			::svm_scheduler_notify__raw(svm,::svm_scheduler_get(svm,CONST_PEP(serial,scheduler)),rl);
		}
	}
#line 398 "src/plugin.cpp"
}

}
