.TH "Simple Virtual Machine - Plugin share" 7 "2022-09-21"
.SH SYNOPSIS
.B svm_plugin_share
A simple shared memory handler.
.SH DESCRIPTION
This plugin allows several process within an application to share copiable values through keys acting as addresses. 
.P
The access to the storage is protected by a lock, but the stored values shall be synchronised by their own means.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginshare/libsvmshare.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS WAITING INSTRUCTION share.set STR:key VALUE ?:value
This instruction associates a value to a key or overrides a value for a key when a key and a value are specified.
.P
The instruction removes the key and the value when the key only is specified.
.SS WAITING INSTRUCTION share.get STR:key -> VALUE ?:value
This instruction returns the value associated to a key.
.P
When the key is not associated to a value, a null value is returned.
.SH EXAMPLES
.SS Simple example
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
PROCESS "test"
        CODE "main" INLINE
		:memory STR/s
		:share.set "key" "value"
		:share.get "key" -> &s
		:com.message @&s
        END
END
.fi
.SS Several processes
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "svmrun.so"
PLUGIN "===PLUGINLIB==="
PROCESS "test"
        CODE "main" INLINE
		:share.set "key" "value"
        END
	SCHEDULER run.parallel
END
PROCESS "test"
        CODE "main" INLINE
		:run.sleep HARD 1
		:memory STR/s
		:share.get "key" -> &s
		:com.message @&s
        END
	SCHEDULER run.parallel
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.BR svm_plugin_mem (7)
for basic memory management.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
