/*
 * Copyright (C) 2022-09-21  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 73 "../plugins/share/core/share.svm_plugin"
#include <map>
#line 25 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN share \n"
		"DEFINE \n"
		"	WAITING INSTRUCTION share.set STR:key VALUE ?:value \n"
		"	WAITING INSTRUCTION share.get STR:key -> VALUE ?:value \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 78 "../plugins/share/core/share.svm_plugin"
	static std::map<std::string, SVM_Value> storage;
	SVM_Lock lock;
#line 120 "src/plugin.cpp"

extern "C"
{

/* WAITING INSTRUCTION share.set STR:key VALUE ?:value */

SVM_Value instruction_set(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 102 "../plugins/share/core/share.svm_plugin"
	SVM_LockGuard_Write guard = ::svm_lock_writeguard_new(svm,lock,TRUE);
	::svm_variable_scope_set_local(svm,guard);
	auto raw_key = ARGV_VALUE(0,string);
	std::string key(raw_key.string,raw_key.size);
	auto it = storage.find(key);
	if(argc==1)
	{
		if(it!=storage.end())
		{
			storage.erase(it);
		}
		return nullptr;
	}
	SVM_Value value = ::svm_parameter_value_get(svm,argv[1]);
	::svm_variable_scope_set_global(svm,value);
	if(it==storage.end())
	{
		storage.insert(std::make_pair(key,value));
	}
	else
	{
		::svm_variable_scope_set_local(svm,it->second);
		it->second = value;
	}
#line 154 "src/plugin.cpp"
	return nullptr;
}


/* WAITING INSTRUCTION share.get STR:key -> VALUE ?:value */

SVM_Value instruction_get(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 136 "../plugins/share/core/share.svm_plugin"
	SVM_LockGuard_Read guard = ::svm_lock_readguard_new(svm,lock,TRUE);
	::svm_variable_scope_set_local(svm,guard);
	auto raw_key = ARGV_VALUE(0,string);
	std::string key(raw_key.string,raw_key.size);
	auto it = storage.find(key);
	if(it==storage.end())
	{
		return ::svm_value_automatic_new_null(svm);
	}
	return it->second;
#line 174 "src/plugin.cpp"
}


/* Generic handling functions */

void plugin_initialisation(const void *svm)
{
#line 84 "../plugins/share/core/share.svm_plugin"
	lock = ::svm_lock_new(svm);
	::svm_variable_scope_set_global(svm,lock);
#line 185 "src/plugin.cpp"
}

void plugin_finalisation(const void *svm)
{
#line 90 "../plugins/share/core/share.svm_plugin"
	for(auto& s: storage)
	{
		::svm_variable_scope_set_local(svm,s.second);
	}
	::svm_variable_scope_set_local(svm,lock);
	storage.clear();
#line 197 "src/plugin.cpp"
}

}
