.TH "Simple Virtual Machine - Plugin shell" 7 "2022-01-31"
.SH SYNOPSIS
.B svm_plugin_shell
A basic shell handling plugin.
.SH DESCRIPTION
This plugin forks the SVM and launch a shell command.
.P
To communicate with the command standard input, output and error, this plugin defines all suitable objects to create a device of the official plugin com.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginshell/libsvmshell.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH DEPENDENCIES
.SS TYPE com.device
This plugin has be designed to work this the official plugin com.
.SS INTERRUPTION com.interrupted
This plugin use this interruption when a read has been interrupted.
.SH CONTENT
.SS STRUCT shell.command
Device to control command through anonymous pipes.
.SS FUNCTION shell.device_command_open [ < > <> ] [ > >> ] ? 'FREE' ? ( STR + | PTR ) -> $shell.command
Function to open the shell.command device.
.P
The first parameter indicates:
 - >: connect only to command stdin,
 - <: connect only to command stdout,
 - <>: connect to both.
.P
The second optional parameter indicates what to do with stderr:
 - nothing: do not connect to command stderr,
 - >: connect command stderr in a separate channel (to be read with :com.command <device> ERROR),
 - >>: connect command stderr merged with stdout.
.P
The third optional parameter allows to disable locking all other processes while launching the command.
Use with caution.
.P
The remaining parameters are the command name (with its path) and its command line arguments.
.SS FUNCTION shell.device_command_print $shell.command -> STR
Function to print the shell command
.SS FUNCTION shell.device_command_read $shell.command -> STR ?
Function to read from the shell command
.SS FUNCTION shell.device_command_write $shell.command STR
Function to write to the shell command
.SS FUNCTION shell.device_command_idle $shell.command MUTABLE INT 3
Function to idle from and to the shell command
.SS FUNCTION shell.device_command_command $shell.command . * -> VALUE ?
This function allows several operations:
.TP
Standard error read
The keyword ERROR dumps all the standard error and returns it as a string.
.TP
Standard input close
The keyword CLOSE closes the channel to the standard input of the command.
.SS FUNCTION shell.device_command_close $shell.command -> BLN
Function to close the shell command
.SH EXAMPLE
.SS A stupid example
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="

PROCESS "stupid"
	CODE "main" INLINE
		:memory com.device/cmd, STR/s
		:com.open shell.command <> "cat" "-" -> &cmd
		:com.write @&cmd "bla\(rsnbla\(rsn"
		:com.command @&cmd CLOSE
	:label loop
		:com.read @&cmd com.line -> &s
		:shutdown :unless &s INITIALISED
		:com.write STDOUT "> " @&s
		:goto loop
	END
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
