.TH "Simple Virtual Machine - Plugin sqlite" 7 "2022-08-11"
.SH SYNOPSIS
.B svm_plugin_sqlite
Simple Virtual Machine plugin to handle basic sqlite operations.
.SH DESCRIPTION
This plugin manages sqlite databases in read-only or read-write modes.

The plugin does not manage the concurrent write access to the databases and this shall be handled by the application.

The plugin handles prepared queries with binded values.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginsqlite/libsvmsqlite.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS INTERRUPTION sqlite.error
This interruption is raised when the sqlite library returns an error code.
.SS INTERRUPTION sqlite.busy
This interruption is raised when concurrent write access is attempted on a database file.
.SS TYPE sqlite.database
This type represents a connection to a database.
.SS TYPE sqlite.query
This type represents a prepared SQL query on a specific database.
.SS SYSTEM INSTRUCTION sqlite.database STR:file [ 'RO' 'RW' ]:mode -> sqlite.database
This instruction opens a connection to an sqlite database.
The database name should follow the sqlite specifications.
.P
When a file name is provided, this file shall exist when the database is opened in read-only mode (RO).
A sqlite.error interruption is raised when the file does not exist.
When the database is opened in read-write mode (RW), the file is created when it does not exist.
.P
The database remains opened until the returned value is destroyed.
.SS INSTRUCTION sqlite.query sqlite.database STR:query -> sqlite.query
This instruction compiles a SQL query for an opened database.
.P
The query can be used several times. It is called a prepared SQL statement.
.P
When the query text is invalid, a sqlite.error interruption is raised.
.SS INSTRUCTION sqlite.init MUTABLE sqlite.query ( VALUE | KEYWORD = VALUE ) *:parameters
This instruction initiates a query execution, taking arguments for bindings.
.P
Anonymous bindings are supported and uses positional values.
Named bindings are supported. They are specified by the alternative with a keyword.
The named binding shall start with a colon and be in small letters within the query text.
Variable bindings are supported.
The values are not passed as arguments of this instruction, but defined by the sqlite.var instruction.
The variable binding shall start with a dollar sign and be in small letters within the query text.
.P
When the binding is invalid, or a named binding does not exist into the query text, a sqlite.error interruption is raised.
.SS INSTRUCTION sqlite.exec MUTABLE sqlite.query PTR ? -> PTR ?
This instruction runs the query and returns one row whenever possible.
.P
When no data is returned, a null pointer is returned.
Otherwise a pointer indicating the row values is returned.
.P
When no extra pointer is provided as parameter, the row is instanciated as local memory.
In the row values, a null value is represented by a null AUTO value.
An integer is represented by an initialised INT value.
Other values are represented by an initialised STR value.
.P
When an extra pointer is provided as parameter, the corresponding memory region is used to store the row.
The size of the region has to be the same as the returned row, or a MEMORY interruption is raised.
If a type mismatches, a MEMORY interruption is raised.
A null value will be represented by a null value in memory.
.P
If a concurrent access to the database file is attempted, a sqlite.busy interruption is raised.
.SS INSTRUCTION sqlite.var STR:name VALUE ?:value
This instruction sets or resets a variable.
Variables are values accessibles from every query, regardless the process where it is run.
.P
When the value is not specified, the variable is deleted.
Otherwise, the variable is created or updated.
.SH EXAMPLE
.SS Simple select
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT STR database
PROCESS "select"
	CODE "main" INLINE
		:memory sqlite.database/db, sqlite.query/q, STR/n, PTR/r, INT/a
		:interruption !sqlite.error no_database
		:sqlite.database @&database -> &db
		:interruption !sqlite.error
		:sqlite.query @&db "SELECT age FROM person WHERE name = ?;" -> &q
	:label loop
		:com.prompt "Name" STR -> &n
		:shutdown :unless &n INITIALISED
		:sqlite.init @&q @&n
		:sqlite.exec @&q a -> &r
		:goto no_result :unless &r INITIALISED
		:com.message @&n " is " @(@&r/0) " years old."
		:goto loop
	:label no_result
		:com.message @&n " is not referenced!"
		:goto loop 
	:label no_database
		:com.message STDERR @&database " is not a valid database."
	END
	MEMORY database
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER, Julien TALLON, Francois GOASMAT and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
