.TH "Simple Virtual Machine - Plugin sys" 7 "2023-03-20"
.SH SYNOPSIS
.B svm_plugin_sys
An implementation of operating system access for SVM.
.SH DESCRIPTION
This plugin enables basic access to the operating system in which the SVM is running.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginsys/libsvmsys.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS SYSTEM INSTRUCTION sys.name -> STR ?
This instruction returns the system host name.
When the host name can not be retrieved, a null string is returned.
.SS SYSTEM INSTRUCTION sys.user -> STR ?
This instruction returns the login user name.
When the user name can not be retrieved, a null string is returned.
.SS SYSTEM INSTRUCTION sys.cpu -> INT
This instruction returns the number of processor cores available on the system.
.P
This value can be useful to auto-tune schedulers to adapt to every system.
.SS INSTRUCTION sys.getenv STR -> STR ?
This instruction returns the eventual value of an environment variable.
When the variable does not exist, a nul string is returned.
.P
The instruction raises a FAILURE interruption when the variable name is ill-formed.
.SS SYSTEM INSTRUCTION sys.setenv STR STR ?
This instruction changes the eventual value of an environment variable.
When the second parameter is not provided, the variable is deleted.
Otherwise, the variable is created or updated with the new value.
.P
The instruction raises a FAILURE interruption when the variable name is ill-formed.
.SS INSTRUCTION sys.listenv -> PTR
This instruction returns all defined environment variables.
It returns a pointer to an array of pointers.
Each element pointer indicates two strings: the first one is the variable name, and the second one the variable value.
.SH EXAMPLE
.SS Hello system!
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
PROCESS "test"
	CODE "main" INLINE
		:memory (STR*2,INT)/sys
		:sys.name -> (sys/0)
		:sys.user -> (sys/1)
		:sys.cpu -> (sys/2)
		:com.message "OS: " @(sys/0) " used by " @(sys/1) " with " @(sys/2) " CPUs."
	END
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
