/*
 * Copyright (C) 2023-03-20  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 42 "../plugins/sys/core/sys.svm_plugin"
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <thread>
#include <map>
#line 29 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN sys \n"
		"DEFINE \n"
		"	SYSTEM INSTRUCTION sys.name -> STR ? \n"
		"	SYSTEM INSTRUCTION sys.user -> STR ? \n"
		"	SYSTEM INSTRUCTION sys.cpu -> INT \n"
		"	INSTRUCTION sys.getenv STR -> STR ? \n"
		"	SYSTEM INSTRUCTION sys.setenv STR STR ? \n"
		"	INSTRUCTION sys.listenv -> PTR \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 51 "../plugins/sys/core/sys.svm_plugin"
static const int USER_NAME_MAX = 128;
#line 127 "src/plugin.cpp"

extern "C"
{

/* SYSTEM INSTRUCTION sys.name -> STR ? */

SVM_Value instruction_name(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 58 "../plugins/sys/core/sys.svm_plugin"
	char name[HOST_NAME_MAX];
	if(::gethostname(name,HOST_NAME_MAX))
	{
		return NEW_NULL_VALUE(string);
	}
	return NEW_VALUE(string,::svm_string_new__raw(svm,name));
#line 143 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION sys.user -> STR ? */

SVM_Value instruction_user(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 73 "../plugins/sys/core/sys.svm_plugin"
	char name[USER_NAME_MAX+1];
	if(::getlogin_r(name,USER_NAME_MAX))
	{
		return NEW_NULL_VALUE(string);
	}
	return NEW_VALUE(string,::svm_string_new__raw(svm,name));
#line 158 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION sys.cpu -> INT */

SVM_Value instruction_cpu(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 88 "../plugins/sys/core/sys.svm_plugin"
	auto cpu = std::thread::hardware_concurrency();
	return NEW_VALUE(integer,cpu);
#line 169 "src/plugin.cpp"
}


/* INSTRUCTION sys.getenv STR -> STR ? */

SVM_Value instruction_getenv(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 100 "../plugins/sys/core/sys.svm_plugin"
	auto name = ARGV_VALUE(0,string);
	char *value = ::getenv(name.string);
	if(not value)
	{
		return NEW_NULL_VALUE(string);
	}
	return NEW_VALUE(string,::svm_string_new__raw(svm,value));
#line 185 "src/plugin.cpp"
}


/* SYSTEM INSTRUCTION sys.setenv STR STR ? */

SVM_Value instruction_setenv(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 118 "../plugins/sys/core/sys.svm_plugin"
	auto name = ARGV_VALUE(0,string);
	if(argc==1)
	{
		if(::unsetenv(name.string))
		{
			ERROR_INTERNAL(FAILURE,"Invalid variable name");
		}
		RETURN;
	}
	auto value = ARGV_VALUE(1,string);
	if(::setenv(name.string,value.string,1/*overwrite*/))
	{
		ERROR_INTERNAL(FAILURE,"Invalid variable name");
	}
#line 208 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION sys.listenv -> PTR */

SVM_Value instruction_listenv(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 144 "../plugins/sys/core/sys.svm_plugin"
	std::map<std::string,std::string> variables;
	for(char **v=environ ; *v ; ++v)
	{
		auto s = std::string(*v);
		auto equal = s.find('=');
		variables.insert(std::make_pair(s.substr(0,equal),s.substr(equal+1)));
	}
	SVM_Memory_Zone z = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,z,POINTER,variables.size());
	SVM_Value_Pointer v = ::svm_memory_allocate(svm,CURRENT(kernel),z);
	SVM_Memory_Zone zz = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,zz,STRING,2);
	SVM_Address a = ::svm_value_pointer_get_address(svm,v);
	for(const auto& vv: variables)
	{
		SVM_Value_Pointer rv = ::svm_memory_allocate(svm,CURRENT(kernel),zz);
		SVM_Value_String *av =::svm_value_array_new(svm,2);
		av[0] = NEW_VALUE(string,NEW_STRING(vv.first));
		av[1] = NEW_VALUE(string,NEW_STRING(vv.second));
		::svm_value_state_set_movable(svm,av[0]);
		::svm_value_state_set_movable(svm,av[1]);
		::svm_memory_write_pointer(svm,CURRENT(kernel),rv,av);
		VARIABLE_DELETE(av);
		::svm_value_state_set_movable(svm,rv);
		::svm_memory_write_address(svm,CURRENT(kernel),a++,rv);
	}
	return v;
#line 245 "src/plugin.cpp"
}


/* Generic handling functions */

}
