.TH "Simple Virtual Machine - Plugin task" 7 "2023-02-23"
.SH SYNOPSIS
.B svm_plugin_task
A simple tasking plugin to exploit parallelisation in the SVM.
.SH DESCRIPTION
This plugin enables the support of tasks.
A task is a process having a specific identifier allowing it to exchange data with other tasks.
.P
The plugin uses an event queue to exchange data between tasks.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmplugintask/libsvmtask.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS STRUCT task.id
This structure contains data attached to a task.
.P
The content of this structure can be read by other tasks.
.SS TYPE task.id
This type is a task identifier.
.P
A task identifier is required to create a task.
.SS STRUCT task.event
This structure conveys data between tasks.
.SS INSTRUCTION task.id STR:name PTR:values ? -> task.id
This instruction create a task identifier.
.P
A name has to be provided for the task, and optional values can be attached to the identifier.
.SS INSTRUCTION task.name task.id -> STR
This instruction retrieves the task name from a task identifier
.SS INSTRUCTION task.values task.id -> PTR
This instruction retrieves the task values attached to a task identifier
.SS WAITING INSTRUCTION task.new task.id:name SYM:code PEP:scheduler PEP:sequencer ?
This instruction creates a task.
.P
A process is created by this instruction and attached to the scheduler given as parameter.
An optional sequencer can be provided.
The code executed by the task is specified with the symbol.
.P
The task uses the task identifier to get its name and identity.
This identifer is accessible within the task at the address
.nf
&P
.fi
.P
This instruction can raise a FAILURE interruption when the sequencer does not exist or the scheduler does not exist or refuse the process.
.SS WAITING INSTRUCTION task.recv task.id:destination 'SOURCE' ? PTR:values ? -> PTR ?
This instruction allows a task to retrieve an event from another task.
The instruction will wait until an event is received, or when interrupted.
.P
The specified task identifier indicates on which address the task should listen to events.
.P
When the SOURCE keyword is present, the first address of the result will contain the task identifier of the task sending the event.
.P
When the optional pointer is present, it is used to store the received event (and the optional task identifier).
The instruction raises a MEMORY interrupted when the received data can not be stored into the given pointer (the data are lost in this case).
The memory is allocated otherwise.
.P
The instruction returns a null pointer when interrupted, or the pointer containing the received data.
.SS INSTRUCTION task.send task.id:source => task.id:destination PTR:values
This instruction allows a task to send an event to another task.
.P
The source task identifier can be retrieved by the receiver.
.P
The destination task identifier specifies to which task the event shall be sent.
.P
The values are specified by a pointer.
If one address of the pointer is not initialised, a MEMORY interrupted is raised.
The values are removed from the memory (the addresses remain defined but null).
.SH EXAMPLE
.SS Parallel Fibonacci generation
.nf
#!/usr/bin/env svm
LOG
PLUGIN "svmrun.so"
PLUGIN "svmint.so"
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT INT nb
PROCESS "root"
	CODE "main" INLINE
		:memory task.id/root, task.id/fib, INT/i, INT/j, INT*2/r
		:task.id "root" -> &root
		0 -> &i
	:label send
		:task.id "fib" -> &fib
		:task.new @&fib $"fib" run.parallel
		@&i -> &j
		:task.send @&root => @&fib j 
		:shift &i
		:goto send :when @&i IN &0*@&nb
		0 -> &i 
	:label recv
		:task.recv @&root r
		:com.message @(r/0) " => " @(r/1)
		:shift &i
		:goto recv :when @&i IN &0*@&nb
		:shutdown 0
	:symbol fib
		:memory (task.id, INT)/i, (PTR,INT*2)/r
		:task.recv @&P SOURCE i
		[ , @(i/1) , ] -> r
		:call fib_internal r
		:task.send @&P => @(i/0) (&r+1)*2
		:shutdown
	:label fib_internal
		:memory (PTR, INT*2)*2, BLN -> &P
		:int.cmp @(P/1) < 2 -> (@&P/6)
		:goto fib_recursion :unless @(@&P/6) TRUE
		@(P/1) -> (P/2)
		:return
	:label fib_recursion
		:int.sub @(P/1) 1 -> (@&P/1)
		:call fib_internal &@&P*3
		:int.sub @(P/1) 2 -> (@&P/4)
		:call fib_internal (&@&P+3)*3
		:int.add @(@&P/2) @(@&P/5) -> (P/2)
		:return
	END
	MEMORY nb
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
