/*
 * Copyright (C) 2023-02-23  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 81 "../plugins/task/core/task.svm_plugin"
#include <vector>
#line 25 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN task \n"
		"DEFINE \n"
		"	STRUCT task.id \n"
		"	TYPE task.id \n"
		"	STRUCT task.event \n"
		"	INSTRUCTION task.id STR:name PTR:values ? -> task.id \n"
		"	INSTRUCTION task.name task.id -> STR \n"
		"	INSTRUCTION task.values task.id -> PTR \n"
		"	WAITING INSTRUCTION task.new task.id:name SYM:code PEP:scheduler PEP:sequencer ? \n"
		"	WAITING INSTRUCTION task.recv task.id:destination 'SOURCE' ? PTR:values ? -> PTR ? \n"
		"	INSTRUCTION task.send task.id:source => task.id:destination PTR:values \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 86 "../plugins/task/core/task.svm_plugin"
	SVM_Event_Queue events;
#line 126 "src/plugin.cpp"

extern "C"
{

/* STRUCT task.id */

struct struct_id
{
#line 104 "../plugins/task/core/task.svm_plugin"
	SVM_Value_String _name;
	std::vector<SVM_Value> _values;
#line 138 "src/plugin.cpp"
};

void struct_id_delete(const void *svm, void *handler)
{
	struct_id * const object = reinterpret_cast<struct_id*>(handler);
	{
#line 109 "../plugins/task/core/task.svm_plugin"
	::svm_variable_scope_set_local(svm,object->_name);
	for(const auto& v: object->_values)
	{
		::svm_variable_scope_set_local(svm,v);
	}
#line 151 "src/plugin.cpp"
	}
	delete object;
}


/* TYPE task.id */

struct type_id
{
#line 124 "../plugins/task/core/task.svm_plugin"
	SVM_Event_Queue_Address _address;
#line 163 "src/plugin.cpp"
};

void type_id_delete(const void *svm, void *handler)
{
	type_id * const object = reinterpret_cast<type_id*>(handler);
	{
#line 128 "../plugins/task/core/task.svm_plugin"
	::svm_variable_scope_set_local(svm,object->_address);
	if(::svm_variable_scope_is_local(svm,object->_address))
	{
		::svm_event_queue_leave(svm,events,object->_address);
	}
#line 176 "src/plugin.cpp"
	}
	delete object;
}

void* type_id_copy(const void *svm, const void *handler)
{
	const type_id *object = reinterpret_cast<const type_id*>(handler);
	type_id *copy = new type_id(*object);
	{
#line 136 "../plugins/task/core/task.svm_plugin"
	::svm_variable_scope_set_global(svm,object->_address);
#line 188 "src/plugin.cpp"
	}
	return copy;
}

SVM_String type_id_print(const void *svm, const void *handler)
{
	const type_id *object = reinterpret_cast<const type_id*>(handler);
	{
#line 140 "../plugins/task/core/task.svm_plugin"
	auto s = reinterpret_cast<struct_id*>(::svm_structure_get_internal(svm,CONST_PEP(task,id),::svm_event_address_get_struct(svm,object->_address)));
	return ::svm_value_string_get(svm,s->_name);
#line 200 "src/plugin.cpp"
	}
}


/* STRUCT task.event */

struct struct_event
{
#line 152 "../plugins/task/core/task.svm_plugin"
	std::vector<SVM_Value> _values;
#line 211 "src/plugin.cpp"
};

void struct_event_delete(const void *svm, void *handler)
{
	struct_event * const object = reinterpret_cast<struct_event*>(handler);
	{
#line 156 "../plugins/task/core/task.svm_plugin"
	for(const auto& v: object->_values)
	{
		::svm_variable_scope_set_local(svm,v);
	}
#line 223 "src/plugin.cpp"
	}
	delete object;
}


/* INSTRUCTION task.id STR:name PTR:values ? -> task.id */

SVM_Value instruction_id(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 168 "../plugins/task/core/task.svm_plugin"
	SVM_Value_String name = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Value_Pointer values = nullptr;
	if(argc>1)
	{
		values = ::svm_parameter_value_get(svm,argv[1]);
	}
	struct_id *sid = new struct_id;
	sid->_name = name;
	::svm_variable_scope_set_global(svm,name);
	if(argc>1)
	{
		SVM_Address a = ::svm_value_pointer_get_address(svm,values);
		SVM_Size s = ::svm_value_pointer_get_size(svm,values);
		for(SVM_Address i=a ; i<(a+s) ; ++i)
		{
			SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),i);
			::svm_variable_scope_set_global(svm,v);
			sid->_values.push_back(v);
		}
	}
	SVM_Structure id = ::svm_structure_new(svm,CONST_PEP(task,id),sid);
	SVM_Event_Queue_Address address = ::svm_event_address_new_struct(svm,id);
	::svm_event_queue_join(svm,events,address);
	::svm_variable_scope_set_shared(svm,address);
	::svm_variable_scope_set_global(svm,address);
	return NEW_PLUGIN(task,id,new type_id { address });
#line 260 "src/plugin.cpp"
}


/* INSTRUCTION task.name task.id -> STR */

SVM_Value instruction_name(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 204 "../plugins/task/core/task.svm_plugin"
	auto id = ARGV_PLUGIN(0,task,id);
	auto s = reinterpret_cast<struct_id*>(::svm_structure_get_internal(svm,CONST_PEP(task,id),::svm_event_address_get_struct(svm,id->_address)));
	return s->_name;
#line 272 "src/plugin.cpp"
}


/* INSTRUCTION task.values task.id -> PTR */

SVM_Value instruction_values(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 212 "../plugins/task/core/task.svm_plugin"
	auto id = ARGV_PLUGIN(0,task,id);
	auto s = reinterpret_cast<struct_id*>(::svm_structure_get_internal(svm,CONST_PEP(task,id),::svm_event_address_get_struct(svm,id->_address)));
	SVM_Memory_Zone zone = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,zone,AUTOMATIC,s->_values.size());
	SVM_Value_Pointer pointer = ::svm_memory_allocate(svm,CURRENT(kernel),zone);
	SVM_Address a = ::svm_value_pointer_get_address(svm,pointer);
	for(const auto& v: s->_values)
	{
		::svm_memory_write_address(svm,CURRENT(kernel),a++,v);
	}
	return pointer;
#line 292 "src/plugin.cpp"
}


/* WAITING INSTRUCTION task.new task.id:name SYM:code PEP:scheduler PEP:sequencer ? */

SVM_Value instruction_new(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 228 "../plugins/task/core/task.svm_plugin"
	auto id = ARGV_PLUGIN(0,task,id);
	SVM_Value_Symbol symbol = ::svm_parameter_value_get(svm,argv[1]);
	SVM_Value_PluginEntryPoint scheduler = ::svm_parameter_value_get(svm,argv[2]);
	SVM_Value_PluginEntryPoint sequencer = nullptr;
	if(argc>3)
	{
		sequencer = ::svm_parameter_value_get(svm,argv[3]);
	}
	auto name = reinterpret_cast<struct_id*>(::svm_structure_get_internal(svm,CONST_PEP(task,id),::svm_event_address_get_struct(svm,id->_address)));
	SVM_Kernel kernel = ::svm_kernel_new_symbol(svm,TRUE,FALSE,FALSE,nullptr,symbol);
	SVM_Memory_Zone zone = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_external__raw(svm,zone,CONST_PEP(task,id),1);
	SVM_Value_Pointer pointer = ::svm_memory_allocate(svm,kernel,zone);
	::svm_processor_set_currentpointer(svm,kernel,pointer);
	::svm_memory_write_address(svm,kernel,::svm_value_pointer_get_address(svm,pointer),::svm_value_copy(svm,::svm_parameter_value_get(svm,argv[0])));
	SVM_Process task = ::svm_process_new(svm,name->_name,sequencer,FALSE,kernel);
	::svm_process_ownership_get_local(svm,task);
	if(not ::svm_scheduler_process_attach__raw(svm,::svm_scheduler_get(svm,scheduler),task,0))
	{
		ERROR_INTERNAL(FAILURE,"Task rejected by scheduler");
	}
#line 322 "src/plugin.cpp"
	return nullptr;
}


/* WAITING INSTRUCTION task.recv task.id:destination 'SOURCE' ? PTR:values ? -> PTR ? */

SVM_Value instruction_recv(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 269 "../plugins/task/core/task.svm_plugin"
	auto destination = ARGV_PLUGIN(0,task,id);
	bool reply_source = false;
	SVM_Value_Pointer values = nullptr;
	if(argc>1)
	{
		SVM_Index c = 1;
		if(::svm_parameter_type_is_keyword(svm,argv[1]))
		{
			reply_source = true;
			++c;
		}
		if(argc>c)
		{
			values = ::svm_parameter_value_get(svm,argv[c]);
		}
	}
	SVM_Event_Queue_Address source;
	SVM_Structure event;
	::svm_process_interruptionnotification_enable(svm,CURRENT(process));
	SVM_Boolean received = ::svm_event_queue_pull(svm,events,destination->_address,&source,&event,TRUE);
	::svm_process_interruptionnotification_disable(svm,CURRENT(process));
	if(not received)
	{
		return NEW_NULL_VALUE(pointer);
	}
	auto s = reinterpret_cast<struct_id*>(::svm_structure_get_internal(svm,CONST_PEP(task,id),::svm_event_address_get_struct(svm,source)));
	auto e = reinterpret_cast<struct_event*>(::svm_structure_get_internal(svm,CONST_PEP(task,event),event));
	SVM_Index re = (e->_values.size()+(reply_source?1:0));
	auto rid = new type_id { source };
	::svm_variable_scope_set_global(svm,source);
	SVM_Value_Plugin id = NEW_PLUGIN(task,id,rid);
	if(values)
	{
		SVM_Size vs = ::svm_value_pointer_get_size(svm,values);
		if(vs!=re)
		{
			ERROR_INTERNAL(MEMORY,"Invalid pointer size");
		}
		SVM_Address a = ::svm_value_pointer_get_address(svm,values);
		if(reply_source)
		{
			if(not ::svm_memory_address_is_writable(svm,CURRENT(kernel),a++,id))
			{
				ERROR_INTERNAL(MEMORY,"Unable to write task id");
			}
		}
		for(const auto& v:e->_values)
		{
			if(not ::svm_memory_address_is_writable(svm,CURRENT(kernel),a,v))
			{
				std::ostringstream oss;
				oss << "Unable to write value at address &" << a;
				ERROR_INTERNAL(MEMORY,oss.str().c_str());
			}
			++a;
		}
	}
	else
	{
		SVM_Memory_Zone zone = ::svm_memory_zone_new(svm);
		::svm_memory_zone_append_internal__raw(svm,zone,AUTOMATIC,re);
		values = ::svm_memory_allocate(svm,CURRENT(kernel),zone);
	}
	SVM_Address wa = ::svm_value_pointer_get_address(svm,values);
	if(reply_source)
	{
		::svm_memory_write_address(svm,CURRENT(kernel),wa++,id);
	}
	for(const auto& v:e->_values)
	{
		::svm_memory_write_address(svm,CURRENT(kernel),wa++,v);
	}
	return values;
#line 405 "src/plugin.cpp"
}


/* INSTRUCTION task.send task.id:source => task.id:destination PTR:values */

SVM_Value instruction_send(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 361 "../plugins/task/core/task.svm_plugin"
	auto source = ARGV_PLUGIN(0,task,id);
	auto destination = ARGV_PLUGIN(2,task,id);
	SVM_Value_Pointer values = ::svm_parameter_value_get(svm,argv[3]);
	SVM_Address a = ::svm_value_pointer_get_address(svm,values);
	SVM_Size s = ::svm_value_pointer_get_size(svm,values);
	for(SVM_Index i=a ; i<(a+s) ; ++i)
	{
		if(not ::svm_memory_address_is_initialised(svm,CURRENT(kernel),i))
		{
			std::ostringstream oss;
			oss << "Unable to read address &" << i;
			ERROR_INTERNAL(MEMORY,oss.str().c_str());
		}
	}
	auto e = new struct_event;
	a = ::svm_value_pointer_get_address(svm,values);
	s = ::svm_value_pointer_get_size(svm,values);
	for(SVM_Index i=a ; i<(a+s) ; ++i)
	{
		SVM_Value v = ::svm_memory_read_address(svm,CURRENT(kernel),i);
		::svm_variable_scope_set_global(svm,v);
		e->_values.push_back(v);
		::svm_memory_write_address(svm,CURRENT(kernel),i,::svm_value_automatic_new_null(svm));
	}
	SVM_Structure event = NEW_STRUCT(task,event,e);
	::svm_event_queue_push(svm,events,destination->_address,source->_address,event);
#line 440 "src/plugin.cpp"
	return nullptr;
}


/* Generic handling functions */

void plugin_initialisation(const void *svm)
{
#line 91 "../plugins/task/core/task.svm_plugin"
	events = ::svm_event_queue_new(svm);
	::svm_variable_scope_set_global(svm,events);
#line 452 "src/plugin.cpp"
}

void plugin_finalisation(const void *svm)
{
#line 97 "../plugins/task/core/task.svm_plugin"
	::svm_variable_scope_set_local(svm,events);
#line 459 "src/plugin.cpp"
}

}
