.TH "Simple Virtual Machine - Plugin tcp" 7 "2024-05-01"
.SH SYNOPSIS
.B svm_plugin_tcp
A fast implementation of TCP, compatible with com plugin.
.SH DESCRIPTION
This plugin allows simple and fast management of TCP devices, compatible with com plugin.
.P
It eases the creation of applications based on a TCP server or a TCP client.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmplugintcp/libsvmtcp.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH DEPENDENCIES
.SS TYPE com.device
This plugin can create com.device values to allow read, write and idle operations.
.SS FUNCTION com.device $tcp.client -> com.device ?
This function is used to create a com.device from a tcp.client channel.
.SS INTERRUPTION com.interrupted
Read operation can raise this interruption while interrupted.
.SH CONTENT
.SS STRUCT tcp.client
This structure is the tcp.client channel, containing data for socket management.
.SS FUNCTION tcp.device_client_open STR:host STR:service -> $tcp.client
This function is used by :com.open instruction.
.P
This creates a tcp.client device used by clients to connect to servers.
.SS FUNCTION tcp.device_client_print $tcp.client -> STR
This function is used to create a string representation of the tcp.client device.
.SS FUNCTION tcp.device_client_read $tcp.client -> STR ?
This function is used by :com.read instruction on a tcp.client device.
.P
The function can raise a com.interrupted interruption when an interruption notification is catched.
.SS FUNCTION tcp.device_client_write $tcp.client STR
This function is used by the :com.write instruction on a tcp.client device.
.SS FUNCTION tcp.device_client_idle $tcp.client MUTABLE INT 3
This function is used by the :com.idle instruction on a tcp.client device.
.SS FUNCTION tcp.device_client_command $tcp.client . * -> VALUE ?
This function is used by the :com.command instruction on a tcp.client device.
.P
It supports these commands:
 - 'CLOSE' [ < > ] for socket half closure,
 - 'LINGER' [ 'OFF' INT ] for TCP linger mode (OFF to disable, an integer to enable),
 - 'BLOCKING' BLN for socket in blocking or non-blocking mode,
 - 'NODELAY' BLN for TCP Nagle disabling or enabling,
 - 'REMOTE' [ 'IP' 'PORT' ] to get information on the remote peer of a tcp.client device.
.SS FUNCTION tcp.device_client_close $tcp.client -> BLN
This function is used by the com.device destructor on a tcp.client device.
.SS WAITING INSTRUCTION tcp.server STR:host STR:service INT:queue > STR:process_name SYM:code PTR:memory PEP:scheduler PEP:sequencer ?
This instruction opens a TCP port and awaits for a TCP client to connect to the TCP server represented by this instruction.
.P
The instruction loops on each TCP client connection until it receives a signal to terminate.
While the instruction is executed, the TCP listening port is opened.
.P
On each TCP connection:
 - it creates a process and attaches it to the specified scheduler,
 - initialise the memory of the kernel of the created process:
   - P references two addresses: the first one is the tcp.client device representing the client and the second one is the shared parameters,
   - the memory pointer and all its associated memory is instanciated in the new kernel, and the memory is shared between the server process and the new process.
.SS OPTION tcp.scheduler_run_limit -l INT
This option configures the TCP scheduler. It indicates the maximal number of processes running at the same time.
.SS OPTION tcp.scheduler_run_time -t INT
This option configures the TCP scheduler. It indicates the maximal time slice allocated to a running processes in milliseconds.
.SS SYSTEM INSTRUCTION tcp.scheduler_run_limit INT
This instruction changes dynamically the maximal number of running process of the TCP scheduler.
.P
A value inferior to 1 will raise a FAILURE interruption.
.SS SCHEDULER tcp.scheduler
This scheduler allows the parallel run of a maximum of processes, using a round robin policy when more processes require execution.
Waiting processes are not counted in the process pool to run, letting them wait for external events.
.P
By default, the limit of parallel running processes is 1, and the time slice for process run is set to 1000ms.
Theses values can be changed by plugin options, and the parallel run limit can also be changed by an instruction.
.SH EXAMPLES
.SS Simple server
.nf
#!/usr/bin/env svm
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB===" -l 3 -t 2000
PLUGIN "svmstr.so"
OPTION -i STR host
ARGUMENT STR service

PROCESS "server"
        CODE "main" INLINE
                :goto has_host :when &host INITIALISED
                "localhost" -> &host
        :label has_host
                :tcp.server @&host @&service 5 > "client" $"client" P tcp.scheduler
        :symbol client
                :memory STR/s
                :com.read @&P com.line -> &s
                :shutdown :unless &s INITIALISED
                :str.replace @&s ALL CONST str.pattern "\n" => ""
                :str.join "<" @&s ">\n" -> &s
                :com.write @&P @&s
        END
        SCHEDULER tcp.scheduler
        MEMORY host service
END
.fi
.SS Simple client
.nf
#!/usr/bin/env svm
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
PLUGIN "svmstr.so"
OPTION -i STR host
ARGUMENT STR service

PROCESS "client"
        CODE "main" INLINE
                :goto has_host :when &host INITIALISED
                "localhost" -> &host
        :label has_host
                :memory com.device/c, STR/s
                :com.open tcp.client @&host @&service -> &c
                :com.write @&c "lol\n"
                :com.read @&c com.line -> &s
                :str.replace @&s ALL CONST str.pattern "\n" => ""
                :com.message @&s
        END
        MEMORY host service
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.BR svm_plugin_com (7)
for com plugin documentation.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
