.TH "Simple Virtual Machine - Plugin unittest" 7 "2023-11-01"
.SH SYNOPSIS
.B svm_plugin_unittest
A plugin to unittest SVM code.
.SH DESCRIPTION
This plugin allows unit testing of SVM code.
.P
To achieve this, this plugin opens code internals to other codes.
.P
It is advised to write your application in at least two files:
 - One file containing the application description,
 - The other file containing the application code.
.P
You can use the FILE option to the CODE directive in the application description file to load the code:
.nf
PROCESS "application"
	CODE "main" FILE "code.svm"
	...
END
.fi
.P
Then, you can write a separated application description file to unit test your code:
.nf
PLUGIN "svmcom.so"
PROCESS "unittest"
	CODE "main" INLINE
		:memory com.device/f, STR/s, LIB/code
		:com.open com.file < "code.svm" -> &f
		:com.read @&f com.all -> &s
		[ ] -> f
		:library "code" @&s -> &code
		# start unit tests here
		# Use :call $(@&code/"symbol") parameters to call a symbol
		# Use :unittest.call_local @&code "label" parameters to call a label
		# Use :unittest.run @&code "start" => "exit" to run a part of the code
		...
	END
	...
END
.fi
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginunittest/libsvmunittest.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS SYSTEM INSTRUCTION unittest.call_local LIB:code [ STR INT ]:function PTR:parameters
This instruction performs a call to a local function of a code.
.P
This allows internal functions testing without having to switch labels into symbols.
.SS SYSTEM INSTRUCTION unittest.run LIB:code [ STR INT ]:start => [ STR INT ]:exit
This instruction performs a jump to an arbitrary location in the code.
It also sets an exit point (using the :unittest.exit instruction) on an arbitrary location in the code.
.P
The execution will then pass to the beginning of the tested section, until the exit (excluded).
Once the exit is reached, the execution continues after this instruction (The exit acts as a return). 
.SH EXAMPLES
.SS Local function call
.nf
#!/usr/bin/env svm
LOG
PLUGIN "===PLUGINLIB==="
PLUGIN "svmcom.so"
PROCESS "test"
	CODE "main" INLINE
		:memory LIB/l, INT*3/p
		:library "testcode" """:com.message 1
		:com.message 2
	:label f
		:com.message @(P/0)
		:com.message @(P/1)
		:com.message @(P/2)
		:return
		:com.message 6
		:com.message 7
		""" -> &l
		[ 3 , 4 , 5 ] -> p
		:com.message "==="
		:unittest.call_local @&l "f" p
		:com.message "==="
		:unittest.call_local @&l 1 p
		:com.message "==="
	END
END
.fi
.SS Stray testing
.nf
#!/usr/bin/env svm
LOG
PLUGIN "===PLUGINLIB==="
PLUGIN "svmcom.so"
PROCESS "test"
	CODE "main" INLINE
		:memory LIB/l
		:library "testcode" """:com.message 1
		:com.message 2
	:label b
		:com.message 3
		:com.message 4
		:com.message 5
	:label e
		:com.message 6
		:com.message 7
		""" -> &l
		:com.message "==="
		:unittest.run @&l "b" => "e"
		:com.message "==="
		:unittest.run @&l 1 => 6
		:com.message "==="
	END
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
