/*
 * Copyright (C) 2023-11-01  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>


#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN unittest \n"
		"DEFINE \n"
		"	SYSTEM INSTRUCTION unittest.call_local LIB:code [ STR INT ]:function PTR:parameters \n"
		"	SYSTEM INSTRUCTION unittest.run LIB:code [ STR INT ]:start => [ STR INT ]:exit \n"
		"	OVERRIDE INSTRUCTION unittest.exit SYM:return \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 340 "../plugins/unittest/core/unittest.svm_plugin"
namespace UnitTest
{
	SVM_Value_Symbol get_symbol(const void *svm, SVM_Code c, SVM_Value l, const std::string& where)
	{
		SVM_Address b=0;
		if(::svm_value_type_is_integer(svm,l))
		{
			auto i = ::svm_value_integer_get(svm,l);
			if(i<0)
			{
				std::stringstream oss;
				oss << "Negative address not allowed for " << where << ".";
				ERROR_INTERNAL(FAILURE,oss.str().c_str());
			}
			b = static_cast<SVM_Address>(i);
		}
		else
		{
			SVM_Boolean tl = ::svm_code_label_has_address(svm,c,l);
			if(not tl)
			{
				std::stringstream oss;
				oss << "Invalid label for " << where << ".";
				ERROR_INTERNAL(FAILURE,oss.str().c_str());
			}
			b = ::svm_code_label_get_address(svm,c,l);
		}
		return ::svm_value_symbol_new(svm,c,b);
	}
}
#line 146 "src/plugin.cpp"

extern "C"
{

/* SYSTEM INSTRUCTION unittest.call_local LIB:code [ STR INT ]:function PTR:parameters */

SVM_Value instruction_call_local(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 376 "../plugins/unittest/core/unittest.svm_plugin"
	SVM_Value_Library l = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Code c = ::svm_value_library_get_code(svm,l);
	SVM_Value_Symbol f = ::UnitTest::get_symbol(svm,c,::svm_parameter_value_get(svm,argv[1]),"local function");
	SVM_Value_Pointer p = ::svm_parameter_value_get(svm,argv[2]);
	::svm_processor_call_global(svm,CURRENT(kernel),f,p);
#line 161 "src/plugin.cpp"
	return nullptr;
}


/* SYSTEM INSTRUCTION unittest.run LIB:code [ STR INT ]:start => [ STR INT ]:exit */

SVM_Value instruction_run(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 391 "../plugins/unittest/core/unittest.svm_plugin"
	SVM_Value_Library l = ::svm_parameter_value_get(svm,argv[0]);
	SVM_Code c = ::svm_value_library_get_code(svm,l);
	SVM_Value_Symbol b = ::UnitTest::get_symbol(svm,c,::svm_parameter_value_get(svm,argv[1]),"unittest start");
	SVM_Value_Symbol e = ::UnitTest::get_symbol(svm,c,::svm_parameter_value_get(svm,argv[3]),"unittest exit");
	SVM_Value_Symbol r = ::svm_processor_get_nextinstruction(svm,CURRENT(kernel));
	SVM_Parameter *p = ::svm_parameter_array_new(svm,1);
	p[0] = ::svm_parameter_value_new(svm,r);
	::svm_processor_instructionoverride_set_global(svm,CURRENT(kernel),e,CONST_PEP(unittest,exit),1,p,GLOBAL);
	::svm_debug_breakpoint_add_break(svm,CURRENT(kernel),b);
	::svm_processor_jump_global(svm,CURRENT(kernel),b);
#line 181 "src/plugin.cpp"
	return nullptr;
}


/* OVERRIDE INSTRUCTION unittest.exit SYM:return */

SVM_Value instruction_exit(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 413 "../plugins/unittest/core/unittest.svm_plugin"
	SVM_Value_Symbol s = ::svm_parameter_value_get(svm,argv[0]);
	::svm_processor_jump_global(svm,CURRENT(kernel),s);
	::svm_processor_instructionoverride_reset_global(svm,CURRENT(kernel),::svm_processor_get_currentinstruction(svm,CURRENT(kernel)),GLOBAL);
#line 194 "src/plugin.cpp"
	return nullptr;
}


/* Generic handling functions */

}
